package com.hpcner.statusmanageservice.controller;


import com.hpcner.statusmanageservice.bean.Response;
import com.hpcner.statusmanageservice.bean.dto.EventInfoDTO;
import com.hpcner.statusmanageservice.bean.entity.EventInfo;
import com.hpcner.statusmanageservice.bean.vo.EventInfoVO;
import com.hpcner.statusmanageservice.constant.ResponseConstant;
import com.hpcner.statusmanageservice.service.database.EventInfoService;
import com.hpcner.statusmanageservice.utils.TimeUtils;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;

@Slf4j
@Controller
@RequestMapping("/event")
public class EventController {


    @Resource
    private EventInfoService eventInfoService;



    @PostMapping("/manage")
    @ResponseBody
    public Response manageEvent(@RequestBody EventInfoDTO eventInfoDTO) {
        try {
            log.info("Event Action: {}", eventInfoDTO);
            if(eventInfoDTO == null){
                return Response.builder().code(ResponseConstant.RES_ILLEGAL_PARAM).msg("非法参数").data("").build();
            }
            if(eventInfoDTO.getType()==null){
                return Response.builder().code(ResponseConstant.RES_ILLEGAL_PARAM).msg("非法参数").data("").build();
            }
            String action = eventInfoDTO.getType().toLowerCase();
            boolean success = false;
            EventInfo eventInfo = EventInfoDTO.from(eventInfoDTO);
            if(action.equals("update")){
                success = eventInfoService.UpdateEventByName(eventInfo);
            }else if(action.equals("delete")) {
                success = eventInfoService.DeleteEventByName(eventInfo);
            }else if(action.equals("insert")){
                int inserted = eventInfoService.InsertEventByName(eventInfo);
                if(inserted == -1){
                    success = false;
                    return Response.builder().code(500).msg("事件已存在").data("").build();
                }else{
                    success=true;
                }
            }else if(action.equals("set")){
                success = eventInfoService.ActivateByName(eventInfo);
            }
            else if(action.equals("unset")){
                success = eventInfoService.DeactivateByName(eventInfo);
            }
            if(success){
                return Response.builder().code(ResponseConstant.RES_OK).msg("成功更新配置信息!").data("").build();
            }else{
                return Response.builder().code(500).msg("请检查").data("").build();
            }


        }catch (Exception e){
            log.error("Error occurred while managing event: {}", e.getMessage());
            return Response.builder().code(ResponseConstant.RES_SERVER_ERROR).msg("服务器错误，请查看日志").data(e.getMessage()).build();
        }
    }

    @PostMapping("/info")
    @ResponseBody
    public Response manageEvent(){

        try {
            List<EventInfo> eventInfo = eventInfoService.GetAllEventInfo();
            List<EventInfoVO> eventInfoVO = new ArrayList<>();
            if(eventInfo!=null) {
                for(EventInfo eventInfoVO1 : eventInfo){
                    eventInfoVO.add(EventInfoVO.from(eventInfoVO1));
                }
            }


            EventInfo activateEvent = eventInfoService.GetActivate();
            Map<String,Object> ret = new java.util.Hashtable<>();
            if(activateEvent!=null)
                ret.put("current_event",activateEvent.getEventName());
            else
                ret.put("current_event","null");
            ret.put("event_list",eventInfoVO);

            return Response.builder().code(ResponseConstant.RES_OK).msg("成功获取事件信息").data(ret).build();
        }catch (Exception e){
            log.error("Error occurred while managing event: {}", e.getMessage());
            return Response.builder().code(ResponseConstant.RES_SERVER_ERROR).msg("服务器错误，请查看日志").data(e.getMessage()).build();
        }
    }
}
