package com.hpcner.statusmanageservice.serv.recog;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hpcner.statusmanageservice.bean.entity.ServiceInfo;
import com.hpcner.statusmanageservice.service.database.ServiceInfoService;
import com.hpcner.statusmanageservice.utils.ApplicationContextUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.*;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Component("recog-zgs")
@Slf4j
public class RecogZgsService extends RecogService{

    public static final String BASE_URL="http://localhost:8081";

    @Override
    public boolean start(String json) {
        //curl -X POST  "http://localhost:8081/models?url=retinanet.mar&initial_workers=3"
        String modelUrl = "retinanet.mar";
        int workers = 3;

        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(json);

            if (jsonObject.has("url")) {
                modelUrl = jsonObject.get("url").asText();
            }
            if (jsonObject.has("initial_workers")) {
                workers = jsonObject.get("initial_workers").asInt();
            }

            String url = String.format("%s/models?url=%s&initial_workers=%d", BASE_URL, modelUrl, workers);
            log.info("Start recog zgs {}", url);

            RestTemplate restTemplate = new RestTemplate(new SimpleClientHttpRequestFactory());
            String result = restTemplate.postForObject(url, null, String.class);

            JsonNode resultObject = mapper.readTree(result);
            if (resultObject == null) {
                log.info("Error parse recog zgs result: {}", result);
                return false;
            }

            if (resultObject.has("code")) {
                log.info("Error starting recog zgs: {}", resultObject.path("message").asText());
                return false;
            }
            ServiceInfoService serviceInfoService = ApplicationContextUtil.getBean(ServiceInfoService.class);
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.setServiceId(getId());
            serviceInfo.setServiceState(true);
            serviceInfoService.UpsertServiceInfoByServiceId(serviceInfo);
            return true;
        } catch (Exception e) {
            log.error("Exception in start recog zgs", e);
            return false;
        }
    }

    @Override
    public boolean stop() {
        String url = String.format("%s/models/retinanet/1.0",BASE_URL);
        log.info("Stop recog zgs {}",url);
        RestTemplate restTemplate = new RestTemplate(new SimpleClientHttpRequestFactory());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<String> entity = new HttpEntity<>(headers);

        // 发送DELETE请求并获取响应
        ResponseEntity<String> response = restTemplate.exchange(
                url,
                HttpMethod.DELETE,
                entity,
                String.class
        );
        if(response.getStatusCode().equals(HttpStatus.OK)){
            log.info("Stop recog zgs success");
            ServiceInfoService serviceInfoService = ApplicationContextUtil.getBean(ServiceInfoService.class);
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.setServiceId(getId());
            serviceInfo.setServiceState(false);
            serviceInfoService.UpsertServiceInfoByServiceId(serviceInfo);
            return true;
        }
        return false;
    }

    @Override
    public boolean restart(String json) {
        if(!stop()){
            return false;
        }
        if(start(json)){
            return true;
        }
        else{
            return false;
        }
    }
}
