package com.hpcner.statusmanageservice.bean.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.hpcner.statusmanageservice.bean.entity.EventInfo;
import lombok.Data;
import lombok.ToString;
@ToString
@Data
public class EventInfoDTO {
    @JsonProperty("type")
    private String type;
    @JsonProperty("event_name")
    private String eventName;
    @JsonProperty("event_longitude")
    private String eventLongitude;
    @JsonProperty("event_latitude")
    private String eventLatitude;
    @JsonProperty("event_description")
    private String eventDescription;



    public static EventInfo from(EventInfoDTO eventInfoDTO) {
        EventInfo dto = new EventInfo();
        dto.setEventName(eventInfoDTO.getEventName());
        if(eventInfoDTO.getEventLatitude()!=null && !eventInfoDTO.getEventLatitude().equals("")){
            dto.setEventLongitude(Double.parseDouble(eventInfoDTO.getEventLongitude()));
        }
        if(eventInfoDTO.getEventLatitude()!=null && !eventInfoDTO.getEventLatitude().equals("")){
            dto.setEventLatitude(Double.parseDouble(eventInfoDTO.getEventLatitude()));
        }
        dto.setEventDescription(eventInfoDTO.getEventDescription());
        return dto;
    }
}
