package com.hpcner.statusmanageservice.bean.entity;


import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.time.LocalDateTime;

@Data
@TableName("event_info")
public class EventInfo {
    @TableId(value = "event_id", type = IdType.AUTO) // 假设主键自增
    @JsonIgnore
    private Integer eventId;

    /**
     * 事件名称
     */
    @TableField("event_name")
    private String eventName="";

    /**
     * 事件经度
     */
    @TableField("event_longitude")
    private Double eventLongitude;

    /**
     * 事件纬度
     */
    @TableField("event_latitude")
    private Double eventLatitude;

    /**
     * 事件描述
     */
    @TableField("event_description")
    private String eventDescription;

    /**
     * 是否为当前激活事件
     * (使用 Boolean 类型映射 tinyint(1))
     */
    @TableField(value = "activate", insertStrategy = FieldStrategy.DEFAULT)
    @JsonIgnore
    private Boolean activate=false;



    @TableField(value = "gmt_create") // 插入时自动填充
    @JsonIgnore
    private String gmtCreate;

    @TableField(value = "gmt_modified") // 更新时自动填充
    @JsonIgnore
    private String gmtModified;

}