package com.hpcner.statusmanageservice;

import com.hpcner.statusmanageservice.bean.entity.EventInfo;
import com.hpcner.statusmanageservice.config.ServiceConfig;
import com.hpcner.statusmanageservice.serv.BaseService;
import com.hpcner.statusmanageservice.serv.ServiceFactory;
import com.hpcner.statusmanageservice.serv.deploy.DeployService;
import com.hpcner.statusmanageservice.serv.deploy.DeployXyqService;
import com.hpcner.statusmanageservice.service.database.EventInfoService;
import com.hpcner.statusmanageservice.utils.ApplicationContextUtil;
import com.hpcner.statusmanageservice.utils.TimeUtils;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;

import java.util.List;
import java.util.Map;

@SpringBootTest
@Slf4j
class StatusManageServiceApplicationTests {

    @Resource
    private EventInfoService eventInfoService;


    @Test
    void InsertEventInfo(){
        EventInfo eventInfo = new EventInfo();
        eventInfo.setEventName("TestEvent2");
        eventInfo.setGmtCreate(TimeUtils.getNowTime());
        eventInfo.setGmtModified(TimeUtils.getNowTime());
        if(eventInfoService.InsertEventByName(eventInfo) == -1){
            log.info("Event {} already exists",eventInfo.getEventName());
        }else{
            log.info("Event {} created",eventInfo.getEventName());
        }

    }

    @Test
    void Activate(){
        EventInfo eventInfo = new EventInfo();
        eventInfo.setEventName("TestEvent2");

        if(eventInfoService.ActivateByName(eventInfo)) {
            log.info("Event {} activated", eventInfo.getEventName());
        }
        else {
            log.info("Event {} activate failed", eventInfo.getEventName());
        }
    }

    @Test
    void Deactivate(){
        EventInfo eventInfo = new EventInfo();
        eventInfo.setEventName("TestEvent2");

        if(eventInfoService.DeactivateByName(eventInfo)) {
            log.info("Event {} deactivated", eventInfo.getEventName());
        }
        else {
            log.info("Event {} deactivate failed", eventInfo.getEventName());
        }
    }
    @Test
    void Delete(){
        EventInfo eventInfo = new EventInfo();
        eventInfo.setEventName("TestEvent2");

        if(eventInfoService.DeleteEventByName(eventInfo)) {
            log.info("Event {} deleted", eventInfo.getEventName());
        }
        else {
            log.info("Event {} deleted failed", eventInfo.getEventName());
        }
    }

    @Test
    void Update(){
        EventInfo eventInfo = new EventInfo();
        eventInfo.setEventName("TestEvent2");
        eventInfo.setEventLatitude(16.56);
        eventInfo.setEventLongitude(123.0);
        if(eventInfoService.UpdateEventByName(eventInfo)) {
            log.info("Event {} updated", eventInfo.getEventName());
        }
        else {
            log.info("Event {} updated failed", eventInfo.getEventName());
        }
    }
    @Test
    void Query(){
        EventInfo eventInfo = eventInfoService.GetActivate();
        if(eventInfo != null){
            log.info("Event {} activated",eventInfo.getEventName());
        }else{
            log.info("No activated event");
        }
        eventInfoService.GetAllEventInfo().forEach(event -> {
            log.info("Event {}",event.getEventName());
        });
    }

    @Test
    void GetService(){

        Map<String, Map<String, BaseService>> serviceMap = ServiceFactory.serviceMap;
        for(Map.Entry<String, Map<String, BaseService>> entry : serviceMap.entrySet()) {
            String type = entry.getKey();
            Map<String, BaseService> services = entry.getValue();

            for (Map.Entry<String, BaseService> serviceEntry : services.entrySet()) {

                BaseService service = serviceEntry.getValue();
                log.info("Service type: {} id:{}", type,service.getId()); // 打印实际类型
                //service.start("");
            }
        }
    }
}
