package com.hpcner.statusmanageservice.bean.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.hpcner.statusmanageservice.bean.entity.ServiceInfo;
import lombok.Data;

@Data
public class ServiceInfoVO {

    @JsonProperty("service_state")
    private String serviceState;
    @JsonProperty("service_id")
    private String serviceId;
    @JsonProperty("service_name")
    private String serviceName;
    @JsonProperty("service_json")
    private String serviceJson;

    public static ServiceInfoVO from(ServiceInfo serviceInfo){
        if(serviceInfo==null){
            return null;
        }
        ServiceInfoVO vo = new ServiceInfoVO();
        if(serviceInfo.getServiceState())
        {
            vo.setServiceState("run");
        }else {
            vo.setServiceState("stop");
        }
        vo.setServiceId(serviceInfo.getServiceId());
        vo.setServiceName(serviceInfo.getServiceName());
        vo.setServiceJson(serviceInfo.getServiceJson());
        return vo;
    }
}
