package com.hpcner.statusmanageservice;

import com.hpcner.statusmanageservice.config.ServiceConfig;
import org.apache.ibatis.annotations.Mapper;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.annotation.Configuration;

@SpringBootApplication
@MapperScan("com.hpcner.statusmanageservice.dao.mapper")
@EnableConfigurationProperties(ServiceConfig.class)
@EnableDiscoveryClient
public class StatusManageServiceApplication {

    public static void main(String[] args) {
        SpringApplication.run(StatusManageServiceApplication.class, args);
    }

}
