package com.hpcner.statusmanageservice.bean.vo;


import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hpcner.statusmanageservice.bean.entity.EventInfo;
import lombok.Data;

@Data
public class EventInfoVO {


    @JsonProperty("event_name")
    private String eventName;

    @JsonProperty("event_longitude")
    private String eventLongitude;

    @JsonProperty("event_latitude")
    private String eventLatitude;


    @JsonProperty("event_description")
    private String eventDescription;

    public static EventInfoVO from(EventInfo eventInfo){
        if(eventInfo==null){
            return null;
        }
        EventInfoVO vo = new EventInfoVO();
        vo.setEventName(eventInfo.getEventName());
        if(eventInfo.getEventLongitude()!=null){
            vo.setEventLongitude(String.valueOf(eventInfo.getEventLongitude()));
        }
        if(eventInfo.getEventLatitude()!=null){
            vo.setEventLatitude(String.valueOf(eventInfo.getEventLatitude()));
        }
        vo.setEventDescription(eventInfo.getEventDescription());
        return vo;
    }

}
