package com.hpcner.statusmanageservice.serv.other;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hpcner.statusmanageservice.bean.entity.ServiceInfo;
import com.hpcner.statusmanageservice.constant.ResponseConstant;
import com.hpcner.statusmanageservice.serv.BaseService;
import com.hpcner.statusmanageservice.service.database.ServiceInfoService;
import com.hpcner.statusmanageservice.utils.ApplicationContextUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.*;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

@Component("other_localization")
@Slf4j
public class LocalizationService extends BaseService {

    //这是本地服务的位置
    public static final String BASE_URL="http://Localization-Service";

    @Override
    public boolean start(String json) throws JsonProcessingException {

        RestTemplate restTemplate = ApplicationContextUtil.getBean(RestTemplate.class);
        String url = BASE_URL + "/start";


        ResponseEntity<String> result = restTemplate.postForEntity(url, null, String.class);

        if(result.getStatusCode().equals(HttpStatus.OK)){
            String retBody = result.getBody();
            log.info("Localization Service start result: {}", retBody);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(retBody);
            if(!jsonObject.has("code")){
                log.info("Error parse Localization Service result: {}", retBody);
                return false;
            }else{
                if(jsonObject.get("code").asInt()!= ResponseConstant.RES_OK){
                    log.info("Error starting Localization Service: {}", jsonObject.get("message").asText());
                    return false;
                }
            }
            ServiceInfoService serviceInfoService = ApplicationContextUtil.getBean(ServiceInfoService.class);
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.setServiceId(getId());
            serviceInfo.setServiceState(true);
            serviceInfoService.UpsertServiceInfoByServiceId(serviceInfo);
            return true;
        }else{
            return false;
        }
    }

    @Override
    public boolean stop() throws JsonProcessingException {
        RestTemplate restTemplate = ApplicationContextUtil.getBean(RestTemplate.class);
        String url = BASE_URL + "/stop";

        ResponseEntity<String> result = restTemplate.postForEntity(url, null, String.class);

        if(result.getStatusCode().equals(HttpStatus.OK)){
            String retBody = result.getBody();
            log.info("Localization Service start result: {}", retBody);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(retBody);
            if(!jsonObject.has("code")){
                log.info("Error parse Localization Service result: {}", retBody);
                return false;
            }else{
                if(jsonObject.get("code").asInt()!= ResponseConstant.RES_OK){
                    log.info("Error stopping Localization Service: {}", jsonObject.get("message").asText());
                    return false;
                }
            }
            ServiceInfoService serviceInfoService = ApplicationContextUtil.getBean(ServiceInfoService.class);
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.setServiceId(getId());
            serviceInfo.setServiceState(false);
            serviceInfoService.UpsertServiceInfoByServiceId(serviceInfo);
            return true;
        }else{
            return false;
        }
    }

    @Override
    public boolean restart(String json) throws JsonProcessingException {
        if(!stop()){
            return false;
        }
        if(start(json)){
            return true;
        }
        else{
            return false;
        }
    }



}
