package com.hpcner.statusmanageservice.serv.other;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hpcner.statusmanageservice.bean.entity.ServiceInfo;
import com.hpcner.statusmanageservice.serv.BaseService;
import com.hpcner.statusmanageservice.service.database.ServiceInfoService;
import com.hpcner.statusmanageservice.utils.ApplicationContextUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component("other_simulator")
@Slf4j
public class SimulatorService extends BaseService {

//(base) [cwk@iZ2ze2pfzefpro00cn0ybhZ backend-5.1.0]$ curl -X POST http://127.0.0.1:5096/start
//{"network":"network started (PID: 13791)","person":"person started (PID: 13792)","uav":"uav started (PID: 13793)"}
//(base) [cwk@iZ2ze2pfzefpro00cn0ybhZ backend-5.1.0]$ curl -X POST http://127.0.0.1:5096/start
//{"network":"network already running","person":"person already running","uav":"uav already running"}
//(base) [cwk@iZ2ze2pfzefpro00cn0ybhZ backend-5.1.0]$ curl -X POST http://127.0.0.1:5096/stop
//{"network":"network stopped","person":"person stopped","uav":"uav stopped"}
//(base) [cwk@iZ2ze2pfzefpro00cn0ybhZ backend-5.1.0]$ curl -X POST http://127.0.0.1:5096/stop
//{"network":"network not running","person":"person not running","uav":"uav not running"}
//(base) [cwk@iZ2ze2pfzefpro00cn0ybhZ backend-5.1.0]$ curl -X POST http://127.0.0.1:5096/restart
//{"network":"network started (PID: 13851)","person":"person started (PID: 13852)","uav":"uav started (PID: 13853)"}
//(base) [cwk@iZ2ze2pfzefpro00cn0ybhZ backend-5.1.0]$ curl -X POST http://127.0.0.1:5096/restart
//{"network":"network already running","person":"person already running","uav":"uav already running"}
//(base) [cwk@iZ2ze2pfzefpro00cn0ybhZ backend-5.1.0]$ curl -X POST http://127.0.0.1:5096/stop
//{"network":"network not running","person":"person not running","uav":"uav not running"}
//(base) [cwk@iZ2ze2pfzefpro00cn0ybhZ backend-5.1.0]$ curl -X POST http://127.0.0.1:5096/stop
//{"network":"network not running","person":"person not running","uav":"uav not running"}
//(base) [cwk@iZ2ze2pfzefpro00cn0ybhZ backend-5.1.0]$ curl -X POST http://127.0.0.1:5096/start
//{"network":"network started (PID: 13899)","person":"person started (PID: 13900)","uav":"uav started (PID: 13901)"}
//(base) [cwk@iZ2ze2pfzefpro00cn0ybhZ backend-5.1.0]$ curl -X POST http://127.0.0.1:5096/stop
//{"network":"network stopped","person":"person stopped","uav":"uav stopped"}
    public static final String BASE_URL="http://localhost:5096";


    @Override
    public boolean start(String json) {
        try {


            String url = String.format("%s/start", BASE_URL);
            log.info("Start other sim {}", url);

            RestTemplate restTemplate = new RestTemplate(new SimpleClientHttpRequestFactory());
            String result = restTemplate.postForObject(url, null, String.class);
            log.info("other sim result: {}", result);
            if (result == null) {
                log.info("Error parse other sim result: {}", result);
                return false;
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode resultObject = mapper.readTree(result);
            if (resultObject == null) {
                log.info("Error parse other sim result: {}", result);
                return false;
            }

            if (resultObject.has("network")) {
                if (!resultObject.get("network").asText().contains("started")) {
                    return false;
                }
            }
            if (resultObject.has("person")) {
                if (!resultObject.get("person").asText().contains("started")) {
                    return false;
                }
            }
            if (resultObject.has("uav")) {
                if (!resultObject.get("uav").asText().contains("started")) {
                    return false;
                }
            }
            ServiceInfoService serviceInfoService = ApplicationContextUtil.getBean(ServiceInfoService.class);
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.setServiceId(getId());
            serviceInfo.setServiceState(true);
            serviceInfoService.UpsertServiceInfoByServiceId(serviceInfo);
            return true;
        } catch (Exception e) {
            log.error("Exception in other sim", e);
            return false;
        }
    }
    @Override
    public boolean stop() {
        try {


            String url = String.format("%s/stop", BASE_URL);
            log.info("Stop other sim {}", url);

            RestTemplate restTemplate = new RestTemplate(new SimpleClientHttpRequestFactory());
            String result = restTemplate.postForObject(url, null, String.class);
            log.info("other sim result: {}", result);
            if (result == null) {
                log.info("Error parse other sim result: {}", result);
                return false;
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode resultObject = mapper.readTree(result);
            if (resultObject == null) {
                log.info("Error parse other sim result: {}", result);
                return false;
            }

            if (resultObject.has("network")) {
                if (!resultObject.get("network").asText().contains("stopped")) {
                    return false;
                }
            }
            if (resultObject.has("person")) {
                if (!resultObject.get("person").asText().contains("stopped")) {
                    return false;
                }
            }
            if (resultObject.has("uav")) {
                if (!resultObject.get("uav").asText().contains("stopped")) {
                    return false;
                }
            }
            ServiceInfoService serviceInfoService = ApplicationContextUtil.getBean(ServiceInfoService.class);
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.setServiceId(getId());
            serviceInfo.setServiceState(false);
            serviceInfoService.UpsertServiceInfoByServiceId(serviceInfo);
            return true;
        } catch (Exception e) {
            log.error("Exception in other sim", e);
            return false;
        }
    }

    @Override
    public boolean restart(String json) {
        if(!stop()){
            return false;
        }
        if(start(json)){
            return true;
        }
        else{
            return false;
        }
    }
}
