package com.hpcner.statusmanageservice.serv.recog;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hpcner.statusmanageservice.bean.entity.ServiceInfo;
import com.hpcner.statusmanageservice.serv.BaseService;
import com.hpcner.statusmanageservice.service.database.ServiceInfoService;
import com.hpcner.statusmanageservice.utils.ApplicationContextUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.*;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.concurrent.atomic.AtomicBoolean;

@Component("edgetoedge")
@Slf4j
public class RecogThhService extends BaseService {

    //curl -X GET http://localhost:8000/e2e_status
    // {"status":"success","services":{"service1":"stopped","service2":"stopped"}}
//curl -X GET http://localhost:8000/e2e_status
//{"status":"success","services":{"service1":"running","service2":"running"}}(base)


    // curl -X POST http://localhost:8000/e2e_start
    //{"status":"completed","details":{"service1":"started","service2":"started"}}(base) [cwk@iZ2ze2pfzefpro00cn0ybhZ StatusManageService]$ curl -X POST http://localhost:8000/e2e_start
    //{"status":"completed","details":{"service1":"already running","service2":"already running"}}

    // curl -X POST http://localhost:8000/e2e_stop
    //curl -X POST http://localhost:8000/e2e_stop
    //{"status":"completed","details":{"service1":"stopped","service2":"stopped"}}(base) [cwk@iZ2ze2pfzefpro00cn0ybhZ StatusManageService]$ curl -X POST http://localhost:8000/e2e_stop
    //{"status":"completed","details":{"service1":"already stopped","service2":"already stopped"}}

    public static final String BASE_URL="http://localhost:8000";

    @Override
    public boolean start(String json) {
        //curl -X POST  "http://localhost:8081/models?url=retinanet.mar&initial_workers=3"

        try {
            ObjectMapper mapper = new ObjectMapper();

            String url = String.format("%s/e2e_start", BASE_URL);
            log.info("Start recog thh {}", url);

            RestTemplate restTemplate = new RestTemplate(new SimpleClientHttpRequestFactory());
            ResponseEntity<String> responseEntity = restTemplate.postForEntity(url, null, String.class);

            if(!responseEntity.getStatusCode().equals(HttpStatus.OK)){
                return false;
            }
            JsonNode resultObject = mapper.readTree(responseEntity.getBody());
            if (resultObject == null) {
                log.info("Error parse recog thh result: {}", responseEntity.getBody());
                return false;
            }

            if (!resultObject.has("details")) {
                log.info("Error starting recog thh: {}", responseEntity.getBody());
                return false;
            }
            AtomicBoolean started = new AtomicBoolean(false);
            resultObject.get("details").fields().forEachRemaining(entry -> {
                String serviceName = entry.getKey();
                String serviceStatus = entry.getValue().asText();
                if(serviceStatus.contains("already")) {
                    log.info("Service {} is already running", serviceName);
                    started.set(true);
                }

            });
            if(started.get()){
                return false;
            }
            ServiceInfoService serviceInfoService = ApplicationContextUtil.getBean(ServiceInfoService.class);
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.setServiceId(getId());
            serviceInfo.setServiceState(true);
            serviceInfoService.UpsertServiceInfoByServiceId(serviceInfo);
            return true;
        } catch (Exception e) {
            log.error("Exception in start recog zgs", e);
            return false;
        }
    }

    @Override
    public boolean stop() {

        try {
            ObjectMapper mapper = new ObjectMapper();

            String url = String.format("%s/e2e_stop", BASE_URL);
            log.info("Stop recog thh {}", url);

            RestTemplate restTemplate = new RestTemplate(new SimpleClientHttpRequestFactory());
            ResponseEntity<String> responseEntity = restTemplate.postForEntity(url, null, String.class);

            if(!responseEntity.getStatusCode().equals(HttpStatus.OK)){
                return false;
            }
            JsonNode resultObject = mapper.readTree(responseEntity.getBody());
            if (resultObject == null) {
                log.info("Error parse recog thh result: {}", responseEntity.getBody());
                return false;
            }

            if (!resultObject.has("details")) {
                log.info("Error Stopping recog thh: {}", responseEntity.getBody());
                return false;
            }
            AtomicBoolean started = new AtomicBoolean(false);
            resultObject.get("details").fields().forEachRemaining(entry -> {
                String serviceName = entry.getKey();
                String serviceStatus = entry.getValue().asText();
                if(serviceStatus.contains("already")) {
                    log.info("Service {} is already stopped", serviceName);
                    started.set(true);
                }

            });
            if(started.get()){
                return false;
            }
            ServiceInfoService serviceInfoService = ApplicationContextUtil.getBean(ServiceInfoService.class);
            ServiceInfo serviceInfo = new ServiceInfo();
            serviceInfo.setServiceId(getId());
            serviceInfo.setServiceState(false);
            serviceInfoService.UpsertServiceInfoByServiceId(serviceInfo);
            return true;
        } catch (Exception e) {
            log.error("Exception in stop recog zgs", e);
            return false;
        }
    }

    @Override
    public boolean restart(String json) {
        if(!stop()){
            return false;
        }
        if(start(json)){
            return true;
        }
        else{
            return false;
        }
    }
}
