package com.hpcner.statusmanageservice.bean.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.hpcner.statusmanageservice.bean.dto.ServiceInfoDTO;
import lombok.Data;

import java.io.Serializable;

@Data
@TableName("service_info")
public class ServiceInfo {

    // -------------------- 主键字段 --------------------
    /**
     * 服务ID
     */
    @TableId(value = "service_id", type = IdType.INPUT)
    private String serviceId;

    /**
     * 服务类型
     */
    @TableField(value = "service_type")
    private String serviceType;

    // -------------------- 其他字段 --------------------
    /**
     * ID
     */
    private Integer id;

    /**
     * 服务名称
     */
    @TableField("service_name")
    private String serviceName;

    /**
     * 服务状态
     */
    @TableField("service_state")
    private Boolean serviceState;

    /**
     * 服务JSON配置
     */
    @TableField("service_json")
    private String serviceJson;


    public  static  ServiceInfo from(ServiceInfoDTO serviceInfoDTO){
        if(serviceInfoDTO == null)
        {
            return  null;
        }
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setServiceId(serviceInfoDTO.getServiceId());
        serviceInfo.setServiceType(serviceInfoDTO.getServiceType());
        serviceInfo.setServiceName(serviceInfoDTO.getServiceName());
        serviceInfo.setServiceState(serviceInfoDTO.getServiceState());
        serviceInfo.setServiceJson(serviceInfoDTO.getServiceJson());
        return serviceInfo;

    }
}
