package com.hpcner.statusmanageservice.controller;

import com.hpcner.statusmanageservice.bean.Response;
import com.hpcner.statusmanageservice.bean.dto.ServiceInfoDTO;
import com.hpcner.statusmanageservice.bean.entity.ServiceInfo;
import com.hpcner.statusmanageservice.bean.vo.ServiceInfoVO;
import com.hpcner.statusmanageservice.constant.ResponseConstant;
import com.hpcner.statusmanageservice.serv.BaseService;
import com.hpcner.statusmanageservice.serv.ServiceFactory;
import com.hpcner.statusmanageservice.service.database.ServiceInfoService;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.javassist.NotFoundException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Controller
@RequestMapping("/service")
public class ServiceController {
    @Resource
    private ServiceInfoService serviceInfoService;


    @PostMapping("/manage")
    @ResponseBody
    public Response  manageService(@RequestBody ServiceInfoDTO serviceInfoDTO){
        try {
            if (serviceInfoDTO == null || serviceInfoDTO.serviceType == null || serviceInfoDTO.serviceId == null) {
                return Response.builder().code(ResponseConstant.RES_ILLEGAL_PARAM).msg("非法参数").data("").build();
            }
            String action = serviceInfoDTO.serviceOperation.toLowerCase();
            boolean success = false;

//            ServiceInfo serviceInfo = ServiceInfo.from(serviceInfoDTO);
            BaseService baseService = ServiceFactory.CreateService(serviceInfoDTO);
            if(baseService==null) {
                return Response.builder().code(ResponseConstant.RES_ILLEGAL_PARAM).msg("找不到服务").data("").build();
            }
            if (action.equals("start")) {
                if(!serviceInfoService.IsActivate(serviceInfoDTO.serviceId)) {
                    success = baseService.start(serviceInfoDTO.serviceJson);
                }else{
                    return Response.builder().code(ResponseConstant.RES_ILLEGAL_ACTION).msg("服务已启动").data("").build();
                }
            } else if (action.equals("stop")) {
                if(!serviceInfoService.IsActivate(serviceInfoDTO.serviceId)) {
                    return Response.builder().code(ResponseConstant.RES_ILLEGAL_ACTION).msg("服务已停止").data("").build();
                }
                success = baseService.stop();
            } else if (action.equals("restart")) {
                success = baseService.restart(serviceInfoDTO.serviceJson);
            }
            if (!success) {
                return Response.builder().code(ResponseConstant.RES_SERVER_ERROR).msg("操作失败").data("").build();
            }

            return Response.builder().code(ResponseConstant.RES_OK).msg("成功更新配置信息!").data("").build();
        }catch (NotFoundException e) {
            return Response.builder().code(ResponseConstant.RES_ILLEGAL_ACTION).msg("服务未找到").data("").build();
        }
        catch (Exception e){
            log.error("Error in updateService: {}", e.getMessage());
            return Response.builder().code(ResponseConstant.RES_SERVER_ERROR).msg("服务器错误").data("").build();
        }


    }


    @PostMapping("/update")
    @ResponseBody
    public Response updateService(@RequestBody ServiceInfoDTO serviceInfoDTO){
        try {


            if (serviceInfoDTO == null || serviceInfoDTO.serviceId == null) {
                return Response.builder().code(ResponseConstant.RES_ILLEGAL_PARAM).msg("非法参数").data("").build();
            }
            log.info("Service Update {}",serviceInfoDTO);
            boolean success = serviceInfoService.UpsertServiceInfoByServiceId(ServiceInfo.from(serviceInfoDTO));
            if (!success) {
                return Response.builder().code(ResponseConstant.RES_SERVER_ERROR).msg("更新失败").data("").build();
            }
            return Response.builder().code(ResponseConstant.RES_OK).msg("成功更新配置信息!").data("").build();
        }catch (Exception e){
            log.error("Error in updateService: {}", e.getMessage());
            return Response.builder().code(ResponseConstant.RES_SERVER_ERROR).msg("服务器错误").data("").build();
        }
    }


    @PostMapping("/info")
    @ResponseBody
    public Response getServiceInfo( ) {
        try {


            List<ServiceInfo> serviceInfos = serviceInfoService.ListAll();
            Map<String,List<ServiceInfoVO>> ret = new HashMap<>();
            ret.put("other",new ArrayList<>());
            ret.put("deploy",new ArrayList<>());
            ret.put("recog",new ArrayList<>());
            if (serviceInfos == null || serviceInfos.isEmpty()) {
                return Response.builder().code(ResponseConstant.RES_OK).msg("成功获取服务信息!").data(ret).build();
            }
            for (ServiceInfo serviceInfo : serviceInfos) {
                String serviceType = serviceInfo.getServiceType();
                ret.get(serviceType).add(ServiceInfoVO.from(serviceInfo));
            }
            return Response.builder().code(ResponseConstant.RES_OK).msg("成功获取服务信息!").data(ret).build();
        } catch (Exception e) {
            log.error("Error in getServiceInfo: {}", e.getMessage());
            return Response.builder().code(ResponseConstant.RES_SERVER_ERROR).msg("服务器错误").data("").build();
        }
    }
}
