package com.hpcner.statusmanageservice.controller;




import com.hpcner.statusmanageservice.bean.Response;
import com.hpcner.statusmanageservice.constant.ResponseConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.slf4j.LoggerFactory;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;

import java.util.Map;

@Controller
@Slf4j
public class StaticPageController {
    Logger logger = (Logger) LoggerFactory.getLogger("com.hpcner");
    private final Map<String,Level> levelMap = Map.of(
            "DEBUG",Level.DEBUG,
            "INFO",Level.INFO,
            "WARN",Level.WARN,
            "ERROR",Level.ERROR,
            "TRACE",Level.TRACE,
            "ALL",Level.ALL,
            "OFF",Level.OFF
    );
    /**
     * 注意，这里是个静态映射，返回的是一个html页面
     * 该页面内容位于 src/main/resources/static/index.html
     * 当访问"/" 或者 "index.html"时都会返回此html页面的内容
     * 具体内容可见：
     *          <a href="https://blog.csdn.net/Blue_Zwj/article/details/123312856">...</a>
     *          <a href="https://www.jb51.net/article/195744.htm">...</a>
     *          <a href="https://blog.csdn.net/m0_67391870/article/details/124469402">...</a>
     * 静态映射时不能加 @RestController 或者 @ResponseBody 注解。
     * @return index.html页面内容
     */
    @GetMapping("/")
    public String index(){
        return "index";
    }

    @RequestMapping(value = "/",method = {RequestMethod.HEAD})
    @ResponseBody
    public Response healthCheck() {
        //aliyun slb health check
        log.debug("health check");
        return Response.builder().code(200).msg("ok").data("").build();
    }
    @GetMapping("/v3/")
    public String indexV3(){
        return "index";
    }

    @PostMapping("/loglevel")
    @ResponseBody
    public Response changeLogLevel(@RequestParam("level") String level){
        String levelUpperCase = level.toUpperCase();
        if(levelMap.containsKey(levelUpperCase)){
            logger.setLevel(levelMap.get(levelUpperCase));
            return Response.builder().code(200).msg(String.format("日志等级修改为%s",levelUpperCase)).data("").build();
        }
        return Response.builder().code(ResponseConstant.RES_ILLEGAL_PARAM).msg("非法参数").data("").build();
    }
}
