package com.hpcner.statusmanageservice.serv.deploy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hpcner.statusmanageservice.constant.ResponseConstant;
import com.hpcner.statusmanageservice.serv.BaseService;
import com.hpcner.statusmanageservice.utils.ApplicationContextUtil;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

@Slf4j
@Data
public class DeployService extends BaseService {


    public static final String BASE_URL="http://iccs-b-server24-2";

    @Override
    public boolean start(String json) throws JsonProcessingException {

        RestTemplate restTemplate = ApplicationContextUtil.getBean(RestTemplate.class);
        String url = BASE_URL + "/algo/control/run";

        Map<String,Object> req = Map.of(
                "algo_name", getId()

        );
        ResponseEntity<String> result = restTemplate.postForEntity(url, req, String.class);

        if(result.getStatusCode().equals(HttpStatus.OK)){
            String retBody = result.getBody();
            log.info("DeployService start result: {}", retBody);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(retBody);
            if(!jsonObject.has("code")){
                log.info("Error parse deploy result: {}", retBody);
                return false;
            }else{
                if(jsonObject.get("code").asInt()!= ResponseConstant.RES_OK){
                    log.info("Error starting deploy: {}", jsonObject.get("msg").asText());
                    return false;
                }
            }
            return true;
        }else{
            return false;
        }
    }

    @Override
    public boolean stop() throws JsonProcessingException {
        RestTemplate restTemplate = ApplicationContextUtil.getBean(RestTemplate.class);
        String url = BASE_URL + "/algo/control/stop";
        Map<String,Object> req = Map.of(
                "algo_name", getId()

        );
        ResponseEntity<String> result = restTemplate.postForEntity(url, req, String.class);

        if(result.getStatusCode().equals(HttpStatus.OK)){
            String retBody = result.getBody();
            log.info("DeployService start result: {}", retBody);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(retBody);
            if(!jsonObject.has("code")){
                log.info("Error parse deploy result: {}", retBody);
                return false;
            }else{
                if(jsonObject.get("code").asInt()!= ResponseConstant.RES_OK){
                    log.info("Error stopping deploy: {}", jsonObject.get("msg").asText());
                    return false;
                }
            }
            return true;
        }else{
            return false;
        }
    }

    @Override
    public boolean restart(String json) throws JsonProcessingException {
        RestTemplate restTemplate = ApplicationContextUtil.getBean(RestTemplate.class);
        String url = BASE_URL + "/algo/control/restart";
        Map<String,Object> req = Map.of(
                "algo_name", getId()

        );
        ResponseEntity<String> result = restTemplate.postForEntity(url, req, String.class);

        if(result.getStatusCode().equals(HttpStatus.OK)){
            String retBody = result.getBody();
            log.info("DeployService start result: {}", retBody);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObject = mapper.readTree(retBody);
            if(!jsonObject.has("code")){
                log.info("Error parse deploy result: {}", retBody);
                return false;
            }else{
                if(jsonObject.get("code").asInt()!= ResponseConstant.RES_OK){
                    log.info("Error starting deploy: {}", jsonObject.get("msg").asText());
                    return false;
                }
            }
            return true;
        }else{
            return false;
        }
    }
}
