package com.hpcner.statusmanageservice.service.database.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.hpcner.statusmanageservice.bean.entity.EventInfo;
import com.hpcner.statusmanageservice.dao.mapper.EventInfoMapper;
import com.hpcner.statusmanageservice.service.database.EventInfoService;
import com.hpcner.statusmanageservice.utils.TimeUtils;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
@Slf4j
public class EventInfoServiceImpl extends ServiceImpl<EventInfoMapper, EventInfo> implements EventInfoService {
    @Override
    public int InsertEventByName(EventInfo newEvent) {
        if(newEvent == null || newEvent.getEventName() == null|| newEvent.getEventName().equals("")){
            return -1;
        }
        QueryWrapper<EventInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("event_name", newEvent.getEventName());
        EventInfo eventInfo = this.getOne(queryWrapper);
        if (eventInfo != null) {
            return -1;
        }
        newEvent.setGmtCreate(TimeUtils.getNowTime());
        newEvent.setGmtModified(TimeUtils.getNowTime());
        this.save(newEvent);
        QueryWrapper<EventInfo> queryWrapper2 = new QueryWrapper<>();
        queryWrapper2.eq("event_name",newEvent.getEventName());
        eventInfo = this.getOne(queryWrapper2);
        if(eventInfo==null){
            log.info("Can't find {}",newEvent.getEventName());
            return 0;
        }

        return eventInfo.getEventId();
    }

    @Override
    public boolean ActivateByName(EventInfo eventInfo) {
        if(eventInfo == null || eventInfo.getEventName() == null|| eventInfo.getEventName().equals("")){
            return false;
        }
        UpdateWrapper<EventInfo> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("activate",false);
        this.update(updateWrapper);
        updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("event_name", eventInfo.getEventName());
        updateWrapper.set("activate",true).set("gmt_modified", TimeUtils.getNowTime());
        return this.update(updateWrapper);

    }

    @Override
    public boolean DeactivateByName(EventInfo eventInfo) {
        if(eventInfo == null || eventInfo.getEventName() == null|| eventInfo.getEventName().equals("")){
            return false;
        }

        UpdateWrapper<EventInfo> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("event_name", eventInfo.getEventName());
        updateWrapper.set("activate",false).set("gmt_modified", TimeUtils.getNowTime());
        return this.update(updateWrapper);

    }

    @Override
    public boolean DeleteEventByName(EventInfo eventInfo) {
        if(eventInfo == null || eventInfo.getEventName() == null|| eventInfo.getEventName().equals("")){
            return false;
        }
        QueryWrapper<EventInfo> queryWrapper = Wrappers.query();
        queryWrapper.eq("event_name", eventInfo.getEventName());
        return this.remove(queryWrapper);
    }

    @Override
    public boolean UpdateEventByName(EventInfo eventInfo) {
        if (eventInfo == null || eventInfo.getEventName() == null || eventInfo.getEventName().equals("")) {
            return false;
        }

        UpdateWrapper<EventInfo> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("event_name", eventInfo.getEventName());

        if (eventInfo.getEventLongitude() != null) {
            updateWrapper.set("event_longitude", eventInfo.getEventLongitude());
        }
        if (eventInfo.getEventLatitude() != null) {
            updateWrapper.set("event_latitude", eventInfo.getEventLatitude());
        }
        if (eventInfo.getEventDescription() != null) {
            updateWrapper.set("event_description", eventInfo.getEventDescription());
        }
        updateWrapper.set("gmt_modified", TimeUtils.getNowTime());

        return this.update(updateWrapper);
    }

    @Override
    public EventInfo GetActivate() {
        QueryWrapper<EventInfo> queryWrapper = Wrappers.query();
        queryWrapper.eq("activate", true);
        EventInfo eventInfo = this.getOne(queryWrapper);
        if (eventInfo == null || eventInfo.getEventName() == null || eventInfo.getEventName().equals("")) {
            return null ;
        }
        return eventInfo;

    }

    @Override
    public List<EventInfo> GetAllEventInfo() {
        List<EventInfo> eventInfos = this.list();
        if (eventInfos == null || eventInfos.isEmpty()) {
            return null;
        }
        for (EventInfo eventInfo : eventInfos) {
            if (eventInfo.getGmtCreate() == null || eventInfo.getGmtModified() == null) {
                return null;
            }
        }
        return eventInfos;
    }
}
