package com.hpcner.statusmanageservice.service.database.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.hpcner.statusmanageservice.bean.entity.ServiceInfo;
import com.hpcner.statusmanageservice.dao.mapper.ServiceInfoMapper;
import com.hpcner.statusmanageservice.serv.BaseService;
import com.hpcner.statusmanageservice.service.database.ServiceInfoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.javassist.NotFoundException;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Slf4j
@Repository
public class ServiceInfoServiceImpl extends ServiceImpl<ServiceInfoMapper, ServiceInfo> implements ServiceInfoService {

    public static  final  String key = "service_id";
    @Override
    public ServiceInfo GetServiceInfoByServiceId(String sid) {
        QueryWrapper<ServiceInfo> queryWrapper = Wrappers.query();
        queryWrapper.eq(key,sid);
        return this.getOne(queryWrapper);
    }

    @Override
    public boolean UpsertServiceInfoByServiceId(ServiceInfo serviceInfo) {
        if(serviceInfo == null || serviceInfo.getServiceId() ==null){
            return  false;
        }
        QueryWrapper<ServiceInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(key,serviceInfo.getServiceId());
        ServiceInfo existingServiceInfo = this.getOne(queryWrapper);
        if (existingServiceInfo == null) {
            if(serviceInfo.getServiceType()==null){
                serviceInfo.setServiceType("other");
            }
            return this.save(serviceInfo);
        }
        UpdateWrapper<ServiceInfo> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq(key,serviceInfo.getServiceId());
        if(serviceInfo.getServiceState()!=null){
            updateWrapper.set("service_state",serviceInfo.getServiceState());
        }
        if(serviceInfo.getServiceJson()!=null){
            updateWrapper.set("service_json",serviceInfo.getServiceJson());
        }
        if(serviceInfo.getServiceName()!=null){
            updateWrapper.set("service_name",serviceInfo.getServiceName());
        }
        if(serviceInfo.getServiceType()!=null){
            updateWrapper.set("service_type",serviceInfo.getServiceType());
        }
        return this.update(updateWrapper);
    }

    @Override
    public boolean DeleteServiceInfoByServiceId(String sid) {
        if(sid == null  ){
            return  false;
        }
        return this.remove(Wrappers.<ServiceInfo>query().eq(key,sid));
    }

    @Override
    public List<ServiceInfo> ListAll() {
        return  this.list();
    }

    @Override
    public void DeleteNotExist(Map<String, Map<String, BaseService>> info) {
        List<ServiceInfo> serviceInfos = this.list();
        for (ServiceInfo serviceInfo : serviceInfos) {
            String serviceId = serviceInfo.getServiceId();
            String serviceType = serviceInfo.getServiceType();
            Map<String, BaseService> services = info.get(serviceType);
            if (services == null || !services.containsKey(serviceId)) {
                this.DeleteServiceInfoByServiceId(serviceId);
            }
        }
    }

    @Override
    public boolean IsActivate(String sid) throws NotFoundException {
        if(sid == null){
            throw new NotFoundException("Service id is null");
        }
        QueryWrapper<ServiceInfo> queryWrapper = Wrappers.query();
        queryWrapper.eq(key,sid);
        ServiceInfo serviceInfo = this.getOne(queryWrapper);
        if(serviceInfo == null){
            throw new NotFoundException("Service not found");
        }
        return serviceInfo.getServiceState();
    }
}
