package com.hpcner.statusmanageservice.utils;

import com.hpcner.statusmanageservice.bean.entity.ServiceInfo;
import com.hpcner.statusmanageservice.config.ServiceConfig;
import com.hpcner.statusmanageservice.serv.BaseService;
import com.hpcner.statusmanageservice.serv.ServiceFactory;
import com.hpcner.statusmanageservice.service.database.ServiceInfoService;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Component
public class InitHelper implements CommandLineRunner {
    @Resource
    private ServiceConfig serviceConfig;

    @Resource
    private ServiceInfoService serviceInfoService;
    @Override
    public void run(String... args) throws Exception {
        Map<String, Map<String, BaseService>> serviceMap = ServiceFactory.serviceMap;

        List<BaseService> deployLists = serviceConfig.getDeployLists();
        Map<String,BaseService> deployMap = new HashMap<>();
        for (BaseService deploy : deployLists) {
            BaseService bean =(BaseService) ApplicationContextUtil.getBean(deploy.getId());

            if (bean != null) {
                bean.reValue(deploy);
                log.info("Deploy bean: {}", bean.getId());
                deployMap.put(deploy.getId(), bean);
            }

        }
        serviceMap.put("deploy", deployMap);
        List<BaseService> recogLists = serviceConfig.getRecogLists();
        Map<String,BaseService> recogMap = new HashMap<>();
        for (BaseService recog : recogLists) {
            BaseService bean =(BaseService) ApplicationContextUtil.getBean(recog.getId());

            if (bean != null) {
                bean.reValue(recog);
                log.info("Recog bean: {}", bean.getId());
                recogMap.put(recog.getId(), bean);
            }
        }
        serviceMap.put("recog", recogMap);
        List<BaseService> otherLists = serviceConfig.getOtherLists();
        Map<String,BaseService> otherMap = new HashMap<>();
        for (BaseService other : otherLists) {
            BaseService bean =(BaseService) ApplicationContextUtil.getBean(other.getId());

            if (bean != null) {
                bean.reValue(other);
                log.info("Other bean: {}", bean.getId());
                otherMap.put(other.getId(), bean);
            }
        }
        serviceMap.put("other", otherMap);
        log.info("Service map initialized: {}", serviceMap);
        // 初始化服务信息
        for (Map.Entry<String, Map<String, BaseService>> entry : serviceMap.entrySet()) {
            String serviceType = entry.getKey();
            Map<String, BaseService> services = entry.getValue();
            for (Map.Entry<String, BaseService> serviceEntry : services.entrySet()) {

                BaseService service = serviceEntry.getValue();
                ServiceInfo  si = new ServiceInfo();
                si.setServiceId(service.getId());
                si.setServiceName(service.getName());
                si.setServiceType(serviceType);
                //si.setServiceJson(service.getJson());
                serviceInfoService.UpsertServiceInfoByServiceId(si);
            }
        }
        serviceInfoService.DeleteNotExist(serviceMap);
    }
}
