#归一化pso
import math
import time
from itertools import combinations

import numpy as np
from matplotlib import pyplot as plt

import Users
from pso import PSO
from improvedPSO import CPSO
import tool
import GDOP
import ObjectiveFuction as OF
import constants as C
import dynamicProcess as dynamic

plt.style.use('seaborn-whitegrid')

# 设置字体为 Times New Roman
plt.rcParams['font.family'] = 'Times New Roman'

#slot1为长时间尺度，slot2短时间尺度
def whole_process(users,k,slot1,slot2):
    # users= Users.getUsers("./data.csv")
    uavs=tool.getUavInitialPos(k,users)
    pre_uavs=uavs
    # r_c,r_p=dynamic.random_r(users)
    fitness=[]
    df_c=dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index=0
    r_c,r_p=dynamic.get_r_c_and_r_p(df_c,df_p,index)
    pso = CPSO(pre_uavs, users, r_c, r_p, k, )
    e=0
    for i in range(0,10*slot1,slot2):
        users_loc = dynamic.gauss_markov_model(users, C.v * slot2, C.max_range, )
        users = users_loc
        if i%C.r_change_slot==0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        if i % slot1 != 0:
            c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
            f,e,rate,gdop=OF.real_objective(pre_uavs, uavs, users, r_p, p_all, b_all, c_association, p_association,slot2)
            print(f,rate,gdop)
            print("悬停时隙能耗：", e)
            fitness.append(f)
        else:#资源重分配，无人机重部署
            c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
            pso.re_init(pre_uavs,users,r_c,r_p,c_association, p_association, p_all, b_all)
            X, V = pso.initParticle(users)
            global_pos, global_best, result = pso.pso(X, V, OF.linear_w, OF.objective,)
            f,e, rate, gdop = OF.real_objective(pre_uavs, global_pos, users, r_p, p_all, b_all, c_association, p_association,slot2)
            print("飞行时隙能耗：",e)
            pre_uavs=global_pos
            uavs=global_pos
            fitness.append(f)
            # fitness.append(global_best[0])

    print(fitness)
def whole_process_new(U,k,slot1,slot2):
    # users= Users.getUsers("./data.csv")
    users=U[0]
    uavs=tool.getUavInitialPos(k,users)
    pre_uavs=uavs
    # r_c,r_p=dynamic.random_r(users)
    fitness=[]
    df_c=dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index=0
    r_c,r_p=dynamic.get_r_c_and_r_p(df_c,df_p,index)
    c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
    f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_c,r_p, p_all, b_all, c_association, p_association, slot2)
    r, g = OF.cal_satisfaction(uavs, users, p_all, b_all, r_c, r_p, c_association, p_association)
    fitness.append(f)

    pso = CPSO(pre_uavs, users, r_c, r_p, k, )
    e=0
    j=1
    r_s=[]
    g_s=[]
    r_s.append(r)
    g_s.append(g)
    for i in range(10,3*C.r_change_slot,slot2):
        users= U[j]
        j+=1
        if i%C.r_change_slot==0 and i!=0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        if i % slot1 != 0:
            c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
            # c_association, p_association, p_all, b_all = OF.objective_resource_avg(uavs, users, r_c)
            f,e,rate,gdop=OF.real_objective(pre_uavs, uavs, users,r_c, r_p, p_all, b_all, c_association, p_association,slot2)
            r,g=OF.cal_satisfaction(uavs, users, p_all, b_all, r_c, r_p, c_association, p_association)
            r_s.append(r)
            g_s.append(g)
            print(f,rate,gdop)
            print("满足率",r,g)
            print("悬停时隙能耗：", e)
            fitness.append(f)
        else:#资源重分配，无人机重部署
            # c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
            c_association, p_association, p_all, b_all = OF.objective_resource_avg(uavs, users, r_c)
            pso.re_init(pre_uavs,users,r_c,r_p,c_association, p_association, p_all, b_all)
            X, V = pso.initParticle(users)
            global_pos, global_best, result = pso.pso(X, V, OF.linear_w, OF.objective,)

            print("pso:",global_best)
            c_association, p_association, p_all, b_all = OF.objective_resource(global_pos, users, r_c)
            r, g = OF.cal_satisfaction(global_pos, users, p_all, b_all, r_c, r_p, c_association, p_association)
            print("满足率", r, g)
            r_s.append(r)
            g_s.append(g)
            f,e, rate, gdop = OF.real_objective(pre_uavs, global_pos, users, r_c,r_p, p_all, b_all, c_association, p_association,slot2)
            if f>global_best[0]:
                fitness.append(f)
            else:
                fitness.append(global_best[0])
            print("实际:",f)
            print("飞行时隙能耗：",e)
            pre_uavs=global_pos
            uavs=global_pos
            # fitness.append(f)
            # fitness.append(global_best[0])

    print("proposed:",fitness)
    print(r_s)
    print(g_s)
    return fitness
def whole_process_kmeans(U,k,slot1,slot2):
    users = U[0]
    uavs = tool.getUavInitialPos(k, users)
    pre_uavs = uavs
    # r_c,r_p=dynamic.random_r(users)
    fitness = []
    df_c = dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index = 0
    r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
    c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
    f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_c, r_p, p_all, b_all, c_association, p_association,
                                         slot2)
    fitness.append(f)
    j = 1
    for i in range(0, 3 * C.r_change_slot, slot2):
        users = U[j]
        j += 1
        if i % C.r_change_slot == 0 and i != 0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        if i % slot1 != 0:
            c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
            # c_association, p_association, p_all, b_all = OF.objective_resource_avg(uavs, users, r_c)
            f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_c, r_p, p_all, b_all, c_association,
                                                 p_association, slot2)
            print(f, rate, gdop)
            print("悬停时隙能耗：", e)
            fitness.append(f)
        else:  # 资源重分配，无人机重部署
            uavs = tool.getUavInitialPos(k, users)
            c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
            f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_c, r_p, p_all, b_all, c_association,
                                                 p_association, slot2)
            fitness.append(f)
            print("实际:", f)
            print("飞行时隙能耗：", e)
            pre_uavs = uavs
    print(fitness)

def fixed_position_fixed_resource(U,k,slot1,slot2):
    users = U[0]
    uavs = tool.getUavInitialPos(k, users)
    pre_uavs = uavs
    # r_c,r_p=dynamic.random_r(users)
    fitness = []
    df_c = dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index = 0
    r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
    c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
    f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_c, r_p, p_all, b_all, c_association, p_association,
                                         slot2)
    r, g = OF.cal_satisfaction(uavs, users, p_all, b_all, r_c, r_p, c_association, p_association)
    fitness.append(f)

    j = 1
    r_s = []
    g_s = []
    r_s.append(r)
    g_s.append(g)
    for i in range(0, 3 * C.r_change_slot, slot2):
        users = U[j]
        j += 1
        if i % C.r_change_slot == 0 and i != 0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_c, r_p, p_all, b_all, c_association,
                                         p_association, slot2)
        fitness.append(f)
    print(fitness)
    return fitness

def whole_process_pso(users,k,slot1,slot2):
    # users= Users.getUsers("./data.csv")
    uavs=tool.getUavInitialPos(k,users)
    pre_uavs=uavs
    # r_c,r_p=dynamic.random_r(users)
    fitness=[]
    df_c=dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index=0
    r_c,r_p=dynamic.get_r_c_and_r_p(df_c,df_p,index)
    pso = PSO(pre_uavs, users, r_c, r_p, k, )
    e=0
    for i in range(0,10*slot1,slot2):
        users_loc = dynamic.gauss_markov_model(users, C.v * slot2, C.max_range, )
        users = users_loc
        if i%C.r_change_slot==0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
        if i % slot1 != 0:
            f,e,rate,gdop=OF.real_objective(pre_uavs, uavs, users, r_p, p_all, b_all, c_association, p_association,slot2)
            print(f,rate,gdop)
            print("悬停时隙能耗：", e)
            fitness.append(f)
        else:#资源重分配，无人机重部署
            pso.re_init(pre_uavs,users,r_c,r_p,c_association, p_association, p_all, b_all)
            X, V = pso.initParticle(users)
            global_pos, global_best, result = pso.pso(X, V, OF.linear_w, OF.objective,)
            f,e, rate, gdop = OF.real_objective(pre_uavs, global_pos, users, r_p, p_all, b_all, c_association, p_association,slot2)
            print("飞行时隙能耗：",e)
            pre_uavs=global_pos
            uavs=global_pos
            fitness.append(f)
            # fitness.append(global_best[0])

    print(fitness)
def run_whole_process():
    users= Users.getUsers("./data.csv")
    slot1=30
    slot2=10
    U=dynamic.generate_users_pos(users,slot2,30)
    # whole_process(users,4,slot1,slot2)
    fitness=[]
    f_sum = []
    k=5
    for j in range(k):
        for i in range(10,70,10):
            f=whole_process_new(U, 4, i, slot2)
            fitness.append(f)
        f_sum.append(fitness)
        print(fitness)
    print(f_sum)
        # whole_process_kmeans(U,4,i,slot2)
    # f1_sum=[0 for i in range(19)]
    # f2_sum = [0 for i in range(19)]
    # f3_sum = [0 for i in range(19)]
    # f4_sum = [0 for i in range(19)]
    # k=3
    # for i in range(k):
    #     f1=whole_process_new(U, 4, slot1, slot2)
    #     f2=fixed_position_dynamic_resource2(U, 4, slot1, slot2)
    #     f3=fixed_resource_dynamic_position2(U,4,slot1,slot2)
    #     f4=same_dynamic_resource_dynamic_position2(U,4,slot1,slot2)
    #     f1_sum=[f1_sum[j]+f1[j] for j in range(len(f1))]
    #     f2_sum = [f2_sum[j] + f2[j] for j in range(len(f1))]
    #     f3_sum = [f3_sum[j] + f3[j] for j in range(len(f1))]
    #     f4_sum = [f4_sum[j] + f4[j] for j in range(len(f1))]
    # f1_avg=[f1_sum[i]/k for i in range(len(f1_sum))]
    # f2_avg = [f2_sum[i] / k for i in range(len(f1_sum))]
    # f3_avg = [f3_sum[i] / k for i in range(len(f1_sum))]
    # f4_avg = [f4_sum[i] / k for i in range(len(f1_sum))]
    # print(f1_avg)
    # print(f2_avg)
    # print(f3_avg)
    # print(f4_avg)
        # fixed_position_fixed_resource(U, 4, slot1, slot2)


#只优化资源
def fixed_position_dynamic_resource(users,k,slot1,slot2):
    uavs = tool.getUavInitialPos(k, users)
    pre_uavs = uavs
    df_c = dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index=0
    r_c, r_p = dynamic.get_r_c_and_r_p(df_c,df_p,index)
    fitness = []
    for i in range(0, 10 * slot1, slot2):
        users_loc = dynamic.gauss_markov_model(users, C.v * slot2, C.max_range, )
        users = users_loc
        if i % C.r_change_slot == 0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
        f,e, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_p, p_all, b_all, c_association, p_association,slot2)
        print(f, e,rate, gdop)
        fitness.append(f)
    print(fitness)
def fixed_position_dynamic_resource2(U,k,slot1,slot2):
    users=U[0]
    uavs = tool.getUavInitialPos(k, users)
    pre_uavs = uavs
    df_c = dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index=0
    r_c, r_p = dynamic.get_r_c_and_r_p(df_c,df_p,index)
    fitness = []
    c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
    f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users,r_c, r_p, p_all, b_all, c_association, p_association, slot2)
    print(f, e, rate, gdop)
    fitness.append(f)
    j=1
    r_s,g_s=[],[]
    for i in range(0, 3 * C.r_change_slot, slot2):
        users = U[j]
        j=j+1
        if i % C.r_change_slot == 0 and i!=0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
        f,e, rate, gdop = OF.real_objective(pre_uavs, uavs, users,r_c, r_p, p_all, b_all, c_association, p_association,slot2)
        print(f, e,rate, gdop)
        fitness.append(f)
        r, g = OF.cal_satisfaction(uavs, users, p_all, b_all, r_c, r_p, c_association, p_association)
        r_s.append(r)
        g_s.append(g)
    print("fixed_position_dynamic_resource:",fitness)
    print("fixed_position_dynamic_resource:", r_s,g_s)
    return fitness

#只优化位置
def fixed_resource_dynamic_position(users,k,slot1,slot2):
    uavs = tool.getUavInitialPos(k, users)
    pre_uavs = uavs
    df_c = dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index = 0
    r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
    fitness = []
    pso = CPSO(pre_uavs, users, r_c, r_p, k, )
    c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
    for i in range(0, 10 * slot1, slot2):
        users_loc = dynamic.gauss_markov_model(users, C.v * slot2, C.max_range, )
        users = users_loc
        if i % C.r_change_slot == 0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        # if index==1:
        #     c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
        if i % slot1 == 0:
            pso.re_init(pre_uavs, users, r_c, r_p, c_association, p_association, p_all, b_all)
            X, V = pso.initParticle(users)
            global_pos, global_best, result = pso.pso(X, V, OF.linear_w, OF.objective,)
            f, e, rate, gdop = OF.real_objective(pre_uavs, global_pos, users,r_c, r_p, p_all, b_all, c_association,
                                                 p_association, slot2)
            print(f, e, rate, gdop)
            fitness.append(f)
            pre_uavs = global_pos
            uavs = global_pos
        else:
            f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users,r_c, r_p, p_all, b_all, c_association,
                                                 p_association, slot2)
            print(f, e, rate, gdop)
            fitness.append(f)
    print(fitness)
    return fitness
def fixed_resource_dynamic_position2(U,k,slot1,slot2):
    users=U[0]
    uavs = tool.getUavInitialPos(k, users)
    pre_uavs = uavs
    df_c = dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index = 0
    r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
    fitness = []
    pso = CPSO(pre_uavs, users, r_c, r_p, k, )
    c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
    f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users,r_c, r_p, p_all, b_all, c_association,
                                         p_association, slot2)
    print(f, e, rate, gdop)
    fitness.append(f)
    j=1
    r_s,g_s=[],[]
    for i in range(0, 3 * C.r_change_slot, slot2):
        users = U[j]
        j=j+1
        if i % C.r_change_slot == 0 and i!=0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        # if index==1:
        #     c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
        if i % slot1 == 0:
            pso.re_init(pre_uavs, users, r_c, r_p, c_association, p_association, p_all, b_all)
            X, V = pso.initParticle(users)
            global_pos, global_best, result = pso.pso(X, V, OF.linear_w, OF.objective,)
            f, e, rate, gdop = OF.real_objective(pre_uavs, global_pos, users,r_c, r_p, p_all, b_all, c_association,
                                                 p_association, slot2)
            r, g = OF.cal_satisfaction(global_pos, users, p_all, b_all, r_c, r_p, c_association, p_association)
            r_s.append(r)
            g_s.append(g)
            print(f, e, rate, gdop)
            fitness.append(f)
            pre_uavs = global_pos
            uavs = global_pos
        else:
            f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users,r_c, r_p, p_all, b_all, c_association,
                                                 p_association, slot2)
            r, g = OF.cal_satisfaction(uavs, users, p_all, b_all, r_c, r_p, c_association, p_association)
            r_s.append(r)
            g_s.append(g)
            print(f, e, rate, gdop)
            fitness.append(f)
    print("fixed_resource_dynamic_position",fitness)
    print("fixed_resource_dynamic_position：", r_s, g_s)
    return fitness
#同时优化资源和位置
def same_dynamic_resource_dynamic_position(users,k,slot1,slot2):
    # users= Users.getUsers("./data.csv")
    uavs = tool.getUavInitialPos(k, users)
    pre_uavs = uavs
    # r_c,r_p=dynamic.random_r(users)
    fitness = []
    df_c = dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index = 0
    r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
    pso = CPSO(pre_uavs, users, r_c, r_p, k, )
    c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
    e = 0
    for i in range(0, 10 * slot1, slot2):
        users_loc = dynamic.gauss_markov_model(users, C.v * slot2, C.max_range, )
        users = users_loc
        if i % C.r_change_slot == 0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        if i % slot1 == 0:
            c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
            pso.re_init(pre_uavs, users, r_c, r_p, c_association, p_association, p_all, b_all)
            X, V = pso.initParticle(users)
            global_pos, global_best, result = pso.pso(X, V, OF.linear_w, OF.objective,)
            f, e, rate, gdop = OF.real_objective(pre_uavs, global_pos, users,r_c, r_p, p_all, b_all, c_association,
                                                 p_association, slot2)
            print("当前时隙能耗：", e)
            pre_uavs = global_pos
            uavs = global_pos
            fitness.append(f)
        else:  #计算
            f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users,r_c, r_p, p_all, b_all, c_association,
                                                 p_association, slot2)
            print(f, e, rate, gdop)
            fitness.append(f)

            # fitness.append(global_best[0])

    print(fitness)
    return fitness
def same_dynamic_resource_dynamic_position2(U,k,slot1,slot2):
    # users= Users.getUsers("./data.csv")
    users=U[0]
    uavs = tool.getUavInitialPos(k, users)
    pre_uavs = uavs
    # r_c,r_p=dynamic.random_r(users)
    fitness = []
    df_c = dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index = 0
    r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
    pso = CPSO(pre_uavs, users, r_c, r_p, k, )
    c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
    f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users,r_c, r_p, p_all, b_all, c_association,
                                         p_association, slot2)
    fitness.append(f)
    e = 0
    j=1
    r_s,g_s=[],[]
    for i in range(0, 3 * C.r_change_slot, slot2):
        users = U[j]
        j=j+1
        if i % C.r_change_slot == 0 and i!=0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        if i % slot2 == 0:
            c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
            pso.re_init(pre_uavs, users, r_c, r_p, c_association, p_association, p_all, b_all)
            X, V = pso.initParticle(users)
            global_pos, global_best, result = pso.pso(X, V, OF.linear_w, OF.objective,)
            f, e, rate, gdop = OF.real_objective(pre_uavs, global_pos, users,r_c, r_p, p_all, b_all, c_association,
                                                 p_association, slot2)
            r, g = OF.cal_satisfaction(global_pos, users, p_all, b_all, r_c, r_p, c_association, p_association)
            r_s.append(r)
            g_s.append(g)
            print("当前时隙能耗：", e)
            pre_uavs = global_pos
            uavs = global_pos
            fitness.append(f)
        else:  #计算
            f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users,r_c, r_p, p_all, b_all, c_association,
                                                 p_association, slot2)
            r, g = OF.cal_satisfaction(uavs, users, p_all, b_all, r_c, r_p, c_association, p_association)
            r_s.append(r)
            g_s.append(g)
            print(f, e, rate, gdop)
            fitness.append(f)

            # fitness.append(global_best[0])

    print("统一尺度：",fitness)
    print("统一尺度：",r_s,g_s)
    return fitness

# run_whole_process()

def cal_avg():
    result=[[[1328.1765246507357, 1503.4819127657738, 1413.0043866027665, 1463.0694754945252, 1411.3332686120364,
       1430.8494924488095, 1348.4585284268035, 1425.5665531789396, 1434.6103288936818, 1382.0470220409627,
       1400.9531567236882, 1430.8877968272081, 1388.6185194154302, 1349.9589680879892, 1331.6482975811632,
       1349.4196364208437, 1333.4082035862293, 1289.1716043437505],
      [1328.1765246507357, 1353.1879576378208, 1405.8565440529696, 1432.7524257593964, 1401.1414708835648,
       1413.2404297641222, 1383.0244353104806, 1424.8984233930191, 1431.198682113639, 1377.8356032938168,
       1396.959114367267, 1431.17968510067, 1386.0419445035495, 1356.377703925818, 1332.1232554431833,
       1352.6415842615386, 1334.979935409752, 1287.8872570069313],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1461.5691341367276, 1411.0399445665012,
       1428.6282956069683, 1342.4394201899177, 1410.6593127134165, 1421.27785518321, 1379.0053611335575,
       1400.2550306243324, 1433.9203792901133, 1356.75918484904, 1345.2969702372804, 1335.91205104966,
       1353.492373837457, 1338.6041420862807, 1291.1214993205556],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1397.2181548623369,
       1416.1632823180864, 1381.329183610079, 1423.0177897257574, 1381.024457636659, 1314.0230128358758,
       1329.5899423905234, 1388.9476610421257, 1338.3554621772444, 1327.6922803222226, 1313.4015072363025,
       1355.1396654592534, 1334.929881133014, 1288.7404759786446],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
       1239.6349292315638, 1256.4686678242904, 1277.2435737396827, 1267.0466827108758, 1178.9368661962508,
       1368.468264013462, 1423.5411331544783, 1242.4019341077947, 1226.9254448575948, 1186.9326588398535,
       1344.001558702772, 1337.9391635327902, 1297.4028580414574],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
       1311.5753634371717, 1388.2120232884542, 1431.8449807730888, 1431.3580503007593, 1378.1452369441306,
       1396.4141506156877, 1433.377670872926, 1384.1169572273377, 1359.900905300984, 1330.6370094444353,
       1353.823654014219, 1336.9776868893764, 1288.787931542987],
      [1328.1765246507357, 1462.1032302319172, 1220.7983757506436, 1250.8351027133883, 1407.6119127563513,
       1428.0915257023041, 1326.2581462780947, 1429.3390687732622, 1430.3834005472518, 1350.323846827929,
       1384.6852854906783, 1388.5883879436703, 1384.9288942132264, 1363.9051313106954, 1333.3026983930981,
       1356.3990159011914, 1336.8379103270627, 1253.635910753905],
      [1328.1765246507357, 1353.1879576378208, 1391.94935171302, 1419.4723595055307, 1436.012266121132,
       1448.4136632819252, 1346.110107123306, 1411.6812049560685, 1441.2949816305224, 1380.5627492161482,
       1312.6260756214342, 1359.85895865934, 1380.3851780875336, 1356.023191076924, 1330.8989844393104,
       1351.9296714736968, 1356.4851064483519, 1337.4758375470306],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1460.7498660143006, 1410.0728187816906,
       1427.4464699502457, 1338.1539823621792, 1373.4882526392807, 1377.483347538101, 1373.6246453797514,
       1387.3376104301349, 1441.5264866455693, 1348.6983324094676, 1338.5720560333045, 1324.1236454249363,
       1354.1914050001853, 1338.8665448937927, 1291.2684553450981],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1290.7792571204702,
       1214.308347749437, 1200.58340380531, 1239.501463648965, 1428.4077716261145, 1377.987085647185,
       1398.1278396468706, 1428.7798719957766, 1385.7469740316235, 1356.5052284818378, 1330.6706853931034,
       1353.4385628020025, 1335.2583787011524, 1288.6298545399088],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
       1442.8167958144866, 1406.2259749595107, 1428.1080839534975, 1426.0580976301176, 1381.5838277366659,
       1397.6065029785466, 1430.6366358870098, 1387.3287325595181, 1359.7125256576942, 1333.3789756932902,
       1355.1829245789684, 1339.515619602179, 1291.7515379563479],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
       1311.5753634371717, 1388.1381132403171, 1432.010926615392, 1431.3321798901468, 1378.0565228773867,
       1396.81940623514, 1432.7982708122322, 1377.8612793152831, 1350.6348893911354, 1327.8024309518744,
       1345.099570863568, 1328.029161164731, 1280.9350822776496],
      [1328.1765246507357, 1504.1073057068995, 1219.5661435925442, 1460.274343713098, 1436.3592446035104,
       1425.1034928610165, 1339.2784050231967, 1443.2730535440444, 1425.0924476853634, 1363.5785187957338,
       1341.4800219444169, 1423.9137275869386, 1349.7704669791651, 1360.7630386223702, 1333.425113996663,
       1366.2030511798673, 1337.4231380704002, 1291.6640507163672],
      [1328.1765246507357, 1353.1879576378208, 1410.579915824099, 1462.9235155522852, 1394.8132884136066,
       1414.5613788698495, 1392.1522068490503, 1431.5057538173428, 1440.2238046243085, 1387.293910964124,
       1399.5857248683053, 1435.6166727422476, 1388.969821621961, 1364.2475752956364, 1332.0464144720595,
       1354.9038046415044, 1339.1743300404082, 1291.630256209334],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1458.4159965010651, 1411.3548799046819,
       1425.7224684005503, 1391.377051941948, 1431.8159723489114, 1431.278025139241, 1358.8212920663784,
       1380.2436201750243, 1425.1958017919642, 1384.3256466756068, 1359.07917364794, 1332.9247098888873,
       1353.1637744754123, 1336.07627725299, 1290.0476381211815],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1393.4337378530465,
       1409.835132447911, 1391.1722552886845, 1417.0328256395617, 1432.3487735073522, 1378.2772749194908,
       1396.6008401570577, 1433.1155975041377, 1390.5914406805628, 1362.6765110445174, 1334.5762051476459,
       1361.4369514102002, 1336.6893145856227, 1288.9669265353398],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
       1424.8510324458748, 1390.7715313987126, 1431.7204129721713, 1431.9081214684788, 1378.1928653857747,
       1396.5681148308058, 1430.780621400254, 1384.5714015170224, 1359.6447860912401, 1330.3893264075632,
       1353.4188754217143, 1336.859504893905, 1288.08174852749],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
       1311.5753634371717, 1388.375915240571, 1420.9624704974776, 1421.2395781820762, 1367.800240844252,
       1399.9786499043562, 1424.3801787948573, 1387.408334861284, 1360.107103934737, 1330.7643039541172,
       1355.5080991940283, 1337.1438609436389, 1290.3414189906262],
      [1328.1765246507357, 1503.913864640719, 1413.8980639539386, 1468.00534814896, 1422.8104408104573,
       1423.765114927117, 1324.9175310660078, 1435.7069206999379, 1433.6130926608998, 1381.3226169858867,
       1356.3795348447263, 1431.3801618130071, 1386.6510817433498, 1361.9492867624042, 1332.7701837350623,
       1350.1107156688993, 1333.0696822151624, 1329.2298025753437],
      [1328.1765246507357, 1353.1879576378208, 1409.2744122762876, 1454.3125460261099, 1410.4565982165238,
       1424.082433572339, 1391.4733702241447, 1430.879428730335, 1414.3890111884998, 1350.34520050958,
       1394.841280189504, 1429.3744950534692, 1386.4838423235042, 1356.8345977131296, 1332.5345285357314,
       1354.656448130794, 1336.017705107397, 1290.1994987112023],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1286.0162095769574, 1223.6306854721179,
       1277.8869653640977, 1354.6916735211269, 1421.0978338505058, 1419.4423878951538, 1357.758685952835,
       1387.6171511136472, 1429.1792659040157, 1327.5638800212087, 1323.1431279704393, 1316.45311752381,
       1340.1900930468087, 1333.8143956170393, 1302.8716294862143],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1369.9885881316322,
       1389.746107250975, 1370.1832958235645, 1402.7731717332395, 1430.2269756772712, 1376.3970040533245,
       1396.0147842886943, 1431.3398512920298, 1376.3795115633775, 1354.4061186176452, 1322.125898247653,
       1347.3190083197246, 1357.8289704460617, 1309.05475863672],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
       1425.0648190120878, 1390.8167346028026, 1432.1377945654822, 1431.7215282770155, 1377.5399714568885,
       1380.911844832686, 1424.423408758382, 1296.815612973573, 1283.9798136146878, 1256.8194756407995,
       1355.3359054061746, 1338.4699601111859, 1293.041446825808],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
       1311.5753634371717, 1388.1670414052744, 1432.0300312924162, 1431.3542356778341, 1378.091812602148,
       1396.8353951681145, 1432.8116506446752, 1385.8096029856881, 1357.7211709158132, 1330.4374574117403,
       1353.7555347511545, 1337.7274048862123, 1288.7985560635561],
      [1328.1765246507357, 1355.524217113136, 1412.9393304787225, 1465.2536583945196, 1410.697993614098,
       1409.4334667878807, 1392.1943945343658, 1432.1373353197077, 1428.3902744802278, 1376.9823301026836,
       1376.0674161952127, 1416.117550231582, 1383.412506204135, 1255.0784335917822, 1331.1853834984765,
       1354.5528533816318, 1335.8822725180155, 1334.9239189752302],
      [1328.1765246507357, 1353.1879576378208, 1410.814724976499, 1463.2075296132891, 1359.6374526982909,
       1379.8017091774498, 1339.6702397963766, 1414.80823357494, 1417.2239029395234, 1361.4605045875321,
       1396.318343095436, 1431.4467641883664, 1383.7222680136367, 1357.68401316966, 1330.5022749791037,
       1354.0002885613083, 1335.781720673481, 1289.1835604091564],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1458.0227275098182, 1409.1231290530502,
       1424.7112929163986, 1353.9694749430198, 1425.9473138683177, 1431.1149171600007, 1379.894377567314,
       1399.26941534447, 1435.5745950310902, 1279.2743553908692, 1265.4957438307756, 1251.3268288661366,
       1361.1714386001656, 1360.3714394835474, 1337.4519399978253],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1269.3936064664942,
       1311.6416869961968, 1273.6585777553612, 1313.941461891031, 1432.7823407239148, 1380.7522541180585,
       1399.1895890144515, 1431.7253108836628, 1384.9934068374707, 1359.608569164655, 1332.9293029520368,
       1353.6079657716728, 1299.1185666067004, 1268.3723761743663],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
       1423.4143076476337, 1390.586686099597, 1430.8731140025316, 1431.3352484839065, 1377.530665193921,
       1396.4032147703758, 1430.013055959338, 1385.216220842132, 1357.4682050836072, 1330.022274655173,
       1353.691056324455, 1337.2310920781447, 1289.1970135479476],
      [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
       1311.5753634371717, 1369.5460147787514, 1443.1311137429147, 1440.8509908426902, 1382.9197914159233,
       1381.0026954392465, 1444.6890646393772, 1353.2513864631362, 1341.0551593686894, 1305.9609304041398,
       1331.0007656836608, 1328.9668585129314, 1289.3981557047607]], [
         [1328.1765246507357, 1503.4819127657738, 1413.0043866027665, 1463.0694754945252, 1411.3332686120364,
          1430.8494924488095, 1348.4585284268035, 1425.5665531789396, 1434.6103288936818, 1382.0470220409627,
          1400.9531567236882, 1430.8877968272081, 1388.6185194154302, 1349.9589680879892, 1331.6482975811632,
          1349.4196364208437, 1333.4082035862293, 1289.1716043437505],
         [1328.1765246507357, 1353.1879576378208, 1405.8565440529696, 1432.7524257593964, 1401.1414708835648,
          1413.2404297641222, 1383.0244353104806, 1424.8984233930191, 1431.198682113639, 1377.8356032938168,
          1396.959114367267, 1431.17968510067, 1386.0419445035495, 1356.377703925818, 1332.1232554431833,
          1352.6415842615386, 1334.979935409752, 1287.8872570069313],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1461.5691341367276, 1411.0399445665012,
          1428.6282956069683, 1342.4394201899177, 1410.6593127134165, 1421.27785518321, 1379.0053611335575,
          1400.2550306243324, 1433.9203792901133, 1356.75918484904, 1345.2969702372804, 1335.91205104966,
          1353.492373837457, 1338.6041420862807, 1291.1214993205556],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1397.2181548623369,
          1416.1632823180864, 1381.329183610079, 1423.0177897257574, 1381.024457636659, 1314.0230128358758,
          1329.5899423905234, 1388.9476610421257, 1338.3554621772444, 1327.6922803222226, 1313.4015072363025,
          1355.1396654592534, 1334.929881133014, 1288.7404759786446],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1239.6349292315638, 1256.4686678242904, 1277.2435737396827, 1267.0466827108758, 1178.9368661962508,
          1368.468264013462, 1423.5411331544783, 1242.4019341077947, 1226.9254448575948, 1186.9326588398535,
          1344.001558702772, 1337.9391635327902, 1297.4028580414574],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.2120232884542, 1431.8449807730888, 1431.3580503007593, 1378.1452369441306,
          1396.4141506156877, 1433.377670872926, 1384.1169572273377, 1359.900905300984, 1330.6370094444353,
          1353.823654014219, 1336.9776868893764, 1288.787931542987],
         [1328.1765246507357, 1462.1032302319172, 1220.7983757506436, 1250.8351027133883, 1407.6119127563513,
          1428.0915257023041, 1326.2581462780947, 1429.3390687732622, 1430.3834005472518, 1350.323846827929,
          1384.6852854906783, 1388.5883879436703, 1384.9288942132264, 1363.9051313106954, 1333.3026983930981,
          1356.3990159011914, 1336.8379103270627, 1253.635910753905],
         [1328.1765246507357, 1353.1879576378208, 1391.94935171302, 1419.4723595055307, 1436.012266121132,
          1448.4136632819252, 1346.110107123306, 1411.6812049560685, 1441.2949816305224, 1380.5627492161482,
          1312.6260756214342, 1359.85895865934, 1380.3851780875336, 1356.023191076924, 1330.8989844393104,
          1351.9296714736968, 1356.4851064483519, 1337.4758375470306],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1460.7498660143006, 1410.0728187816906,
          1427.4464699502457, 1338.1539823621792, 1373.4882526392807, 1377.483347538101, 1373.6246453797514,
          1387.3376104301349, 1441.5264866455693, 1348.6983324094676, 1338.5720560333045, 1324.1236454249363,
          1354.1914050001853, 1338.8665448937927, 1291.2684553450981],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1290.7792571204702,
          1214.308347749437, 1200.58340380531, 1239.501463648965, 1428.4077716261145, 1377.987085647185,
          1398.1278396468706, 1428.7798719957766, 1385.7469740316235, 1356.5052284818378, 1330.6706853931034,
          1353.4385628020025, 1335.2583787011524, 1288.6298545399088],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1442.8167958144866, 1406.2259749595107, 1428.1080839534975, 1426.0580976301176, 1381.5838277366659,
          1397.6065029785466, 1430.6366358870098, 1387.3287325595181, 1359.7125256576942, 1333.3789756932902,
          1355.1829245789684, 1339.515619602179, 1291.7515379563479],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.1381132403171, 1432.010926615392, 1431.3321798901468, 1378.0565228773867,
          1396.81940623514, 1432.7982708122322, 1377.8612793152831, 1350.6348893911354, 1327.8024309518744,
          1345.099570863568, 1328.029161164731, 1280.9350822776496],
         [1328.1765246507357, 1504.1073057068995, 1219.5661435925442, 1460.274343713098, 1436.3592446035104,
          1425.1034928610165, 1339.2784050231967, 1443.2730535440444, 1425.0924476853634, 1363.5785187957338,
          1341.4800219444169, 1423.9137275869386, 1349.7704669791651, 1360.7630386223702, 1333.425113996663,
          1366.2030511798673, 1337.4231380704002, 1291.6640507163672],
         [1328.1765246507357, 1353.1879576378208, 1410.579915824099, 1462.9235155522852, 1394.8132884136066,
          1414.5613788698495, 1392.1522068490503, 1431.5057538173428, 1440.2238046243085, 1387.293910964124,
          1399.5857248683053, 1435.6166727422476, 1388.969821621961, 1364.2475752956364, 1332.0464144720595,
          1354.9038046415044, 1339.1743300404082, 1291.630256209334],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1458.4159965010651, 1411.3548799046819,
          1425.7224684005503, 1391.377051941948, 1431.8159723489114, 1431.278025139241, 1358.8212920663784,
          1380.2436201750243, 1425.1958017919642, 1384.3256466756068, 1359.07917364794, 1332.9247098888873,
          1353.1637744754123, 1336.07627725299, 1290.0476381211815],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1393.4337378530465,
          1409.835132447911, 1391.1722552886845, 1417.0328256395617, 1432.3487735073522, 1378.2772749194908,
          1396.6008401570577, 1433.1155975041377, 1390.5914406805628, 1362.6765110445174, 1334.5762051476459,
          1361.4369514102002, 1336.6893145856227, 1288.9669265353398],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1424.8510324458748, 1390.7715313987126, 1431.7204129721713, 1431.9081214684788, 1378.1928653857747,
          1396.5681148308058, 1430.780621400254, 1384.5714015170224, 1359.6447860912401, 1330.3893264075632,
          1353.4188754217143, 1336.859504893905, 1288.08174852749],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.375915240571, 1420.9624704974776, 1421.2395781820762, 1367.800240844252,
          1399.9786499043562, 1424.3801787948573, 1387.408334861284, 1360.107103934737, 1330.7643039541172,
          1355.5080991940283, 1337.1438609436389, 1290.3414189906262],
         [1328.1765246507357, 1503.913864640719, 1413.8980639539386, 1468.00534814896, 1422.8104408104573,
          1423.765114927117, 1324.9175310660078, 1435.7069206999379, 1433.6130926608998, 1381.3226169858867,
          1356.3795348447263, 1431.3801618130071, 1386.6510817433498, 1361.9492867624042, 1332.7701837350623,
          1350.1107156688993, 1333.0696822151624, 1329.2298025753437],
         [1328.1765246507357, 1353.1879576378208, 1409.2744122762876, 1454.3125460261099, 1410.4565982165238,
          1424.082433572339, 1391.4733702241447, 1430.879428730335, 1414.3890111884998, 1350.34520050958,
          1394.841280189504, 1429.3744950534692, 1386.4838423235042, 1356.8345977131296, 1332.5345285357314,
          1354.656448130794, 1336.017705107397, 1290.1994987112023],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1286.0162095769574, 1223.6306854721179,
          1277.8869653640977, 1354.6916735211269, 1421.0978338505058, 1419.4423878951538, 1357.758685952835,
          1387.6171511136472, 1429.1792659040157, 1327.5638800212087, 1323.1431279704393, 1316.45311752381,
          1340.1900930468087, 1333.8143956170393, 1302.8716294862143],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1369.9885881316322,
          1389.746107250975, 1370.1832958235645, 1402.7731717332395, 1430.2269756772712, 1376.3970040533245,
          1396.0147842886943, 1431.3398512920298, 1376.3795115633775, 1354.4061186176452, 1322.125898247653,
          1347.3190083197246, 1357.8289704460617, 1309.05475863672],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1425.0648190120878, 1390.8167346028026, 1432.1377945654822, 1431.7215282770155, 1377.5399714568885,
          1380.911844832686, 1424.423408758382, 1296.815612973573, 1283.9798136146878, 1256.8194756407995,
          1355.3359054061746, 1338.4699601111859, 1293.041446825808],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.1670414052744, 1432.0300312924162, 1431.3542356778341, 1378.091812602148,
          1396.8353951681145, 1432.8116506446752, 1385.8096029856881, 1357.7211709158132, 1330.4374574117403,
          1353.7555347511545, 1337.7274048862123, 1288.7985560635561],
         [1328.1765246507357, 1355.524217113136, 1412.9393304787225, 1465.2536583945196, 1410.697993614098,
          1409.4334667878807, 1392.1943945343658, 1432.1373353197077, 1428.3902744802278, 1376.9823301026836,
          1376.0674161952127, 1416.117550231582, 1383.412506204135, 1255.0784335917822, 1331.1853834984765,
          1354.5528533816318, 1335.8822725180155, 1334.9239189752302],
         [1328.1765246507357, 1353.1879576378208, 1410.814724976499, 1463.2075296132891, 1359.6374526982909,
          1379.8017091774498, 1339.6702397963766, 1414.80823357494, 1417.2239029395234, 1361.4605045875321,
          1396.318343095436, 1431.4467641883664, 1383.7222680136367, 1357.68401316966, 1330.5022749791037,
          1354.0002885613083, 1335.781720673481, 1289.1835604091564],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1458.0227275098182, 1409.1231290530502,
          1424.7112929163986, 1353.9694749430198, 1425.9473138683177, 1431.1149171600007, 1379.894377567314,
          1399.26941534447, 1435.5745950310902, 1279.2743553908692, 1265.4957438307756, 1251.3268288661366,
          1361.1714386001656, 1360.3714394835474, 1337.4519399978253],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1269.3936064664942,
          1311.6416869961968, 1273.6585777553612, 1313.941461891031, 1432.7823407239148, 1380.7522541180585,
          1399.1895890144515, 1431.7253108836628, 1384.9934068374707, 1359.608569164655, 1332.9293029520368,
          1353.6079657716728, 1299.1185666067004, 1268.3723761743663],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1423.4143076476337, 1390.586686099597, 1430.8731140025316, 1431.3352484839065, 1377.530665193921,
          1396.4032147703758, 1430.013055959338, 1385.216220842132, 1357.4682050836072, 1330.022274655173,
          1353.691056324455, 1337.2310920781447, 1289.1970135479476],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1369.5460147787514, 1443.1311137429147, 1440.8509908426902, 1382.9197914159233,
          1381.0026954392465, 1444.6890646393772, 1353.2513864631362, 1341.0551593686894, 1305.9609304041398,
          1331.0007656836608, 1328.9668585129314, 1289.3981557047607]], [
         [1328.1765246507357, 1503.4819127657738, 1413.0043866027665, 1463.0694754945252, 1411.3332686120364,
          1430.8494924488095, 1348.4585284268035, 1425.5665531789396, 1434.6103288936818, 1382.0470220409627,
          1400.9531567236882, 1430.8877968272081, 1388.6185194154302, 1349.9589680879892, 1331.6482975811632,
          1349.4196364208437, 1333.4082035862293, 1289.1716043437505],
         [1328.1765246507357, 1353.1879576378208, 1405.8565440529696, 1432.7524257593964, 1401.1414708835648,
          1413.2404297641222, 1383.0244353104806, 1424.8984233930191, 1431.198682113639, 1377.8356032938168,
          1396.959114367267, 1431.17968510067, 1386.0419445035495, 1356.377703925818, 1332.1232554431833,
          1352.6415842615386, 1334.979935409752, 1287.8872570069313],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1461.5691341367276, 1411.0399445665012,
          1428.6282956069683, 1342.4394201899177, 1410.6593127134165, 1421.27785518321, 1379.0053611335575,
          1400.2550306243324, 1433.9203792901133, 1356.75918484904, 1345.2969702372804, 1335.91205104966,
          1353.492373837457, 1338.6041420862807, 1291.1214993205556],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1397.2181548623369,
          1416.1632823180864, 1381.329183610079, 1423.0177897257574, 1381.024457636659, 1314.0230128358758,
          1329.5899423905234, 1388.9476610421257, 1338.3554621772444, 1327.6922803222226, 1313.4015072363025,
          1355.1396654592534, 1334.929881133014, 1288.7404759786446],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1239.6349292315638, 1256.4686678242904, 1277.2435737396827, 1267.0466827108758, 1178.9368661962508,
          1368.468264013462, 1423.5411331544783, 1242.4019341077947, 1226.9254448575948, 1186.9326588398535,
          1344.001558702772, 1337.9391635327902, 1297.4028580414574],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.2120232884542, 1431.8449807730888, 1431.3580503007593, 1378.1452369441306,
          1396.4141506156877, 1433.377670872926, 1384.1169572273377, 1359.900905300984, 1330.6370094444353,
          1353.823654014219, 1336.9776868893764, 1288.787931542987],
         [1328.1765246507357, 1462.1032302319172, 1220.7983757506436, 1250.8351027133883, 1407.6119127563513,
          1428.0915257023041, 1326.2581462780947, 1429.3390687732622, 1430.3834005472518, 1350.323846827929,
          1384.6852854906783, 1388.5883879436703, 1384.9288942132264, 1363.9051313106954, 1333.3026983930981,
          1356.3990159011914, 1336.8379103270627, 1253.635910753905],
         [1328.1765246507357, 1353.1879576378208, 1391.94935171302, 1419.4723595055307, 1436.012266121132,
          1448.4136632819252, 1346.110107123306, 1411.6812049560685, 1441.2949816305224, 1380.5627492161482,
          1312.6260756214342, 1359.85895865934, 1380.3851780875336, 1356.023191076924, 1330.8989844393104,
          1351.9296714736968, 1356.4851064483519, 1337.4758375470306],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1460.7498660143006, 1410.0728187816906,
          1427.4464699502457, 1338.1539823621792, 1373.4882526392807, 1377.483347538101, 1373.6246453797514,
          1387.3376104301349, 1441.5264866455693, 1348.6983324094676, 1338.5720560333045, 1324.1236454249363,
          1354.1914050001853, 1338.8665448937927, 1291.2684553450981],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1290.7792571204702,
          1214.308347749437, 1200.58340380531, 1239.501463648965, 1428.4077716261145, 1377.987085647185,
          1398.1278396468706, 1428.7798719957766, 1385.7469740316235, 1356.5052284818378, 1330.6706853931034,
          1353.4385628020025, 1335.2583787011524, 1288.6298545399088],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1442.8167958144866, 1406.2259749595107, 1428.1080839534975, 1426.0580976301176, 1381.5838277366659,
          1397.6065029785466, 1430.6366358870098, 1387.3287325595181, 1359.7125256576942, 1333.3789756932902,
          1355.1829245789684, 1339.515619602179, 1291.7515379563479],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.1381132403171, 1432.010926615392, 1431.3321798901468, 1378.0565228773867,
          1396.81940623514, 1432.7982708122322, 1377.8612793152831, 1350.6348893911354, 1327.8024309518744,
          1345.099570863568, 1328.029161164731, 1280.9350822776496],
         [1328.1765246507357, 1504.1073057068995, 1219.5661435925442, 1460.274343713098, 1436.3592446035104,
          1425.1034928610165, 1339.2784050231967, 1443.2730535440444, 1425.0924476853634, 1363.5785187957338,
          1341.4800219444169, 1423.9137275869386, 1349.7704669791651, 1360.7630386223702, 1333.425113996663,
          1366.2030511798673, 1337.4231380704002, 1291.6640507163672],
         [1328.1765246507357, 1353.1879576378208, 1410.579915824099, 1462.9235155522852, 1394.8132884136066,
          1414.5613788698495, 1392.1522068490503, 1431.5057538173428, 1440.2238046243085, 1387.293910964124,
          1399.5857248683053, 1435.6166727422476, 1388.969821621961, 1364.2475752956364, 1332.0464144720595,
          1354.9038046415044, 1339.1743300404082, 1291.630256209334],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1458.4159965010651, 1411.3548799046819,
          1425.7224684005503, 1391.377051941948, 1431.8159723489114, 1431.278025139241, 1358.8212920663784,
          1380.2436201750243, 1425.1958017919642, 1384.3256466756068, 1359.07917364794, 1332.9247098888873,
          1353.1637744754123, 1336.07627725299, 1290.0476381211815],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1393.4337378530465,
          1409.835132447911, 1391.1722552886845, 1417.0328256395617, 1432.3487735073522, 1378.2772749194908,
          1396.6008401570577, 1433.1155975041377, 1390.5914406805628, 1362.6765110445174, 1334.5762051476459,
          1361.4369514102002, 1336.6893145856227, 1288.9669265353398],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1424.8510324458748, 1390.7715313987126, 1431.7204129721713, 1431.9081214684788, 1378.1928653857747,
          1396.5681148308058, 1430.780621400254, 1384.5714015170224, 1359.6447860912401, 1330.3893264075632,
          1353.4188754217143, 1336.859504893905, 1288.08174852749],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.375915240571, 1420.9624704974776, 1421.2395781820762, 1367.800240844252,
          1399.9786499043562, 1424.3801787948573, 1387.408334861284, 1360.107103934737, 1330.7643039541172,
          1355.5080991940283, 1337.1438609436389, 1290.3414189906262],
         [1328.1765246507357, 1503.913864640719, 1413.8980639539386, 1468.00534814896, 1422.8104408104573,
          1423.765114927117, 1324.9175310660078, 1435.7069206999379, 1433.6130926608998, 1381.3226169858867,
          1356.3795348447263, 1431.3801618130071, 1386.6510817433498, 1361.9492867624042, 1332.7701837350623,
          1350.1107156688993, 1333.0696822151624, 1329.2298025753437],
         [1328.1765246507357, 1353.1879576378208, 1409.2744122762876, 1454.3125460261099, 1410.4565982165238,
          1424.082433572339, 1391.4733702241447, 1430.879428730335, 1414.3890111884998, 1350.34520050958,
          1394.841280189504, 1429.3744950534692, 1386.4838423235042, 1356.8345977131296, 1332.5345285357314,
          1354.656448130794, 1336.017705107397, 1290.1994987112023],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1286.0162095769574, 1223.6306854721179,
          1277.8869653640977, 1354.6916735211269, 1421.0978338505058, 1419.4423878951538, 1357.758685952835,
          1387.6171511136472, 1429.1792659040157, 1327.5638800212087, 1323.1431279704393, 1316.45311752381,
          1340.1900930468087, 1333.8143956170393, 1302.8716294862143],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1369.9885881316322,
          1389.746107250975, 1370.1832958235645, 1402.7731717332395, 1430.2269756772712, 1376.3970040533245,
          1396.0147842886943, 1431.3398512920298, 1376.3795115633775, 1354.4061186176452, 1322.125898247653,
          1347.3190083197246, 1357.8289704460617, 1309.05475863672],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1425.0648190120878, 1390.8167346028026, 1432.1377945654822, 1431.7215282770155, 1377.5399714568885,
          1380.911844832686, 1424.423408758382, 1296.815612973573, 1283.9798136146878, 1256.8194756407995,
          1355.3359054061746, 1338.4699601111859, 1293.041446825808],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.1670414052744, 1432.0300312924162, 1431.3542356778341, 1378.091812602148,
          1396.8353951681145, 1432.8116506446752, 1385.8096029856881, 1357.7211709158132, 1330.4374574117403,
          1353.7555347511545, 1337.7274048862123, 1288.7985560635561],
         [1328.1765246507357, 1355.524217113136, 1412.9393304787225, 1465.2536583945196, 1410.697993614098,
          1409.4334667878807, 1392.1943945343658, 1432.1373353197077, 1428.3902744802278, 1376.9823301026836,
          1376.0674161952127, 1416.117550231582, 1383.412506204135, 1255.0784335917822, 1331.1853834984765,
          1354.5528533816318, 1335.8822725180155, 1334.9239189752302],
         [1328.1765246507357, 1353.1879576378208, 1410.814724976499, 1463.2075296132891, 1359.6374526982909,
          1379.8017091774498, 1339.6702397963766, 1414.80823357494, 1417.2239029395234, 1361.4605045875321,
          1396.318343095436, 1431.4467641883664, 1383.7222680136367, 1357.68401316966, 1330.5022749791037,
          1354.0002885613083, 1335.781720673481, 1289.1835604091564],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1458.0227275098182, 1409.1231290530502,
          1424.7112929163986, 1353.9694749430198, 1425.9473138683177, 1431.1149171600007, 1379.894377567314,
          1399.26941534447, 1435.5745950310902, 1279.2743553908692, 1265.4957438307756, 1251.3268288661366,
          1361.1714386001656, 1360.3714394835474, 1337.4519399978253],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1269.3936064664942,
          1311.6416869961968, 1273.6585777553612, 1313.941461891031, 1432.7823407239148, 1380.7522541180585,
          1399.1895890144515, 1431.7253108836628, 1384.9934068374707, 1359.608569164655, 1332.9293029520368,
          1353.6079657716728, 1299.1185666067004, 1268.3723761743663],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1423.4143076476337, 1390.586686099597, 1430.8731140025316, 1431.3352484839065, 1377.530665193921,
          1396.4032147703758, 1430.013055959338, 1385.216220842132, 1357.4682050836072, 1330.022274655173,
          1353.691056324455, 1337.2310920781447, 1289.1970135479476],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1369.5460147787514, 1443.1311137429147, 1440.8509908426902, 1382.9197914159233,
          1381.0026954392465, 1444.6890646393772, 1353.2513864631362, 1341.0551593686894, 1305.9609304041398,
          1331.0007656836608, 1328.9668585129314, 1289.3981557047607]], [
         [1328.1765246507357, 1503.4819127657738, 1413.0043866027665, 1463.0694754945252, 1411.3332686120364,
          1430.8494924488095, 1348.4585284268035, 1425.5665531789396, 1434.6103288936818, 1382.0470220409627,
          1400.9531567236882, 1430.8877968272081, 1388.6185194154302, 1349.9589680879892, 1331.6482975811632,
          1349.4196364208437, 1333.4082035862293, 1289.1716043437505],
         [1328.1765246507357, 1353.1879576378208, 1405.8565440529696, 1432.7524257593964, 1401.1414708835648,
          1413.2404297641222, 1383.0244353104806, 1424.8984233930191, 1431.198682113639, 1377.8356032938168,
          1396.959114367267, 1431.17968510067, 1386.0419445035495, 1356.377703925818, 1332.1232554431833,
          1352.6415842615386, 1334.979935409752, 1287.8872570069313],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1461.5691341367276, 1411.0399445665012,
          1428.6282956069683, 1342.4394201899177, 1410.6593127134165, 1421.27785518321, 1379.0053611335575,
          1400.2550306243324, 1433.9203792901133, 1356.75918484904, 1345.2969702372804, 1335.91205104966,
          1353.492373837457, 1338.6041420862807, 1291.1214993205556],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1397.2181548623369,
          1416.1632823180864, 1381.329183610079, 1423.0177897257574, 1381.024457636659, 1314.0230128358758,
          1329.5899423905234, 1388.9476610421257, 1338.3554621772444, 1327.6922803222226, 1313.4015072363025,
          1355.1396654592534, 1334.929881133014, 1288.7404759786446],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1239.6349292315638, 1256.4686678242904, 1277.2435737396827, 1267.0466827108758, 1178.9368661962508,
          1368.468264013462, 1423.5411331544783, 1242.4019341077947, 1226.9254448575948, 1186.9326588398535,
          1344.001558702772, 1337.9391635327902, 1297.4028580414574],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.2120232884542, 1431.8449807730888, 1431.3580503007593, 1378.1452369441306,
          1396.4141506156877, 1433.377670872926, 1384.1169572273377, 1359.900905300984, 1330.6370094444353,
          1353.823654014219, 1336.9776868893764, 1288.787931542987],
         [1328.1765246507357, 1462.1032302319172, 1220.7983757506436, 1250.8351027133883, 1407.6119127563513,
          1428.0915257023041, 1326.2581462780947, 1429.3390687732622, 1430.3834005472518, 1350.323846827929,
          1384.6852854906783, 1388.5883879436703, 1384.9288942132264, 1363.9051313106954, 1333.3026983930981,
          1356.3990159011914, 1336.8379103270627, 1253.635910753905],
         [1328.1765246507357, 1353.1879576378208, 1391.94935171302, 1419.4723595055307, 1436.012266121132,
          1448.4136632819252, 1346.110107123306, 1411.6812049560685, 1441.2949816305224, 1380.5627492161482,
          1312.6260756214342, 1359.85895865934, 1380.3851780875336, 1356.023191076924, 1330.8989844393104,
          1351.9296714736968, 1356.4851064483519, 1337.4758375470306],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1460.7498660143006, 1410.0728187816906,
          1427.4464699502457, 1338.1539823621792, 1373.4882526392807, 1377.483347538101, 1373.6246453797514,
          1387.3376104301349, 1441.5264866455693, 1348.6983324094676, 1338.5720560333045, 1324.1236454249363,
          1354.1914050001853, 1338.8665448937927, 1291.2684553450981],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1290.7792571204702,
          1214.308347749437, 1200.58340380531, 1239.501463648965, 1428.4077716261145, 1377.987085647185,
          1398.1278396468706, 1428.7798719957766, 1385.7469740316235, 1356.5052284818378, 1330.6706853931034,
          1353.4385628020025, 1335.2583787011524, 1288.6298545399088],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1442.8167958144866, 1406.2259749595107, 1428.1080839534975, 1426.0580976301176, 1381.5838277366659,
          1397.6065029785466, 1430.6366358870098, 1387.3287325595181, 1359.7125256576942, 1333.3789756932902,
          1355.1829245789684, 1339.515619602179, 1291.7515379563479],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.1381132403171, 1432.010926615392, 1431.3321798901468, 1378.0565228773867,
          1396.81940623514, 1432.7982708122322, 1377.8612793152831, 1350.6348893911354, 1327.8024309518744,
          1345.099570863568, 1328.029161164731, 1280.9350822776496],
         [1328.1765246507357, 1504.1073057068995, 1219.5661435925442, 1460.274343713098, 1436.3592446035104,
          1425.1034928610165, 1339.2784050231967, 1443.2730535440444, 1425.0924476853634, 1363.5785187957338,
          1341.4800219444169, 1423.9137275869386, 1349.7704669791651, 1360.7630386223702, 1333.425113996663,
          1366.2030511798673, 1337.4231380704002, 1291.6640507163672],
         [1328.1765246507357, 1353.1879576378208, 1410.579915824099, 1462.9235155522852, 1394.8132884136066,
          1414.5613788698495, 1392.1522068490503, 1431.5057538173428, 1440.2238046243085, 1387.293910964124,
          1399.5857248683053, 1435.6166727422476, 1388.969821621961, 1364.2475752956364, 1332.0464144720595,
          1354.9038046415044, 1339.1743300404082, 1291.630256209334],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1458.4159965010651, 1411.3548799046819,
          1425.7224684005503, 1391.377051941948, 1431.8159723489114, 1431.278025139241, 1358.8212920663784,
          1380.2436201750243, 1425.1958017919642, 1384.3256466756068, 1359.07917364794, 1332.9247098888873,
          1353.1637744754123, 1336.07627725299, 1290.0476381211815],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1393.4337378530465,
          1409.835132447911, 1391.1722552886845, 1417.0328256395617, 1432.3487735073522, 1378.2772749194908,
          1396.6008401570577, 1433.1155975041377, 1390.5914406805628, 1362.6765110445174, 1334.5762051476459,
          1361.4369514102002, 1336.6893145856227, 1288.9669265353398],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1424.8510324458748, 1390.7715313987126, 1431.7204129721713, 1431.9081214684788, 1378.1928653857747,
          1396.5681148308058, 1430.780621400254, 1384.5714015170224, 1359.6447860912401, 1330.3893264075632,
          1353.4188754217143, 1336.859504893905, 1288.08174852749],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.375915240571, 1420.9624704974776, 1421.2395781820762, 1367.800240844252,
          1399.9786499043562, 1424.3801787948573, 1387.408334861284, 1360.107103934737, 1330.7643039541172,
          1355.5080991940283, 1337.1438609436389, 1290.3414189906262],
         [1328.1765246507357, 1503.913864640719, 1413.8980639539386, 1468.00534814896, 1422.8104408104573,
          1423.765114927117, 1324.9175310660078, 1435.7069206999379, 1433.6130926608998, 1381.3226169858867,
          1356.3795348447263, 1431.3801618130071, 1386.6510817433498, 1361.9492867624042, 1332.7701837350623,
          1350.1107156688993, 1333.0696822151624, 1329.2298025753437],
         [1328.1765246507357, 1353.1879576378208, 1409.2744122762876, 1454.3125460261099, 1410.4565982165238,
          1424.082433572339, 1391.4733702241447, 1430.879428730335, 1414.3890111884998, 1350.34520050958,
          1394.841280189504, 1429.3744950534692, 1386.4838423235042, 1356.8345977131296, 1332.5345285357314,
          1354.656448130794, 1336.017705107397, 1290.1994987112023],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1286.0162095769574, 1223.6306854721179,
          1277.8869653640977, 1354.6916735211269, 1421.0978338505058, 1419.4423878951538, 1357.758685952835,
          1387.6171511136472, 1429.1792659040157, 1327.5638800212087, 1323.1431279704393, 1316.45311752381,
          1340.1900930468087, 1333.8143956170393, 1302.8716294862143],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1369.9885881316322,
          1389.746107250975, 1370.1832958235645, 1402.7731717332395, 1430.2269756772712, 1376.3970040533245,
          1396.0147842886943, 1431.3398512920298, 1376.3795115633775, 1354.4061186176452, 1322.125898247653,
          1347.3190083197246, 1357.8289704460617, 1309.05475863672],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1425.0648190120878, 1390.8167346028026, 1432.1377945654822, 1431.7215282770155, 1377.5399714568885,
          1380.911844832686, 1424.423408758382, 1296.815612973573, 1283.9798136146878, 1256.8194756407995,
          1355.3359054061746, 1338.4699601111859, 1293.041446825808],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.1670414052744, 1432.0300312924162, 1431.3542356778341, 1378.091812602148,
          1396.8353951681145, 1432.8116506446752, 1385.8096029856881, 1357.7211709158132, 1330.4374574117403,
          1353.7555347511545, 1337.7274048862123, 1288.7985560635561],
         [1328.1765246507357, 1355.524217113136, 1412.9393304787225, 1465.2536583945196, 1410.697993614098,
          1409.4334667878807, 1392.1943945343658, 1432.1373353197077, 1428.3902744802278, 1376.9823301026836,
          1376.0674161952127, 1416.117550231582, 1383.412506204135, 1255.0784335917822, 1331.1853834984765,
          1354.5528533816318, 1335.8822725180155, 1334.9239189752302],
         [1328.1765246507357, 1353.1879576378208, 1410.814724976499, 1463.2075296132891, 1359.6374526982909,
          1379.8017091774498, 1339.6702397963766, 1414.80823357494, 1417.2239029395234, 1361.4605045875321,
          1396.318343095436, 1431.4467641883664, 1383.7222680136367, 1357.68401316966, 1330.5022749791037,
          1354.0002885613083, 1335.781720673481, 1289.1835604091564],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1458.0227275098182, 1409.1231290530502,
          1424.7112929163986, 1353.9694749430198, 1425.9473138683177, 1431.1149171600007, 1379.894377567314,
          1399.26941534447, 1435.5745950310902, 1279.2743553908692, 1265.4957438307756, 1251.3268288661366,
          1361.1714386001656, 1360.3714394835474, 1337.4519399978253],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1269.3936064664942,
          1311.6416869961968, 1273.6585777553612, 1313.941461891031, 1432.7823407239148, 1380.7522541180585,
          1399.1895890144515, 1431.7253108836628, 1384.9934068374707, 1359.608569164655, 1332.9293029520368,
          1353.6079657716728, 1299.1185666067004, 1268.3723761743663],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1423.4143076476337, 1390.586686099597, 1430.8731140025316, 1431.3352484839065, 1377.530665193921,
          1396.4032147703758, 1430.013055959338, 1385.216220842132, 1357.4682050836072, 1330.022274655173,
          1353.691056324455, 1337.2310920781447, 1289.1970135479476],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1369.5460147787514, 1443.1311137429147, 1440.8509908426902, 1382.9197914159233,
          1381.0026954392465, 1444.6890646393772, 1353.2513864631362, 1341.0551593686894, 1305.9609304041398,
          1331.0007656836608, 1328.9668585129314, 1289.3981557047607]], [
         [1328.1765246507357, 1503.4819127657738, 1413.0043866027665, 1463.0694754945252, 1411.3332686120364,
          1430.8494924488095, 1348.4585284268035, 1425.5665531789396, 1434.6103288936818, 1382.0470220409627,
          1400.9531567236882, 1430.8877968272081, 1388.6185194154302, 1349.9589680879892, 1331.6482975811632,
          1349.4196364208437, 1333.4082035862293, 1289.1716043437505],
         [1328.1765246507357, 1353.1879576378208, 1405.8565440529696, 1432.7524257593964, 1401.1414708835648,
          1413.2404297641222, 1383.0244353104806, 1424.8984233930191, 1431.198682113639, 1377.8356032938168,
          1396.959114367267, 1431.17968510067, 1386.0419445035495, 1356.377703925818, 1332.1232554431833,
          1352.6415842615386, 1334.979935409752, 1287.8872570069313],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1461.5691341367276, 1411.0399445665012,
          1428.6282956069683, 1342.4394201899177, 1410.6593127134165, 1421.27785518321, 1379.0053611335575,
          1400.2550306243324, 1433.9203792901133, 1356.75918484904, 1345.2969702372804, 1335.91205104966,
          1353.492373837457, 1338.6041420862807, 1291.1214993205556],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1397.2181548623369,
          1416.1632823180864, 1381.329183610079, 1423.0177897257574, 1381.024457636659, 1314.0230128358758,
          1329.5899423905234, 1388.9476610421257, 1338.3554621772444, 1327.6922803222226, 1313.4015072363025,
          1355.1396654592534, 1334.929881133014, 1288.7404759786446],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1239.6349292315638, 1256.4686678242904, 1277.2435737396827, 1267.0466827108758, 1178.9368661962508,
          1368.468264013462, 1423.5411331544783, 1242.4019341077947, 1226.9254448575948, 1186.9326588398535,
          1344.001558702772, 1337.9391635327902, 1297.4028580414574],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.2120232884542, 1431.8449807730888, 1431.3580503007593, 1378.1452369441306,
          1396.4141506156877, 1433.377670872926, 1384.1169572273377, 1359.900905300984, 1330.6370094444353,
          1353.823654014219, 1336.9776868893764, 1288.787931542987],
         [1328.1765246507357, 1462.1032302319172, 1220.7983757506436, 1250.8351027133883, 1407.6119127563513,
          1428.0915257023041, 1326.2581462780947, 1429.3390687732622, 1430.3834005472518, 1350.323846827929,
          1384.6852854906783, 1388.5883879436703, 1384.9288942132264, 1363.9051313106954, 1333.3026983930981,
          1356.3990159011914, 1336.8379103270627, 1253.635910753905],
         [1328.1765246507357, 1353.1879576378208, 1391.94935171302, 1419.4723595055307, 1436.012266121132,
          1448.4136632819252, 1346.110107123306, 1411.6812049560685, 1441.2949816305224, 1380.5627492161482,
          1312.6260756214342, 1359.85895865934, 1380.3851780875336, 1356.023191076924, 1330.8989844393104,
          1351.9296714736968, 1356.4851064483519, 1337.4758375470306],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1460.7498660143006, 1410.0728187816906,
          1427.4464699502457, 1338.1539823621792, 1373.4882526392807, 1377.483347538101, 1373.6246453797514,
          1387.3376104301349, 1441.5264866455693, 1348.6983324094676, 1338.5720560333045, 1324.1236454249363,
          1354.1914050001853, 1338.8665448937927, 1291.2684553450981],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1290.7792571204702,
          1214.308347749437, 1200.58340380531, 1239.501463648965, 1428.4077716261145, 1377.987085647185,
          1398.1278396468706, 1428.7798719957766, 1385.7469740316235, 1356.5052284818378, 1330.6706853931034,
          1353.4385628020025, 1335.2583787011524, 1288.6298545399088],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1442.8167958144866, 1406.2259749595107, 1428.1080839534975, 1426.0580976301176, 1381.5838277366659,
          1397.6065029785466, 1430.6366358870098, 1387.3287325595181, 1359.7125256576942, 1333.3789756932902,
          1355.1829245789684, 1339.515619602179, 1291.7515379563479],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.1381132403171, 1432.010926615392, 1431.3321798901468, 1378.0565228773867,
          1396.81940623514, 1432.7982708122322, 1377.8612793152831, 1350.6348893911354, 1327.8024309518744,
          1345.099570863568, 1328.029161164731, 1280.9350822776496],
         [1328.1765246507357, 1504.1073057068995, 1219.5661435925442, 1460.274343713098, 1436.3592446035104,
          1425.1034928610165, 1339.2784050231967, 1443.2730535440444, 1425.0924476853634, 1363.5785187957338,
          1341.4800219444169, 1423.9137275869386, 1349.7704669791651, 1360.7630386223702, 1333.425113996663,
          1366.2030511798673, 1337.4231380704002, 1291.6640507163672],
         [1328.1765246507357, 1353.1879576378208, 1410.579915824099, 1462.9235155522852, 1394.8132884136066,
          1414.5613788698495, 1392.1522068490503, 1431.5057538173428, 1440.2238046243085, 1387.293910964124,
          1399.5857248683053, 1435.6166727422476, 1388.969821621961, 1364.2475752956364, 1332.0464144720595,
          1354.9038046415044, 1339.1743300404082, 1291.630256209334],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1458.4159965010651, 1411.3548799046819,
          1425.7224684005503, 1391.377051941948, 1431.8159723489114, 1431.278025139241, 1358.8212920663784,
          1380.2436201750243, 1425.1958017919642, 1384.3256466756068, 1359.07917364794, 1332.9247098888873,
          1353.1637744754123, 1336.07627725299, 1290.0476381211815],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1393.4337378530465,
          1409.835132447911, 1391.1722552886845, 1417.0328256395617, 1432.3487735073522, 1378.2772749194908,
          1396.6008401570577, 1433.1155975041377, 1390.5914406805628, 1362.6765110445174, 1334.5762051476459,
          1361.4369514102002, 1336.6893145856227, 1288.9669265353398],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1424.8510324458748, 1390.7715313987126, 1431.7204129721713, 1431.9081214684788, 1378.1928653857747,
          1396.5681148308058, 1430.780621400254, 1384.5714015170224, 1359.6447860912401, 1330.3893264075632,
          1353.4188754217143, 1336.859504893905, 1288.08174852749],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.375915240571, 1420.9624704974776, 1421.2395781820762, 1367.800240844252,
          1399.9786499043562, 1424.3801787948573, 1387.408334861284, 1360.107103934737, 1330.7643039541172,
          1355.5080991940283, 1337.1438609436389, 1290.3414189906262],
         [1328.1765246507357, 1503.913864640719, 1413.8980639539386, 1468.00534814896, 1422.8104408104573,
          1423.765114927117, 1324.9175310660078, 1435.7069206999379, 1433.6130926608998, 1381.3226169858867,
          1356.3795348447263, 1431.3801618130071, 1386.6510817433498, 1361.9492867624042, 1332.7701837350623,
          1350.1107156688993, 1333.0696822151624, 1329.2298025753437],
         [1328.1765246507357, 1353.1879576378208, 1409.2744122762876, 1454.3125460261099, 1410.4565982165238,
          1424.082433572339, 1391.4733702241447, 1430.879428730335, 1414.3890111884998, 1350.34520050958,
          1394.841280189504, 1429.3744950534692, 1386.4838423235042, 1356.8345977131296, 1332.5345285357314,
          1354.656448130794, 1336.017705107397, 1290.1994987112023],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1286.0162095769574, 1223.6306854721179,
          1277.8869653640977, 1354.6916735211269, 1421.0978338505058, 1419.4423878951538, 1357.758685952835,
          1387.6171511136472, 1429.1792659040157, 1327.5638800212087, 1323.1431279704393, 1316.45311752381,
          1340.1900930468087, 1333.8143956170393, 1302.8716294862143],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1369.9885881316322,
          1389.746107250975, 1370.1832958235645, 1402.7731717332395, 1430.2269756772712, 1376.3970040533245,
          1396.0147842886943, 1431.3398512920298, 1376.3795115633775, 1354.4061186176452, 1322.125898247653,
          1347.3190083197246, 1357.8289704460617, 1309.05475863672],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1425.0648190120878, 1390.8167346028026, 1432.1377945654822, 1431.7215282770155, 1377.5399714568885,
          1380.911844832686, 1424.423408758382, 1296.815612973573, 1283.9798136146878, 1256.8194756407995,
          1355.3359054061746, 1338.4699601111859, 1293.041446825808],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1388.1670414052744, 1432.0300312924162, 1431.3542356778341, 1378.091812602148,
          1396.8353951681145, 1432.8116506446752, 1385.8096029856881, 1357.7211709158132, 1330.4374574117403,
          1353.7555347511545, 1337.7274048862123, 1288.7985560635561],
         [1328.1765246507357, 1355.524217113136, 1412.9393304787225, 1465.2536583945196, 1410.697993614098,
          1409.4334667878807, 1392.1943945343658, 1432.1373353197077, 1428.3902744802278, 1376.9823301026836,
          1376.0674161952127, 1416.117550231582, 1383.412506204135, 1255.0784335917822, 1331.1853834984765,
          1354.5528533816318, 1335.8822725180155, 1334.9239189752302],
         [1328.1765246507357, 1353.1879576378208, 1410.814724976499, 1463.2075296132891, 1359.6374526982909,
          1379.8017091774498, 1339.6702397963766, 1414.80823357494, 1417.2239029395234, 1361.4605045875321,
          1396.318343095436, 1431.4467641883664, 1383.7222680136367, 1357.68401316966, 1330.5022749791037,
          1354.0002885613083, 1335.781720673481, 1289.1835604091564],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1458.0227275098182, 1409.1231290530502,
          1424.7112929163986, 1353.9694749430198, 1425.9473138683177, 1431.1149171600007, 1379.894377567314,
          1399.26941534447, 1435.5745950310902, 1279.2743553908692, 1265.4957438307756, 1251.3268288661366,
          1361.1714386001656, 1360.3714394835474, 1337.4519399978253],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1269.3936064664942,
          1311.6416869961968, 1273.6585777553612, 1313.941461891031, 1432.7823407239148, 1380.7522541180585,
          1399.1895890144515, 1431.7253108836628, 1384.9934068374707, 1359.608569164655, 1332.9293029520368,
          1353.6079657716728, 1299.1185666067004, 1268.3723761743663],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1423.4143076476337, 1390.586686099597, 1430.8731140025316, 1431.3352484839065, 1377.530665193921,
          1396.4032147703758, 1430.013055959338, 1385.216220842132, 1357.4682050836072, 1330.022274655173,
          1353.691056324455, 1337.2310920781447, 1289.1970135479476],
         [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977,
          1311.5753634371717, 1369.5460147787514, 1443.1311137429147, 1440.8509908426902, 1382.9197914159233,
          1381.0026954392465, 1444.6890646393772, 1353.2513864631362, 1341.0551593686894, 1305.9609304041398,
          1331.0007656836608, 1328.9668585129314, 1289.3981557047607]]]
    k=5
    f1_sum=[0 for i in range(18)]
    f2_sum = [0 for i in range(18)]
    f3_sum = [0 for i in range(18)]
    f4_sum = [0 for i in range(18)]
    f5_sum = [0 for i in range(18)]
    f6_sum = [0 for i in range(18)]
    for i in range(k):
        f1_sum=[f1_sum[j]+result[i][0][j] for j in range(len(result[i][0]))]
        f2_sum = [f2_sum[j] + result[i][1][j] for j in range(len(result[i][1]))]
        f3_sum = [f3_sum[j] + result[i][2][j] for j in range(len(result[i][2]))]
        f4_sum = [f4_sum[j] + result[i][3][j] for j in range(len(result[i][3]))]
        f5_sum = [f5_sum[j] + result[i][4][j] for j in range(len(result[i][4]))]
        f6_sum = [f6_sum[j] + result[i][5][j] for j in range(len(result[i][5]))]
    f1_sum=[f1_sum[j]/k for j in range(len(f1_sum))]
    f2_sum = [f2_sum[j] / k for j in range(len(f1_sum))]
    f3_sum = [f3_sum[j] / k for j in range(len(f1_sum))]
    f4_sum = [f4_sum[j] / k for j in range(len(f1_sum))]
    f5_sum = [f5_sum[j] / k for j in range(len(f1_sum))]
    f6_sum = [f6_sum[j] / k for j in range(len(f1_sum))]
    r=[]
    r.append(f1_sum)
    r.append(f2_sum)
    r.append(f3_sum)
    r.append(f4_sum)
    r.append(f5_sum)
    r.append(f6_sum)
    print(r)

cal_avg()