#归一化pso
import math
import time
from itertools import combinations

import numpy as np
from matplotlib import pyplot as plt

import Users
import dynamicProcess
from pso import PSO
from improvedPSO import CPSO
import tool
import GDOP
import ObjectiveFuction as OF
import constants as C
import dynamicProcess as dynamic

plt.style.use('seaborn-whitegrid')

# 设置字体为 Times New Roman
plt.rcParams['font.family'] = 'Times New Roman'


def interpolate_points(point1, point2, num_points):
    # 提取点的坐标
    x1, y1 = point1
    x2, y2 = point2

    # 计算每个点之间的间距
    dx = (x2 - x1) / (num_points + 1)
    dy = (y2 - y1) / (num_points + 1)

    # 生成等分点坐标
    interpolated_points = []
    for i in range(1, num_points + 1):
        x = x1 + i * dx
        y = y1 + i * dy
        interpolated_points.append((x, y))

    return interpolated_points
#每隔一段时间计算无人机位置
def cal_uav_pos(U,k,slot):
    users=U[0]
    pre_uavs = tool.getUavInitialPos(k, users)
    df_c = dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index=0
    r_c,r_p=dynamic.get_r_c_and_r_p(df_c,df_p,index)
    num=70
    t=200
    pso = PSO(pre_uavs, users, r_c, r_p, k, num, t)
    X, V = pso.initParticle(users)
    best_pos_arr=[]
    best_arr=[]
    for i in range(0,len(U)-3,3):
        users=U[i]
        if i%6==0 and i!=0:
            index+=1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        c_association, p_association, p_all, b_all = OF.objective_resource_avg(pre_uavs, users, r_c)
        pso.re_init(pre_uavs, users, r_c, r_p, c_association, p_association, p_all, b_all)
        # pso.re_init(pre_uavs,)
        global_pos, global_best, result = pso.pso(X, V, OF.linear_w, OF.objective)
        best_pos_arr.append(global_pos)
        best_arr.append(global_best)
        pre_uavs=global_pos
    print(best_arr)
    print(best_pos_arr)
    best_pos_arr=np.array(best_pos_arr)
    np.save('uavs_pos2.npy', best_pos_arr)

def get_uavs_from_file(U):
    uavs = np.load('uavs_pos2.npy')
    users = U[0]
    pre_uavs = tool.getUavInitialPos(5, users)
    # 打印加载的数组
    # print("Loaded Data:")
    # print(len(uavs))
    # print(pre_uavs)
    return uavs


def whole_process_new(U,k,slot1,slot2):
    # users= Users.getUsers("./data.csv")
    users=U[0]
    uavs=tool.getUavInitialPos(k,users)
    pre_uavs=uavs
    # r_c,r_p=dynamic.random_r(users)
    fitness=[]
    df_c=dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index=0
    r_c,r_p=dynamic.get_r_c_and_r_p(df_c,df_p,index)
    e=0
    j=1
    r_s=[]
    g_s=[]
    UAVS=get_uavs_from_file(U)
    a=0
    for i in range(10,3*C.r_change_slot,slot2):
        if i%C.r_change_slot==0 and i!=0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        #每slot1时隙动一次位置
        if i%slot1==0 and i!=0:
            uavs=UAVS[a]
            a+=1
        users= U[j-1]#前一个时刻的位置
        #根据前一个时刻的位置进行资源分配
        c_association, p_association, p_all, b_all = OF.objective_resource_u(uavs, users, r_c)
        #作用在这一时刻的用户位置上
        users=U[j]
        # interpolated_points = interpolate_points(users_pre,users, 10)
        # print(interpolated_points)
        f, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_c, r_p, p_all, b_all, c_association,
                                             p_association, slot2)
        if i%slot1==0 and i!=0:
            print(i,rate,gdop)
            break
        r, g = OF.cal_satisfaction(uavs, users, p_all, b_all, r_c, r_p, c_association, p_association)
        r_s.append(r)
        g_s.append(g)
        # print(f)
        fitness.append(f)

        j+=1
    print("proposed:",fitness)
    print(r_s)
    print(g_s)
    return fitness
def whole_process(U,k,slot1,slot2):
    # users= Users.getUsers("./data.csv")
    users=U[0]
    uavs=tool.getUavInitialPos(k,users)
    pre_uavs=uavs
    # r_c,r_p=dynamic.random_r(users)
    fitness=[]
    df_c=dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index=0
    r_c,r_p=dynamic.get_r_c_and_r_p(df_c,df_p,index)
    e=0
    j=1
    r_s=[]
    g_s=[]
    UAVS=get_uavs_from_file(U)
    a=0
    for i in range(10,3*C.r_change_slot,slot2):
        if i%C.r_change_slot==0 and i!=0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        #每slot1时隙动一次位置
        if i%slot1==0 and i!=0:
            uavs=UAVS[a]
            a+=1
        users= U[j-1]#前一个时刻的位置
        #根据前一个时刻的位置进行资源分配
        c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
        #作用在这一时刻的用户位置上
        users=U[j]
        f, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_c, r_p, p_all, b_all, c_association,
                                             p_association, slot2)
        r, g = OF.cal_satisfaction(uavs, users, p_all, b_all, r_c, r_p, c_association, p_association)
        r_s.append(r)
        g_s.append(g)
        fitness.append(f)
        # print(f)

        j+=1
    print("proposed:",fitness)
    print(r_s)
    print(g_s)
    return fitness
#统一尺度
def whole_process_unified(U,k,slot1,slot2):
    # users= Users.getUsers("./data.csv")
    users=U[0]
    uavs=tool.getUavInitialPos(k,users)
    pre_uavs=uavs
    # r_c,r_p=dynamic.random_r(users)
    fitness=[]
    df_c=dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index=0
    r_c,r_p=dynamic.get_r_c_and_r_p(df_c,df_p,index)
    e=0
    j=1
    r_s=[]
    g_s=[]
    UAVS=get_uavs_from_file(U)
    # objective_resource_avg
    users = U[j - 1]
    c_association, p_association, p_all, b_all = OF.objective_resource_avg(uavs, users, r_c)
    a=0
    for i in range(10,3*C.r_change_slot,slot2):
        if i%C.r_change_slot==0 and i!=0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        #每slot1时隙动一次位置
        # if i%slot1==0 and i!=0:
        #     uavs=UAVS[a]
        #     a+=1
        users= U[j-1]#前一个时刻的位置
        #根据前一个时刻的位置进行资源分配
        c_association, p_association, p_all, b_all = OF.objective_resource_u(uavs, users, r_c)
        #作用在这一时刻的用户位置上
        users=U[j]
        f, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_c, r_p, p_all, b_all, c_association,
                                             p_association, slot2)
        r, g = OF.cal_satisfaction(uavs, users, p_all, b_all, r_c, r_p, c_association, p_association)
        r_s.append(r)
        g_s.append(g)
        fitness.append(f)
        # print(f)

        j+=1
    print("proposed:",fitness)
    print(r_s)
    print(g_s)
    return fitness
def whole_process_kmeans(U,k,slot1,slot2):
    users = U[0]
    uavs = tool.getUavInitialPos(k, users)
    pre_uavs = uavs
    # r_c,r_p=dynamic.random_r(users)
    fitness = []
    df_c = dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index = 0
    r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
    e = 0
    j = 1
    r_s = []
    g_s = []
    a = 0
    for i in range(10, 3 * C.r_change_slot, slot2):
        if i % C.r_change_slot == 0 and i != 0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        # 每slot1时隙动一次位置

        users = U[j - 1]  # 前一个时刻的位置
        # 根据前一个时刻的位置进行资源分配
        c_association, p_association, p_all, b_all = OF.objective_resource_avg(uavs, users, r_c)
        uavs= tool.getUavInitialPos(k, users)
        # 作用在这一时刻的用户位置上
        users = U[j]
        f, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_c, r_p, p_all, b_all, c_association,
                                          p_association, slot2)
        r, g = OF.cal_satisfaction(uavs, users, p_all, b_all, r_c, r_p, c_association, p_association)
        r_s.append(r)
        g_s.append(g)
        fitness.append(f)
        # print(f)

        j += 1
    print("proposed:", fitness)
    print(r_s)
    print(g_s)
    return fitness

def fixed_position_fixed_resource(U,k,slot1,slot2):
    users = U[0]
    uavs = tool.getUavInitialPos(k, users)
    pre_uavs = uavs
    # r_c,r_p=dynamic.random_r(users)
    fitness = []
    df_c = dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index = 0
    r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
    c_association, p_association, p_all, b_all = OF.objective_resource(uavs, users, r_c)
    f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_c, r_p, p_all, b_all, c_association, p_association,
                                         slot2)
    r, g = OF.cal_satisfaction(uavs, users, p_all, b_all, r_c, r_p, c_association, p_association)
    fitness.append(f)

    j = 1
    r_s = []
    g_s = []
    r_s.append(r)
    g_s.append(g)
    for i in range(0, 3 * C.r_change_slot, slot2):
        users = U[j]
        j += 1
        if i % C.r_change_slot == 0 and i != 0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        f, e, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_c, r_p, p_all, b_all, c_association,
                                         p_association, slot2)
        fitness.append(f)
    print(fitness)
    return fitness

def run_whole_process():
    users= Users.getUsers("./data.csv")
    slot1=30
    slot2=10
    U=dynamic.get_users_pos_from_file()
    # whole_process(users,4,slot1,slot2)
    fitness=[]
    f_sum = []
    k=5
    for j in range(k):
        for i in range(10,70,10):
            f=whole_process_new(U, 4, i, slot2)
            fitness.append(f)
        f_sum.append(fitness)
        print(fitness)
    print(f_sum)
        # whole_process_kmeans(U,4,i,slot2)
    # f1_sum=[0 for i in range(19)]
    # f2_sum = [0 for i in range(19)]
    # f3_sum = [0 for i in range(19)]
    # f4_sum = [0 for i in range(19)]
    # k=3
    # for i in range(k):
    #     f1=whole_process_new(U, 4, slot1, slot2)
    #     f2=fixed_position_dynamic_resource2(U, 4, slot1, slot2)
    #     f3=fixed_resource_dynamic_position2(U,4,slot1,slot2)
    #     f4=same_dynamic_resource_dynamic_position2(U,4,slot1,slot2)
    #     f1_sum=[f1_sum[j]+f1[j] for j in range(len(f1))]
    #     f2_sum = [f2_sum[j] + f2[j] for j in range(len(f1))]
    #     f3_sum = [f3_sum[j] + f3[j] for j in range(len(f1))]
    #     f4_sum = [f4_sum[j] + f4[j] for j in range(len(f1))]
    # f1_avg=[f1_sum[i]/k for i in range(len(f1_sum))]
    # f2_avg = [f2_sum[i] / k for i in range(len(f1_sum))]
    # f3_avg = [f3_sum[i] / k for i in range(len(f1_sum))]
    # f4_avg = [f4_sum[i] / k for i in range(len(f1_sum))]
    # print(f1_avg)
    # print(f2_avg)
    # print(f3_avg)
    # print(f4_avg)
        # fixed_position_fixed_resource(U, 4, slot1, slot2)


def fixed_position_dynamic_resource2(U,k,slot1,slot2):
    users=U[0]
    uavs = tool.getUavInitialPos(k, users)
    pre_uavs = uavs
    df_c = dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index=0
    r_c, r_p = dynamic.get_r_c_and_r_p(df_c,df_p,index)
    fitness = []
    j=1
    r_s,g_s=[],[]
    for i in range(0, 3 * C.r_change_slot, slot2):
        if i % C.r_change_slot == 0 and i!=0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        users = U[j - 1]  # 前一个时刻的位置
        # 根据前一个时刻的位置进行资源分配
        c_association, p_association, p_all, b_all = OF.objective_resource_u(uavs, users, r_c)
        users=U[j]
        f, rate, gdop = OF.real_objective(pre_uavs, uavs, users,r_c, r_p, p_all, b_all, c_association, p_association,slot2)
        print(f, rate, gdop)
        fitness.append(f)
        r, g = OF.cal_satisfaction(uavs, users, p_all, b_all, r_c, r_p, c_association, p_association)
        r_s.append(r)
        g_s.append(g)
        j+=1
    print("fixed_position_dynamic_resource:",fitness)
    print("fixed_position_dynamic_resource:", r_s,g_s)
    return fitness

def fixed_resource_dynamic_position2(U,k,slot1,slot2):
    users=U[0]
    uavs = tool.getUavInitialPos(k, users)
    pre_uavs = uavs
    df_c = dynamic.read_csv_to_df('r_c.csv')
    df_p = dynamic.read_csv_to_df('r_p.csv')
    index = 0
    r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
    fitness = []
    c_association, p_association, p_all, b_all = OF.objective_resource_u(uavs, users, r_c)
    j=1
    a=0
    UAVS=get_uavs_from_file(U)
    r_s,g_s=[],[]
    for i in range(0, 3 * C.r_change_slot, slot2):

        if i % C.r_change_slot == 0 and i!=0:
            index = index + 1
            r_c, r_p = dynamic.get_r_c_and_r_p(df_c, df_p, index)
        if i % slot1 == 0 and i != 0:
            uavs = UAVS[a]
            a += 1
        users = U[j - 1]  # 前一个时刻的位置
        # 根据前一个时刻的位置进行资源分配
        # 作用在这一时刻的用户位置上
        users = U[j]
        j=j+1
        f, rate, gdop = OF.real_objective(pre_uavs, uavs, users, r_c, r_p, p_all, b_all, c_association,
                                          p_association, slot2)
        r, g = OF.cal_satisfaction(uavs, users, p_all, b_all, r_c, r_p, c_association, p_association)
        r_s.append(r)
        g_s.append(g)
        fitness.append(f)
        # print(f)
    print("fixed_resource_dynamic_position",fitness)
    print("fixed_resource_dynamic_position：", r_s, g_s)
    return fitness


# run_whole_process()
if __name__ == '__main__':
    U = dynamicProcess.get_users_pos_from_file()
    U=U[:19]
    # cal_uav_pos(U,5,10)
    # get_uavs_from_file(U)
    # whole_process(U, 5, 30, 10)
    whole_process_new(U, 5, 30, 10)
    # whole_process_unified(U, 5, 30, 10)
    # whole_process(U, 5, 30, 10)
    # whole_process_kmeans(U,5,30,10)
    # fixed_position_dynamic_resource2(U,5,30,10)
    # fixed_resource_dynamic_position2(U,5,30,10)

