import math
import random

import numpy as np
import csv
import matplotlib.pyplot as plt
from sklearn.cluster import KMeans
import pandas as pd


# 随机生成U个用户的位置
def generate(num,filename):
    data = np.random.randint(1, 1000, (num, 2))
    f = open(filename, 'w', encoding='utf-8', newline="")
    #  2.基于文件对象构建csv写入对象
    csv_write = csv.writer(f)
    #  4.写入csv文件
    for d in data:
        csv_write.writerow(d)
    return data


def generateNormalDistribution(num):
    mu, sigma = 500, 170  # 有关于正态分布的值μ，σ
    x = sigma * np.random.randn(1, num) + mu
    x = ([i for item in x for i in item])  # 在这个循环中我们能把二维的数组转换成一维的数组，y2同理
    y = sigma * np.random.randn(1, num) + mu
    y = ([i for item in y for i in item])
    data = np.zeros((num, 2))
    for i in range(num):
        data[i] = np.array([x[i], y[i]])
    f = open('../data_normal.csv', 'w', encoding='utf-8', newline="")
    csv_write = csv.writer(f)
    for d in data:
        csv_write.writerow(d)
    print(data)
    return data


# 用户按集群分布
def generateGroupDistribution(num):
    centers = [[500, 500], [1600, 400], [700, 1200], [1400, 1500]]
    sigma = 100  # 有关于正态分布的值σ
    group_num = 4
    x_ = []
    y_ = []
    for i in range(group_num):
        number = int(num / group_num)
        print(centers[i])
        x = sigma * np.random.randn(1, number) + centers[i][0]
        y = sigma * np.random.randn(1, number) + centers[i][1]
        x_.extend([i for item in x for i in item])
        y_.extend([i for item in y for i in item])
    data = np.zeros((num, 2))
    for i in range(num):
        data[i] = np.array([x_[i], y_[i]])
    f = open('../data_group.csv', 'w', encoding='utf-8', newline="")
    csv_write = csv.writer(f)
    for d in data:
        csv_write.writerow(d)
    print(data)
    return data


def generateNormal(mean, sigma):
    x = sigma * np.random.randn(1) + mean
    return x


# 从csv文件读用户位置
def getUsers(filename):
    data = pd.read_csv(filename, header=None)
    list = data.values.tolist()
    array = np.array(list)
    return array


def getDistanceFromCenter(user, x, y):
    return math.sqrt((user[0] - x) ** 2 + (user[1] - y) ** 2)


def draw(data):
    plt.figure(num=1, figsize=(10, 10))
    x = data[:, 0]
    y = data[:, 1]
    plt.scatter(x, y)
    plt.xlim(0, 7001)
    plt.ylim(0, 7001)
    ax = plt.gca()
    ax.spines['left'].set_position(('data', 0))
    ax.spines['bottom'].set_position(('data', 0))
    # x1 = np.linspace(300, 700, 500)
    # center1 = 500 + np.sqrt(200 ** 2 - (x1 - 500) ** 2)
    # center2 = 500 - np.sqrt(200 ** 2 - (x1 - 500) ** 2)
    # plt.plot(x1, center1,c='b')
    # plt.plot(x1, center2,c='b')
    # x2 = np.linspace(200, 800, 500)
    # center21 = 500 + np.sqrt(300 ** 2 - (x2 - 500) ** 2)
    # center22 = 500 - np.sqrt(300 ** 2 - (x2 - 500) ** 2)
    # plt.plot(x2, center21, c='r')
    # plt.plot(x2, center22, c='r')
    # x3 = np.linspace(100, 900, 500)
    # center31 = 500 + np.sqrt(400 ** 2 - (x3 - 500) ** 2)
    # center32 = 500 - np.sqrt(400 ** 2 - (x3 - 500) ** 2)
    # plt.plot(x3, center31, c='g')
    # plt.plot(x3, center32, c='g')
    # model = KMeans(n_clusters=5, random_state=0).fit(data)
    # center = model.cluster_centers_
    # for c in center:
    #     plt.scatter(c[0], c[1],s=200,marker='p')
    return plt


if __name__ == '__main__':
    data=generate(20,"./data-20.csv")
    # list=getUsers("./data2.csv")
    # print(list)

    # data=generateGroupDistribution(100)
    # list = getUsers("../data_group.csv")
    # draw(list).show()

