# 打开TXT文件
import matplotlib.pyplot as plt  # 导入 Matplotlib 工具包
import numpy as np

plt.style.use('seaborn-whitegrid')
import matplotlib as mpl
plt.rcParams['font.family'] = 'Times New Roman'
mpl.rcParams['axes.labelsize'] = 14
mpl.rcParams['legend.fontsize'] = 12
# 设置字体为 Times New Roman
plt.rcParams['font.family'] = 'Times New Roman'
def drawResultAndIter(line):
    labels1=["train","test"]
    f, ax = plt.subplots(1, 1)
    for i in range(len(line)):
        plt.plot(line[i],label=labels1[i])
    # plt.plot(r2,label=labels1[1])
    # plt.axhline(y=60, color='r', linestyle='--', label='Horizontal Line at y=60')
    plt.legend()
    ax.set_xlabel('iteration')
    ax.set_ylabel('mse')
    plt.show()

def draw_mae():
    f, ax = plt.subplots(1, 1)
    x=[i for i in range(1,6)]
    r1=[13.212,23.561,31.479,37.121,40.163]
    r2=[10.979,14.929,16.194,17.517,21.643]
    r1 = [174.212, 529, 961, 1369, 1600]
    r2 = [100.979, 196, 256, 289, 441]
    d=[(r1[i]-r2[i])/r1[i] for i in range(len(r1))]
    print(sum(d)/len(d))
    plt.plot(x,r1, label="traditional LSTM",marker="o")
    plt.plot(x,r2, label="proposed LSTM",marker="^")
    ax.set_xlabel('number of prediction times')
    ax.set_ylabel('MAE(m)')
    plt.xticks(np.arange(1, 6, 1))
    plt.legend()
    plt.show()

def draw_num_mae():
    # 60 0.0078 0.0090 18.347
    # 70 0.0056 0.0052 12.885
    # 80 0.0058 0.0080 16.715
    # 90 0.0077 0.0079 16.813
    # 100 0.0059 0.0057 13.206
    # 110 0.0059 0.0060 14.344
    # 120 0.0175 0.0126 19.897
    f, ax = plt.subplots(1, 1)
    x=[i for i in range(60,130,10)]
    y1=[0.0078,0.0056,0.0058,0.0077,0.0059,0.0060,0.0175]
    y2=[18.347,12.885,16.715,16.813,13.206,14.344,19.897]
    plt.plot(x, y1, label="train MAE", marker="o")
    plt.plot(x, y2, label="real MAE", marker="^")
    ax.set_xlabel('number of hidden nodes')
    ax.set_ylabel('MAE(m)')
    # plt.xticks(np.arange(1, 6, 1))
    plt.legend()
    plt.show()

if __name__ == '__main__':
    draw_mae()
    # draw_num_mae()
    # with open("loss.txt", "r", encoding="utf-8") as f:
    #     text = f.readlines()
    # with open("val_loss.txt", "r", encoding="utf-8") as f:
    #     text2 = f.readlines()
    # l=[]
    # l1 = [float(line.strip("\n")) for line in text]
    # l2=[float(line.strip("\n")) for line in text2]
    # l.append(l1)
    # l.append(l2)
    #
    # drawResultAndIter(l)

