import copy
from copy import deepcopy
import math
import matplotlib.pyplot as plt
#option是一个字典，确定了坐标系，cor_P是P点相对坐标（形如列表[x,y]），返回P点的经纬度（形如列表[lng,lat]）
import numpy as np


def gps_to_xyz(latitude, longitude, altitude, lat_ref, long_ref, alt_ref):
    # 将经纬度转换为弧度制
    latitude_rad = math.radians(latitude)
    longitude_rad = math.radians(longitude)
    lat_ref_rad = math.radians(lat_ref)
    long_ref_rad = math.radians(long_ref)

    # 地球的平均半径，单位：米
    R = 6371000  # 注意：北纬40度附近

    # 计算纬度和经度的距离差（m）
    d_lat = (latitude_rad - lat_ref_rad) * R
    d_long = (longitude_rad - long_ref_rad) * R * math.cos(lat_ref_rad)

    # 将距离差转换为直角坐标系中的x和y坐标
    x = d_long
    y = d_lat

    # 计算z轴上的高度差
    z = altitude - alt_ref

    result = [x, y, z]
    return result


def xyz_to_gps(x, y, z, lat_ref, long_ref, alt_ref):
    # 地球的平均半径，单位：米
    R = 6371000  # 注意：北纬40度附近，可调

    # 将经纬度转换为弧度制
    lat_ref_rad = math.radians(lat_ref)
    long_ref_rad = math.radians(long_ref)

    # 将 x、y 转换为经纬差
    d_long = x / (R * math.cos(lat_ref_rad))
    d_lat = y / R

    # 计算待转换点的纬度和经度弧度制
    latitude_rad = lat_ref_rad + d_lat
    longitude_rad = long_ref_rad + d_long

    # 将经纬度转换为度数制
    latitude = math.degrees(latitude_rad)
    longitude = math.degrees(longitude_rad)

    # 计算待转换点的高度
    altitude = z + alt_ref

    result = [latitude, longitude, altitude]
    return result


def draw(data):
    plt.figure(num=1, figsize=(10, 10))
    x = data[:, 0]
    y = data[:, 1]
    plt.scatter(x, y)
    # plt.xlim(-1000, 1000)
    # plt.ylim(-0, 7001)
    ax = plt.gca()
    ax.spines['left'].set_position(('data', 0))
    ax.spines['bottom'].set_position(('data', 0))
    # x1 = np.linspace(300, 700, 500)
    # center1 = 500 + np.sqrt(200 ** 2 - (x1 - 500) ** 2)
    # center2 = 500 - np.sqrt(200 ** 2 - (x1 - 500) ** 2)
    # plt.plot(x1, center1,c='b')
    # plt.plot(x1, center2,c='b')
    # x2 = np.linspace(200, 800, 500)
    # center21 = 500 + np.sqrt(300 ** 2 - (x2 - 500) ** 2)
    # center22 = 500 - np.sqrt(300 ** 2 - (x2 - 500) ** 2)
    # plt.plot(x2, center21, c='r')
    # plt.plot(x2, center22, c='r')
    # x3 = np.linspace(100, 900, 500)
    # center31 = 500 + np.sqrt(400 ** 2 - (x3 - 500) ** 2)
    # center32 = 500 - np.sqrt(400 ** 2 - (x3 - 500) ** 2)
    # plt.plot(x3, center31, c='g')
    # plt.plot(x3, center32, c='g')
    # model = KMeans(n_clusters=5, random_state=0).fit(data)
    # center = model.cluster_centers_
    # for c in center:
    #     plt.scatter(c[0], c[1],s=200,marker='p')
    return plt

#主函数为测试样例，仅供参考
if __name__ == '__main__':
    point=[115.82869371103702, 39.934012711037056]
    # users= [[115.81213005558247, 39.91493319843596], [115.80151534346862, 39.89924075328783], [115.81181641633103, 39.91345439036004], [115.81848975759513, 39.89903321215211], [115.85197567, 39.9198535], [115.80020969196244, 39.9189566370977], [115.80196883, 39.92988283], [115.79974025758239, 39.90582839900009], [115.7997408, 39.9058]]
    users=[[115.82869371103702, 39.934012711037056],
    [115.82882156385072, 39.93437556385077],
    [115.82852192424052, 39.9342609242405],
    [115.83312770598623, 39.92981770598637],
    [115.83292091918966, 39.929899919189836],
    [115.83301170598625, 39.92970970598638],
    [115.8325003116783, 39.93359531167772],
    [115.83289629147556, 39.93401129147525],
    [115.83301557069605, 39.934121570695886]]
    data=[]
    for user in users:
        data.append(gps_to_xyz(user[0],user[1],500,point[0],point[1],0))
    data=np.array(data)
    # print(data)
    draw(data).show()


    # file = open('相对坐标.txt', 'w')
    #
    # point_map={
    #     "10": [117.4067305, 39.55563215],
    #     "9": [117.4025971, 39.55762687],
    #     "8": [117.4051509, 39.55808252],
    #     "7": [117.4038813, 39.55929924],
    #     "6": [117.4015306, 39.55961509],
    #     "5": [117.4028736, 39.56110118],
    #     "4": [117.401473, 39.5607669],
    #     "3": [117.4035416, 39.56090042],
    #     "2": [117.4024371, 39.56174394],
    #     "1": [117.4018553, 39.56173589],
    #     "回传点": [117.4049073, 39.55535354],
    # }
    # points=[]
    # for key in point_map:
    #     points.append(point_map[key])
    # print(get_option())
    # # option=determine_coordinate(points)
    # option=get_option()
    # file.write("("+str(option["cor_O"][0])+", "+str(option["cor_O"][1])+") 对应 ")
    # file.write(str(option["ll_O"][0])+", "+str(option["ll_O"][1])+'\n')
    # file.write("(" + str(option["cor_A"][0]) + ", " + str(option["cor_A"][1]) + ") 对应 ")
    # file.write(str(option["ll_A"][0]) + ", " + str(option["ll_A"][1]) + '\n')
    # file.write("(" + str(option["cor_B"][0]) + ", " + str(option["cor_B"][1]) + ") 对应 ")
    # file.write(str(option["ll_B"][0]) + ", " + str(option["ll_B"][1]) + '\n')
    # file.write('\n')
    #
    # for key in point_map:
    #     ans=lnglat_to_coordinate(option, point_map[key])
    #     file.write(key+", "+'('+str(ans[0])+', '+str(ans[1])+')'+'\n')
    #
    #
    #
    # file.close()
    # uavs=[[2560.02056799,2086.20168574],
    #  [4085.42479909,5313.20660584]]
    # for uav in uavs:
    #     print(coordinate_to_lnglat(option,uav))

