#归一化pso
import math
import time
from itertools import combinations
import random

import numpy as np
from matplotlib import pyplot as plt

import Users
from pso import PSO
from improvedPSO import CPSO
import tool
import GDOP
import ObjectiveFuction as OF
from static_pso import SPSO

plt.style.use('seaborn-whitegrid')

# 设置字体为 Times New Roman
plt.rcParams['font.family'] = 'Times New Roman'

def drawResultAndIter(resultAndIter):
    f, ax = plt.subplots(1, 1)
    plt.plot(resultAndIter)
    ax.set_xlabel('iteration')
    ax.set_ylabel('fitness')
    plt.show()
def draw_compare(resultArr):
    labels=['Adapted w','Fixed w','Linear w']
    markers=['o','s','^']
    line=['-','--',':','-.']
    for i in range(len(resultArr)):
        plt.plot(resultArr[i], label=labels[i],linestyle=line[i])
    # 设置图例
    plt.legend()

    # 设置标题和坐标轴标签
    # plt.title('Multiple Lines on One Plot')
    plt.xlabel('x')
    plt.ylabel('y')

    # 显示图形
    plt.show()


def draw_c1_c2():
    c1=[]
    c2=[]
    for i in range(100):
        c1.append(OF.dynamic_c1(i,100))
        c2.append(OF.dynamic_c2(i,100))
    c1=np.array(c1)
    c2=np.array(c2)
    plt.plot(c1, label="c1")
    plt.plot(c2, label="c2")
    plt.show()
def run_fixed_compare(users, k):
    pre_uavs=tool.getUavInitialPos(k,users)
    r_c = {}
    r_p={}
    for i in range(len(users)):
        r_c[i] = 4
    r=1
    for i in range(len(users)):
        r_p[i] = r
        r+=1
    pso=PSO(pre_uavs,users,r_c,r_p,k,)
    X, V = pso.initParticle(users)
    # print(X)
    global_pos, global_best, result = pso.pso(X, V, OF.fixed_w,OF.objective)
    print(global_pos, global_best)
    # pso迭代曲线
    return global_pos, global_best, result

def draw_w(maxIter):
    w=[]
    for i in range(maxIter):
        w.append(OF.adapted_w3(0.4,0.9,i,maxIter,1,))
    plt.plot(w)
    plt.show()


def run_linear_compare(users, k,num,t):
    pre_uavs=tool.getUavInitialPos(k,users)
    r_c = {}
    r_p={}
    for i in range(len(users)):
        r_c[i] = 2
    r=1
    for i in range(len(users)):
        r_p[i] = 2
        r+=1
    pso=PSO(pre_uavs,users,r_c,r_p,k,num,t)
    X, V = pso.initParticle(users)
    # print(X)
    c_association, p_association, p_all, b_all = OF.objective_resource_u(pre_uavs, users, r_c)
    global_pos, global_best, result = pso.pso(X, V, OF.linear_w,OF.objective)
    pso.re_init(pre_uavs,users,r_c,r_p,c_association,p_association,p_all,b_all)
    print(global_pos, global_best)
    # pso迭代曲线
    return global_pos, global_best, result

def run(users, k,num):
    pre_uavs=tool.getUavInitialPos(k,users)
    r_c = {}
    r_p={}
    r = 1
    for i in range(len(users)):
        r_c[i] = 2
    r = 1
    for i in range(len(users)):
        r_p[i] = 2
        r+=1
    pso=SPSO(pre_uavs,users,r_c,r_p,k,num)
    pso.init_alloc()
    X, V = pso.initParticle(users)
    # print(X)
    # global_pos, global_best, result = pso.pso(X, V, adapted_w3,OF.objective_func,dynamic_c1,dynamic_c2)
    global_pos, global_best, result = pso.pso(X, V, OF.linear_w, OF.objective, )
    print(global_pos, global_best)
    # pso迭代曲线
    return global_pos, global_best, result

def run_(users, k,num):
    pre_uavs=tool.getUavInitialPos(k,users)
    r_c = {}
    r_p={}
    r = 1
    for i in range(len(users)):
        r_c[i] = 2
    r = 1
    for i in range(len(users)):
        r_p[i] = 2
        r+=1
    pso=PSO(pre_uavs,users,r_c,r_p,k,num)
    pso.init_alloc()
    X, V = pso.initParticle(users)
    # print(X)
    # global_pos, global_best, result = pso.pso(X, V, adapted_w3,OF.objective_func,dynamic_c1,dynamic_c2)
    global_pos, global_best, result = pso.pso(X, V, OF.linear_w, OF.objective_func, )
    print(global_pos, global_best)
    # pso迭代曲线
    return global_pos, global_best, result

def run_all(users,k):
    resultArr=[]
    global_pos1, global_best1, result1 = run(users, k)
    global_pos2, global_best2, result2 = run_fixed_compare(users, k)
    global_pos3, global_best3, result3 = run_linear_compare(users, k)
    resultArr.append(result1)
    resultArr.append(result2)
    resultArr.append(result3)
    draw_compare(resultArr)



if __name__ == '__main__':

    users = Users.getUsers("./data3.csv")
    # global_pos, global_best,result=run(users,3)
    # print(fitness(users,global_pos))
    # run_all(users,4)
    # draw_c1_c2()

    # draw_data()
    # draw_w(150)
    p_num=70
    # # global_pos, global_best, result = run_fixed_compare(users, 4)
    start_time = time.time()
    # global_pos, global_best, result = run_(users, 5,p_num)
    end_time1 = time.time()
    global_pos1, global_best1, result1 = run_linear_compare(users, 5,p_num,200)
    end_time2 = time.time()
    run_time=end_time1-start_time
    run_time1 = end_time2 - end_time1
    # run_time2=end_time2 - start_time-run_time1
    print("程序运行时间为：", run_time1)
    # print(global_best[0])
    # print(list(result))
    print(list(result1))
    # # print("最优解",global_best[0],global_best1[0])
    # drawResultAndIter(result1)
    # plt.show()
    # arr=[]
    # arr_t=[]
    # for k in range(30,110,20):
    # # k=70
    #     t=250
    # # for t in range(100, 350, 50):
    #     num = []
    #     sum_time = []
    #     for i in range(1):
    #         start_time = time.time()
    #         global_pos, global_best, result = run_linear_compare(users, 5,k,t)
    #         num.append(global_best[0])
    #         print(global_best)
    #         end_time = time.time()
    #         run_time = end_time - start_time
    #         sum_time.append(run_time)
    #         print("程序运行时间为：", run_time)
    #         # drawResultAndIter(result)
    #         # plt.show()
    #     print(sum(num)/len(num))
    #     print(sum(sum_time)/len(sum_time))
    #     arr.append(sum(num)/len(num))
    #     arr_t.append(sum(sum_time)/len(sum_time))
    # print(arr)
    # print(arr_t)
    # num=[-9657.993479469107, -11023.13972392451, -10511.070624574759, -10724.3448906409, -10623.367312657523,
    #  -9802.662654304893, -7603.911448332553, -9695.134404543633, -9575.730714137575, -10454.63434179702]
    # print(sum(num)/10)



