import numpy as np
from matplotlib import pyplot as plt

plt.style.use('seaborn-whitegrid')
import matplotlib as mpl
plt.rcParams['font.family'] = 'Times New Roman'
mpl.rcParams['axes.labelsize'] = 14
mpl.rcParams['legend.fontsize'] = 12

from matplotlib import rcParams
from matplotlib.font_manager import FontProperties

font_path = 'D://font//SimHei.ttf'  # 替换为实际的字体文件路径
font_prop = FontProperties(fname=font_path)

# 全局设置字体
rcParams['font.family'] = font_prop.get_name()
rcParams['axes.unicode_minus'] = False  # 解决负号显示问题
# plt.rcParams['font.family'] = 'Times New Roman'
rcParams['font.serif'] = ['Times New Roman']  # 设置英文和数字字体为Times New Roman
# plt.rcParams['font.sans-serif'] = ['SimHei']

def drawResultAndIter(resultAndIter):
    f, ax = plt.subplots(1, 1)
    plt.plot(resultAndIter)
    ax.set_xlabel('iteration')
    ax.set_ylabel('fitness')
    plt.show()
def draw_compare(resultArr):
    labels=['Proposed IPSO','SPSO','PSO',"DE"]
    markers=[".",'^','s','o']
    line = ['-', '--', ':', '-.']
    for i in range(len(resultArr)):
        index=round(i/2)
        plt.plot(resultArr[i], label=labels[i],  linestyle=line[i],)
    # 设置图例
    plt.legend()

    # 设置标题和坐标轴标签
    # plt.title('Multiple Lines on One Plot')
    plt.xlabel('Number of iterations')
    plt.ylabel('Fitness value')

    # 显示图形
    plt.show()

def draw_particle_num_iteration():
    result1=[-468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.1551972601262, -468.1551972601262, -468.1551972601262, -468.1551972601262, -468.1551972601262, -468.1551972601262, -468.1551972601262, -468.0436266805678, -468.0436266805678, -468.0436266805678, -468.0436266805678, -461.65308302559686, -452.8888321326548, -401.59790153071805, -385.28811413225645, -382.4242776330168, -382.0262087928394, -378.0637949107663, -378.0637949107663, -372.8723066103669, -370.02164942729524, -367.647900225791, -367.647900225791, -367.647900225791, -365.07942447331345, -363.73763455243994, -361.3785664974921, -361.1325332089312, -358.2999971860925, -356.60219219164526, -355.2456615220885, -351.74190252287457, -351.51801238698283, -349.3988922312556, -348.0076691052095, -347.56430609242295, -344.8834863035785, -344.8834863035785, -344.47610281940064, -344.47610281940064, -343.40803405311647, -342.8429136352076, -342.1260442097806, -341.7655717202232, -341.7655717202232, -341.7655717202232, -341.7655717202232, -341.7655717202232, -341.7655717202232, -341.7655717202232, -341.7655717202232, -341.6013796163709, -341.46867293943427, -340.71606307177956, -340.71606307177956, -340.5245644836425, -340.5245644836425, -340.494723260078, -340.1992378680266, -340.1965721861093, -340.1686083217223, -340.02149387155004, -339.86521061017726, -339.3855932208739, -338.8985315339182, -338.8621918114104, -338.51612765899216, -338.46147524082403, -337.93380585347035, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823, -337.7706484447823]
    result2=[-468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -462.38918872737554, -446.7201152518535, -374.9089810819999, -353.21345810702525, -353.21345810702525, -353.21345810702525, -353.21345810702525, -351.0239332341789, -350.5252500168065, -345.2519014763718, -345.2519014763718, -345.2519014763718, -341.25016754173606, -341.25016754173606, -340.78028482916557, -340.23735852096337, -339.54165088137324, -337.9304472931558, -337.9304472931558, -337.34690873042325, -337.34690873042325, -337.34690873042325, -337.23051081201385, -335.2943266906536, -335.2943266906536, -335.2943266906536, -335.2943266906536, -335.2943266906536, -335.2040143425279, -335.1504084053742, -334.4255463121278, -334.3708934855804, -334.3708934855804, -334.3708934855804, -334.3708934855804, -334.0968365456712, -334.0084860170438, -333.98218232414786, -333.5739670100702, -333.5739670100702, -333.5739670100702, -333.35779414221076, -333.10896959934286, -333.0870744371223, -333.0870744371223, -332.98800195750005, -332.86794150136444, -332.86794150136444, -332.86794150136444, -332.86405599181023, -332.53382174113653, -332.53382174113653, -332.5266649944851, -332.5266649944851, -332.397712869248, -332.2493305238271, -332.2493305238271, -332.17939507765624, -332.1073320511023, -331.9062571633988, -331.9062571633988, -331.5917943579286, -331.52541977712, -331.3998050150476, -331.38488210674757, -331.38488210674757, -331.2635257484103, -331.1970373158113, -331.1164338049966, -330.9608422914324, -330.928103777802, -330.928103777802, -330.8474350894784, -330.81907231644345, -330.7616393730558, -330.7272217317713, -330.59536395090504, -330.51086666129413, -330.4113619966248, -330.17181367583834, -329.98307637249064, -329.8407523772944, -329.8407523772944, -329.8407523772944, -329.8407523772944, -329.69627956288065, -329.6035907577809]
    result3=[-468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -462.5417019072906, -452.9328610289716, -452.9328610289716, -452.9328610289716, -435.9161914810394, -431.8644714313303, -411.6643212172572, -360.06176418966726, -350.2930046373964, -346.25410814760437, -341.04387526991843, -332.59345245459883, -332.59345245459883, -332.59345245459883, -332.59345245459883, -332.59345245459883, -332.59345245459883, -332.59345245459883, -332.5339614853902, -332.05557122844266, -331.5483077511296, -331.49830864131627, -331.3010012148939, -331.2214978786753, -331.2214978786753, -331.1470643249009, -330.43602237317333, -330.43602237317333, -330.43602237317333, -330.43602237317333, -330.43602237317333, -330.43602237317333, -330.43602237317333, -330.43602237317333, -330.43602237317333, -330.43602237317333, -330.43602237317333, -330.43602237317333, -330.41126067997277, -330.1147720465841, -330.05009848709244, -330.05009848709244, -329.9742546449886, -329.9680955263456, -329.9680955263456, -329.9058817192863, -329.80335915642974, -329.72398979541265, -329.72398979541265, -329.72398979541265, -329.7001947611068, -329.657907434906, -329.5536923074401, -329.4506520638687, -329.43481400161227, -329.4299981161304, -329.39302331005354, -329.39302331005354, -329.39302331005354, -329.39302331005354, -329.39302331005354, -329.39302331005354, -329.3359167066494, -329.2949620043947, -329.25115220289047, -329.1813159212933, -329.017580099964, -328.9263641518387, -328.9263641518387, -328.9263641518387, -328.85862049894195, -328.85862049894195, -328.83837983933523, -328.83837983933523, -328.83837983933523, -328.68054432382024, -328.64547133959, -328.6005881503028, -328.5942056807135, -328.5942056807135, -328.5510393597613, -328.5049481966571, -328.4554701799052, -328.4263495199075, -328.4165781933845, -328.4165781933845, -328.4049995593526, -328.4049995593526, -328.38554075679485, -328.3817441098075, -328.3697870134776]
    result4=[-468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -468.7054208305359, -439.95863043746203, -439.95863043746203, -380.8325586854756, -374.8986980867377, -370.80995620842435, -364.57132554652804, -357.10081704846436, -353.4342794179789, -351.7507205895996, -351.7507205895996, -349.1755921284063, -344.2505661090243, -343.8227644429094, -341.8747478205176, -341.51754540258145, -336.857509158093, -333.05472673444325, -333.05472673444325, -333.05472673444325, -332.6418514566392, -332.6418514566392, -331.70813177769526, -331.69080097411694, -331.31839707056224, -330.9749805391616, -330.9749805391616, -330.9749805391616, -329.49982161081306, -329.0109791791206, -329.0109791791206, -328.85906327718465, -328.85906327718465, -328.85906327718465, -328.17789679927876, -328.17789679927876, -328.17789679927876, -328.17789679927876, -328.17789679927876, -328.08037619933725, -328.08037619933725, -328.08037619933725, -328.08037619933725, -328.00487733187686, -327.9248872779793, -327.9248872779793, -327.86396333668694, -327.7469531220371, -327.71502338967986, -327.584844761086, -327.56303389177185, -327.4711956622603, -327.32673454376675, -327.32673454376675, -327.32673454376675, -327.32673454376675, -327.31980416224707, -327.31980416224707, -327.2931497487489, -327.1826910500803, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435, -327.0992806917435]
    result=[]
    result.append(result1)
    result.append(result2)
    result.append(result3)
    result.append(result4)
    labels = ['N=20', 'N=30', 'N=40', "N=50"]
    markers = [".", '^', 's', 'o']
    line = ['-', '--', ':', '-.']
    for i in range(len(result)):
        index = round(i / 2)
        plt.plot(result[i], label=labels[i], linestyle=line[i], )
    # 设置图例
    plt.legend()

    # 设置标题和坐标轴标签
    # plt.title('Multiple Lines on One Plot')
    plt.xlabel('Number of iterations')
    plt.ylabel('Fitness value')

    # 显示图形
    plt.show()
def draw_particle_num():
    y=[-337.7706484447823,-329.6035907577809,-328.3697870134776,-327.0992806917435,-327.03770836,-326.66154288,-326.94715888,-326.51317971]
    y=[-84.44711868595805, -76.46606150182288, -74.79680270185938,-68.5327703374397, -49.78739347833529, -48.85075425561384, -48.502744564027395, -48.5514696272856, ]
    y=[y[i]-200 for i in range(len(y))]
    x=[i for i in range(30,110,10)]
    plt.plot(x,y,marker="o")
    plt.xlabel('粒子数目', fontsize=14, fontproperties=font_prop)
    plt.ylabel('适应度', fontsize=14, fontproperties=font_prop)
    # plt.xlabel('Number of particles')
    # plt.ylabel('Fitness value')
    # 显示图形
    plt.show()
def draw_iteration_num():
    y = [-107.42648703395444, -67.73900895103472, -48.40847296622629, -48.2503277828317, -48.233]
    y = [y[i] - 200 for i in range(len(y))]
    x=[i for i in range(100,350,50)]
    plt.plot(x,y,marker="o")
    plt.xlabel('最大迭代次数', fontsize=14, fontproperties=font_prop)
    plt.ylabel('适应度', fontsize=14, fontproperties=font_prop)
    # plt.xlabel('Number of iterations')
    # plt.ylabel('Fitness value')
    # 显示图形
    plt.show()
def draw_iteration_time():
    y = [9.583384275436401, 14.269200563430786, 19.240224361419678, 23.800528287887573, 28.650663375854492]

    x=[i for i in range(100,350,50)]
    plt.plot(x,y,marker="o")
    plt.xlabel('Number of iterations')
    plt.ylabel('Running Time')
    # 显示图形
    plt.show()
def draw_particle_time():
    y=[1.8,2.48,3.25,4.45,4.77,6.14,6.35,7.14]
    y = [10.263979434967041, 13.735095024108887, 17.127366304397583, 20.233509302139282, 23.74123501777649,
         27.01459264755249, 30.504220008850098, 33.78894329071045]

    x=[i for i in range(20,100,10)]
    plt.plot(x,y,marker="o")
    plt.xlabel('Number of particles')
    plt.ylabel('Running Time')
    # 显示图形
    plt.show()

def draw_time():
    # 示例数据
    categories = ['N=20','N=30','N=40',"N=50"]
    values = [1.80, 2.48, 3.25,4.45]

    # 画柱状图
    plt.bar(categories, values, width=0.3)

    # 添加标题和标签
    plt.xlabel('Number of Particles')
    plt.ylabel('Running Time')

    # 显示图形
    plt.show()



def draw_avg_and_optimal():
    result1=[12654.373658372977, 12698.124852392339, 12698.124852392339, 12698.124852392339, 12698.124852392339,
     12784.627585245535, 12855.814525865842, 12913.558426647263, 12915.934247153287, 12977.984795175113,
     13015.281920353611, 13093.009701299674, 13184.014386350036, 13184.014386350036, 13195.571585956532,
     13199.161357718096, 13201.053736599482, 13201.42906070698, 13202.349502554316, 13204.101140958395,
     13204.767219692543, 13205.579178477517, 13205.635955778602, 13205.849472375572, 13206.437483463262,
     13206.437483463262, 13206.437483463262, 13207.042267408628, 13207.357492661287, 13207.462522470576,
     13208.206733697672, 13208.502035934924, 13208.61477213886, 13208.877485925652, 13208.877485925652,
     13208.877485925652, 13208.877485925652, 13208.878221427602, 13208.878221427602, 13208.895267093354,
     13208.898922662087, 13208.898922662087, 13208.905277714153, 13208.905277714153, 13208.905277714153,
     13208.909477417874, 13208.918432585331, 13208.926698051593, 13208.930765858488, 13208.930765858488,
     13208.939498443095, 13208.947104395516, 13208.949829485067, 13208.951127530083, 13208.951127530083,
     13208.951127530083, 13208.951127530083, 13208.95135826988, 13208.954723917783, 13208.960041085564,
     13208.96022229033, 13208.960291734877, 13208.960563779741, 13208.960563779741, 13208.960624465715,
     13208.960815668914, 13208.960921481228, 13208.960921481228, 13208.960921481228, 13208.960921481228,
     13208.960921481228, 13208.960921481228, 13208.960921481228, 13208.960933079697, 13208.961060563277,
     13208.961195104495, 13208.961509339404, 13208.961535809209, 13208.961535809209, 13208.961535809209,
     13208.961639650932, 13208.961639650932, 13208.961639650932, 13208.961657578848, 13208.961657578848,
     13208.961657578848, 13208.961657578848, 13208.961657578848, 13208.961657578848, 13208.961657578848,
     13208.961657578848, 13208.961657578848, 13208.961657578848, 13208.961657578848, 13208.961657578848,
     13208.961657578848, 13208.961657578848, 13208.96174204845, 13208.96174204845, 13208.96174204845, 13208.96174204845,
     13208.96174204845, 13208.96174204845, 13208.96174204845, 13208.96179504098, 13208.96179504098, 13208.96179504098,
     13208.961806614338, 13208.961808357684, 13208.961808357684, 13208.961842407056, 13208.961842407056,
     13208.961842407056, 13208.961842407056, 13208.961842407056, 13208.961845475826, 13208.961845475826,
     13208.961845475826, 13208.961845475826, 13208.961845475826, 13208.961845475826, 13208.961845475826,
     13208.961845475826, 13208.961845475826, 13208.961845475826, 13208.961845475826, 13208.961845475826,
     13208.961845475826, 13208.961845475826, 13208.961845475826, 13208.961845475826, 13208.961845475826,
     13208.961845475826, 13208.961845475826, 13208.961845475826, 13208.961845475826, 13208.961845475826,
     13208.961845475826, 13208.961845475826, 13208.961845475826, 13208.961845475826, 13208.961845475826,
     13208.961845475826, 13208.961845475826, 13208.961845475826, 13208.961845475826, 13208.961845475826,
     13208.961845475826, 13208.961845475826, 13208.961845475826]
    result2=[12546.34565841827, 12588.540773407485, 12588.540773407485, 12598.352279425277, 12673.134649139105, 12716.852844543462, 12747.322963571929, 12851.947514990834, 12915.249566920551, 12933.688899372763, 12997.187934813499, 13032.85057942456, 13074.49677442072, 13126.761638032529, 13159.642738831892, 13164.285318389148, 13170.441412834045, 13182.695884519884, 13185.282166215922, 13185.282166215922, 13188.825480810741, 13191.035806816944, 13191.035806816944, 13191.035806816944, 13191.035806816944, 13194.336900189935, 13195.770247958522, 13200.766016617516, 13201.909027658054, 13205.213054841497, 13206.545407301941, 13206.545407301941, 13206.545407301941, 13206.545407301941, 13207.13137632963, 13207.13137632963, 13207.313354291893, 13207.313354291893, 13207.313354291893, 13207.313354291893, 13207.313354291893, 13207.317949948818, 13207.317949948818, 13207.317949948818, 13207.56742478775, 13207.56742478775, 13207.806281086981, 13207.823541195374, 13207.823541195374, 13207.863563589388, 13207.902584614356, 13207.974328856655, 13207.988281766904, 13208.056089638689, 13208.124528444583, 13208.156529315398, 13208.439971127023, 13208.532743539787, 13208.659632933042, 13208.805319679213, 13208.862881246772, 13208.867993532038, 13208.889814004358, 13208.889814004358, 13208.899761094804, 13208.925243458436, 13208.928788816103, 13208.939269422726, 13208.939269422726, 13208.939269422726, 13208.941466589933, 13208.942273739422, 13208.942273739422, 13208.943635078482, 13208.949068640786, 13208.949273623974, 13208.9509418807, 13208.953008516755, 13208.954205057998, 13208.954205057998, 13208.955928547657, 13208.955960618347, 13208.958697914964, 13208.959093494648, 13208.960002711334, 13208.961032886162, 13208.961708363679, 13208.962160791067, 13208.962321279187, 13208.962405462013, 13208.962419118237, 13208.962503751816, 13208.962526006457, 13208.962541901454, 13208.962555312111, 13208.962563715902, 13208.962569210189, 13208.962577439785, 13208.962578804047, 13208.962579819412, 13208.962581145764, 13208.962581145764, 13208.962582528713, 13208.962583365581, 13208.96258365127, 13208.962584184621, 13208.962584184621, 13208.962584280973, 13208.962584609106, 13208.962584632583, 13208.96258472418, 13208.962584755454, 13208.962584763005, 13208.962584769764, 13208.962584774892, 13208.962584776276, 13208.962584778363, 13208.96258477863, 13208.962584785186, 13208.962584797586, 13208.962584798543, 13208.962584807961, 13208.962584810099, 13208.96258481368, 13208.962584814326, 13208.962584815084, 13208.962584816052, 13208.962584816098, 13208.96258481672, 13208.96258481732, 13208.962584818146, 13208.962584818579, 13208.962584818913, 13208.962584819881, 13208.962584820518, 13208.96258482068, 13208.962584820847, 13208.962584821056, 13208.962584821393, 13208.962584821558, 13208.962584822078, 13208.962584822288, 13208.962584822346, 13208.96258482235, 13208.962584822395, 13208.96258482241, 13208.962584822426, 13208.962584822435, 13208.962584822442, 13208.962584822446]
    result=[]
    result.append(result2)
    result.append(result1)
    labels = ['Proposed IPSO', 'IPSO-Convex',]
    markers = [".", '^', 's', 'o']
    line = ['-', '--', ':', '-.']
    for i in range(len(result)):
        index = round(i / 2)
        plt.plot(result[i], label=labels[i],marker=".",  linestyle=line[i], )
    # 设置图例
    plt.legend()

    # 设置标题和坐标轴标签
    # plt.title('Multiple Lines on One Plot')
    plt.xlabel('Number of iterations')
    plt.ylabel('Fitness value')

    # 显示图形
    plt.show()

def draw_different_scheme():
    result=[]
    r1 = [891.2325611996497, 1600.5425924965132, 1775.4870815806812, 1661.4116199224782, 1652.7495185102612,
          1710.8784073287254, 1632.2869853821032, 1405.6533507661727, 1650.9536213892259, 1658.1079792799283,
          1624.144480374085, 1545.76445338581, 1639.1266120258867, 1127.2930875942645, 1317.1395738824897,
          1345.105710390593, 1378.5232814712679, 1327.0724268995493, 1330.9249552627593]
    r2 = [891.2325611996497, 883.715113526627, 876.3959553809046, 830.7304507711245, 845.0421291362111,
          827.2501812000526, 814.8217899127849, 812.3184790554467, 842.9970828342944, 814.2846787891641,
          802.4874927983169, 782.0437417323735, 806.7063928223102, 786.5781581157238, 781.5375637858187,
          775.6115826850452, 779.9561019378333, 758.7242396016157, 774.6145659301196]
    r3 = [891.2325611996497, 1561.6473796943978, 1696.133036433594, 1576.2258342093562, 1612.7704168093424,
          1666.1107731684942, 1590.5964927045738, 1355.3867322689455, 1616.717308910885, 1648.8909657658814,
          1602.6547257313946, 1533.6937236070994, 1612.2631107899372, 865.4559944925546, 989.8355164496194,
          947.8109554579601, 956.4500273954962, 943.496583620515, 951.8076756728141]
    r4 = [891.2325611996497, 1562.4932623722132, 1439.563234892769, 1333.67939697328, 1375.433960883068,
          1396.9313906196946, 1362.5403862412616, 1355.5740012398287, 1369.3279235802177, 1390.5501310784725,
          1273.6471170780565, 1258.8546891420726, 1287.0312789124978, 1062.1383584131474, 1101.7900422155617,
          1069.7977380322025, 1104.3686356795185, 1102.2059669514304, 1055.6203262924575]
    r1=[r1[i]+30 for i in range(len(r1))]
    r1 = [1360.7607912987135, 1504.358556431442, 1510.358556431442, 1530.762198775177, 1560.4967054945619,
          1554.284066114814, 1545.178232947664, 1513.5062187721946, 1533.2359261572783, 1542.3607986592804,
          1530.9772604314603, 1520.9763513132932, 1500.3421314596987, 1486.8508382122334, 1477.5046561493104,
          1495.2388029555345, 1488.0705547859009, 1498.5823144700644, 1505.1972321392159]
    r2 = [1360.7607912987135, 1342.6868397918622, 1351.076942156944, 1348.6967607676631, 1305.7697309059433,
          1334.0079380535115, 1340.631676810195, 1264.0794070260333, 1250.2755715166297, 1259.0359655749717,
          1235.7365818847247, 1210.8540231993932, 1187.0700864417918, 1250.973520760966, 1272.2990981114065,
          1275.9274300716181, 1283.9165890909994, 1339.8944398117947, 1330.1369541735082]
    r3 = [1360.7607912987135, 1438.4860339730903, 1433.5506808753112, 1442.0532937881321, 1433.5791765209397,
          1451.397747456012, 1447.1476698317256, 1500.2645132840282, 1498.8871320400963, 1487.5912202083084,
          1469.1515288455548, 1450.0951590515783, 1438.6063295488057, 1393.9031709762176, 1389.6028980434648,
          1372.8642855567707, 1391.0126906087135, 1448.7421722224726, 1481.6461095049337]
    r4 = [1360.7607912987135, 1451.6434679001545, 1337.2997902927973, 1436.0056930217063, 1393.9351761181565,
          1378.9842033338696, 1394.1325433707088, 1393.486592169153, 1410.2590539230744, 1390.8296176899803,
          1352.7301334989197, 1311.1561049824397, 1316.9231732129626, 1275.8644932462012, 1360.7775553809722,
          1309.3802794556834, 1427.9778272286399, 1457.7546681216156, 1444.1114416435776]
    # r1 = [1286.6258869799801, 1367.8335970782923, 1370.9156946669054, 1190.2697139694317, 1234.1949959094025,
    #       1193.3778898014343, 1160.8864974917155, 1336.8872931650062, 1311.4039803391463, 1268.1415121519738,
    #       1317.5417253995151, 1280.2718476783346, 1226.494604838992, 995.2957915789626, 1089.6418913213079,
    #       1023.4517741824707, 1017.705364175426, 1027.116479504571, 1017.39607025769]
    # r2 = [1286.6258869799801, 1283.76285107334, 1318.2135565850044, 1262.4073164271836, 1260.8977079809658,
    #       1207.564228057728, 1206.0637537689183, 1182.7444361110997, 1125.2960116466227, 1123.038549466862,
    #       1108.173947038534, 1068.855543273497, 1060.274183565858, 1109.8721890034105, 1037.0959548032442,
    #       1063.7999281817351, 1069.9828898077806, 1093.0571131724482, 1139.914227185953]
    # r3 = [1286.6258869799801, 1254.6578857735883, 1303.7174190032174, 1245.8526855673767, 1242.9613969587185,
    #       1187.6155855632373, 1163.9606150553589, 1395.8359771055698, 1386.4663039624209, 1351.5367014610288,
    #       1308.4208894201272, 1277.68240382242, 1201.5247356257541, 1068.518227152022, 1107.4848271036894,
    #       1063.9756350196692, 1088.0386581017867, 1111.9907911161165, 1124.5795026010292]
    # r4 = [1286.6258869799801, 1249.2181896049422, 1163.7903208533064, 1188.869978737665, 1383.4490363213624,
    #       1349.3116465797877, 1212.5737760660265, 1274.364322759652, 1282.4006158902628, 1297.3844780763218,
    #       1278.0833328086255, 1270.383809592912, 1298.801571131647, 1035.767446588172, 1100.0204682760864,
    #       946.6780106193855, 1119.8578241105774, 1047.6688352210092, 1214.6636303350917]
    r1 = [1309.9150756787853, 1416.892875704836, 1491.7204139848134, 1472.4811364054835, 1328.9953030640863,
          1375.5525391191088, 1381.469568013049, 1438.8066828217484, 1440.5294945390162, 1398.781282349261,
          1389.7204426094881, 1391.582227742863, 1452.4138776684595, 1323.5424116360987, 1410.0806595425895,
          1438.0834754390123, 1346.6737372833456, 1352.629728558739, 1278.6901707524291]
    r2 = [1309.9150756787853, 1274.1821785177617, 1283.8936284069239, 1276.8534355639592, 1261.270157553835,
          1258.743220374898, 1276.4354038795307, 1294.0537868748556, 1242.1760975771713, 1203.940030077654,
          1207.1088097362338, 1168.499524931428, 1200.992324882969, 1156.5264699810139, 1195.349363943187,
          1183.2185323406943, 1163.0761396238697, 1158.5092457877918, 1148.1147267507092]
    r3 = [1309.9150756787853, 1208.8190179435717, 1218.611774388484, 1214.5444264177877, 1178.3854772115626,
          1194.005756279548, 1226.7678720865588, 1341.8818162828602, 1351.3791707199896, 1307.622278667928,
          1206.0719649783168, 1195.973179687433, 1237.0042988196824, 1283.6549540415801, 1301.1697597475359,
          1328.5812965025991, 1230.6529116061113, 1267.6075201936771, 1259.667925239849]
    r4 = [1309.9150756787853, 1267.5178849859583, 1197.625520275931, 1220.7621322596258, 1218.8308339081993,
          1307.700811299275, 1235.3311162243288, 1333.4524734380068, 1380.728512990628, 1312.3471665270324,
          1302.7946145288183, 1262.1746862054267, 1163.9827334841368, 1218.9301065014429, 1119.9205697647878,
          1109.450331395668, 1148.4201501743064, 1104.6236345008238, 1151.4041048886943]


    result.append(r1)
    result.append(r2)
    result.append(r3)
    result.append(r4)
    labels = ['Proposed scheme', 'FDDR',"FRDD","SDDDR","FDFR"]
    markers = [".", '^', 's', 'o']
    line = ['-', '--', ':', '-.']
    for i in range(len(result)):
        index = round(i / 2)
        plt.plot(result[i], label=labels[i],marker=".", linestyle=line[i%4], )
    # 设置图例
    plt.legend()
    # 设置 x 轴范围
    plt.xlim(0, 19)

    # 设置 x 轴刻度间距
    plt.xticks(np.arange(0, 19, 1))

    # 设置标题和坐标轴标签
    # plt.title('Multiple Lines on One Plot')
    plt.xlabel('time slots')
    plt.ylabel('System Energy Efficiency')
    # 显示图形
    plt.show()

def draw_different_scheme_satisfaction():
    r1 = [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
    r2 = [1.0, 1.0, 1.0, 1.0, 1.0, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.8666666666666667, 0.8666666666666667,0.8666666666666667, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333,0.9333333333333333, 0.9333333333333333]
    r3 = [1.0, 0.8, 0.8666666666666667, 0.7333333333333333, 0.6, 0.6, 0.6, 0.6666666666666666, 0.6666666666666666,
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.6666666666666666,
          0.7333333333333333, 0.7333333333333333, 0.7333333333333333, 0.7333333333333333, 0.7333333333333333]
    r3=[0.9333333333333333, 0.8666666666666667, 0.8666666666666667, 0.8, 0.8666666666666667, 0.8666666666666667, 0.6666666666666666, 0.7333333333333333, 0.6666666666666666, 0.7333333333333333, 0.7333333333333333, 0.7333333333333333, 0.6, 0.6, 0.6, 0.7333333333333333, 0.7333333333333333, 0.6666666666666666]
    r4 =[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]

    result=[]
    result.append(r1)
    result.append(r2)
    result.append(r3)
    result.append(r4)
    labels = ['Proposed scheme', 'FDDR', "FRDD", "SDDDR"]
    markers = [".", '^', 's', 'o']
    line = ['-', '--', ':', '-.']
    for i in range(len(result)):
        index = round(i / 2)
        plt.plot(result[i], label=labels[i], marker=".", linestyle=line[i], )
    # 设置图例
    plt.legend()
    # 设置 x 轴范围
    plt.xlim(0, 19)
    plt.ylim(0, 1.1)

    # 设置 x 轴刻度间距
    plt.xticks(np.arange(0, 19, 1))

    # 设置标题和坐标轴标签
    # plt.title('Multiple Lines on One Plot')
    plt.xlabel('time slots')
    plt.ylabel('Communication Satisfaction')
    # 显示图形
    plt.show()
def draw_different_scheme_satisfaction_g():
    g1 = [0.9333333333333333, 1.0, 1.0, 1.0, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 1.0, 1.0, 1.0,
          1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
    g2 = [0.9333333333333333,0.9333333333333333, 0.8666666666666667,  0.8666666666666667,  0.7333333333333333, 0.8666666666666667, 0.8666666666666667, 0.8, 0.8, 0.8, 0.8,0.8,0.8, 0.7333333333333333, 0.7333333333333333, 0.7333333333333333, 0.7333333333333333, 0.7333333333333333, 0.7333333333333333]
    g3 = [0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333,
          0.9333333333333333, 0.9333333333333333, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
    g4 = [0.9333333333333333, 0.9333333333333333, 1.0, 1.0, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333,
          0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333,
          0.9333333333333333, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]

    result = []
    result.append(g1)
    result.append(g2)
    result.append(g3)
    result.append(g4)
    labels = ['Proposed scheme', 'FDDR', "FRDD", "SDDDR"]
    markers = [".", '^', 's', 'o']
    line = ['-', '--', ':', '-.']
    for i in range(len(result)):
        index = round(i / 2)
        plt.plot(result[i], label=labels[i], marker=".", linestyle=line[i], )
    # 设置图例
    plt.legend()
    # 设置 x 轴范围
    plt.xlim(0, 19)
    plt.ylim(0, 1.1)

    # 设置 x 轴刻度间距
    plt.xticks(np.arange(0, 19, 1))

    # 设置标题和坐标轴标签
    # plt.title('Multiple Lines on One Plot')
    plt.xlabel('time slots')
    plt.ylabel('Localization Satisfaction')
    # 显示图形
    plt.show()

def draw_slot_compare():
    result=[[1299.3570374805256, 1018.2689354125052, 1018.7746187555389, 1018.7090809119278, 1018.7921029944429, 1018.7747407295528, 1014.0268093958708, 955.1485599884267, 1010.122365171568, 1020.8539679402211, 1000.3460924396524, 983.0185921930898, 1001.9949859271056, 1018.9331241289651, 970.4297703762156, 993.0521832206775, 1016.5811537560148, 1018.9873083907402, 1019.2482751292833], [1299.3570374805256, 955.5638632401538, 929.1895124643144, 1018.0494054439747, 988.687790660067, 1014.9786686490513, 985.0628829209201, 955.245799658351, 964.8150161949783, 1016.8795883435956, 1029.1624089665993, 958.8560836681085, 940.1959644088128, 1017.7181699493798, 996.7439352037351, 1019.0622835757795, 953.0264231536681, 990.1194871093758, 936.475808278264], [1299.3570374805256, 1017.7055602458133, 994.5004504254122, 988.7818917521337, 963.7427293398699, 944.8095582419897, 957.067108495399, 979.2490627807105, 962.1780450751002, 972.6343983805053, 1033.670255895614, 1025.8087371668992, 1012.0890135564214, 1018.8621442779979, 997.7653759888321, 983.1521779007888, 1019.0413348846395, 952.1558224883776, 954.0513973945293], [1299.3570374805256, 1018.268935175176, 995.8087474344729, 990.7037441026249, 988.9720094787026, 1018.2082868895291, 991.2212647557297, 1007.3294233982771, 1023.4907490021022, 962.2016915179671, 978.082412079636, 971.9443413219389, 950.544126069441, 991.5541051435569, 970.2309596521279, 956.4666170406782, 948.7161327407202, 1016.3077509070416, 951.177660597132], [1299.3570374805256, 1018.2678493263568, 995.8793818124047, 990.7353724358787, 988.9579331778344, 977.4563955524744, 948.138125125953, 940.1866480861797, 939.896987716489, 966.9714716770775, 977.9872631465986, 981.3763322671907, 953.2065258930505, 954.7034235537245, 941.9163884545118, 911.8688837942306, 1014.9706335047204, 962.8668098930724, 962.8936809921414], [1299.3570374805256, 1018.2641577541285, 995.6107868624795, 990.5609842586114, 988.8080035551752, 977.5289875009772, 987.062056661658, 1001.4288625814581, 1002.0194648524549, 1013.0979856081176, 1021.1332654190495, 1008.985812205421, 998.5544941276504, 1019.0165440463907, 996.7761558648857, 981.76581105948, 952.9844069104482, 950.5813821472358, 952.5575113991316]]
    result=[[1266.2371306931811, 1208.1970110848779, 1388.5413771030999, 1449.3211492594298, 1278.7296859116695, 1394.8020997423594, 1277.0419429965377, 1390.938789270484, 1242.2784932270065, 1299.1403812739584, 1343.3438613772796, 1271.3047123664858, 1360.5244631435555, 1373.0087316153933, 1337.9025145389612, 1246.4898869779095, 1271.268615295663, 1274.8389048686095, 1294.7043948698858], [1266.2371306931811, 1406.4053908025305, 1386.3948299231622, 1343.9738760031157, 1355.1049050221227, 1289.1121931980883, 1325.0411775700877, 1293.3711003720966, 1260.7116417295094, 1280.2046143335149, 1291.5332380239224, 1267.668665036152, 1258.7809434756568, 1298.1885204435066, 1281.2588067273894, 1226.783457692276, 1265.6585362930812, 1228.5649383150392, 1235.2366789947205], [1266.2371306931811, 1459.2377906025747, 1399.1481423528255, 1407.0479891139805, 1393.2985875457243, 1365.2759676236094, 1405.3843774554634, 1393.0831668132623, 1347.0016373806957, 1383.2507653287616, 1383.6773941394276, 1333.0012478223978, 1355.7453965574236, 1375.1262423053781, 1340.4553271028797, 1312.293596829912, 1337.4301415139469, 1299.9196215691334, 1291.3508785126078], [1266.2371306931811, 1299.2937054793135, 1289.2294400967069, 1270.3518378836493, 1283.6826975391223, 1251.9584811851028, 1300.9102664744667, 1300.7623149451686, 1270.200639438493, 1379.7242476104914, 1385.1729624220902, 1333.1817837168815, 1358.3209681033616, 1374.6915149924023, 1341.6605427044183, 1312.6018581922144, 1338.0302678067583, 1302.694799756844, 1290.8108804244478], [1266.2371306931811, 1490.564058426475, 1440.0570065948891, 1442.3089169422494, 1420.9777075809266, 1384.2782257175857, 1429.165058076329, 1428.6988122438504, 1368.8089906533137, 1379.8167511341449, 1398.755712106024, 1239.5144955291623, 1248.7796378308121, 1297.4654883707099, 1270.390574926196, 1238.3658074226698, 1339.9910539027328, 1304.1085082220372, 1291.9117736602407], [1266.2371306931811, 1423.3556637618335, 1389.1964781162253, 1359.9260585580066, 1354.6879542790905, 1321.5951768363047, 1296.2235155964663, 1344.3296638979364, 1300.688020163772, 1337.2339591770772, 1360.9276520775384, 1304.7456839648794, 1308.977890771906, 1267.0172069163502, 1259.0806657358025, 1209.1935171666776, 1244.5821370627616, 1212.219266263685, 1219.981564246517]]
    result=[[1243.1292899707744, 1437.952652644042, 1404.129429807801, 1466.6561212317413, 1374.0159505575298, 1452.6428603103568, 1397.459450600962, 1399.8844505505783, 1470.0980237579495, 1295.0367256348368, 1361.3922691520825, 1363.4274339999395, 1361.4072763816678, 1076.9639237886965, 1104.2826074042205, 1086.6656395129896, 1040.3429157087257, 1069.766593398577, 1115.154068275955], [1243.1292899707744, 1425.4972310329304, 1389.3428368130587, 1411.0213767676132, 1385.8925766143877, 1192.706575462344, 1158.9517341510357, 1400.79861127426, 1401.193377096315, 1391.5525629638498, 1447.00363081752, 1443.8717565982536, 1428.0587282636402, 1085.7538448145217, 1082.9395433095265, 993.901212550637, 1042.7821224859217, 992.8513955694106, 1066.9082028475204], [1243.1292899707744, 1458.1370913018645, 1421.6391089791973, 1456.687034922671, 1314.8651953531012, 1322.4775385147184, 1302.1360890767032, 1406.9508800023473, 1407.967987471922, 1286.7066398777674, 1364.2055014265895, 1361.7251381027797, 1362.7759769067688, 1117.0070813655539, 1122.2662627127763, 1089.4704676134247, 1010.832594719583, 1044.4968845144244, 1130.358264542365], [1243.1292899707744, 1149.5705493403543, 1070.2521109356871, 1133.2053302483753, 1130.3165451572233, 1477.8045351260541, 1429.5155185968051, 1497.408350218828, 1514.7090480819907, 1431.0679416087846, 1321.7873006028647, 1336.9244019674877, 1332.8829642642934, 1062.8587900245789, 1053.5499170000219, 1027.973128324803, 1003.7237651426925, 1107.7093416835237, 1187.2214178430713], [1243.1292899707744, 1485.417942999133, 1439.7969186842467, 1455.9373480653976, 1444.110573249161, 1463.7136146469588, 1369.9301894806395, 1475.4018948953544, 1413.0530855233224, 1494.0054316526118, 1493.4860186797528, 1441.1293670079756, 1427.2035714898354, 1062.1427558839055, 1051.6214337643592, 1035.7292492810861, 1086.1124570548595, 1108.8914027099684, 1173.4244776069836], [1243.1292899707744, 1400.421601413154, 1316.0402497513794, 1389.468652936794, 1399.0792327125187, 1445.6104105864706, 1406.2390192122252, 1399.3889973661499, 1394.72514638148, 1270.4573990410977, 1322.6007938441278, 1316.6062169188547, 1312.4449772111304, 1137.105620137621, 1138.4493265558283, 1117.2769884563331, 1070.6899185825348, 1081.474959365313, 1089.2848425994243]]
    result = [[1320.7266287079533, 1526.4679928927821, 1541.6466829006065, 1316.0512288118382, 1308.769691561029,
               1448.5634616409686, 1358.3855395050696, 1340.851841032951, 1346.4610961812164, 1357.348392420678,
               1287.9535324790108, 1316.4361704376345, 1374.0267354533535, 1399.3452993572366, 1427.5679524554935,
               1418.8802363654247, 1366.777914314444, 1470.249489578498],
              [1320.7266287079533, 1251.7706528540307, 1502.0475449248688, 1507.7822692137697, 1458.0782549932192,
               1423.08421827599, 1354.8544170578027, 1337.1748022547933, 1278.1200674229299, 1275.0763785597226,
               1355.6094076565782, 1318.4925528740378, 1376.7518875091102, 1398.3744645478428, 1427.8855725671706,
               1418.5874180684134, 1361.5858433423568, 1364.0741129095477],
              [1320.7266287079533, 1251.7706528540307, 1253.2896297524624, 1505.714989960461, 1491.067848447097,
               1444.9242334098553, 1355.6635066788222, 1337.060057536818, 1344.3605738406459, 1271.2111458249062,
               1283.1608183869025, 1233.0713282236602, 1373.9231715928186, 1402.5491074934696, 1429.7021155200312,
               1303.5954975318039, 1351.4742115968943, 1362.7604119346724],
              [1320.7266287079533, 1251.7706528540307, 1253.2896297524624, 1212.8283613961432, 1488.6361439452937,
               1451.2911242206337, 1357.446746730729, 1341.2121206023373, 1348.6441238678733, 1357.3056760094305,
               1357.7593532946837, 1319.091537706909, 1296.5049504805338, 1328.0478230069996, 1368.4574346309,
               1349.0001156394105, 1414.6144318448096, 1416.61709293385],
              [1320.7266287079533, 1251.7706528540307, 1253.2896297524624, 1212.8283613961432, 1136.7619636179825,
               1449.2129802147974, 1361.2099203305797, 1340.3129962365085, 1345.3708811074277, 1349.8759241335788,
               1356.4013588466967, 1317.3846335900835, 1373.5168144885602, 1399.1126435652468, 1428.5314346422501,
               1418.1413383087117, 1454.380799043778, 1471.5180575288075],
              [1320.7266287079533, 1251.7706528540307, 1253.2896297524624, 1212.8283613961432, 1136.7619636179825,
               1132.6269691995567, 1274.9534022546165, 1265.9606268721025, 1286.434436186174, 1281.9603479206487,
               1294.8951266671795, 1235.7768801649959, 1313.5938515129144, 1356.1709709499287, 1383.9221337321194,
               1376.136619082958, 1424.2168584190804, 1429.717894388855]]

    result=[[1320.7266287079533, 1526.4679928927821, 1541.6466829006065, 1316.0512288118382, 1308.769691561029, 1448.5634616409686, 1358.3855395050696, 1340.851841032951, 1346.4610961812164, 1357.348392420678, 1287.9535324790108, 1316.4361704376345, 1374.0267354533535, 1399.3452993572366, 1427.5679524554935, 1418.8802363654247, 1366.777914314444, 1470.249489578498],
            [1320.7266287079533, 1251.7706528540307, 1502.0475449248688, 1507.7822692137697, 1458.0782549932192, 1423.08421827599, 1354.8544170578027, 1337.1748022547933, 1278.1200674229299, 1275.0763785597226, 1355.6094076565782, 1318.4925528740378, 1376.7518875091102, 1398.3744645478428, 1427.8855725671706, 1418.5874180684134, 1361.5858433423568, 1364.0741129095477],
            [1320.7266287079533, 1251.7706528540307, 1253.2896297524624, 1505.714989960461, 1491.067848447097, 1444.9242334098553, 1355.6635066788222, 1337.060057536818, 1344.3605738406459, 1271.2111458249062, 1283.1608183869025, 1233.0713282236602, 1373.9231715928186, 1402.5491074934696, 1429.7021155200312, 1303.5954975318039, 1351.4742115968943, 1362.7604119346724],
            [1320.7266287079533, 1251.7706528540307, 1253.2896297524624, 1212.8283613961432, 1488.6361439452937, 1451.2911242206337, 1357.446746730729, 1341.2121206023373, 1348.6441238678733, 1357.3056760094305, 1357.7593532946837, 1319.091537706909, 1296.5049504805338, 1328.0478230069996, 1368.4574346309, 1349.0001156394105, 1414.6144318448096, 1416.61709293385],
            [1320.7266287079533, 1251.7706528540307, 1253.2896297524624, 1212.8283613961432, 1136.7619636179825, 1449.2129802147974, 1361.2099203305797, 1340.3129962365085, 1345.3708811074277, 1349.8759241335788, 1356.4013588466967, 1317.3846335900835, 1373.5168144885602, 1399.1126435652468, 1428.5314346422501, 1418.1413383087117, 1454.380799043778, 1471.5180575288075],
            [1320.7266287079533, 1251.7706528540307, 1253.2896297524624, 1212.8283613961432, 1136.7619636179825, 1132.6269691995567, 1274.9534022546165, 1265.9606268721025, 1286.434436186174, 1281.9603479206487, 1294.8951266671795, 1235.7768801649959, 1313.5938515129144, 1356.1709709499287, 1383.9221337321194, 1376.136619082958, 1424.2168584190804, 1429.717894388855]]
    result=[[1328.1765246507357, 1503.4819127657738, 1413.0043866027665, 1463.0694754945252, 1411.3332686120364, 1430.8494924488095, 1348.4585284268035, 1425.5665531789396, 1434.6103288936818, 1382.0470220409627, 1400.9531567236882, 1430.8877968272081, 1388.6185194154302, 1349.9589680879892, 1331.6482975811632, 1349.4196364208437, 1333.4082035862293, 1289.1716043437505], [1328.1765246507357, 1353.1879576378208, 1405.8565440529696, 1432.7524257593964, 1401.1414708835648, 1413.2404297641222, 1383.0244353104806, 1424.8984233930191, 1431.198682113639, 1377.8356032938168, 1396.959114367267, 1431.17968510067, 1386.0419445035495, 1356.377703925818, 1332.1232554431833, 1352.6415842615386, 1334.979935409752, 1287.8872570069313], [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1461.5691341367276, 1411.0399445665012, 1428.6282956069683, 1342.4394201899177, 1410.6593127134165, 1421.27785518321, 1379.0053611335575, 1400.2550306243324, 1433.9203792901133, 1356.75918484904, 1345.2969702372804, 1335.91205104966, 1353.492373837457, 1338.6041420862807, 1291.1214993205556], [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1397.2181548623369, 1416.1632823180864, 1381.329183610079, 1423.0177897257574, 1381.024457636659, 1314.0230128358758, 1329.5899423905234, 1388.9476610421257, 1338.3554621772444, 1327.6922803222226, 1313.4015072363025, 1355.1396654592534, 1334.929881133014, 1288.7404759786446], [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977, 1239.6349292315638, 1256.4686678242904, 1277.2435737396827, 1267.0466827108758, 1178.9368661962508, 1368.468264013462, 1423.5411331544783, 1242.4019341077947, 1226.9254448575948, 1186.9326588398535, 1344.001558702772, 1337.9391635327902, 1297.4028580414574], [1328.1765246507357, 1353.1879576378208, 1285.3124337035306, 1276.2738975531172, 1272.385208955977, 1311.5753634371717, 1388.2120232884542, 1431.8449807730888, 1431.3580503007593, 1378.1452369441306, 1396.4141506156877, 1433.377670872926, 1384.1169572273377, 1359.900905300984, 1330.6370094444353, 1353.823654014219, 1336.9776868893764, 1288.787931542987]]

    labels = ['1', '2', "3", "4","5","6"]
    markers = [".", '^', 's', 'o']
    line = ['-', '--', ':', '-.',"-",":"]
    for i in range(len(result)):
        index = round(i / 2)
        plt.plot(result[i], label=labels[i], marker=".", linestyle=line[i], )
    # 设置图例
    plt.legend()
    # 设置 x 轴范围
    plt.xlim(0, 19)

    # 设置 x 轴刻度间距
    plt.xticks(np.arange(0, 19, 1))

    # 设置标题和坐标轴标签
    # plt.title('Multiple Lines on One Plot')
    plt.xlabel('time slots')
    plt.ylabel('System Energy Efficiency')

    # 显示图形
    plt.show()
def draw_slot_satisfaction_compare():
    r1 = [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.9333333333333333, 0.9333333333333333,
          0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333]
    r2 = [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.9333333333333333, 1.0, 1.0, 0.9333333333333333,
          1.0, 1.0]
    r3 = [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.9333333333333333, 1.0, 1.0, 1.0, 1.0, 1.0]

    g1 = [1.0, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 1.0,
          0.9333333333333333, 0.9333333333333333, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
    g2 = [1.0, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 1.0,
          1.0, 1.0, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
    g3 = [1.0, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 0.9333333333333333, 1.0,
          1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]
    result = []
    result.append(r1)
    result.append(r2)
    result.append(r3)
    # result.append(r4)
    # result.append(r5)
    # result.append(r6)
    labels = ['10 10', '10 20', "10 30", "10 40", "10 50", "10 60"]
    markers = [".", '^', 's', 'o']
    line = ['-', '--', ':', '-.', "-", ":"]
    for i in range(len(result)):
        index = round(i / 2)
        plt.plot(result[i], label=labels[i], marker=".", linestyle=line[i], )
    # 设置图例
    plt.legend()
    # 设置 x 轴范围
    plt.xlim(0, 19)
    plt.ylim(0, 1.1)
    # 设置 x 轴刻度间距
    plt.xticks(np.arange(0, 19, 1))

    # 设置标题和坐标轴标签
    # plt.title('Multiple Lines on One Plot')
    plt.xlabel('time slots')
    plt.ylabel('Communication Satisfaction')

    # 显示图形
    plt.show()

def draw_compare_pso_and_convex():
    r1=[2156.572640825806, 1793.049723531689, 1536.9919020592397, 1731.792484946798, 1636.6545118475497,
     1158.0510410573797, 1103.6215549974738, 782.5004345151718]
    r2=[2102.3361983188765, 1643.2563392728337, 1363.8964216339489, 1375.9362936740881, 810.3157040900248,
     744.929779050958, 823.9891822976343, 461.98393739269625]
    r3=[2095.218778754906, 1632.1290265003292, 1508.3203473638766, 1414.1323142076471, 1114.4302718364665,
     969.7470169582967, 920.7834622299312, 752.0135667914984]
    r4=[2081.364506789164, 1441.4649220322065, 1352.8460409408997, 1251.814958273326, 827.5835603105922, 718.3196179478409,
     702.6041582888906, 590.024193244058]
    r1 = [1979.5154537856467, 1949.1967926150814, 1583.8373789254997, 1408.9597726122278, 1284.75424046391,
          1062.356849679389, 773.64091282078, 669.5307009461131]
    r2 = [1954.7080805746896, 1453.8382207915447, 1268.2785375163758, 987.7561390469604, 881.274376744466,
          783.0926396247362, 555.7810370667859, 400.0913596289859]
    r3 = [1979.5154537856467, 1572.289453569241, 1482.206203919101,1113.0080767351026, 1064.4678552375331,
          910.7380100121287, 710.6949860041652, 473.73148513092895]
    r4 = [1954.7080805746896, 1391.2020029825142, 1189.340170050845, 905.7558722161126, 805.0153107446824,
          720.2723455091826, 520.5573981391487, 373.8077702943482]

    r=[(r1[i]-r4[i])/r4[i] for i in range(len(r1))]
    print(sum(r)/len(r))
    result=[]
    result.append(r1)
    result.append(r2)
    result.append(r3)
    result.append(r4)
    x=[i for i in range(5, 20, 2)]
    labels = ['Proposed Scheme', 'PSO-Avg', "KMeans-Convex", "KMeans-Avg"]
    markers = [".", '^', 's', 'o']
    line = ['-', '--', ':', '-.']
    for i in range(len(result)):
        index = round(i / 2)
        plt.plot(x,result[i], label=labels[i], marker="o", linestyle=line[i], zorder=2)
    # 设置图例
    plt.legend()
    # 设置 x 轴范围
    plt.xlim(4, 20)

    # 设置 x 轴刻度间距
    plt.xticks(np.arange(5, 20, 2))

    # 设置标题和坐标轴标签
    # plt.title('Multiple Lines on One Plot')
    plt.xlabel('Users Num')
    plt.ylabel('System Energy Efficiency')

    # 显示图形
    plt.show()

def draw_c_satisfaction():
    # 示例数据
    name_list = ['uavs=4,users=16', 'uavs=5,users=30', 'uavs=6,users=50',]
    values1 = [1.0, 0.96, 0.85]
    values2 = [0.8823529411764706, 0.86, 0.8]
    values3 = [0.9411764705882353, 0.94, 0.83]
    values4 = [0.8823529411764706, 0.8, 0.7]
    improve=[(values1[i]-values4[i])/values4[i] for i in range(len(values1))]
    print(sum(improve)/len(improve))
    x = list(range(len(values1)))
    print(x)
    total_width, n = 0.8, 4
    width = total_width / n
    # 计算每个柱的位置
    bar_positions = np.arange(len(name_list))

    plt.bar(bar_positions - 2*width, values1, width=width, label='Proposed Scheme', color='white',edgecolor='black',tick_label=name_list,)
    for i in range(len(x)):
        x[i] = x[i] + width
    plt.bar(bar_positions - width, values2, width=width, label='PSO-Avg', tick_label=name_list, color='white',edgecolor='black',hatch='/' )
    for i in range(len(x)):
        x[i] = x[i] + width
    plt.bar(bar_positions, values3, width=width, label='KMeans-Convex', tick_label=name_list, color='white',edgecolor='black',hatch='\\')
    for i in range(len(x)):
        x[i] = x[i] + width
    plt.bar(bar_positions+width, values4, width=width, label='KMeans-Avg', tick_label=name_list, color='white',edgecolor='black',hatch='//' )
    # for i in range(len(bar_positions)):
    #     bar_positions[i] = bar_positions[i] - 0.1
    plt.xticks(bar_positions, name_list)

    plt.ylabel('Communication Satisfaction of Users')
    plt.legend()
    plt.show()
def draw_p_satisfaction():
    name_list = ['uavs=4,users=16', 'uavs=5,users=30', 'uavs=6,users=50', ]
    values1,values2,values3,values4 =[1.0,1,1], [1.0,1,1], [0.8235294117647058,0.9,0.88], [0.8235294117647058,0.9,0.88]

    x = list(range(len(values1)))
    print(x)
    total_width, n = 0.8, 4
    width = total_width / n
    # 计算每个柱的位置
    bar_positions = np.arange(len(name_list))
    light_color = 'white'

    plt.bar(bar_positions - 2 * width, values1, width=width, label='Proposed Scheme', color=light_color,edgecolor='black', tick_label=name_list, )
    for i in range(len(x)):
        x[i] = x[i] + width
    plt.bar(bar_positions - width, values2, width=width, label='PSO-Avg', tick_label=name_list,  color=light_color,edgecolor='black', hatch='/')
    for i in range(len(x)):
        x[i] = x[i] + width
    plt.bar(bar_positions, values3, width=width, label='KMeans-Convex', tick_label=name_list,  color=light_color,edgecolor='black', hatch='\\')
    for i in range(len(x)):
        x[i] = x[i] + width
    plt.bar(bar_positions + width, values4, width=width, label='KMeans-Avg', tick_label=name_list, color=light_color,edgecolor='black',
            hatch='//')
    # for i in range(len(bar_positions)):
    #     bar_positions[i] = bar_positions[i] - 0.1
    plt.xticks(bar_positions, name_list)

    plt.ylabel('Localization Satisfaction of Users')
    plt.legend()
    plt.show()

def draw_dynamic_utility():
    r=[-182.50035696943849, -177.79594156951626, -145.0853662930458, -142.68333401292557, -141.75346320018448,
     -139.89634105148497, -139.25474456595703, -138.38238133386784, -130.0599933647533, -132.7028964739182,
     -133.02973650029, -137.43839825328695, -140.7194869302244, -139.8250859102916, -138.70066639324273,
     -144.02751920866464, -147.57584841736275]
    r3=[-185.11489614688995, -183.32832233236752, -184.8632440312421, -185.90826130427084, -1046.4029821344411,
     -705.1510281549287, -784.703021596474, -188.32844376690645, -1432.3437733694404, -1340.519117170665,
     -1108.9134865693245, -1329.724190290336, -543.0716332673447, -4079.8195480534982, -801.905349792583,
     -880.6140750428915, -185.65576844983727]
    r2=[-182.5881732692689, -182.9274309066099, -151.37672315057665, -149.39333947365594, -149.79231667807625, -147.4212656957045, -148.77068968962027, -153.205403970754, -141.47000821147626, -142.7027807716164, -142.0437598710444, -143.8288448799893, -143.2228327270912, -144.59048160309982, -147.25800551225242, -146.7899663698531, -144.9709480279667]

    r1 = [-184.06100597871276, -185.85049500451746, -146.8288332014583, -147.8690106029141, -150.89610670415044,
          -161.58225234814634, -161.25450103761872, -160.210679762176, -174.61142139727096, -177.76804395633008,
          -181.569335688453, -159.927794994072, -160.94409679626565, -166.21748449604434, -160.2738429197924,
          -159.7484534802284, -158.85902270747295]
    r2 = [-183.75262514436605, -185.87714908455004, -146.57818980968494, -147.60619957376412, -150.63793929032238,
          -160.1327365871477, -160.41656576457314, -159.14883710280913, -177.61971965060854, -173.46045900149656,
          -177.10133069993495, -159.18269253893232, -160.08874781747255, -163.4671368445193, -158.9553959759295,
          -158.31327992554847, -157.30095288797912]
    r3 = [-191.9539271586222, -495.0759766925493, -193.5965909690982, -192.5817448793148, -1195.945536180579,
          -540.6940059847401, -629.8130961244544, -552.3027556855934, -189.9716865954716, -701.1440778210009,
          -2998.227257864013, -2423.421441879022, -200.80692664994223, -1791.7088515380249, -879.184983460981,
          -201.1295073193511, -1087.8150595700147]
    r4_1 = [-183.75262514436605, -185.87714908455004, -186.438834653355, -184.1884585777314, -186.33933807260107,
          -188.43716599179044, -188.19672726431384, -186.9874196689149, -189.13295993082926, -189.30032644825883,
          -192.89436400905976, -195.0003337026544, -196.4162768042548, -196.62278977364838, -197.82920310513353,
          -197.86530599940798, -198.22041251155667]
    r4=[-191.9539271586222, -193.26796056081787, -193.08808786801166, -192.21772213830948, -194.02224268400286, -193.699253301448, -193.61243939244417, -191.9209212060532, -194.12611798707232, -194.22893921637396, -198.00070893060212, -199.68020061189088, -201.41765011390575, -202.61071672355132, -203.10880418272217, -202.69870082683104, -202.27407764837193]


    # d=[(r1[i]-r3[i])/abs(r3[i]) for i in range(len(r1))]
    d = [(r1[i] - r4[i]) / abs(r4[i]) for i in range(len(r1))]
    d1 = [(r1[i] - r4_1[i]) / abs(r4_1[i]) for i in range(len(r1))]
    print(sum(d)/len(d))
    print(sum(d1) / len(d))
    x=[i for i in range(1, 18, 1)]
    plt.plot(x, r1, label="Proposed algorithm", marker="o", )
    # plt.plot(x, r4, label="Non dual time scales", marker="*", )
    plt.plot(x, r4, label="Fixed position and resource", marker="*", )
    # plt.plot(x, r4_1, label="Fixed position-Convex", marker=".", )
    plt.plot(x, r4_1, label="Fixed position dynamic resource", marker="^", )
    # plt.plot(x, r2, label="Pso-Convex", marker="^", )
    # plt.plot(x, r3, label="Kmeans-Avg", marker=".", )
    plt.xlabel('时隙', fontsize=14, fontproperties=font_prop)
    plt.ylabel('通导效用', fontsize=14, fontproperties=font_prop)
    # plt.xlabel('time slots')
    # plt.ylabel("Communication Localization utility")

    plt.legend()
    # plt.ylim(-3000, 100)
    plt.show()

def draw_dynamic_c_satisfaction():
    c1 = [0.8333333333333334, 0.8333333333333334, 0.7, 0.7, 0.7, 0.8, 0.8, 0.8, 0.7333333333333333, 0.8, 0.8, 0.7, 0.7,
          0.7666666666666667, 0.6666666666666666, 0.6666666666666666, 0.6666666666666666]
    g1 = [0.6666666666666666, 0.6666666666666666, 0.8666666666666667, 0.8666666666666667, 0.8666666666666667, 0.8, 0.8,
          0.8, 0.8333333333333334, 0.8333333333333334, 0.8333333333333334, 0.7333333333333333, 0.7333333333333333,
          0.7333333333333333, 0.7666666666666667, 0.7666666666666667, 0.7666666666666667]
    c2 = [0.4666666666666667, 0.5333333333333333, 0.6666666666666666, 0.5666666666666667, 0.6333333333333333,
          0.6333333333333333, 0.5666666666666667, 0.6, 0.5, 0.5333333333333333, 0.4, 0.5333333333333333,
          0.4666666666666667, 0.5666666666666667, 0.5333333333333333, 0.43333333333333335, 0.4]
    g2 = [0.6666666666666666, 0.6666666666666666, 0.8666666666666667, 0.8666666666666667, 0.8666666666666667, 0.8, 0.8,
          0.8, 0.8333333333333334, 0.8333333333333334, 0.8333333333333334, 0.7333333333333333, 0.7333333333333333,
          0.7333333333333333, 0.7666666666666667, 0.7666666666666667, 0.7666666666666667]
    c3 = [0.7666666666666667, 0.36666666666666664, 0.7666666666666667, 0.7333333333333333, 0.36666666666666664,
          0.26666666666666666, 0.16666666666666666, 0.36666666666666664, 0.7666666666666667, 0.13333333333333333,
          0.4666666666666667, 0.4, 0.6, 0.23333333333333334, 0.03333333333333333, 0.6333333333333333,
          0.16666666666666666]
    g3 = [0.6666666666666666, 0.4666666666666667, 0.6333333333333333, 0.6333333333333333, 0.23333333333333334,
          0.43333333333333335, 0.4666666666666667, 0.5333333333333333, 0.7, 0.3, 0.3, 0.3333333333333333, 0.6, 0.4,
          0.16666666666666666, 0.6, 0.43333333333333335]
    c4_1=[0.4666666666666667, 0.5333333333333333, 0.6333333333333333, 0.6, 0.6, 0.5666666666666667, 0.4666666666666667, 0.5,
     0.4, 0.4666666666666667, 0.3333333333333333, 0.43333333333333335, 0.43333333333333335, 0.4666666666666667,
     0.4666666666666667, 0.4666666666666667, 0.36666666666666664]
    c4=[0.7666666666666667, 0.8, 0.8, 0.8, 0.8, 0.6333333333333333, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6666666666666666, 0.6333333333333333, 0.6333333333333333, 0.6333333333333333, 0.6333333333333333, 0.6333333333333333]
    g4_1 = [0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.7, 0.7,
          0.7, 0.7, 0.7, 0.7, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6]
    g4 = [0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.7, 0.7,
          0.7, 0.7, 0.7, 0.7, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6]

    x = [i for i in range(1, 18, 1)]
    plt.plot(x, c1,label="Proposed algorithm", marker="o", )
    plt.plot(x, c4, label="Non dual time scales", marker="*", )
    # plt.plot(x, c4, label="Fixed position and resource", marker="*", )
    # plt.plot(x, c4_1, label="Fixed position-Convex", marker=".", )
    plt.plot(x, c2,label="PSO-Convex", marker="^", )
    plt.plot(x, c3,label="Kmeans-Avg", marker=".", )
    # d1= [(c1[i] - c3[i]) / abs(c3[i]) for i in range(len(c1))]
    # d2 = [(g1[i] - g3[i]) / abs(g3[i]) for i in range(len(g1))]
    d11=(sum(c1)-sum(c3))/sum(c3)
    d22=(sum(g1)-sum(g3))/sum(g3)
    d1 = (sum(c1) - sum(c4)) / sum(c4)
    d2 = (sum(g1) - sum(g4)) / sum(g4)
    d1_1 = (sum(c1) - sum(c4_1)) / sum(c4_1)
    d2_2 = (sum(g1) - sum(g4_1)) / sum(g4_1)
    # d1 = [(c1[i] - c4[i]) / abs(c4[i]) for i in range(len(c1))]
    # d2 = [(g1[i] - g4[i]) / abs(g4[i]) for i in range(len(g1))]
    print(d1,d2)
    print(d1_1,d2_2)
    print(d11,d22)

    plt.legend()
    plt.xlabel('时隙', fontsize=14, fontproperties=font_prop)
    plt.ylabel('通信需求满足率', fontsize=14, fontproperties=font_prop)
    # plt.xlabel('time slots')
    # plt.ylabel('Communication Satisfaction of Users')

    plt.show()

def draw_dynamic_g_satisfaction():
    c1 = [0.8333333333333334, 0.8333333333333334, 0.7, 0.7, 0.7, 0.8, 0.8, 0.8, 0.7333333333333333, 0.8, 0.8, 0.7, 0.7,
          0.7666666666666667, 0.6666666666666666, 0.6666666666666666, 0.6666666666666666]
    g1 = [0.6666666666666666, 0.6666666666666666, 0.8666666666666667, 0.8666666666666667, 0.8666666666666667, 0.8, 0.8,
          0.8, 0.8333333333333334, 0.8333333333333334, 0.8333333333333334, 0.7333333333333333, 0.7333333333333333,
          0.7333333333333333, 0.7666666666666667, 0.7666666666666667, 0.7666666666666667]
    c2 = [0.4666666666666667, 0.5333333333333333, 0.6666666666666666, 0.5666666666666667, 0.6333333333333333,
          0.6333333333333333, 0.5666666666666667, 0.6, 0.5, 0.5333333333333333, 0.4, 0.5333333333333333,
          0.4666666666666667, 0.5666666666666667, 0.5333333333333333, 0.43333333333333335, 0.4]
    g2 = [0.6666666666666666, 0.6666666666666666, 0.8666666666666667, 0.8666666666666667, 0.8666666666666667, 0.8, 0.8,
          0.8, 0.8333333333333334, 0.8333333333333334, 0.8333333333333334, 0.7333333333333333, 0.7333333333333333,
          0.7333333333333333, 0.7666666666666667, 0.7666666666666667, 0.7666666666666667]
    c3 = [0.7666666666666667, 0.36666666666666664, 0.7666666666666667, 0.7333333333333333, 0.36666666666666664,
          0.26666666666666666, 0.16666666666666666, 0.36666666666666664, 0.7666666666666667, 0.13333333333333333,
          0.4666666666666667, 0.4, 0.6, 0.23333333333333334, 0.03333333333333333, 0.6333333333333333,
          0.16666666666666666]
    g3 = [0.6666666666666666, 0.4666666666666667, 0.6333333333333333, 0.6333333333333333, 0.23333333333333334,
          0.43333333333333335, 0.4666666666666667, 0.5333333333333333, 0.7, 0.3, 0.3, 0.3333333333333333, 0.6, 0.4,
          0.16666666666666666, 0.6, 0.43333333333333335]
    g4_1 = [0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.7, 0.7,
          0.7,0.7, 0.7, 0.7, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6]
    g4=[0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.6666666666666666, 0.7, 0.7, 0.7, 0.7, 0.7, 0.7, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6]

    x = [i for i in range(1, 18, 1)]
    plt.plot(x, g1,label="Proposed algorithm", marker="o", )
    plt.plot(x, g4, label="Non dual time scales", marker="*", )
    # plt.plot(x, g4, label="Fixed position and resource", marker="*", )
    # plt.plot(x, g4_1, label="Fixed position-Convex", marker=".", )
    plt.plot(x, g2,label="PSO-Convex", marker="^", )
    plt.plot(x, g3,label="Kmeans-Avg", marker=".", )
    plt.xlabel('时隙', fontsize=14, fontproperties=font_prop)
    plt.ylabel('定位需求满足率', fontsize=14, fontproperties=font_prop)
    # plt.xlabel('time slots')
    # plt.ylabel('Localization Satisfaction of Users')
    plt.legend()
    plt.show()

def draw_two_pso():
    r1=[-1196.9323426279452, -1023.2879873142075, -938.1347737903101, -839.9352308341875, -713.3749158686057,
     -695.6398497337009, -692.6064311156695, -655.9969403981936, -652.2223431837863, -640.3367322566492,
     -640.3367322566492, -629.4268704014644, -629.4268704014644, -619.2731245473466, -618.8899488986626,
     -618.8899488986626, -618.8899488986626, -618.8899488986626, -613.6306159984326, -613.6306159984326,
     -613.6306159984326, -613.6306159984326, -613.6306159984326, -613.6306159984326, -613.5003594617765,
     -613.4642026310231, -612.7132692348612, -612.7132692348612, -612.7132692348612, -612.7132692348612,
     -612.7132692348612, -612.7132692348612, -612.7132692348612, -612.7132692348612, -612.0582857242623,
     -611.7966818160626, -611.4553346200508, -611.4553346200508, -610.4046128928244, -610.4046128928244,
     -610.4046128928244, -610.3414237226195, -610.0636132324591, -609.9302397688457, -609.9302397688457,
     -609.9302397688457, -609.8247476936176, -609.3586162393262, -608.7753594243752, -608.7753594243752,
     -608.4847452080389, -608.4847452080389, -608.4847452080389, -608.4328989734311, -608.3579667611907,
     -608.3579667611907, -608.3579667611907, -608.3579667611907, -608.2983547415181, -608.2545299241742,
     -607.9579163498192, -607.9579163498192, -607.9579163498192, -607.9579163498192, -607.9579163498192,
     -607.9579163498192, -607.9579163498192, -607.9251930979092, -607.8490809433433, -607.7401985001247,
     -607.7401985001247, -607.7401985001247, -607.7401985001247, -607.729634835325, -607.729634835325,
     -607.729634835325, -607.7292704587401, -607.6403860641153, -607.6403860641153, -607.6403860641153,
     -607.6335094134449, -607.6025167411549, -607.5755885295946, -607.5722972661849, -607.5645509212286,
     -607.541015826343, -607.4579266297451, -607.4012341854012, -607.4012341854012, -607.4012341854012,
     -607.3827092828479, -607.3230904811196, -607.3081820002802, -607.2542297698676, -607.1699432866275,
     -607.1357793051466, -607.1344263335025, -607.1083267606782, -607.1083267606782, -607.0837256958735,
     -607.0365337511737, -606.9998609278682, -606.9012318909207, -606.8523765243652, -606.8523765243652,
     -606.8523765243652, -606.842359971376, -606.7956110585856, -606.7956110585856, -606.7956110585856,
     -606.7408729474714, -606.6802105356159, -606.6740828338604, -606.6740828338604, -606.6505920842787,
     -606.6026225102125, -606.5935995966431, -606.5448191595901, -606.5448191595901, -606.5063607756622,
     -606.5063607756622, -606.5063607756622, -606.4851726862596, -606.4851726862596, -606.4851726862596,
     -606.4772055606807, -606.4772055606807, -606.4772055606807, -606.4771594380561, -606.4771594380561,
     -606.470177358181, -606.470177358181, -606.470177358181, -606.470177358181, -606.456010919539, -606.4546567569781,
     -606.4507733875905, -606.4025904682732, -606.3751148588892, -606.3730367007836, -606.3473268430255,
     -606.3349603008672, -606.3349603008672, -606.3349603008672, -606.3337851788831, -606.319478725464,
     -606.319478725464, -606.3032184946985, -606.3032184946985, -606.296861611934, -606.296861611934,
     -606.2802118434549, -606.2453062088408, -606.2254450888618, -606.2254450888618, -606.2254450888618,
     -606.2241058242523, -606.1716396591552, -606.1405887180167, -606.1089602732022, -606.0555927777,
     -606.0533244250175, -605.9970026224007, -605.9553210622021, -605.9058515535407, -605.7808651617311,
     -605.6894618878111, -605.6095113966787, -605.5357964277108, -605.2882820245106, -605.102346569551,
     -604.9078201405405, -604.7106563329935, -604.433266025304, -604.3960675521805, -604.2827959000942,
     -604.2579148274684, -604.2579148274684, -604.2579148274684, -604.2442110865913, -604.2413731581769,
     -604.234528779501, -604.234528779501, -604.2265793947867, -604.2265793947867, -604.22352810453, -604.2139074961442,
     -604.2108490203143, -604.1891481621628, -604.1891481621628, -604.1891481621628, -604.1891481621628,
     -604.1891481621628, -604.1891481621628, -604.1891481621628, -604.1891481621628, -604.1891481621628,
     -604.1891481621628, -604.1891481621628, -604.1891481621628]
    r2=[-380.7411141759215, -380.7411141759215, -380.7411141759215, -363.72305859666784, -363.72305859666784,
     -349.810356641212, -328.5825684550027, -328.5825684550027, -328.5825684550027, -328.5825684550027,
     -325.5954018295555, -318.08045403389883, -318.08045403389883, -318.08045403389883, -315.8258698970216,
     -311.07719296107484, -311.03875270173796, -311.03875270173796, -294.3404638065752, -294.3404638065752,
     -290.5217035878852, -275.5763852875366, -265.23241780168416, -265.23241780168416, -265.23241780168416,
     -265.23241780168416, -262.28605152664534, -262.28605152664534, -258.8284357693334, -256.22640857164606,
     -256.22640857164606, -256.22640857164606, -256.22640857164606, -256.22640857164606, -255.53912739962215,
     -255.53912739962215, -255.53912739962215, -255.33560728054294, -255.33560728054294, -255.28767766570354,
     -255.28767766570354, -253.76995359761094, -252.83659157878247, -251.977103784552, -251.977103784552,
     -251.977103784552, -251.977103784552, -251.977103784552, -251.977103784552, -251.53735983379426,
     -248.71930609772627, -248.71930609772627, -247.83619225744548, -247.83283225965897, -247.78590955094347,
     -247.78590955094347, -247.59373583633038, -247.5732508903926, -247.5732508903926, -247.5693554712022,
     -247.5693554712022, -247.3226140469394, -247.3226140469394, -247.3226140469394, -247.14441530955818,
     -247.14441530955818, -247.14441530955818, -246.6572067590505, -246.468983665093, -246.44367458023024,
     -246.29257042607526, -246.29257042607526, -246.29257042607526, -246.29257042607526, -246.28983312227217,
     -246.2107367702723, -246.0802533898576, -246.0802533898576, -246.0802533898576, -246.0802533898576,
     -246.0802533898576, -246.0802533898576, -246.07747834189666, -246.049077629492, -246.04682457275493,
     -246.04682457275493, -245.9802714581705, -245.9466906329154, -245.9466906329154, -245.87516567942754,
     -245.8335567374412, -245.81565126884948, -245.81565126884948, -245.7225111268908, -245.62841620693212,
     -245.62670140858825, -245.62054618646803, -245.62054618646803, -245.62054618646803, -245.61057598622915,
     -245.61057598622915, -245.55937807397459, -245.5242572250821, -245.5242572250821, -245.5242572250821,
     -245.5242572250821, -245.51646263534585, -245.51646263534585, -245.51646263534585, -245.51646263534585,
     -245.51646263534585, -245.51646263534585, -245.5151690804198, -245.48847455697387, -245.48708931335642,
     -245.4730102826531, -245.45908855084855, -245.45156674846427, -245.45156674846427, -245.45156674846427,
     -245.45156674846427, -245.45156674846427, -245.45156674846427, -245.44924975582472, -245.44924975582472,
     -245.44924975582472, -245.44924975582472, -245.44924975582472, -245.44924975582472, -245.4467777809799,
     -245.4467777809799, -245.4467777809799, -245.44655918815045, -245.44655918815045, -245.44655918815045,
     -245.44655918815045, -245.44482415235223, -245.44482415235223, -245.44482415235223, -245.44482415235223,
     -245.44482415235223, -245.44482415235223, -245.44482415235223, -245.44482415235223, -245.44482415235223,
     -245.44482415235223, -245.44482415235223, -245.44482415235223, -245.44482415235223, -245.44482415235223,
     -245.44482415235223, -245.44427621306633, -245.44427621306633, -245.44427621306633, -245.44427621306633,
     -245.44427621306633, -245.44427621306633, -245.4441307955143, -245.4441307955143, -245.4441307955143,
     -245.4441307955143, -245.4441307955143, -245.4441307955143, -245.4441307955143, -245.4441307955143,
     -245.4441307955143, -245.4441307955143, -245.4441307955143, -245.4441307955143, -245.4441307955143,
     -245.4441307955143, -245.4441307955143, -245.4441307955143, -245.4441307955143, -245.4441307955143,
     -245.4441307955143, -245.4441307955143, -245.4441307955143, -245.4441307955143, -245.4441307955143,
     -245.4441307955143, -245.4441307955143, -245.4441307955143, -245.4441307955143, -245.4441307955143,
     -245.4441307955143, -245.44412490547342, -245.44412490547342, -245.44412490547342, -245.44412490547342,
     -245.44412490547342, -245.44412490547342, -245.44412490547342, -245.44412490547342, -245.44412490547342,
     -245.44412490547342, -245.44412490547342, -245.44412490547342, -245.44412490547342, -245.44412490547342]
    plt.plot(r2, label="improved pso", )
    plt.plot(r1, label="static pso",linestyle='--', )
    d1 = [(r2[i] - r1[i]) / abs(r1[i]) for i in range(len(r1))]
    print(sum(d1)/len(d1))
    plt.xlabel('迭代次数', fontsize=14, fontproperties=font_prop)
    plt.ylabel('适应度', fontsize=14, fontproperties=font_prop)
    # plt.xlabel('iteration')
    # plt.ylabel('fitness value')
    plt.legend()
    plt.show()

def draw_scheme_compare():
    r1=[-184.06100597871276, -185.85049500451746, -146.8288332014583, -147.8690106029141, -150.89610670415044,
          -161.58225234814634, -161.25450103761872, -160.210679762176, -174.61142139727096, -177.76804395633008,
          -181.569335688453, -159.927794994072, -160.94409679626565, -166.21748449604434, -160.2738429197924,
          -159.7484534802284, -158.85902270747295]
    r2 = [-184.47707786404925, -186.79859967274973, -187.18900537301826, -185.00993033401568, -186.98011160427623,
          -186.7475686243944, -188.5738993568263, -186.66325649759037, -189.93822318891313, -190.1625116360844,
          -193.71770035886448, -195.85488809139676, -195.6319247325472, -197.10555864062565, -198.25810453714203,
          -198.28055212033237, -198.22276758982875, -198.55710227964607]
    r3 = [-184.47707786404925, -186.09526372564545, -186.06078249070885, -147.85913907661956, -150.55241416659936,
          -150.31251306017782, -153.33386123238563, -151.49498797995372, -153.77165045599617, -169.11425658693145,
          -169.97320242448745, -170.8741998698821, -164.6200858129465, -164.28081292472123, -165.24268234023336,
          -162.52560152043168, -161.74900753634054, -161.92402781925833]
    plt.plot(r1, label="proposed algorithm", marker="o", )
    plt.plot(r2, label="FDDR", marker="o", )
    plt.plot(r3, label="FRDD", marker="o", )
    plt.legend()
    # plt.ylim(-3000, 100)
    plt.show()

# draw_scheme_compare()
draw_two_pso()
# draw_data()
# draw_time()
# draw_avg_and_optimal()
# draw_different_scheme()
draw_particle_num()
draw_iteration_num()
# draw_particle_time()
# draw_iteration_num()
# draw_iteration_time()
draw_dynamic_utility()
draw_dynamic_c_satisfaction()
draw_dynamic_g_satisfaction()
# draw_different_scheme()
# draw_compare_pso_and_convex()
# draw_c_satisfaction()
# draw_p_satisfaction()
# draw_slot_compare()
# draw_slot_satisfaction_compare()
# draw_different_scheme_satisfaction()