#include "GeodeticTool.h"

#include <Geodetics/GeodeticTransform.h>

#include <QtCore/QRegExp>


namespace F1911
{
    GeodeticTool::GeodeticTool(QWidget* parent)
        : QMainWindow(parent)
    {
        ui.setupUi(this);

        connect(ui.toLocalENUButton, &QPushButton::clicked, this, &GeodeticTool::toLocalENUButtonClick);
        connect(ui.toGeodeticButton, &QPushButton::clicked, this, &GeodeticTool::toGeodeticButtonClick);
    }

    GeodeticTool::~GeodeticTool()
    {
        disconnect(ui.toGeodeticButton, &QPushButton::clicked, this, &GeodeticTool::toGeodeticButtonClick);
        disconnect(ui.toLocalENUButton, &QPushButton::clicked, this, &GeodeticTool::toLocalENUButtonClick);
    }

    bool GeodeticTool::parseNumber(const QLineEdit* edit, double& value)
    {
        bool ok;
        value = edit->text().toDouble(&ok);
        return ok;
    }

    void GeodeticTool::setNumber(QLineEdit* edit, double value)
    {
        auto text = QString::number(value, 'f', 12);
        text.remove(QRegExp("0+$")); // Ƴβġ0
        text.remove(QRegExp("\\.$")); // һַǡ.Ƴ
        edit->setText(text);
    }

    void GeodeticTool::toLocalENUButtonClick()
    {
        double longitude, latitude, altitude;
        if (parseNumber(ui.longitudeEdit, longitude) &&
            parseNumber(ui.latitudeEdit, latitude) &&
            parseNumber(ui.altitudeEdit, altitude))
        {
            double east, north, up;
            Geodetics::GeodeticTransform::get().geodeticToLocal(
                east, north, up, longitude, latitude, altitude);

            setNumber(ui.localEastEdit, east);
            setNumber(ui.localNorthEdit, north);
            setNumber(ui.localUpEdit, up);
        }
    }

    void GeodeticTool::toGeodeticButtonClick()
    {
        double east, north, up;
        if (parseNumber(ui.localEastEdit, east) &&
            parseNumber(ui.localNorthEdit, north) &&
            parseNumber(ui.localUpEdit, up))
        {
            double longitude, latitude, altitude;
            Geodetics::GeodeticTransform::get().localToGeodetic(
                longitude, latitude, altitude, east, north, up);

            setNumber(ui.longitudeEdit, longitude);
            setNumber(ui.latitudeEdit, latitude);
            setNumber(ui.altitudeEdit, altitude);
        }
    }
}
