#pragma once

#include "GeodeticsBase.h"


namespace F1911::Geodetics
{
    class GeodeticTransformInternal;

    class GEODETICS_API GeodeticTransform final
    {
        // Instance ----------------------------------------------------------------------------------------------------
    public:
        static GeodeticTransform& get()
        {
            static GeodeticTransform t;
            return t;
        }

        GeodeticTransform(const GeodeticTransform& other) = delete;
        GeodeticTransform& operator=(const GeodeticTransform& other) = delete;
        GeodeticTransform(GeodeticTransform&& other) = delete;
        GeodeticTransform& operator=(GeodeticTransform&& other) = delete;
    private:
        GeodeticTransform();
        ~GeodeticTransform();
        GeodeticTransformInternal* _i;


        // Transforms --------------------------------------------------------------------------------------------------
    public:
        double eastOffset = -643615.753, northOffset = -4400490.578, upOffset = 50;

        bool localToGeodetic(double& longitude, double& latitude,
            double& altitude, double east, double north, double up) const;
        bool geodeticToLocal(double& east, double& north, double& up,
            double longitude, double latitude, double altitude) const;
    };
}
