from tqdm import tqdm
import concurrent.futures
import math
import os
from csv import reader
import pandas as pd
import position_transfer
import matplotlib as mpl
from mpl_toolkits.mplot3d import Axes3D
import numpy as np
import matplotlib.pyplot as plt



def process(file_path,file_name):
    filename = file_name.split(".")[0]
    print(filename)
    df = pd.read_csv(file_path)

    for index,row in df.iterrows():
        position_change=row['position_change']
        if position_change==0:
            if index < len(df) - 1 and index>=1:
                df.loc[index,'tar_x']=(df.loc[index+1,'tar_x']+df.loc[index-1,'tar_x'])/2
                df.loc[index, 'position_change'] = (df.loc[index + 1, 'position_change'] + df.loc[
                    index - 1, 'position_change']) / 2
                df.loc[index, 'tar_y'] = (df.loc[index + 1, 'tar_y'] + df.loc[index - 1, 'tar_y']) / 2
                df.loc[index, 'tar_z'] = (df.loc[index + 1, 'tar_z'] + df.loc[index - 1, 'tar_z']) / 2
                df.loc[index, 'v'] = (df.loc[index + 1, 'v'] + df.loc[index - 1, 'v']) / 2
                df.loc[index, 'v_change'] = (df.loc[index + 1, 'v_change'] + df.loc[index - 1, 'v_change']) / 2
                df.loc[index, 'r'] = (df.loc[index + 1, 'r'] + df.loc[index - 1, 'r']) / 2
                df.loc[index, 'eli_change'] = (df.loc[index + 1, 'eli_change'] + df.loc[index - 1, 'eli_change']) / 2
                df.loc[index, 'h_change'] = (df.loc[index + 1, 'h_change'] + df.loc[index - 1, 'h_change']) / 2
            else:
                df = df.drop(index)


    df.to_csv('E:/replay/1对1/process_data/5/'+filename+'.csv', index=False)
    return filename + 'finish'

def processFiles():
    folder_path = "E:/replay/1对1/data/5"  # 替换为你的文件夹路径
    # folder_path = "E:/replay/demo"
    # # 获取文件夹中的所有文件
    file_list = os.listdir(folder_path)
    results = []
    count = 1
    with concurrent.futures.ProcessPoolExecutor(max_workers=5) as executor:
        for file_name in tqdm(file_list, desc="Processing files"):
            if file_name.endswith(".csv"):
                file_path = os.path.join(folder_path, file_name)
                # 解析XML文件
                result = executor.submit(process, file_path, file_name)
                results.append(result)
        for future in concurrent.futures.as_completed(results):
            print(count)
            print(future.result())
            count += 1

##数据预处理 load dataset,需要处理0值，0值为异常值，
def data_preprocess():
    folder_path = "E:/replay/1对1/process_data/1"  # 替换为你的文件夹路径
    # # 获取文件夹中的所有文件
    file_list = os.listdir(folder_path)
    results = []
    count = 1
    data_all = pd.DataFrame()
    for file_name in tqdm(file_list, desc="Processing files"):
        if file_name.endswith(".csv"):
            file_path = os.path.join(folder_path, file_name)
            # 解析CSV文件
            df_temp = pd.read_csv(file_path)  # 读取csv文件到dataframe中
            df_temp = df_temp.iloc[2:, :]  # 不要前两行
            data_all = pd.concat([data_all, df_temp], axis=0, ignore_index=True)  # 将文件内容合并到data_all中



if __name__ == '__main__':
    folder_path = "E:/replay/1对1/data/1/"
    file_path=folder_path + "default - 20230601-133944.csv"
    # process(file_path,"default - 20230601-133944.csv")
    processFiles()
    # df = pd.read_csv(file_path)
    # df = df[['number', 'longitude', 'latitude', 'altitude', 'yaw', 'pitch', 'roll',
    #                            'tarRng', 'tarAzi', 'tarEli','tar_x','tar_y','tar_z','position_change','v',
    #                         'v_change','r','eli_change','h_change']]
    # df.to_csv(file_path, index=False)
    # process(file_path1,file_name1)
    # cal_features(file_path, file_name)
    # processFiles()
    # cal_features_for_files()
    # change_colum_for_files()

    # 显示图形
    # plt.show()
