import os
import xml.etree.ElementTree as ET
import pandas as pd

folder_path = "C:/xxx/Desktop/2022"  # 替换为你的文件夹路径

# 获取文件夹中的所有文件
file_list = os.listdir(folder_path)

# 创建一个空的DataFrame来存储所有XML文件的数据
all_data = pd.DataFrame()

# 循环处理每个文件
for file_name in file_list:
    if file_name.endswith(".xml"):
        file_path = os.path.join(folder_path, file_name)

        # 解析XML文件
        tree = ET.parse(file_path)
        root = tree.getroot()

        # 提取XML数据并转换为DataFrame
        xml_data = {}
        for element in root.iter():
            xml_data[element.tag] = element.text

        df = pd.DataFrame(xml_data, index=[0])

        # 将DataFrame添加到总的数据集中
        all_data = pd.concat([all_data, df], ignore_index=True)

# 将数据保存为Excel文件
excel_file_path = "C:/xxx/Desktop/2022/file.xlsx"  # 替换为你的输出文件路径，如：/path/to/output/file.xlsx
all_data.to_excel(excel_file_path, index=False)

print("转换完成！Excel文件已保存。")