import xml.etree.ElementTree as ET
import os
import pandas as pd
from tqdm import tqdm
import concurrent.futures




#我们创建了一个空的DataFrame，包含四个列：id、title、author和price。
# df = pd.DataFrame(columns=['id','number', 'longitude', 'latitude','altitude', 'yaw', 'pitch', 'roll',
#                                                     'tarRng', 'tarAzi', 'tarEli'])
count=1


def processFile(file_path,filename):
    filename=filename.split(".")[0]
    df = pd.DataFrame(columns=['number', 'longitude', 'latitude', 'altitude', 'yaw', 'pitch', 'roll',
                               'tarRng', 'tarAzi', 'tarEli'])
    tree = ET.parse(file_path)
    replay = tree.getroot()
    objectsSequences = replay.find('objectsSequences')
    for sequence in objectsSequences:
        group = sequence.find('group').text
        if group == '0':
            frames = sequence.find('frames')
            for frame in frames:
                number = frame.find('number').text
                item = frame.find('data')
                if item.get('Type') == '1':
                    longitude = item.find('longitude').text
                    if longitude=="0.000000":
                        continue
                    latitude = item.find('latitude').text
                    altitude = item.find('altitude').text
                    yaw = item.find('yaw').text
                    pitch = item.find('pitch').text
                    roll = item.find('roll').text

                    devices = item.find('devices')
                    tarRng = ''
                    tarAzi = ''
                    tarEli = ''
                    if devices != None:
                        for device in devices:
                            if device.get('Type') == "F1911::Radar":
                                tracks = device.find("tracks")
                                if tracks != None:
                                    track = tracks.find("track")
                                    if track != None:
                                        tarRng = track.find('tarRng').text
                                        tarAzi = track.find('tarAzi').text
                                        tarEli = track.find('tarEli').text
                    if(tarRng==''):
                        continue
                    df = df.append(
                        pd.Series([number, longitude, latitude, altitude, yaw, pitch, roll, tarRng, tarAzi, tarEli],
                                  index=['number', 'longitude', 'latitude', 'altitude', 'yaw', 'pitch', 'roll',
                                         'tarRng', 'tarAzi', 'tarEli']), ignore_index=True)
    df.to_excel('E:/replay/1对1/original_data/1/'+filename+'.xlsx', index=False)
    return filename+'finish'

if __name__ == '__main__':
    folder_path = "E:/replay/replay/20230602_1对1/1"  # 替换为你的文件夹路径
    filename='default - 20230601-133944.replay'
    file_path='E:/replay/replay/20230602_1对1/1/default - 20230601-133944.replay'
    processFile(file_path,filename)


    # file_list = os.listdir(folder_path)
    # results=[]
    # count=1
    # with concurrent.futures.ProcessPoolExecutor(max_workers=5) as executor:
    #     for file_name in tqdm(file_list, desc="Processing files"):
    #         if file_name.endswith(".replay"):
    #             file_path = os.path.join(folder_path, file_name)
    #             # 解析XML文件
    #             result=executor.submit(processFile,file_path, file_name)
    #             results.append(result)
    #     for future in concurrent.futures.as_completed(results):
    #         print(count)
    #         print(future.result())
    #         count+=1
    #
    #




