#归一化pso
import math
import time
from itertools import combinations

import Users
from pso import PSO
import tool
import p_tool
import GDOP
import NSGA2 as ns
import draw
import NSGA2_p_first as ns_p
#计算用户平均snr
def function_snr(users,uavs_pos,c_association,power):
    sum=0
    for user_index in range(len(c_association)):
        snr=tool.cal_snr(uavs_pos[c_association[user_index]],users[user_index],power[c_association[user_index]][user_index])
        sum+=snr
    return (sum/len(users))

#计算用户平均gdop
def function_gdop(users,uavs_pos,c_association,p_association):
    # p_association=tool.get_p_association(users,uavs_pos,c_association,len(users)*2)
    sum=0
    for user_index in p_association:
        uavs=[]
        uavs.append(uavs_pos[c_association[user_index]])
        for uav_index in p_association[user_index]:
            uavs.append(uavs_pos[uav_index])
        gdop=GDOP.calculate_gdop(uavs,users[user_index])
        sum+=gdop
    return -sum/len(users)

def fitness(users,uavs_pos):
    c_association = tool.get_c_association(users, uavs_pos, math.ceil(len(users) / len(uavs_pos)))
    p_association = tool.get_p_association(users, uavs_pos, c_association, len(users) * 2 / len(uavs_pos))
    p_solution=ns.init_p(uavs_pos,users)
    snr=function_snr(users, uavs_pos, c_association, p_solution)
    gdop=function_gdop(users, uavs_pos, c_association, p_association, )
    return snr,gdop,snr+gdop

def fitness_p(users,uavs_pos):
    uavs_initial = [i for i in range(len(uavs_pos))]
    combination = list(combinations(uavs_initial, 3))
    c_association, p_association = p_tool.get_p_association_first(users, uavs_pos,
                                                                  math.ceil(len(users) / len(combination)),
                                                                  math.ceil(len(users) / len(uavs_pos)))
    p_solution = ns_p.init_p(uavs_pos, users)
    snr = function_snr(users, uavs_pos, c_association, p_solution)
    gdop = function_gdop(users, uavs_pos, c_association, p_association, )
    return snr, gdop, snr + gdop

def run(users, k):
    pso=PSO(users,[],)
    X, V = pso.initParticle(k, users)
    # print(X)
    global_pos, global_best, result = pso.pso(X, V, k,fitness)
    print(global_pos, global_best)
    # pso迭代曲线
    # draw.drawResultAndIter(result)
    # plt.show()
    return global_pos, global_best, result

def run_p(users, k):
    pso = PSO(users, [], )
    X, V = pso.initParticle(k, users)
    # print(X)
    global_pos, global_best, result = pso.pso(X, V, k, fitness_p)
    print(global_pos, global_best)
    # pso迭代曲线
    # draw.drawResultAndIter(result)
    # plt.show()
    return global_pos, global_best, result

if __name__ == '__main__':
    start_time = time.time()
    users = Users.getUsers("./data.csv")
    # global_pos, global_best,result=run(users,3)
    # print(fitness(users,global_pos))

    global_pos, global_best, result = run(users, 3)
    print(global_pos)
    print(fitness_p(users, global_pos))
    end_time = time.time()
    run_time = end_time - start_time
    print("程序运行时间为：", run_time)


