import matplotlib.pyplot as plt  # 导入 Matplotlib 工具包
import networkx as nx  # 导入 NetworkX 工具包



def example():
    # 问题 2：无向图的最短路问题（司守奎，数学建模算法与应用，P43，例4.3）
    G2 = nx.Graph()  # 创建无向图
    G2.add_weighted_edges_from([(1, 2, 2), (1, 3, 8), (1, 4, 1),
                                (2, 3, 6), (2, 5, 1),
                                (3, 4, 7), (3, 5, 5), (3, 6, 1), (3, 7, 2),
                                (4, 7, 9),
                                (5, 6, 3), (5, 8, 2), (5, 9, 9),
                                (6, 7, 4), (6, 9, 6),
                                (7, 9, 3), (7, 10, 1),
                                (8, 9, 7), (8, 11, 9),
                                (9, 10, 1), (9, 11, 2),
                                (10, 11, 4)])  # 向图中添加多条赋权边: (node1,node2,weight)

    # 两个指定顶点之间的最短加权路径
    minWPath_v1_v5 = nx.dijkstra_path(G2, source=1, target=5)  # 顶点 0 到 顶点 3 的最短加权路径
    print("顶点 v1 到 顶点 v5 的最短加权路径: ", minWPath_v1_v5)
    # 两个指定顶点之间的最短加权路径的长度
    lMinWPath_v1_v5 = nx.dijkstra_path_length(G2, source=1, target=5)  # 最短加权路径长度
    print("顶点 v1 到 顶点 v5 的最短加权路径长度: ", lMinWPath_v1_v5)
    # === 关注 Youcans 原创系列（https://blog.csdn.net/youcans）===
    pos = nx.spring_layout(G2)  # 用 FR算法排列节点
    nx.draw(G2, pos, with_labels=True, alpha=0.5)
    labels = nx.get_edge_attributes(G2, 'weight')
    nx.draw_networkx_edge_labels(G2, pos, edge_labels=labels)
    plt.show()

def example2():
    x = [1, 3, 4, 5, 7, 6]
    y = [4, 5, 2, 8, 5, 10]
    pos = {i + 1: [x[i], y[i]] for i in range(len(x))}
    G = nx.Graph()
    G.add_nodes_from(pos.keys())
    for n, p in pos.items():
        G._node[n]['pos'] = p
    G.add_edges_from([(1, 3), (1, 5), (2, 4), (3, 6), (4, 6)])
    nx.draw(G, pos=pos, with_labels=True, font_size=8, node_size=150)
    plt.show()

def example3():
    G = nx.Graph()
    # 添加对应的边和点
    for i in range(1, 10):
        G.add_node(i, desc=str(i))  # 结点名称不能为str,desc为标签即结点名称
    G.add_edge(1, 2, name='6')  # 添加边， 参数name为边权值
    G.add_edge(1, 3, name='4')
    G.add_edge(1, 4, name='5')
    G.add_edge(2, 5, name='1')
    G.add_edge(3, 5, name='1')
    G.add_edge(4, 6, name='2')
    G.add_edge(5, 7, name='9')
    G.add_edge(5, 8, name='7')
    G.add_edge(6, 8, name='4')
    G.add_edge(7, 9, name='2')
    G.add_edge(8, 9, name='4')

    pos = [(1, 3), (1, 3), (2, 4), (2, 2), (2, 1), (3, 3), (4, 1), (5, 4), (5, 2),
           (6, 3)]  # pos列表从第0位开始，但我定义是从结点1开始，这里令前两个坐标相同
    # 按pos所定位置画出节点,无标签无权值
    nx.draw_networkx(G, pos, with_labels=None)
    # 画出标签
    node_labels = nx.get_node_attributes(G, 'desc')
    nx.draw_networkx_labels(G, pos, labels=node_labels)
    # 画出边权值
    edge_labels = nx.get_edge_attributes(G, 'name')
    nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels)

    plt.show()

def draw_topology_before(users,graph,g):
    plt.figure()
    pos = {i + 1: [users[i][0], users[i][1]] for i in range(len(users))}
    pos[0]=g

    G = nx.Graph()
    # 添加对应的边和点
    for i in range(0, len(users)+1):
        G.add_node(i, desc=str(i))  # 结点名称不能为str,desc为标签即结点名称

    for edge in graph:
        G.add_edge(edge[0], edge[1], name=edge[2])  # 添加边， 参数name为边权值

    # 按pos所定位置画出节点,无标签无权值
    nx.draw_networkx(G, pos, with_labels=None)
    # 画出标签
    node_labels = nx.get_node_attributes(G, 'desc')
    nx.draw_networkx_labels(G, pos, labels=node_labels)
    # 画出边权值
    edge_labels = nx.get_edge_attributes(G, 'name')
    nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels)




def draw_topology_after(uavs,users,graph,g):
    plt.figure()
    pos = {i + 1: [users[i][0], users[i][1]] for i in range(len(users))}
    pos[0]=g
    for i in range(len(uavs)):
        pos[i+100]=[uavs[i][0],uavs[i][1]]
    G = nx.Graph()
    # 添加对应的边和点
    for i in range(0, len(users)+1):
        G.add_node(i, desc=str(i))  # 结点名称不能为str,desc为标签即结点名称
    for i in range(100,100+len(uavs)):
        G.add_node(i, desc=str(i))  # 结点名称不能为str,desc为标签即结点名称
    for edge in graph:
        G.add_edge(edge[0], edge[1], name=edge[2])  # 添加边， 参数name为边权值

    # 按pos所定位置画出节点,无标签无权值
    nx.draw_networkx(G, pos, with_labels=None)
    # 画出标签
    node_labels = nx.get_node_attributes(G, 'desc')
    nx.draw_networkx_labels(G, pos, labels=node_labels)
    # 画出边权值
    edge_labels = nx.get_edge_attributes(G, 'name')
    nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels)

    # plt.title('AOE_CPM', fontsize=10)

def drawResultAndIter(resultAndIter):
    f, ax = plt.subplots(1, 1)
    plt.plot(resultAndIter)
    ax.set_xlabel('iteration')
    ax.set_ylabel('fitness')
    plt.show()


if __name__ == '__main__':
    f11=[78.55335494041263, 78.4925571817822, 78.12553455940584, 74.64405628626322, 74.81648579421885, 78.38827173203428,
     74.55140845209807, 74.25000849350343, 78.53516476576708, 78.62622103565846, 77.80989106559173, 78.49073674312767,
     74.56187387317372, 73.8567018719367, 78.33811448348496, 78.39409737006262, 78.45073133117388, 77.40271093532404,
     78.14754301619742, 78.29073591677286, 78.20984708408737, 77.58599589624374, 77.50354215075774, 74.49757141289503,
     77.7276672803666, 74.37167194076233, 74.04065468827585, 78.18592122242832, 78.63426482129661, 74.59491249776092]
    f21=[0.007917562416945053, 0.008151915801430798, 0.008694667137021531, 0.009298857060978374, 0.009168856063992566, 0.008393988454835794, 0.009356937434857335, 0.00944301517076346, 0.008052155456294353, 0.007891764380788865, 0.008955166010251241, 0.00823125303080821, 0.009324932673847845, 0.009564614590386999, 0.008460548514006244, 0.008326270775816673, 0.00829068236337162, 0.009167415032401014, 0.008674229967017484, 0.008570277672074586, 0.008634748200016893, 0.009081593338821761, 0.009103629944510878, 0.009379318906272775, 0.00897481373615487, 0.009419446727519166, 0.009517387594754897, 0.008666954147779366, 0.007889234462668473, 0.00931283329983273]

    f1=[76.09611889350377, 78.77730268287569, 77.27692095290696, 78.66804524192476, 78.05854827300608, 78.72977555318688,
     77.86763080696251, 78.47870754906403, 78.2432740754877, 79.0176228328904, 78.78766830591486, 77.79220146161504,
     78.0416057000793, 78.91770303778918, 78.10175093982203, 78.69063008870197, 77.8448065926295, 78.89257481607883,
     78.84616875980842, 78.54240776126834, 77.92089708265037, 78.27069703784417, 78.89814401504553, 77.26379035039697,
     78.4852605896078, 78.4483362995136, 78.62594386393594, 76.95302464521706, 78.07787701339166, 78.54801211464334]
    f2=[0.008957420243593904, 0.008201290740429946, 0.008927274457396635, 0.008288478456987991, 0.00876020337183325, 0.00821775769307678, 0.00884697549908514, 0.008564012376663105, 0.008693185801597466, 0.00735141379320691, 0.008121597040711687, 0.008870144914246, 0.008814175569114886, 0.007816144483473175, 0.008752339154269444, 0.008251089419735406, 0.008854797069740515, 0.00797346990413977, 0.00810949970682477, 0.008479282602830965, 0.0088147904312125, 0.008656288021137467, 0.007818774436980862, 0.008933195248335789, 0.008530920794556343, 0.008610826245068343, 0.008429900737165834, 0.008944929590962195, 0.008752409225371844, 0.008464885127027401]

    f11 = [78.13158237224876, 79.67913916248689, 79.40202899951338, 78.77272197444738, 79.59917444374956,
           80.09035223332909, 79.6681397124661, 78.34080376201238, 78.12819077368123, 79.85563519006915,
           80.52055147165817, 79.30631771622784, 79.8274288624724, 79.56041457679224, 80.21400194139083,
           79.73638571878287, 79.84995062609373, 78.26840266326194, 78.3831285983927, 79.52416434639552,
           79.33923792160981, 79.05746289378486, 79.11942123132677, 79.42490159278476, 79.89660802047895,
           78.79239337163062, 77.47565821766244, 79.29407602757921, 79.66940798370524, 79.77125064402064]
    f12 = [0.22231773601132473, 0.16350837224085044, 0.17312398799855006, 0.18963403819980326, 0.16713480177497708,
           0.14600814666994671, 0.16578890122242448, 0.19839836350150053, 0.22423854376689586, 0.1571067600159749,
           0.12792181499374417, 0.1747848367451167, 0.15790084421713313, 0.16762497001543297, 0.1444292252839702,
           0.16218682974741622, 0.15757268651940703, 0.2155643486159565, 0.19023432849851585, 0.16929884872510073,
           0.17450508391491218, 0.1832180145938337, 0.18271473993899678, 0.1707995960118773, 0.15515245415593762,
           0.1894473149044883, 0.23583166359095892, 0.1765863721724546, 0.16394723572377376, 0.16163081747436026]
    f21 = [78.31098477060134, 78.82560236305012, 78.57826894095565, 78.3108960440399, 78.5854728828511,
           77.30031160364588, 78.11383167173456, 78.25213341781318, 78.04134358140921, 78.77412389989188,
           77.9454224332219, 78.97431294265247, 79.09061910039671, 78.48348634443312, 78.21024906731701,
           78.4721077341294, 78.97911928203568, 77.55794714768187, 77.08805834582111, 78.53105259648503,
           77.71578342289433, 77.50550382969944, 78.43462896476744, 78.9513392331249, 79.11843761386997,
           78.9294332432202, 78.1978485303893, 78.7511370236766, 78.58663330340367, 77.7955757103145]
    f22 = [0.2911141433778622, 0.27823663193938153, 0.28568828153083287, 0.2913045174684795, 0.28494162087279007,
           0.30198200261447683, 0.2936150040593367, 0.2920916867844547, 0.2959621683803247, 0.2807112259494087,
           0.29615233759813037, 0.27271478371269403, 0.26918049567143515, 0.287245782388438, 0.29221192743690416,
           0.28865182933677797, 0.2711034108106382, 0.300264700268352, 0.30252685474214913, 0.286811199780341,
           0.2994874545333383, 0.300273046692719, 0.2887174952405154, 0.27418992817388244, 0.26076702354427583,
           0.2777877052773878, 0.2923068759498851, 0.2817938400732662, 0.2844466978672097, 0.2976794824343081]
    f31 = [80.40384249037861, ]
    f32 = [0.14848535240622637]
    labels = ["proposed NSGA2-communication first", "proposed NSGA2-localization first", "pso-weighting method",
              "pso-main objective method","pso-weighting method-localization first","pso-main objective method-localization-first"]

    f41 = [81.46866648101934, ]
    f42 = [0.1379323588640624]
    f51 = [81.20664927884438, ]
    f52 = [0.269883203999093]
    f61 = [81.21235572744315, ]
    f62 = [0.2577773453056189]
    plt.xlabel('average snr', fontsize=12)
    plt.ylabel('average 1/gdop', fontsize=12)
    plt.scatter(f11, f12, label=labels[0])
    plt.scatter(f21, f22, label=labels[1])
    plt.scatter(f31, f32, label=labels[2])
    plt.scatter(f41, f42, label=labels[3])
    plt.scatter(f51, f52, label=labels[4])
    plt.scatter(f61, f62, label=labels[5])
    plt.legend()

    plt.show()




