import random
import math

from matplotlib import pyplot as plt


def objective_function(x):
    # 定义优化的目标函数，此处以一个简单的二维函数为例
    return (x[0] - 2) ** 2 + (x[1] - 3) ** 2

def generate_neighbor(x):
    # 在当前解的邻域内随机生成新解
    return [x[0] + random.uniform(-0.1, 0.1), x[1] + random.uniform(-0.1, 0.1)]

def tabu_search(max_iter):
    current_solution = [0, 0]  # 初始解
    best_solution = current_solution  # 记录最优解
    best=[]
    tabu_list = []  # 禁忌表
    tabu_tenure = 10  # 禁忌期限，即禁忌解在禁忌表中停留的迭代次数

    for i in range(max_iter):
        neighbors = [generate_neighbor(current_solution) for _ in range(10)]  # 随机生成10个邻域解

        # 在邻域解中选择一个非禁忌的最优解
        candidate = min(neighbors, key=objective_function)
        while candidate in tabu_list:
            neighbors.remove(candidate)
            candidate = min(neighbors, key=objective_function)

        # 更新当前解和最优解
        current_solution = candidate
        if objective_function(candidate) < objective_function(best_solution):
            best_solution = candidate
        best.append(objective_function(best_solution))
        tabu_list.append(candidate)  # 将当前解加入禁忌表

        if len(tabu_list) > tabu_tenure:  # 维护禁忌表的长度不超过禁忌期限
            tabu_list.pop(0)

    return best_solution,best

def drawResultAndIter(r1,r2,r3):
    f, ax = plt.subplots(1, 1)
    plt.plot(r1)
    plt.plot(r2)
    plt.plot(r3)
    plt.axhline(y=60, color='r', linestyle='--', label='Horizontal Line at y=60')
    ax.set_xlabel('iteration')
    ax.set_ylabel('number of non-dominated solutions')
    plt.show()

if __name__ == "__main__":
    # num2=[2, 3, 9, 11, 7, 10, 14, 11, 12, 9, 14, 15, 16, 16, 15, 14, 15, 15, 15, 16, 19, 20, 20, 19, 23, 21, 21, 23, 26, 28,
    #  28, 28, 29, 31, 32, 35, 34, 34, 34, 36, 37, 37, 37, 38, 38, 39, 39, 39, 39, 40, 40, 44, 45, 45, 45, 45, 45, 41, 41,
    #  42, 41, 43, 44, 45, 44, 47, 46, 47, 48, 49, 50, 53, 53, 53, 52, 54, 55, 56, 57, 57, 58, 58, 59, 60]
    # num1=[1, 3, 4, 4, 4, 5, 5, 5, 6, 5, 5, 5, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8, 9, 9, 10, 10, 10, 12, 13, 16, 18, 19, 20, 15, 14,
    #  15, 14, 15, 15, 16, 17, 17, 17, 17, 17, 18, 17, 17, 19, 20, 21, 17, 18, 18, 19, 20, 22, 24, 25, 25, 26, 27, 28, 28,
    #  27, 26, 27, 29, 29, 31, 30, 31, 29, 31, 32, 32, 34, 34, 35, 35, 35, 36, 35, 35, 33, 29, 29, 29, 29, 29, 33, 36, 35,
    #  35, 35, 35, 38, 40, 41, 41, 43, 45, 43, 45, 45, 45, 43, 44, 44, 44, 45, 47, 47, 47, 43, 44, 46, 46, 49, 47, 48, 46,
    #  46, 47, 48, 49, 47, 47, 46, 48, 49, 50, 50, 51, 51, 50, 50, 48, 46, 48, 49, 50, 53, 52, 54, 54, 55, 56, 56, 57, 57,
    #  58, 59, 60]
    # num2=[8, 7, 5, 8, 9, 6, 9, 11, 15, 12, 17, 21, 22, 22, 21, 20, 21, 23, 21, 22, 22, 24, 24, 25, 27, 26, 28, 30, 33, 34,
    #  35, 37, 38, 39, 39, 41, 42, 42, 44, 46, 47, 48, 49, 51, 50, 51, 53, 56, 56, 58, 58, 58, 59, 60]
    #
    # num1=[4, 6, 5, 6, 7, 9, 9, 9, 11, 13, 9, 10, 9, 9, 9, 11, 10, 10, 12, 12, 13, 13, 13, 14, 14, 15, 16, 14, 14, 14, 13, 14,
    #  14, 16, 20, 21, 22, 24, 26, 27, 28, 22, 22, 24, 25, 25, 26, 29, 29, 31, 26, 27, 27, 26, 29, 28, 26, 27, 29, 27, 29,
    #  30, 32, 32, 34, 36, 37, 33, 35, 36, 39, 39, 39, 40, 41, 43, 43, 43, 45, 52, 52, 55, 52, 54, 55, 57, 57, 56, 57, 55,
    #  56, 57, 59, 60, 60, 60, 58, 57, 60, 57, 59, 60, 60, 60, 60, 60, 57, 59, 60, 58, 58, 58, 59, 60, 60, 60, 60, 60, 60,
    #  60, 60, 56, 56, 60, 60, 53, 55, 56, 56, 56, 55, 58, 58, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    #  60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    #  60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60]
    # num2=[6, 8, 11, 12, 12, 9, 10, 11, 18, 21, 20, 22, 25, 27, 28, 29, 31, 32, 33, 35, 34, 36, 36, 37, 37, 36, 36, 36, 38,
    #  39, 40, 40, 39, 44, 45, 46, 46, 48, 48, 50, 48, 48, 49, 51, 51, 51, 50, 51, 52, 52, 54, 55, 57, 57, 59, 60, 60, 60,
    #  60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 55, 56, 56, 57, 57, 58, 55, 57,
    #  60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 59, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    #  60, 60, 60, 60, 60, 60, 60, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    #  60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 58, 59, 60, 60, 60, 60,
    #  60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60]
    #
    # num1=[8, 9, 8, 10, 3, 4, 4, 5, 6, 7, 5, 6, 6, 7, 8, 6, 7, 7, 6, 6, 6, 6, 6, 7, 8, 7, 8, 10, 10, 10, 10, 11, 11, 13, 16,
    #  14, 14, 14, 13, 13, 15, 15, 16, 17, 17, 20, 20, 20, 21, 23, 20, 20, 21, 23, 23, 24, 22, 21, 23, 24, 27, 22, 23, 22,
    #  14, 15, 17, 19, 19, 21, 21, 18, 20, 19, 19, 19, 20, 21, 22, 21, 23, 23, 23, 24, 25, 27, 27, 28, 28, 30, 30, 31, 33,
    #  33, 35, 36, 36, 36, 37, 36]
    #
    # num2=[4, 3, 6, 5, 8, 12, 12, 16, 22, 19, 22, 22, 25, 28, 30, 30, 34, 35, 34, 35, 36, 37, 37, 36, 37, 39, 40, 41, 42, 43,
    #  45, 47, 43, 44, 44, 44, 45, 46, 47, 47, 47, 47, 50, 52, 51, 52, 54, 56, 58, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    #  59, 60, 60, 60, 58, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
    #  60, 60, 60, 60, 59, 60, 60, 60, 60, 60, 60, 60]
    #
    # num1=[6, 4, 5, 8, 9, 10, 10, 11, 12, 12, 11, 11, 11, 11, 9, 7, 8, 5, 6, 6, 6, 8, 9, 11, 11, 12, 12, 12, 12, 14, 16, 16,
    #  16, 17, 18, 14, 14, 14, 15, 16, 16, 17, 18, 13, 13, 14, 13, 13, 13, 13, 13, 13, 13, 14, 18, 19, 23, 24, 27, 27, 29,
    #  29, 30, 29, 30, 31, 33, 33, 33, 32, 33, 33, 40, 40, 40, 41, 43, 45, 46, 47, 40, 42, 42, 43, 46, 46, 47, 47, 48, 50,
    #  42, 40, 40, 39, 40, 40, 37, 37, 37, 37, 37, 38, 40, 38, 33, 34, 34, 36, 36, 36, 36, 36, 36, 36, 35, 38, 34, 34, 36,
    #  36, 37, 37, 38, 39, 37, 36, 36, 37, 38, 36, 38, 37, 38, 35, 35, 31, 31, 31, 31, 32, 32, 32, 33, 34, 34, 34, 36, 36,
    #  37, 38, 40, 42, 42, 43, 46, 47, 48, 48, 48, 48, 50, 48, 48, 47, 49, 50, 52, 52, 53, 54, 53, 55, 58, 59, 60]
    #
    # num2=[4, 7, 7, 10, 13, 15, 8, 7, 13, 8, 13, 14, 15, 16, 24, 23, 29, 38, 39, 40, 40, 40, 42, 43, 43, 45, 47, 46, 47, 49,
    #  50, 52, 51, 50, 49, 51, 50, 51, 56, 59, 60]
    #
    # num2=[4, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 8, 5, 7, 6, 7, 7, 7, 9, 9, 9, 6, 6, 7, 7, 7, 8, 10, 11, 11, 12, 14,
    #  15, 12, 12, 12, 12, 15, 15, 15, 17, 16, 17, 19, 20, 21, 21, 24, 22, 22, 25, 26, 26, 26, 27, 27, 27, 27, 28, 29, 30,
    #  27, 29, 30, 35, 34, 38, 39, 40, 40, 41, 37, 40, 46, 50, 51, 50, 51, 52, 53, 57, 58, 57, 59, 60]
    #
    num1=[2, 2, 2, 3, 4, 4, 6, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4, 5, 6, 6, 6, 6, 6, 7, 8, 9, 9, 11, 11, 11, 12, 13, 13, 13, 13,
     13, 15, 17, 17, 16, 13, 13, 13, 12, 13, 15, 16, 17, 18, 20, 21, 21, 22, 23, 22, 22, 22, 24, 25, 25, 26, 28, 29, 31,
     34, 35, 36, 36, 38, 41, 42, 43, 44, 45, 45, 45, 48, 52, 54, 55, 51, 50, 51, 52, 50, 51, 52, 56, 59, 59, 60]

    num2=[3, 8, 7, 7, 12, 8, 8, 12, 10, 12, 16, 15, 24, 24, 26, 25, 32, 34, 37, 35, 38, 39, 40, 43, 41, 43, 44, 47, 50, 55,
     55, 55, 55, 53, 49, 49, 49, 48, 50, 52, 53, 55, 56, 56, 56, 54, 56, 59, 60]
    num2=[3, 5, 4, 6, 6, 11, 13, 8, 9, 9, 9, 10, 9, 10, 10, 9, 8, 3, 6, 6, 7, 9, 10, 11, 12, 13, 13, 14, 15, 19, 21, 16, 17, 23, 24, 23, 23, 24, 25, 27, 28, 27, 27, 29, 24, 24, 26, 29, 29, 32, 40, 45, 40, 38, 42, 45, 47, 53, 50, 49, 50, 52, 49, 50, 48, 51, 52, 50, 51, 55, 56, 57, 56, 59, 58, 57, 58, 59, 60]
    num1=[3, 4, 7, 5, 8, 10, 6, 7, 6, 7, 6, 3, 3, 3, 3, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 7, 7, 9, 10, 11, 12, 12, 13, 12, 13,
     13, 9, 9, 9, 10, 10, 10, 11, 13, 10, 10, 10, 11, 11, 11, 11, 14, 15, 16, 17, 17, 16, 16, 17, 17, 15, 14, 18, 18,
     18, 17, 17, 18, 18, 19, 21, 21, 22, 22, 23, 24, 26, 26, 26, 22, 22, 22, 25, 26, 27, 28, 28, 29, 30, 30, 31, 32, 32,
     31, 32, 31, 31, 32, 34, 31, 32, 34, 34, 36, 36, 37, 38, 34, 36, 38, 37, 39, 41, 43, 42, 44, 44, 44, 46, 46, 46, 48,
     49, 49, 51, 53, 50, 50, 51, 51, 49, 53, 56, 57, 58, 55, 58, 60]
    num3=[4, 4, 3, 5, 8, 8, 8, 9, 12, 7, 8, 9, 9, 9, 10, 10, 12, 12, 13, 14, 14, 14, 16, 17, 12, 13, 14, 12, 13, 11, 12, 13,
     16, 16, 16, 16, 16, 22, 23, 23, 26, 24, 26, 26, 28, 30, 30, 34, 37, 38, 40, 41, 42, 42, 35, 35, 38, 41, 40, 42, 43,
     43, 44, 41, 38, 39, 41, 43, 47, 45, 46, 48, 48, 49, 50, 51, 52, 52, 56, 60]


    drawResultAndIter(num1,num2,num3)

    print((0.8)**(1/6)-1)
