import socket
import json
import random
import time


def send_array(host='127.0.0.1', port=12345):
    data = [-1.3105, 0.5705, -0.2628, 2.6665, 0.8016, -0.8752, -0.2601, 0.5445, 2.0032, 0.4143, -0.6441,-2.2407, -0.5950, 0.4144, 0.0528, 0.1691, -0.9757, 1.5469, 0.3840, 0.2890, 0.2386]
    print("待发送数组:", data)

    try:
        with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as s:
            s.connect((host, port))
            # 将数组序列化为JSON字符串并编码
            data = json.dumps(data).encode('utf-8')
            s.sendall(data)
            print(f"已成功发送至 {host}:{port}")

            # 设置接收超时（5秒）
            s.settimeout(10)
            s.shutdown(socket.SHUT_WR)
            # 接收响应
            response = b""
            while True:
                data = s.recv(1024)
                if not data:
                    break
                response += data

            print(f"收到响应: {response.decode('utf-8')}")

    except Exception as e:
            print(f"连接错误: {str(e)}")


if __name__ == '__main__':
    send_array()  # 使用默认地址和端口