import random
from numpy import random as r

class UserForUAV(object):

    def __init__(self, UserId, TotalContentNum, FalvorNum, K):
        self.UserId = UserId                     # 用户索引
        self.TotalContentNum = TotalContentNum   # 文件集合总数
        self.FalvorNum = FalvorNum               # 该用户倾向选择的文件数量

        self.PlaceX = 0                          # 用户水平位置x
        self.PlaceY = 0                          # 用户水平位置y

        self.K = K
        self.RequestIndex = 0

        self.UAVList = []

        if FalvorNum > TotalContentNum:
            self.FalvorNum = TotalContentNum

        self.FalvorList = random.sample(range(1, 9), FalvorNum)    # 该用户倾向选择的文件

    # 按照zipf分布，模拟用户请求
    def genRequestIndex(self):
        x = r.zipf(a=2, size=1)[0]
        x = x - 1
        if x >= len(self.FalvorList):
            self.RequestIndex = self.FalvorList[len(self.FalvorList)-1]
        else:
            self.RequestIndex = self.FalvorList[x]
        return self.RequestIndex

    def getRequestIndex(self):
        return self.RequestIndex

    # 移动用户位置
    def moveTo(self,x, y):
        self.PlaceX = x
        self.PlaceY = y

    def setUAVList(self, UAVList):
        self.UAVList = UAVList

    def tryGetservice(self):

        for i in range(0, len(self.UAVList)):
            self.UAVList[i].tryGetService(self.PlaceX, self.PlaceY, self.RequestIndex, self.UserId)

    def tryGetCache(self, transSpeedBaseLine, time):
        vehiclesAbleToTrans = 0
        self.genRequestIndex()
        for i in range(0, len(self.UAVList)):
            if self.UAVList[i].tryGetContent(self.PlaceX, self.PlaceY, time, self.UserId, transSpeedBaseLine,  self.RequestIndex):
                vehiclesAbleToTrans = vehiclesAbleToTrans + 1
        return vehiclesAbleToTrans, self.RequestIndex





