
import matplotlib.pyplot as plt
import numpy as np
import torch
from matplotlib.ticker import MultipleLocator
from torch import nn


class plot(object):
    def plotZheXian(self):
        plt.rcParams["figure.dpi"] = 200
        x_axis_data = [2, 3, 4, 5]  # x
        y_axis_data = [0.50, 0.70, 0.67, 0.59]  # y
        y_axis_data2 = [0.47, 0.63, 0.58, 0.42]  # y
        y_axis_data3 = [0.36, 0.52, 0.45, 0.28]  # y

        plt.plot(x_axis_data, y_axis_data, 'b*', linestyle='solid', alpha=1, linewidth=1, label='customer = 20')  # 'bo-'表示蓝色实线，数据点实心原点标注
        plt.plot(x_axis_data, y_axis_data2, 'rs', linestyle='solid',alpha=0.5, linewidth=1, label='customer = 25')
        plt.plot(x_axis_data, y_axis_data3, 'go', linestyle='solid',alpha=0.5, linewidth=1, label='customer = 30')
        ## plot中参数的含义分别是横轴值，纵轴值，线的形状（'s'方块,'o'实心圆点，'*'五角星   ...，颜色，透明度,线的宽度和标签 ，
        x_major_locator = MultipleLocator(1)
        plt.tick_params(labelsize=13)
        ax = plt.gca()
        ax.xaxis.set_major_locator(x_major_locator)

        plt.legend(loc='lower left',fontsize='15')  # 显示上面的label
        plt.xlabel('n', fontsize=17)  # x_label
        plt.ylabel('Content Hit Ratio',fontsize=17)  # y_label

        # plt.ylim(-1,1)#仅设置y轴坐标范围
        plt.show()

    def plotZheXian22(self):
        x_axis_data = [10, 15, 20, 25, 30,35]  # x
        y_axis_data = [0.78,0.74, 0.68, 0.62, 0.51,0.43]  # y
        y_axis_data2 = [0.77,0.70, 0.63, 0.47, 0.36,0.30]  # y


        plt.plot(x_axis_data, y_axis_data, 'b*--', alpha=1, linewidth=1, label='TMAPPO')  # 'bo-'表示蓝色实线，数据点实心原点标注
        plt.plot(x_axis_data, y_axis_data2, 'rs--', alpha=0.5, linewidth=1, label='GS')

        ## plot中参数的含义分别是横轴值，纵轴值，线的形状（'s'方块,'o'实心圆点，'*'五角星   ...，颜色，透明度,线的宽度和标签 ，
        x_major_locator = MultipleLocator(5)
        ax = plt.gca()
        ax.xaxis.set_major_locator(x_major_locator)

        plt.legend()  # 显示上面的label
        plt.xlabel('Users', fontsize=17)  # x_label
        plt.ylabel('Content Hit Ratio', fontsize=17)  # y_label

        # plt.ylim(-1,1)#仅设置y轴坐标范围
        plt.show()

    def plotZheXian22(self):
        x_axis_data = [5, 8, 10, 15, 20]  # x
        y_axis_data = [0.34, 0.52, 0.68, 0.62, 0.51, 0.43]  # y
        y_axis_data2 = [0.34, 0.54, 0.63, 0.47, 0.36, 0.30]  # y

        plt.plot(x_axis_data, y_axis_data, 'b*--', alpha=1, linewidth=1, label='TMAPPO')  # 'bo-'表示蓝色实线，数据点实心原点标注
        plt.plot(x_axis_data, y_axis_data2, 'rs--', alpha=0.5, linewidth=1, label='GS')

        ## plot中参数的含义分别是横轴值，纵轴值，线的形状（'s'方块,'o'实心圆点，'*'五角星   ...，颜色，透明度,线的宽度和标签 ，
        x_major_locator = MultipleLocator(5)
        ax = plt.gca()
        ax.xaxis.set_major_locator(x_major_locator)

        plt.legend()  # 显示上面的label
        plt.xlabel('Users', fontsize=17)  # x_label
        plt.ylabel('Content Hit Ratio', fontsize=17)  # y_label

        # plt.ylim(-1,1)#仅设置y轴坐标范围
        plt.show()

    def plot_col(self):
        plt.rcParams["figure.dpi"] = 200
        Random = [0, 0.1, 0.15, 0.2, 0.23, 0.42]
        Around = [0, 0.15, 0.25, 0.33, 0.36,0.52]
        Without = [0.01, 0.23, 0.53, 0.58,
                     0.68,0.74]
        Slice = [0.34, 0.52, 0.68, 0.71,
                     0.75, 0.76]

        print(Around)
        print(Without)
        print(Random)
        print(Slice)

        # 计算cost
        # plt.grid(True, which="major", linestyle="--", color="gray", linewidth=0.75)
        # plt.grid(True, which="minor", linestyle=":", color="lightgray", linewidth=0.75)
        labels = ['10', '15', '20', '25', '30', '40']
        x = np.arange(len(labels))
        ax = plt.gca()

        ax.set_xticks(x)
        ax.set_xticklabels(labels)

        width = 0.2
        plt.xlabel('UAVs Hover Time', fontsize=17)
        plt.ylabel('Content Hit Ratio', fontsize=17)
        plt.tick_params(labelsize=13)
        ax.bar(x - 1.5 * width, Random, width, label='Random', color='purple', alpha=0.8)
        ax.bar(x - 0.5 * width, Around, width, alpha=0.8, label='Around', color='blue')
        ax.bar(x + 0.5 * width, Without, width, alpha=1, label='Without Slice', color='#15b01A')
        ax.bar(x + 1.5 * width, Slice, width, label='Slice', color='#DC143C', alpha=1)

        # plt.plot(range(len(trainAcc)), trainAcc, label='Average Training Loss', linewidth=1, linestyle='--', marker='.')
        plt.legend(loc='upper left', fontsize=17)
        plt.legend()
        plt.savefig(f'D:\p/成本对比实验.jpg')
        plt.show()

    def plot_col22(self):
        plt.rcParams["figure.dpi"] = 200
        Random = [0.18, 0.14, 0.11, 0.09,0.035]
        Around = [0.19, 0.19, 0.14, 0.14,0.08]


        print(Around)
        print(Random)


        # 计算cost
        # plt.grid(True, which="major", linestyle="--", color="gray", linewidth=0.75)
        # plt.grid(True, which="minor", linestyle=":", color="lightgray", linewidth=0.75)
        labels = ['(5,3)', '(5,4)', '(7,5)', '(7,4)','(12,7)']
        x = np.arange(len(labels))
        ax = plt.gca()

        ax.set_xticks(x)
        ax.set_xticklabels(labels)

        width = 0.2
        plt.xlabel('Code', fontsize=17)
        plt.ylabel('Down', fontsize=17)
        plt.tick_params(labelsize=8)
        ax.bar(x - 1.5 * width, Random, width, label='Slice', color='slategrey', alpha=0.8)
        ax.bar(x - 0.5 * width, Around, width, alpha=1, label='Total', color='brown')

        # plt.plot(range(len(trainAcc)), trainAcc, label='Average Training Loss', linewidth=1, linestyle='--', marker='.')
        plt.legend(loc='upper left')
        plt.legend()
        plt.savefig(f'D:\p/成本对比实验.jpg')
        plt.show()

    def plot_coltrans(self):
        plt.rcParams["figure.dpi"] = 200
        Random = [0.33,0.42, 0.53, 0.59,0.62]
        Around = [0.33,0.43, 0.54, 0.61,0.65]

        print(Around)
        print(Random)

        # 计算cost
        # plt.grid(True, which="major", linestyle="--", color="gray", linewidth=0.75)
        # plt.grid(True, which="minor", linestyle=":", color="lightgray", linewidth=0.75)
        labels = ['(5,3)','(7,4)','(8,4)','(10,4)','(12,5)']
        x = np.arange(len(labels))
        ax = plt.gca()

        ax.set_xticks(x)
        ax.set_xticklabels(labels)

        width = 0.2
        plt.xlabel('Code', fontsize=17)
        plt.ylabel('Content Hit Ratio', fontsize=17)
        plt.tick_params(labelsize=8)
        ax.bar(x - 1.5 * width, Random, width, label='MAPPO', color='slategrey', alpha=0.8)
        ax.bar(x - 0.5 * width, Around, width, alpha=1, label='TMAPPO', color='brown')
        plt.tick_params(labelsize=13)
        # plt.plot(range(len(trainAcc)), trainAcc, label='Average Training Loss', linewidth=1, linestyle='--', marker='.')
        plt.legend(loc='upper left')
        plt.legend()
        plt.savefig(f'D:\p/成本对比实验.jpg')
        plt.show()

    def plot_col_cache(self):
        plt.rcParams["figure.dpi"] = 200
        plt.figure(figsize=(10, 10))


        coding = [0.68, 0.63, 0.61, 0.56, 0.53, 0.36]
        whole = [0.53, 0.52, 0.53, 0.47, 0.45, 0.31]

        # 计算cost
        # plt.grid(True, which="major", linestyle="--", color="gray", linewidth=0.75)
        # plt.grid(True, which="minor", linestyle=":", color="lightgray", linewidth=0.75)
        labels = ['TMAPPO','MASAC', 'MADDPG', 'LFU', 'LRU','FIFO']
        x = np.arange(len(labels))
        ax = plt.gca()


        ax.set_xticks(x)
        ax.set_xticklabels(labels)

        width = 0.2
        plt.xlabel('Caching Algorithm', fontsize=23)
        plt.ylabel('Content Hit Ratio', fontsize=23)
        plt.tick_params(labelsize=16)
        ax.bar(x - 0.5 * width, coding, width, alpha=1, label='Coded Caching', color='#DC143C')
        ax.bar(x + 0.5 * width, whole, width, alpha=1, label='Without Coded Caching', color='blue')


        # plt.plot(range(len(trainAcc)), trainAcc, label='Average Training Loss', linewidth=1, linestyle='--', marker='.')
        plt.legend(fontsize='18')

        plt.savefig(f'D:\p/成本对比实验.jpg')


        plt.show()

    def plot_col_size(self):
        plt.rcParams["figure.dpi"] = 200
        plt.figure(figsize=(10, 10))

        coding = [0.77, 0.72, 0.68, 0.62, 0.53]
        whole = [0.72, 0.64, 0.53, 0.42, 0.31]

        # 计算cost
        # plt.grid(True, which="major", linestyle="--", color="gray", linewidth=0.75)
        # plt.grid(True, which="minor", linestyle=":", color="lightgray", linewidth=0.75)
        labels = ['128', '192', '256', '320', '384']
        x = np.arange(len(labels))
        ax = plt.gca()

        ax.set_xticks(x)
        ax.set_xticklabels(labels)

        width = 0.2
        plt.xlabel('Content Size', fontsize=23)
        plt.ylabel('Content Hit Ratio', fontsize=23)
        plt.tick_params(labelsize=16)
        ax.bar(x - 0.5 * width, coding, width, alpha=0.8, label='Coded Caching', color='#DC143C')
        ax.bar(x + 0.5 * width, whole, width, alpha=0.8, label='Without Coded Caching', color='blue')

        # plt.plot(range(len(trainAcc)), trainAcc, label='Average Training Loss', linewidth=1, linestyle='--', marker='.')

        plt.legend(fontsize='18')
        plt.savefig(f'D:\p/成本对比实验.jpg')

        plt.show()

    def plotDemo(self):
        plt.figure(figsize=(8, 6))
        plt.rcParams["figure.dpi"] = 200
        x_axis_data = [ ]  # x
        y1 = []
        y2= []
        y4 = [895, 1181, 1120, 1109, 1222, 1167, 1099, 1090, 1136, 1066, 1059, 1140, 1088, 1189, 1146, 1219, 1223, 1189, 1106, 1240, 1267, 1150, 1190, 1215, 1214, 1117, 1256, 1251, 1224, 1244, 1264, 1256, 1205, 1175, 1192, 1176, 1252, 1222, 1249, 1258, 1216, 1214, 1273, 1204, 1331, 1299, 1321, 1310, 1241, 1292, 1292, 1261, 1285, 1195, 1253, 1308, 1253, 1268, 1390, 1248, 1411, 1315, 1315, 1352, 1369, 1374, 1396, 1398, 1335, 1314, 1272, 1311, 1336, 1480, 1400, 1371, 1314, 1300, 1302, 1454, 1329, 1520, 1385, 1387, 1318, 1303, 1500, 1468, 1503, 1489, 1340, 1497, 1457, 1592, 1449, 1318, 1519, 1532, 1565, 1449, 1476, 1474, 1579, 1415, 1485, 1410, 1524, 1569, 1447, 1528, 1562, 1543, 1562, 1568, 1613, 1612, 1579, 1587, 1663, 1575, 1577, 1550, 1522, 1588, 1554, 1524, 1547, 1728, 1565, 1541, 1612, 1474, 1677, 1713, 1710, 1757, 1713, 1581, 1671, 1662, 1662, 1768, 1627, 1732, 1706, 1719, 1772, 1598, 1645, 1660, 1574, 1789, 1700, 1728, 1717, 1695, 1803, 1740, 1738, 1708, 1826, 1769, 1717, 1813, 1780, 1749, 1805, 1815, 1897, 1779, 1781, 1722, 1819, 1775, 1961, 1826, 1899, 1858, 1876, 1863, 1818, 1822, 1865, 1846, 1894, 1954, 1794, 1843, 1898, 1825, 1858, 1868, 1843, 1934, 1941, 1932, 2049, 1959, 2017, 1962, 1980, 1956, 1893, 1991, 1924, 1907, 1916, 1927, 1929, 1972, 1983, 1988, 2018, 1922, 1940, 1995, 1995, 2019, 2023, 2035, 2029, 2017, 2013, 2016, 2006, 2082, 2019, 2116, 2018, 2153, 1977, 2001, 2135, 2128, 2185, 2178, 2095, 2133, 2033, 2102, 2174, 2206, 2055, 2069, 2138, 2111, 2104, 2068, 2072, 2159, 2206, 2124, 2262, 2205, 2099, 2037, 2089, 2038, 2155, 2182, 2197, 2199, 2225, 2216, 2151, 2121, 2208, 2185, 2120, 2172, 2089, 2219, 2165, 2184, 2164, 2209, 2216, 2169, 2253, 2095, 2224, 2238, 2109, 2085, 2171, 2132, 2238, 2218, 2210, 2270, 2211, 2202, 2258, 2288, 2138, 2243, 2148, 2209, 2176, 2220, 2180, 2198, 2151, 2203, 2275, 2262, 2265, 2248, 2238, 2175, 2255, 2361, 2220, 2234, 2107, 2150, 2140, 2269, 2164, 2219, 2242, 2335, 2508, 2313, 2303, 2130, 2441, 2310, 2313, 2396, 2324, 2330, 2400, 2400, 2360, 2439, 2205, 2409, 2444, 2357, 2307, 2338, 2387, 2348, 2235, 2400, 2485, 2355, 2579, 2151, 2239, 2525, 2429, 2249, 2155, 2338, 2450, 2205, 2500, 2300, 2360, 2296, 2548, 2514, 2333, 2307, 2279, 2397, 2331, 2393, 2324, 2577, 2506, 2214, 2435, 2175, 2394, 2261, 2376, 2320, 2299, 2371, 2242, 2284, 2260, 2436, 2524, 2499, 2567, 2307, 2224, 2560, 2433, 2252, 2348, 2351, 2375, 2505, 2306, 2534, 2563, 2406, 2463, 2412, 2314, 2523, 2387, 2377, 2331, 2498, 2557, 2476, 2384, 2318, 2449, 2405, 2481, 2532, 2482, 2346, 2428, 2461, 2306, 2377, 2331, 2290, 2317, 2291, 2410, 2387, 2313, 2397, 2370, 2409, 2318, 2329, 2263, 2359, 2354, 2357, 2260, 2445, 2344, 2426, 2277, 2340, 2490, 2373, 2395, 2475, 2366, 2366, 2404, 2383, 2308, 2414, 2406, 2422, 2396, 2324, 2404, 2424, 2333, 2439, 2307, 2392, 2375, 2342, 2391, 2259, 2332, 2344, 2408, 2415, 2327, 2331, 2442, 2427, 2418, 2405, 2343, 2431, 2451, 2354, 2428, 2279, 2363, 2426, 2288, 2392, 2338, 2318, 2396, 2333, 2392, 2298, 2389, 2428, 2434, 2481, 2328, 2341, 2406, 2336, 2391, 2369, 2362, 2335, 2331, 2353, 2424, 2364, 2302, 2322, 2357, 2380, 2364, 2344, 2306, 2296, 2326, 2374, 2313, 2287, 2306, 2304, 2371, 2337, 2353, 2322, 2412, 2299, 2356, 2294, 2411, 2386, 2377, 2250, 2396, 2348, 2281, 2286, 2271, 2297, 2307, 2345, 2378, 2333, 2390, 2279, 2399, 2320, 2375, 2280, 2313, 2340, 2296, 2366, 2356, 2369, 2389, 2401, 2319, 2345, 2380, 2330, 2383, 2345, 2320, 2416, 2399, 2373, 2351, 2336, 2414, 2341, 2393, 2366, 2390, 2390, 2334, 2345, 2408, 2335, 2311, 2376, 2405, 2365, 2390, 2384, 2374, 2408, 2417, 2426, 2385, 2432, 2400, 2381, 2401, 2345, 2425, 2356, 2357, 2353, 2354, 2399, 2365, 2410, 2366, 2361, 2344, 2376, 2384, 2413, 2381, 2419, 2374, 2413, 2357, 2356, 2346, 2346, 2377, 2351, 2421, 2335, 2378, 2452, 2384, 2370, 2455, 2406, 2429, 2340, 2363, 2416, 2349, 2407, 2330, 2423, 2357, 2342, 2383, 2348, 2437, 2447, 2378, 2337, 2397, 2344, 2417, 2372, 2338, 2410, 2432, 2376, 2404, 2347, 2420, 2356, 2373, 2408, 2421, 2367, 2440, 2409, 2454, 2366, 2344, 2426, 2343, 2376, 2359, 2368, 2389, 2370, 2355, 2400, 2370, 2448, 2419, 2387, 2397, 2425, 2431, 2394, 2351, 2412, 2425, 2389, 2367, 2427, 2357, 2422, 2411, 2440, 2411, 2418, 2431, 2406, 2446, 2405, 2341, 2370, 2401, 2395, 2423, 2413, 2376, 2419, 2343, 2337, 2439, 2430, 2372, 2352, 2404, 2451, 2383, 2347, 2407, 2371, 2381, 2368, 2408, 2427, 2370, 2418, 2375, 2389, 2380, 2403, 2351, 2414, 2422, 2408, 2439, 2399, 2348, 2434, 2374, 2432, 2397, 2431, 2359, 2363, 2374, 2425, 2430, 2374, 2382, 2403, 2377, 2406, 2376, 2355, 2383, 2386, 2433, 2427, 2372, 2376, 2406, 2449, 2473, 2359, 2407, 2418, 2440, 2376, 2399, 2450, 2438, 2405, 2358, 2423, 2434, 2448, 2322, 2406, 2419, 2462, 2408, 2393, 2418, 2362, 2368, 2395, 2418, 2370, 2444, 2438, 2421, 2369, 2380, 2406, 2398, 2366, 2372, 2404, 2368, 2377, 2389, 2393, 2385, 2449, 2390, 2452, 2401, 2394, 2384, 2417, 2410, 2448, 2421, 2469, 2414, 2447, 2383, 2396, 2369, 2396, 2422, 2377, 2467, 2359, 2426, 2497, 2416, 2413, 2484, 2452, 2456, 2381, 2398, 2447, 2371, 2431, 2372, 2458, 2392, 2370, 2424, 2377, 2477, 2487, 2417, 2377, 2436, 2383, 2447, 2415, 2375, 2433, 2458, 2408, 2426, 2397, 2441, 2399, 2397, 2431, 2446, 2414, 2486, 2457, 2494, 2393, 2374, 2471, 2369, 2397, 2403, 2409, 2435, 2402, 2376, 2443, 2416, 2495, 2469, 2423, 2429, 2447, 2454, 2420, 2374, 2451, 2468, 2417, 2409, 2469, 2393, 2455, 2453, 2476, 2444, 2462, 2463, 2442, 2480, 2425, 2367, 2403, 2426, 2440, 2470, 2436, 2412, 2444, 2386, 2378, 2465, 2476, 2419, 2388, 2427, 2485, 2415, 2375, 2449, 2412, 2427, 2390, 2430, 2450, 2398, 2464, 2412, 2409, 2426, 2423, 2401, 2443, 2457, 2438, 2470, 2422, 2396, 2468, 2424, 2468, 2428, 2481, 2405, 2390, 2422, 2446, 2452, 2419, 2417, 2450, 2400, 2431, 2405, 2388, 2412, 2422, 2467, 2466, 2418, 2419, 2454, 2497, 2517, 2401, 2444, 2447, 2484, 2415, 2440, 2493, 2484, 2435, 2389, 2448, 2460, 2468, 2360, 2435, 2464, 2511, 2440, 2415, 2439, 2396, 2413, 2440, 2441, 2413, 2492, 2481, 2458, 2407, 2405, 2452, 2427, 2388, 2399, 2429]

        y5 = [776, 1050, 946, 995, 1094, 1033, 950, 923, 959, 893, 900, 1021, 918, 1047, 1028, 1086, 1089, 1021, 956, 1102, 1119, 998, 1055, 1068, 1048, 993, 1073, 1148, 1084, 1123, 1099, 1118, 1018, 1056, 1029, 1044, 1087, 1083, 1137, 1107, 1079, 1037, 1096, 1050, 1153, 1172, 1157, 1179, 1092, 1158, 1167, 1118, 1165, 1088, 1141, 1165, 1098, 1111, 1221, 1136, 1276, 1191, 1153, 1210, 1230, 1220, 1232, 1227, 1160, 1138, 1120, 1149, 1217, 1353, 1222, 1239, 1153, 1182, 1157, 1277, 1185, 1350, 1223, 1264, 1197, 1189, 1349, 1295, 1321, 1363, 1185, 1363, 1293, 1481, 1289, 1160, 1398, 1411, 1385, 1314, 1362, 1359, 1426, 1269, 1343, 1274, 1378, 1409, 1287, 1422, 1426, 1423, 1427, 1465, 1467, 1452, 1444, 1445, 1540, 1454, 1430, 1414, 1360, 1443, 1415, 1411, 1391, 1613, 1459, 1391, 1463, 1346, 1535, 1541, 1595, 1587, 1559, 1460, 1534, 1512, 1530, 1613, 1449, 1606, 1535, 1552, 1647, 1440, 1536, 1535, 1426, 1676, 1550, 1562, 1580, 1551, 1654, 1620, 1613, 1577, 1705, 1602, 1555, 1637, 1615, 1584, 1701, 1641, 1756, 1611, 1619, 1605, 1678, 1663, 1786, 1679, 1754, 1746, 1761, 1725, 1695, 1666, 1707, 1702, 1775, 1796, 1612, 1686, 1769, 1668, 1705, 1705, 1695, 1781, 1806, 1805, 1928, 1795, 1876, 1837, 1814, 1843, 1768, 1827, 1805, 1745, 1776, 1806, 1775, 1816, 1871, 1840, 1903, 1778, 1826, 1855, 1832, 1911, 1904, 1889, 1879, 1891, 1852, 1904, 1842, 1963, 1913, 1991, 1885, 1994, 1812, 1891, 2033, 1986, 2032, 2044, 1944, 1966, 1910, 1975, 2042, 2084, 1906, 1949, 2001, 1988, 1966, 1925, 1925, 1991, 2049, 1966, 2085, 2048, 1975, 1875, 1914, 1896, 2042, 2059, 2021, 2077, 2065, 2038, 2030, 1949, 2093, 2041, 2006, 2018, 1977, 2069, 2010, 2071, 2041, 2032, 2097, 1989, 2110, 1954, 2093, 2097, 1946, 1962, 2069, 1983, 2107, 2114, 2031, 2139, 2038, 2031, 2131, 2135, 1979, 2117, 1977, 2048, 2019, 2045, 2031, 2021, 2034, 2032, 2118, 2129, 2140, 2071, 2076, 2049, 2071, 2230, 2077, 2057, 1965, 2009, 2036, 2105, 2025, 2066, 2090, 2164, 2353, 2193, 2128, 1974, 2313, 2207, 2208, 2253, 2159, 2170, 2250, 2221, 2226, 2334, 2026, 2297, 2279, 2192, 2175, 2211, 2232, 2221, 2134, 2283, 2336, 2239, 2440, 2001, 2132, 2395, 2317, 2118, 1986, 2167, 2296, 2059, 2382, 2157, 2231, 2132, 2368, 2368, 2212, 2168, 2100, 2240, 2146, 2285, 2205, 2468, 2330, 2083, 2306, 2032, 2214, 2141, 2262, 2134, 2151, 2232, 2084, 2132, 2096, 2301, 2404, 2349, 2438, 2162, 2087, 2431, 2302, 2139, 2186, 2197, 2227, 2372, 2180, 2413, 2563, 2462, 2329, 2387, 2216, 2368, 2345, 2291, 2355, 2544, 2556, 2512, 2389, 2259, 2343, 2290, 2364, 2543, 2448, 2394, 2452, 2346, 2220, 2320, 2304, 2253, 2240, 2205, 2363, 2229, 2193, 2425, 2240, 2276, 2221, 2254, 2160, 2418, 2206, 2293, 2224, 2327, 2384, 2449, 2127, 2205, 2382, 2341, 2447, 2525, 2285, 2389, 2406, 2239, 2227, 2301, 2342, 2334, 2389, 2334, 2444, 2365, 2286, 2284, 2168, 2450, 2373, 2321, 2391, 2169, 2378, 2192, 2280, 2436, 2369, 2292, 2339, 2302, 2450, 2435, 2352, 2289, 2494, 2236, 2475, 2304, 2391, 2346, 2237, 2416, 2238, 2330, 2376, 2259, 2420, 2201, 2246, 2412, 2366, 2341, 2232, 2208, 2350, 2321, 2285, 2380, 2210, 2187, 2382, 2385, 2378, 2286, 2206, 2358, 2324, 2290, 2279, 2195, 2319, 2168, 2264, 2434, 2197, 2180, 2310, 2363, 2368, 2387, 2306, 2206, 2352, 2284, 2362, 2329, 2343, 2348, 2402, 2090, 2392, 2276, 2242, 2158, 2143, 2337, 2354, 2325, 2399, 2358, 2231, 2120, 2283, 2370, 2262, 2133, 2197, 2358, 2216, 2207, 2385, 2399, 2409, 2254, 2208, 2333, 2289, 2265, 2298, 2246, 2352, 2262, 2346, 2297, 2200, 2356, 2300, 2367, 2278, 2386, 2410, 2415, 2256, 2222, 2327, 2299, 2330, 2391, 2455, 2305, 2265, 2408, 2277, 2297, 2435, 2396, 2266, 2468, 2245, 2311, 2459, 2281, 2425, 2434, 2432, 2471, 2461, 2483, 2444, 2497, 2439, 2462, 2431, 2476, 2469, 2505, 2448, 2535, 2434, 2533, 2455, 2431, 2411, 2453, 2447, 2461, 2482, 2448, 2455, 2529, 2501, 2465, 2556, 2508, 2537, 2407, 2438, 2534, 2417, 2507, 2440, 2490, 2461, 2437, 2468, 2425, 2549, 2515, 2447, 2453, 2488, 2410, 2515, 2485, 2398, 2487, 2547, 2490, 2485, 2420, 2531, 2433, 2480, 2520, 2519, 2487, 2547, 2484, 2555, 2474, 2410, 2500, 2446, 2439, 2446, 2428, 2456, 2454, 2447, 2515, 2478, 2512, 2491, 2499, 2483, 2522, 2547, 2476, 2446, 2521, 2510, 2481, 2484, 2512, 2466, 2485, 2510, 2506, 2527, 2490, 2548, 2521, 2557, 2523, 2425, 2480, 2501, 2495, 2511, 2504, 2454, 2508, 2445, 2443, 2550, 2504, 2435, 2466, 2468, 2566, 2497, 2429, 2502, 2439, 2453, 2479, 2513, 2508, 2450, 2502, 2455, 2468, 2484, 2477, 2419, 2530, 2519, 2486, 2516, 2475, 2450, 2528, 2485, 2510, 2503, 2523, 2439, 2442, 2437, 2503, 2549, 2477, 2442, 2522, 2482, 2526, 2467, 2466, 2480, 2468, 2509, 2543, 2440, 2442, 2516, 2534, 2557, 2441, 2520, 2480, 2557, 2443, 2471, 2537, 2536, 2505, 2441, 2543, 2539, 2511, 2398, 2486, 2490, 2533, 2484, 2500, 2482, 2425, 2428, 2489, 2506, 2469, 2547, 2523, 2532, 2470, 2447, 2518, 2479, 2472, 2463, 2519, 2436, 2445, 2460, 2471, 2453, 2514, 2496, 2525, 2462, 2455, 2450, 2492, 2496, 2543, 2502, 2572, 2524, 2566, 2473, 2494, 2442, 2497, 2490, 2479, 2545, 2457, 2492, 2615, 2482, 2488, 2545, 2552, 2575, 2448, 2464, 2560, 2474, 2551, 2487, 2533, 2511, 2468, 2514, 2494, 2574, 2566, 2505, 2474, 2513, 2475, 2525, 2516, 2443, 2543, 2529, 2520, 2543, 2483, 2503, 2472, 2461, 2494, 2560, 2506, 2554, 2517, 2570, 2458, 2470, 2547, 2439, 2457, 2472, 2483, 2504, 2496, 2486, 2560, 2516, 2591, 2553, 2541, 2509, 2548, 2535, 2514, 2493, 2521, 2561, 2524, 2504, 2582, 2476, 2542, 2566, 2575, 2511, 2550, 2578, 2532, 2553, 2539, 2431, 2478, 2508, 2504, 2567, 2520, 2527, 2535, 2491, 2489, 2585, 2555, 2506, 2496, 2525, 2576, 2475, 2442, 2539, 2512, 2490, 2451, 2524, 2569, 2475, 2569, 2496, 2504, 2536, 2502, 2499, 2523, 2562, 2516, 2550, 2517, 2513, 2586, 2538, 2545, 2497, 2580, 2505, 2480, 2502, 2535, 2531, 2529, 2519, 2560, 2512, 2496, 2477, 2456, 2505, 2503, 2535, 2551, 2495, 2526, 2518, 2615, 2583, 2470, 2535, 2509, 2581, 2503, 2538, 2578, 2604, 2538, 2471, 2518, 2575, 2584, 2425, 2532, 2565, 2574, 2512, 2530, 2556, 2474, 2501, 2542, 2517, 2501, 2592, 2574, 2537, 2475, 2489, 2546, 2524, 2469, 2510, 2538]

        y_axis_data = [1040, 1328, 1255, 1270, 1409, 1320, 1300, 1304, 1323, 1258, 1287, 1260, 1320, 1333, 1259, 1324, 1364, 1328, 1261, 1331, 1409, 1305, 1366, 1396, 1333, 1341, 1363, 1379, 1324, 1396, 1426, 1373, 1329, 1294, 1354, 1335, 1380, 1385, 1401, 1371, 1390, 1386, 1379, 1409, 1470, 1414, 1444, 1459, 1411, 1444, 1420, 1438, 1453, 1417, 1458, 1441, 1442, 1423, 1499, 1438, 1530, 1507, 1482, 1507, 1494, 1540, 1489, 1544, 1516, 1498, 1497, 1512, 1524, 1578, 1582, 1503, 1542, 1535, 1520, 1576, 1541, 1646, 1530, 1582, 1572, 1555, 1570, 1624, 1670, 1609, 1553, 1670, 1624, 1665, 1570, 1558, 1623, 1597, 1680, 1653, 1607, 1674, 1709, 1552, 1657, 1607, 1724, 1669, 1634, 1683, 1663, 1708, 1698, 1658, 1783, 1714, 1707, 1748, 1759, 1762, 1746, 1760, 1730, 1786, 1730, 1724, 1755, 1794, 1784, 1803, 1756, 1697, 1807, 1866, 1876, 1861, 1817, 1820, 1812, 1868, 1779, 1870, 1836, 1872, 1837, 1810, 1873, 1804, 1845, 1843, 1803, 1874, 1882, 1867, 1861, 1858, 1928, 1932, 1942, 1891, 1958, 1945, 1859, 1938, 1907, 1905, 1935, 1929, 1986, 1936, 1968, 1921, 1962, 1939, 2061, 1963, 2002, 1991, 1982, 2041, 1954, 2040, 2003, 1997, 2007, 2036, 2002, 2054, 2075, 2056, 2033, 2092, 1992, 2117, 2076, 2091, 2139, 2118, 2106, 2069, 2121, 2136, 2077, 2128, 2111, 2115, 2055, 2144, 2146, 2105, 2151, 2135, 2205, 2145, 2141, 2129, 2202, 2160, 2198, 2194, 2219, 2171, 2137, 2183, 2180, 2212, 2157, 2252, 2191, 2303, 2197, 2225, 2242, 2260, 2292, 2246, 2218, 2300, 2214, 2239, 2268, 2320, 2240, 2306, 2273, 2280, 2241, 2235, 2246, 2319, 2316, 2300, 2343, 2311, 2282, 2258, 2284, 2297, 2316, 2333, 2362, 2322, 2342, 2369, 2329, 2329, 2332, 2296, 2308, 2295, 2307, 2366, 2353, 2336, 2342, 2355, 2299, 2311, 2341, 2333, 2372, 2322, 2319, 2344, 2319, 2302, 2337, 2306, 2355, 2360, 2380, 2358, 2381, 2364, 2385, 2370, 2337, 2354, 2317, 2394, 2377, 2379, 2348, 2373, 2427, 2412, 2374, 2389, 2361, 2385, 2372, 2443, 2387, 2412, 2373, 2354, 2381, 2378, 2425, 2418, 2393, 2440, 2415, 2447, 2409, 2428, 2457, 2416, 2443, 2441, 2435, 2434, 2460, 2465, 2421, 2406, 2410, 2456, 2458, 2430, 2438, 2456, 2444, 2459, 2488, 2465, 2436, 2446, 2454, 2453, 2445, 2428, 2431, 2452, 2447, 2472, 2459, 2471, 2453, 2455, 2476, 2498, 2466, 2487, 2492, 2476, 2456, 2481, 2476, 2435, 2489, 2459, 2493, 2485, 2504, 2458, 2510, 2486, 2486, 2495, 2484, 2496, 2492, 2494, 2487, 2504, 2483, 2493, 2511, 2489, 2500, 2514, 2493, 2478, 2511, 2490, 2515, 2506, 2528, 2528, 2515, 2507, 2507, 2492, 2520, 2480, 2489, 2526, 2500, 2534, 2531, 2519, 2536, 2536, 2466, 2483, 2523, 2538, 2524, 2522, 2497, 2522, 2514, 2501, 2511, 2519, 2505, 2529, 2526, 2498, 2490, 2522, 2498, 2519, 2510, 2519, 2518, 2512, 2523, 2508, 2496, 2517, 2552, 2536, 2530, 2500, 2544, 2540, 2542, 2549, 2514, 2545, 2522, 2534, 2490, 2547, 2511, 2543, 2536, 2508, 2540, 2538, 2525, 2551, 2528, 2544, 2491, 2530, 2547, 2502, 2519, 2535, 2552, 2546, 2542, 2529, 2523, 2531, 2527, 2543, 2523, 2532, 2530, 2541, 2529, 2520, 2537, 2551, 2528, 2529, 2554, 2495, 2549, 2546, 2560, 2534, 2548, 2538, 2558, 2561, 2546, 2556, 2554, 2531, 2534, 2558, 2559, 2517, 2567, 2512, 2572, 2519, 2550, 2530, 2549, 2555, 2527, 2550, 2536, 2517, 2536, 2547, 2525, 2503, 2486, 2536, 2555, 2552, 2511, 2537, 2546, 2520, 2531, 2523, 2545, 2524, 2527, 2481, 2561, 2501, 2507, 2486, 2491, 2469, 2546, 2561, 2539, 2533, 2525, 2523, 2526, 2523, 2529, 2479, 2516, 2536, 2526, 2558, 2518, 2549, 2555, 2545, 2540, 2565, 2538, 2568, 2526, 2560, 2533, 2561, 2556, 2561, 2566, 2518, 2553, 2575, 2555, 2564, 2555, 2560, 2534, 2565, 2554, 2568, 2539, 2562, 2566, 2540, 2563, 2584, 2561, 2563, 2566, 2566, 2560, 2572, 2563, 2562, 2570, 2562, 2574, 2562, 2563, 2563, 2575, 2562, 2559, 2576, 2555, 2571, 2560, 2541, 2577, 2568, 2561, 2562, 2578, 2577, 2565, 2568, 2571, 2570, 2575, 2561, 2577, 2562, 2569, 2579, 2575, 2570, 2585, 2574, 2579, 2574, 2579, 2583, 2584, 2590, 2571, 2572, 2577, 2575, 2577, 2556, 2587, 2587, 2572, 2570, 2579, 2583, 2589, 2573, 2581, 2574, 2585, 2583, 2590, 2583, 2591, 2593, 2583, 2583, 2577, 2577, 2587, 2587, 2586, 2586, 2572, 2588, 2578, 2545, 2580, 2593, 2576, 2591, 2575, 2578, 2587, 2587, 2589, 2575, 2594, 2578, 2588, 2586, 2582, 2577, 2588, 2575, 2576, 2582, 2584, 2568, 2588, 2587, 2579, 2587, 2600, 2586, 2591, 2576, 2582, 2587, 2578, 2579, 2596, 2578, 2588, 2585, 2579, 2551, 2599, 2600, 2574, 2586, 2580, 2585, 2584, 2573, 2580, 2591, 2596, 2583, 2584, 2595, 2582, 2586, 2586, 2587, 2590, 2585, 2586, 2583, 2586, 2601, 2593, 2587, 2586, 2599, 2595, 2591, 2597, 2590, 2590, 2608, 2590, 2592, 2599, 2589, 2593, 2592, 2584, 2606, 2584, 2581, 2597, 2576, 2587, 2588, 2597, 2587, 2583, 2591, 2600, 2593, 2602, 2598, 2595, 2589, 2599, 2593, 2597, 2599, 2572, 2589, 2587, 2595, 2569, 2592, 2595, 2600, 2608, 2602, 2599, 2588, 2599, 2607, 2608, 2599, 2598, 2597, 2599, 2604, 2592, 2585, 2611, 2598, 2609, 2595, 2606, 2603, 2596, 2594, 2594, 2609, 2599, 2601, 2613, 2613, 2598, 2608, 2596, 2616, 2594, 2616, 2621, 2587, 2607, 2606, 2602, 2622, 2618, 2615, 2608, 2593, 2602, 2598, 2597, 2608, 2602, 2593, 2603, 2608, 2598, 2616, 2616, 2617, 2630, 2630, 2646, 2636, 2613, 2651, 2610, 2609, 2614, 2621, 2618, 2654, 2620, 2604, 2635, 2628, 2598, 2609, 2668, 2615, 2635, 2640, 2640, 2651, 2611, 2660, 2596, 2639, 2636, 2634, 2646, 2667, 2640, 2641, 2636, 2664, 2645, 2640, 2644, 2663, 2643, 2654, 2658, 2661, 2670, 2632, 2672, 2673, 2692, 2675, 2661, 2666, 2693, 2677, 2678, 2693, 2672, 2673, 2692, 2666, 2683, 2684, 2695, 2684, 2686, 2698, 2695, 2692, 2708, 2680, 2678, 2685, 2687, 2704, 2725, 2691, 2695, 2718, 2701, 2732, 2719, 2704, 2721, 2708, 2720, 2714, 2715, 2731, 2734, 2711, 2715, 2716, 2731, 2705, 2736, 2718, 2734, 2736, 2724, 2748, 2739, 2748, 2729, 2735, 2737, 2730, 2758, 2744, 2723, 2740, 2742, 2749, 2742, 2723, 2714, 2741, 2743, 2741, 2760, 2743, 2754, 2737, 2739, 2755, 2751, 2742, 2759, 2753, 2737, 2754, 2760, 2758, 2733, 2751, 2762, 2753, 2763, 2757, 2768, 2766, 2760, 2753, 2765, 2753, 2759, 2764, 2761, 2760, 2772, 2768, 2751, 2764, 2754, 2767, 2778, 2761, 2770, 2781, 2769, 2763, 2769, 2753, 2775, 2775, 2770, 2773, 2773, 2772, 2776, 2773, 2780, 2768, 2770, 2775, 2762, 2781, 2761, 2772, 2770, 2770, 2780, 2776, 2773, 2762, 2768, 2775, 2784, 2775, 2772, 2773, 2776, 2779, 2779, 2780, 2776, 2780, 2779, 2779, 2779, 2778, 2780, 2780, 2774, 2776, 2784, 2777, 2781, 2780, 2779, 2785, 2780, 2779, 2781, 2784, 2782, 2779, 2783, 2782, 2783, 2780, 2780, 2782, 2794, 2781, 2770, 2787, 2786, 2785, 2781, 2791, 2788, 2779, 2746, 2757, 2787, 2779, 2779, 2783, 2779, 2791, 2777, 2790, 2789, 2779, 2794, 2777, 2792, 2789, 2790, 2781, 2786, 2795, 2783, 2790, 2784, 2783, 2791, 2789, 2768, 2785, 2776, 2792, 2791, 2790, 2786, 2786, 2789, 2793, 2791, 2787, 2787, 2786, 2789, 2785, 2792, 2790, 2795, 2787, 2796, 2791, 2790, 2790, 2785, 2781, 2785, 2775, 2790, 2779, 2786, 2793, 2792, 2776, 2786, 2792, 2784, 2795, 2790, 2787, 2787, 2791, 2793, 2794, 2788, 2795, 2784, 2796, 2798, 2786, 2791, 2798, 2792, 2791, 2790, 2791, 2792, 2789, 2791, 2797, 2790, 2795, 2790, 2787, 2784, 2793, 2779, 2789, 2790, 2795, 2791, 2794, 2790, 2793, 2795, 2791, 2794, 2792, 2796, 2794, 2792, 2789, 2784, 2793, 2793, 2792, 2795, 2798, 2774, 2794, 2795, 2797, 2785, 2794, 2797, 2796, 2795, 2799, 2791, 2798, 2793, 2799, 2794, 2793, 2793, 2792, 2790, 2793, 2794, 2796, 2791, 2793, 2796, 2793, 2795, 2792, 2798, 2796, 2797, 2795, 2792, 2790, 2794, 2796, 2793, 2797, 2791, 2794, 2796, 2793, 2790, 2785, 2796, 2796, 2794, 2797, 2795, 2799, 2788, 2790, 2793, 2796, 2796, 2795, 2795, 2796, 2797, 2798, 2796, 2791, 2794, 2794, 2796, 2794, 2796, 2799, 2798, 2795, 2795, 2797, 2796, 2792, 2797, 2795, 2795, 2797, 2799, 2798, 2796, 2799, 2797, 2797, 2796, 2799, 2796, 2796, 2793, 2792, 2794, 2794, 2797, 2794, 2799, 2796, 2796, 2800, 2796, 2794, 2794, 2800, 2796, 2796, 2799, 2799, 2794, 2791, 2793, 2798, 2792, 2769, 2795, 2791, 2800, 2795, 2796, 2798, 2790, 2798, 2797, 2795, 2794, 2797, 2796, 2800, 2798, 2798, 2798, 2797, 2792, 2798, 2797, 2796, 2798, 2800, 2799, 2798, 2796, 2799, 2796, 2798, 2799, 2798, 2797, 2799, 2794, 2800, 2793, 2800, 2799, 2799, 2799, 2799, 2797, 2798, 2798, 2797, 2799, 2797, 2796, 2799, 2795, 2798, 2784, 2798, 2797, 2797, 2797, 2792, 2796, 2799, 2797, 2797, 2789, 2797, 2793, 2797, 2772, 2796, 2796, 2797, 2797, 2796, 2796, 2798, 2794, 2791, 2800, 2793, 2785, 2798, 2799, 2790, 2793, 2797, 2797, 2793, 2800, 2798, 2797, 2796, 2798, 2795, 2795, 2793, 2795, 2795, 2797, 2799, 2797, 2795, 2796, 2799, 2800, 2793, 2795, 2788, 2798, 2800, 2799, 2798, 2790, 2776, 2790, 2797, 2797, 2795, 2796, 2795, 2795, 2797, 2783, 2789, 2800, 2797, 2797, 2796, 2795, 2787, 2797, 2797, 2800, 2774, 2797, 2796, 2799, 2797, 2800, 2799, 2787, 2793, 2799, 2800, 2791, 2796, 2799, 2799, 2797, 2800, 2799, 2799, 2796, 2798, 2799, 2799, 2799, 2797, 2799, 2800, 2770, 2797, 2800, 2799, 2797, 2799, 2800, 2798, 2798, 2789, 2800, 2800, 2798, 2799, 2793, 2799, 2798, 2797, 2797, 2797, 2797, 2798, 2800, 2785, 2796, 2796, 2797, 2800, 2799, 2799, 2799, 2796, 2800, 2798, 2798, 2789, 2797, 2800, 2779, 2798, 2796, 2800, 2799, 2797, 2800, 2794]  # y
        y_axis_data2 = [1127, 1292, 1282, 1353, 1307, 1278, 1217, 1274, 1320, 1279, 1286, 1277, 1316, 1260, 1299, 1327, 1240, 1349, 1330, 1348, 1292, 1380, 1367, 1370, 1317, 1351, 1461, 1361, 1366, 1365, 1431, 1467, 1417, 1437, 1414, 1498, 1498, 1501, 1469, 1532, 1507, 1591, 1562, 1528, 1572, 1650, 1621, 1615, 1640, 1649, 1692, 1709, 1753, 1722, 1748, 1784, 1729, 1799, 1805, 1809, 1875, 1822, 1959, 1921, 1820, 1824, 1880, 1974, 1975, 2025, 1982, 2013, 2017, 2059, 2118, 2130, 2086, 2054, 2041, 2102, 2178, 2181, 2186, 2225, 2213, 2205, 2303, 2259, 2282, 2321, 2322, 2347, 2308, 2288, 2359, 2349, 2359, 2357, 2369, 2340, 2329, 2406, 2374, 2377, 2403, 2382, 2407, 2469, 2453, 2453, 2478, 2439, 2475, 2492, 2514, 2538, 2507, 2566, 2536, 2522, 2537, 2555, 2541, 2477, 2642, 2548, 2613, 2600, 2617, 2601, 2642, 2595, 2613, 2607, 2612, 2613, 2621, 2601, 2616, 2621, 2650, 2575, 2565, 2570, 2539, 2562, 2553, 2591, 2525, 2512, 2511, 2590, 2509, 2533, 2624, 2418, 2543, 2461, 2627, 2544, 2539, 2543, 2570, 2580, 2493, 2590, 2502, 2544, 2525, 2505, 2517, 2567, 2533, 2456, 2557, 2519, 2566, 2615, 2516, 2568, 2536, 2550, 2583, 2491, 2599, 2575, 2547, 2436, 2514, 2610, 2563, 2531, 2515, 2572, 2429, 2563, 2586, 2496, 2489, 2530, 2492, 2363, 2401, 2462, 2398, 2419, 2477, 2339, 2323, 2358, 2499, 2506, 2408, 2563, 2461, 2513, 2270, 2265, 2339, 2239, 2527, 2417, 2511, 2409, 2288, 2396, 2480, 2376, 2439, 2591, 2563, 2300, 2520, 2577, 2477, 2469, 2320, 2271, 2413, 2560, 2620, 2597, 2573, 2367, 2465, 2457, 2347, 2494, 2376, 2613, 2561, 2507, 2455, 2428, 2489, 2463, 2639, 2574, 2560, 2492, 2586, 2591, 2434, 2618, 2636, 2506, 2606, 2491, 2661, 2503, 2618, 2454, 2481, 2412, 2543, 2629, 2493, 2562, 2576, 2616, 2536, 2506, 2573, 2548, 2576, 2543, 2505, 2461, 2537, 2636, 2569, 2652, 2577, 2520, 2345, 2478, 2618, 2599, 2535, 2571, 2512, 2584, 2642, 2626, 2526, 2621, 2449, 2620, 2583, 2495, 2635, 2629, 2648, 2612, 2681, 2681, 2605, 2473, 2533, 2537, 2601, 2522, 2580, 2592, 2584, 2675, 2588, 2569, 2540, 2659, 2545, 2608, 2534, 2646, 2620, 2608, 2663, 2595, 2641, 2608, 2594, 2623, 2621, 2588, 2525, 2516, 2624, 2515, 2663, 2586, 2670, 2610, 2626, 2601, 2652, 2663, 2639, 2585, 2585, 2621, 2658, 2659, 2662, 2614, 2660, 2606, 2655, 2654, 2621, 2630, 2709, 2631, 2627, 2610, 2652, 2698, 2685, 2704, 2673, 2576, 2579, 2686, 2694, 2662, 2656, 2606, 2687, 2693, 2703, 2623, 2698, 2698, 2714, 2753, 2745, 2685, 2678, 2674, 2718, 2675, 2723, 2637, 2719, 2735, 2571, 2685, 2689, 2621, 2722, 2728, 2662, 2690, 2721, 2694, 2754, 2720, 2756, 2705, 2755, 2748, 2709, 2661, 2718, 2765, 2697, 2730, 2734, 2737, 2737, 2719, 2723, 2755, 2754, 2708, 2677, 2754, 2669, 2757, 2738, 2752, 2732, 2714, 2667, 2717, 2675, 2701, 2698, 2782, 2729, 2745, 2717, 2692, 2745, 2699, 2689, 2692, 2697, 2710, 2658, 2673, 2711, 2699, 2751, 2742, 2698, 2707, 2726, 2633, 2655, 2742, 2706, 2715, 2773, 2746, 2730, 2756, 2779, 2781, 2778, 2772, 2784, 2786, 2770, 2759, 2783, 2789, 2794, 2792, 2787, 2788, 2795, 2795, 2788, 2796, 2792, 2783, 2786, 2793, 2781, 2795, 2690, 2750, 2727, 2733, 2737, 2724, 2735, 2740, 2717, 2706, 2754, 2723, 2768, 2771, 2762, 2699, 2720, 2745, 2723, 2723, 2754, 2797, 2778, 2749, 2758, 2796, 2704, 2760, 2785, 2749, 2779, 2747, 2797, 2781, 2742, 2796, 2747, 2771, 2796, 2775, 2738, 2704, 2745, 2799, 2775, 2706, 2798, 2738, 2717, 2792, 2760, 2745, 2794, 2781, 2791, 2744, 2736, 2772, 2798, 2703, 2737, 2799, 2751, 2773, 2728, 2734, 2699, 2733, 2732, 2754, 2767, 2762, 2799, 2726, 2695, 2730, 2726, 2749, 2716, 2723, 2737, 2733, 2748, 2742, 2744, 2791, 2730, 2790, 2747, 2704, 2771, 2722, 2700, 2722, 2751, 2798, 2796, 2740, 2763, 2732, 2747, 2796, 2770, 2795, 2781, 2756, 2703, 2718, 2758, 2773, 2734, 2798, 2740, 2792, 2791, 2717, 2789, 2738, 2796, 2780, 2798, 2795, 2703, 2732, 2762, 2769, 2760, 2766, 2782, 2704, 2796, 2798, 2800, 2775, 2741, 2799, 2797, 2795, 2799, 2794, 2792, 2746, 2752, 2799, 2800, 2749, 2769, 2800, 2798, 2773, 2799, 2800, 2800, 2798, 2758, 2797, 2799, 2800, 2800, 2799, 2800, 2800, 2799, 2799, 2800, 2799, 2737, 2799, 2800, 2798, 2767, 2754, 2773, 2798, 2800, 2800, 2748, 2799, 2800, 2750, 2724, 2709, 2722, 2724, 2739, 2730, 2727, 2760, 2753, 2771, 2736, 2745, 2721, 2800, 2800, 2797, 2763, 2799, 2790, 2784, 2767, 2729, 2760, 2796, 2785, 2795, 2737, 2790, 2737, 2770, 2806, 2766, 2810, 2764, 2793, 2761, 2791, 2799, 2774, 2783, 2759, 2772, 2768, 2794, 2807, 2764, 2782, 2806, 2813, 2773, 2799, 2791, 2769, 2801, 2798, 2793, 2795, 2814, 2783, 2786, 2795, 2770, 2798, 2771, 2766, 2766, 2799, 2789, 2808, 2810, 2799, 2800, 2797, 2762, 2792, 2772, 2800, 2803, 2765, 2795, 2777, 2787, 2815, 2767, 2813, 2792, 2804, 2780, 2795, 2779, 2775, 2795, 2784, 2808, 2787, 2798, 2793, 2766, 2812, 2780, 2780, 2779, 2765, 2790, 2772, 2773, 2814, 2791, 2765, 2769, 2764, 2784, 2784, 2773, 2784, 2771, 2796, 2789, 2788, 2775, 2777, 2760, 2781, 2800, 2810, 2810, 2794, 2793, 2779, 2786, 2799, 2815, 2769, 2768, 2762, 2784, 2777, 2803, 2769, 2801, 2790, 2772, 2778, 2766, 2774, 2779, 2803, 2790, 2776, 2809, 2805, 2769, 2777, 2781, 2785, 2799, 2794, 2807, 2761, 2771, 2806, 2777, 2807, 2777, 2789, 2769, 2777, 2789, 2800, 2769, 2804, 2805, 2761, 2783, 2793, 2813, 2776, 2792, 2803, 2762, 2787, 2813, 2764, 2807, 2785, 2805, 2773, 2777, 2798, 2798, 2782, 2766, 2785, 2783, 2809, 2807, 2771, 2799, 2788, 2780, 2775, 2773, 2770, 2786, 2781, 2761, 2765, 2792, 2812, 2811, 2780, 2789, 2792, 2736, 2776, 2744, 2685, 2747, 2761, 2787, 2790, 2785, 2799, 2800, 2783, 2749, 2800, 2790, 2767, 2789, 2782, 2754, 2800, 2790, 2763, 2789, 2800, 2794, 2798, 2758, 2786, 2799, 2791, 2800, 2765, 2780, 2792, 2753, 2800, 2766, 2800, 2787, 2800, 2800, 2768, 2797, 2799, 2787, 2800, 2792, 2800, 2799, 2770, 2800, 2800, 2800, 2792, 2763, 2800, 2765, 2726, 2755, 2742, 2764, 2740, 2752, 2751, 2762, 2781, 2779, 2780, 2730, 2768, 2728, 2702, 2728, 2800, 2750, 2739, 2761, 2763, 2800, 2800, 2763, 2782, 2772, 2761, 2800, 2783, 2791, 2798, 2790, 2800, 2779, 2783, 2726, 2704, 2745, 2744, 2800, 2779, 2800, 2800, 2785, 2760, 2797, 2767, 2787, 2769, 2768]
        y3 = [1181, 1254, 1322, 1270, 1243, 1298, 1255, 1336, 1318, 1345, 1299, 1346, 1322, 1330, 1296, 1388, 1381, 1323, 1337, 1323, 1349, 1270, 1356, 1398, 1386, 1418, 1451, 1365, 1354, 1368, 1477, 1440, 1425, 1386, 1411, 1432, 1399, 1449, 1483, 1419, 1470, 1460, 1394, 1447, 1484, 1404, 1513, 1391, 1445, 1459, 1397, 1510, 1461, 1484, 1521, 1446, 1472, 1511, 1592, 1599, 1530, 1609, 1576, 1529, 1661, 1533, 1578, 1569, 1636, 1588, 1589, 1641, 1620, 1597, 1583, 1582, 1585, 1635, 1665, 1637, 1598, 1603, 1675, 1618, 1608, 1639, 1649, 1670, 1724, 1709, 1686, 1656, 1680, 1691, 1749, 1725, 1745, 1722, 1765, 1714, 1735, 1684, 1811, 1745, 1767, 1777, 1784, 1800, 1782, 1818, 1824, 1807, 1749, 1832, 1806, 1846, 1805, 1852, 1869, 1820, 1835, 1812, 1903, 1859, 1942, 1916, 1783, 1931, 1892, 1824, 1939, 1859, 1933, 1875, 1963, 1887, 1998, 1924, 1959, 1930, 1950, 2001, 2035, 1973, 1950, 2057, 1971, 1987, 1906, 1975, 1995, 2004, 2055, 2056, 2049, 2127, 2055, 2090, 2097, 2034, 2006, 2103, 2088, 2055, 2133, 2129, 2125, 2071, 2070, 2104, 2094, 2095, 2140, 2125, 2162, 2031, 2147, 2132, 2135, 2084, 2153, 2166, 2086, 2125, 2167, 2227, 2204, 2140, 2166, 2217, 2235, 2228, 2216, 2198, 2193, 2213, 2186, 2273, 2176, 2194, 2234, 2228, 2210, 2209, 2233, 2205, 2229, 2231, 2280, 2247, 2192, 2263, 2225, 2243, 2249, 2298, 2271, 2299, 2305, 2324, 2286, 2340, 2321, 2319, 2320, 2254, 2353, 2311, 2315, 2352, 2293, 2323, 2343, 2316, 2306, 2382, 2292, 2357, 2300, 2360, 2302, 2379, 2353, 2371, 2363, 2399, 2334, 2380, 2392, 2381, 2374, 2353, 2403, 2358, 2382, 2389, 2414, 2421, 2353, 2409, 2398, 2435, 2385, 2361, 2389, 2428, 2416, 2410, 2479, 2416, 2434, 2417, 2457, 2431, 2437, 2450, 2389, 2440, 2482, 2424, 2436, 2389, 2474, 2477, 2460, 2436, 2472, 2466, 2476, 2456, 2437, 2430, 2429, 2485, 2400, 2430, 2460, 2455, 2441, 2484, 2480, 2479, 2463, 2466, 2437, 2490, 2478, 2507, 2523, 2465, 2486, 2518, 2510, 2454, 2491, 2527, 2456, 2505, 2505, 2496, 2498, 2516, 2488, 2499, 2521, 2533, 2486, 2526, 2491, 2494, 2531, 2527, 2513, 2505, 2502, 2517, 2498, 2538, 2490, 2522, 2543, 2526, 2538, 2560, 2516, 2510, 2532, 2525, 2536, 2532, 2543, 2502, 2516, 2525, 2548, 2522, 2558, 2525, 2547, 2532, 2521, 2517, 2497, 2518, 2534, 2522, 2520, 2544, 2555, 2528, 2513, 2534, 2534, 2536, 2547, 2544, 2537, 2500, 2540, 2559, 2551, 2556, 2564, 2514, 2533, 2541, 2548, 2563, 2559, 2552, 2559, 2545, 2547, 2569, 2557, 2546, 2549, 2559, 2555, 2556, 2549, 2536, 2552, 2569, 2542, 2559, 2582, 2546, 2563, 2554, 2562, 2571, 2548, 2582, 2560, 2557, 2556, 2561, 2556, 2557, 2565, 2564, 2546, 2577, 2559, 2578, 2564, 2541, 2565, 2576, 2570, 2565, 2555, 2581, 2550, 2586, 2577, 2565, 2570, 2576, 2575, 2574, 2564, 2584, 2577, 2567, 2584, 2573, 2573, 2570, 2579, 2567, 2573, 2568, 2574, 2565, 2583, 2572, 2579, 2567, 2570, 2585, 2579, 2578, 2580, 2590, 2591, 2574, 2587, 2587, 2580, 2585, 2591, 2583, 2596, 2582, 2590, 2572, 2577, 2584, 2591, 2585, 2574, 2576, 2589, 2580, 2583, 2580, 2579, 2586, 2573, 2583, 2591, 2590, 2578, 2582, 2597, 2588, 2575, 2586, 2583, 2594, 2581, 2579, 2591, 2592, 2583, 2586, 2589, 2582, 2583, 2589, 2593, 2577, 2592, 2594, 2580, 2588, 2583, 2594, 2570, 2576, 2595, 2596, 2583, 2589, 2577, 2582, 2580, 2585, 2582, 2587, 2592, 2584, 2583, 2589, 2595, 2591, 2608, 2593, 2602, 2595, 2602, 2600, 2602, 2589, 2601, 2597, 2594, 2596, 2620, 2604, 2582, 2589, 2584, 2596, 2604, 2598, 2601, 2600, 2586, 2594, 2586, 2598, 2601, 2596, 2617, 2602, 2606, 2595, 2596, 2609, 2591, 2597, 2586, 2592, 2599, 2606, 2607, 2586, 2598, 2587, 2598, 2609, 2606, 2597, 2599, 2572, 2606, 2596, 2601, 2609, 2605, 2591, 2618, 2596, 2599, 2605, 2610, 2599, 2590, 2596, 2615, 2588, 2606, 2617, 2611, 2605, 2602, 2622, 2605, 2614, 2592, 2611, 2596, 2601, 2614, 2587, 2599, 2609, 2605, 2594, 2610, 2615, 2605, 2612, 2629, 2633, 2635, 2603, 2610, 2621, 2630, 2639, 2621, 2628, 2639, 2596, 2623, 2647, 2644, 2628, 2637, 2643, 2584, 2650, 2636, 2622, 2663, 2637, 2642, 2656, 2655, 2661, 2633, 2655, 2677, 2651, 2673, 2667, 2659, 2658, 2677, 2671, 2673, 2663, 2669, 2680, 2665, 2668, 2683, 2691, 2690, 2685, 2698, 2703, 2691, 2720, 2702, 2708, 2713, 2713, 2734, 2613, 2702, 2673, 2714, 2698, 2726, 2668, 2723, 2705, 2700, 2715, 2736, 2712, 2715, 2726, 2722, 2733, 2730, 2720, 2709, 2735, 2727, 2697, 2660, 2663, 2618, 2690, 2675, 2686, 2666, 2672, 2657, 2640, 2717, 2686, 2630, 2676, 2677, 2649, 2619, 2655, 2687, 2678, 2688, 2677, 2658, 2633, 2611, 2675, 2635, 2649, 2692, 2664, 2664, 2643, 2675, 2680, 2714, 2665, 2700, 2691, 2645, 2680, 2684, 2718, 2626, 2667, 2675, 2708, 2654, 2653, 2699, 2720, 2708, 2715, 2678, 2704, 2714, 2687, 2706, 2719, 2664, 2722, 2674, 2708, 2717, 2728, 2712, 2720, 2766, 2695, 2718, 2706, 2735, 2703, 2719, 2752, 2728, 2727, 2696, 2706, 2735, 2752, 2715, 2710, 2740, 2745, 2732, 2734, 2738, 2733, 2697, 2736, 2738, 2743, 2729, 2735, 2743, 2701, 2754, 2756, 2778, 2740, 2728, 2719, 2731, 2745, 2751, 2706, 2702, 2729, 2736, 2750, 2751, 2729, 2724, 2749, 2739, 2764, 2770, 2745, 2759, 2708, 2719, 2739, 2715, 2767, 2731, 2755, 2746, 2740, 2759, 2739, 2741, 2771, 2740, 2754, 2744, 2768, 2743, 2761, 2762, 2760, 2766, 2775, 2770, 2764, 2773, 2776, 2753, 2718, 2765, 2754, 2779, 2771, 2742, 2744, 2744, 2737, 2743, 2767, 2754, 2768, 2759, 2752, 2766, 2752, 2785, 2779, 2779, 2760, 2726, 2772, 2786, 2770, 2760, 2751, 2746, 2743, 2775, 2785, 2768, 2769, 2753, 2735, 2769, 2763, 2758, 2755, 2749, 2779, 2765, 2781, 2766, 2776, 2765, 2776, 2772, 2765, 2780, 2773, 2759, 2762, 2780, 2769, 2775, 2787, 2764, 2780, 2771, 2741, 2782, 2779, 2774, 2780, 2776, 2781, 2772, 2773, 2784, 2768, 2732, 2774, 2766, 2769, 2778, 2756, 2783, 2754, 2695, 2772, 2773, 2778, 2784, 2770, 2782, 2767, 2786, 2765, 2742, 2768, 2770, 2784, 2783, 2771, 2770, 2786, 2763, 2782, 2787, 2771, 2785, 2789, 2765, 2749, 2776, 2761, 2786, 2772, 2774, 2769, 2783, 2791, 2793, 2779, 2753, 2786, 2781, 2785, 2788, 2747, 2789, 2782, 2779, 2790, 2789, 2747, 2778, 2794, 2787, 2790, 2767, 2785, 2793, 2655, 2785, 2773, 2789, 2755, 2788, 2763, 2764, 2792, 2792, 2795, 2785, 2764]
        for i in range(0, 1000):
            x_axis_data.append(i)
            y1.append(y_axis_data[i])
            y2.append(y_axis_data2[i])

        plt.plot(x_axis_data, y2,   linestyle='solid', color = '#DC143C',alpha=0.8,label='Proposed TMAPPO', linewidth=1,
                  markersize=2)

        plt.plot(x_axis_data, y1, linestyle='solid', color = 'blue', alpha=0.5, linewidth=1,
                 label='MAPPO')  # 'bo-'表示蓝色实线，数据点实心原点标注


        plt.plot(x_axis_data, y3, linestyle='solid', color = 'orange', alpha=0.5, linewidth=1, label='TMAPPO-critic')

        plt.plot(x_axis_data, y4, linestyle='solid', color = 'purple', alpha=0.5, linewidth=1, label='MADDPG')

        plt.plot(x_axis_data, y5, linestyle='solid', color = 'green', alpha=0.5, linewidth=1, label='MASAC')



        ## plot中参数的含义分别是横轴值，纵轴值，线的形状（'s'方块,'o'实心圆点，'*'五角星   ...，颜色，透明度,线的宽度和标签 ，
        plt.tick_params(labelsize=16)
        plt.legend(fontsize=16)  # 显示上面的label
        plt.xlabel('Epi', fontsize=17)  # x_label
        plt.ylabel('Reward', fontsize=17)  # y_label
        plt.grid(True, which="major", linestyle="--", color="gray", linewidth=0.75)
        plt.grid(True, which="minor", linestyle=":", color="lightgray", linewidth=0.75)

        # plt.ylim(-1,1)#仅设置y轴坐标范围
        plt.show()

    def plot_rew(self):
        x_axis_data = []  # x
        plt.figure(figsize=(8.5, 6))
        y_axis_data2 = [1127, 1292, 1282, 1353, 1307, 1278, 1217, 1274, 1320, 1279, 1286, 1277, 1316, 1260, 1299, 1327, 1240, 1349, 1330, 1348, 1292, 1380, 1367, 1370, 1317, 1351, 1461, 1361, 1366, 1365, 1431, 1467, 1417, 1437, 1414, 1498, 1498, 1501, 1469, 1532, 1507, 1591, 1562, 1528, 1572, 1650, 1621, 1615, 1640, 1649, 1692, 1709, 1753, 1722, 1748, 1784, 1729, 1799, 1805, 1809, 1875, 1822, 1959, 1921, 1820, 1824, 1880, 1974, 1975, 2025, 1982, 2013, 2017, 2059, 2118, 2130, 2086, 2054, 2041, 2102, 2178, 2181, 2186, 2225, 2213, 2205, 2303, 2259, 2282, 2321, 2322, 2347, 2308, 2288, 2359, 2349, 2359, 2357, 2369, 2340, 2329, 2406, 2374, 2377, 2403, 2382, 2407, 2469, 2453, 2453, 2478, 2439, 2475, 2492, 2514, 2538, 2507, 2566, 2536, 2522, 2537, 2555, 2541, 2477, 2642, 2548, 2613, 2600, 2617, 2601, 2642, 2595, 2613, 2607, 2612, 2613, 2621, 2601, 2616, 2621, 2650, 2575, 2565, 2570, 2539, 2562, 2553, 2591, 2525, 2512, 2511, 2590, 2509, 2533, 2624, 2418, 2543, 2461, 2627, 2544, 2539, 2543, 2570, 2580, 2493, 2590, 2502, 2544, 2525, 2505, 2517, 2567, 2533, 2456, 2557, 2519, 2566, 2615, 2516, 2568, 2536, 2550, 2583, 2491, 2599, 2575, 2547, 2436, 2514, 2610, 2563, 2531, 2515, 2572, 2429, 2563, 2586, 2496, 2489, 2530, 2492, 2363, 2401, 2462, 2398, 2419, 2477, 2339, 2323, 2358, 2499, 2506, 2408, 2563, 2461, 2513, 2270, 2265, 2339, 2239, 2527, 2417, 2511, 2409, 2288, 2396, 2480, 2376, 2439, 2591, 2563, 2300, 2520, 2577, 2477, 2469, 2320, 2271, 2413, 2560, 2620, 2597, 2573, 2367, 2465, 2457, 2347, 2494, 2376, 2613, 2561, 2507, 2455, 2428, 2489, 2463, 2639, 2574, 2560, 2492, 2586, 2591, 2434, 2618, 2636, 2506, 2606, 2491, 2661, 2503, 2618, 2454, 2481, 2412, 2543, 2629, 2493, 2562, 2576, 2616, 2536, 2506, 2573, 2548, 2576, 2543, 2505, 2461, 2537, 2636, 2569, 2652, 2577, 2520, 2345, 2478, 2618, 2599, 2535, 2571, 2512, 2584, 2642, 2626, 2526, 2621, 2449, 2620, 2583, 2495, 2635, 2629, 2648, 2612, 2681, 2681, 2605, 2473, 2533, 2537, 2601, 2522, 2580, 2592, 2584, 2675, 2588, 2569, 2540, 2659, 2545, 2608, 2534, 2646, 2620, 2608, 2663, 2595, 2641, 2608, 2594, 2623, 2621, 2588, 2525, 2516, 2624, 2515, 2663, 2586, 2670, 2610, 2626, 2601, 2652, 2663, 2639, 2585, 2585, 2621, 2658, 2659, 2662, 2614, 2660, 2606, 2655, 2654, 2621, 2630, 2709, 2631, 2627, 2610, 2652, 2698, 2685, 2704, 2673, 2576, 2579, 2686, 2694, 2662, 2656, 2606, 2687, 2693, 2703, 2623, 2698, 2698, 2714, 2753, 2745, 2685, 2678, 2674, 2718, 2675, 2723, 2637, 2719, 2735, 2571, 2685, 2689, 2621, 2722, 2728, 2662, 2690, 2721, 2694, 2754, 2720, 2756, 2705, 2755, 2748, 2709, 2661, 2718, 2765, 2697, 2730, 2734, 2737, 2737, 2719, 2723, 2755, 2754, 2708, 2677, 2754, 2669, 2757, 2738, 2752, 2732, 2714, 2667, 2717, 2675, 2701, 2698, 2782, 2729, 2745, 2717, 2692, 2745, 2699, 2689, 2692, 2697, 2710, 2658, 2673, 2711, 2699, 2751, 2742, 2698, 2707, 2726, 2633, 2655, 2742, 2706, 2715, 2773, 2746, 2730, 2756, 2779, 2781, 2778, 2772, 2784, 2786, 2770, 2759, 2783, 2789, 2794, 2792, 2787, 2788, 2795, 2795, 2788, 2796, 2792, 2783, 2786, 2793, 2781, 2795, 2690, 2750, 2727, 2733, 2737, 2724, 2735, 2740, 2717, 2706, 2754, 2723, 2768, 2771, 2762, 2699, 2720, 2745, 2723, 2723, 2754, 2797, 2778, 2749, 2758, 2796, 2704, 2760, 2785, 2749, 2779, 2747, 2797, 2781, 2742, 2796, 2747, 2771, 2796, 2775, 2738, 2704, 2745, 2799, 2775, 2706, 2798, 2738, 2717, 2792, 2760, 2745, 2794, 2781, 2791, 2744, 2736, 2772, 2798, 2703, 2737, 2799, 2751, 2773, 2728, 2734, 2699, 2733, 2732, 2754, 2767, 2762, 2799, 2726, 2695, 2730, 2726, 2749, 2716, 2723, 2737, 2733, 2748, 2742, 2744, 2791, 2730, 2790, 2747, 2704, 2771, 2722, 2700, 2722, 2751, 2798, 2796, 2740, 2763, 2732, 2747, 2796, 2770, 2795, 2781, 2756, 2703, 2718, 2758, 2773, 2734, 2798, 2740, 2792, 2791, 2717, 2789, 2738, 2796, 2780, 2798, 2795, 2703, 2732, 2762, 2769, 2760, 2766, 2782, 2704, 2796, 2798, 2800, 2775, 2741, 2799, 2797, 2795, 2799, 2794, 2792, 2746, 2752, 2799, 2800, 2749, 2769, 2800, 2798, 2773, 2799, 2800, 2800, 2798, 2758, 2797, 2799, 2800, 2800, 2799, 2800, 2800, 2799, 2799, 2800, 2799, 2737, 2799, 2800, 2798, 2767, 2754, 2773, 2798, 2800, 2800, 2748, 2799, 2800, 2750, 2724, 2709, 2722, 2724, 2739, 2730, 2727, 2760, 2753, 2771, 2736, 2745, 2721, 2800, 2800, 2797, 2763, 2799, 2790, 2784, 2767, 2729, 2760, 2796, 2785, 2795, 2737, 2790, 2737, 2770, 2806, 2766, 2810, 2764, 2793, 2761, 2791, 2799, 2774, 2783, 2759, 2772, 2768, 2794, 2807, 2764, 2782, 2806, 2813, 2773, 2799, 2791, 2769, 2801, 2798, 2793, 2795, 2814, 2783, 2786, 2795, 2770, 2798, 2771, 2766, 2766, 2799, 2789, 2808, 2810, 2799, 2800, 2797, 2762, 2792, 2772, 2800, 2803, 2765, 2795, 2777, 2787, 2815, 2767, 2813, 2792, 2804, 2780, 2795, 2779, 2775, 2795, 2784, 2808, 2787, 2798, 2793, 2766, 2812, 2780, 2780, 2779, 2765, 2790, 2772, 2773, 2814, 2791, 2765, 2769, 2764, 2784, 2784, 2773, 2784, 2771, 2796, 2789, 2788, 2775, 2777, 2760, 2781, 2800, 2810, 2810, 2794, 2793, 2779, 2786, 2799, 2815, 2769, 2768, 2762, 2784, 2777, 2803, 2769, 2801, 2790, 2772, 2778, 2766, 2774, 2779, 2803, 2790, 2776, 2809, 2805, 2769, 2777, 2781, 2785, 2799, 2794, 2807, 2761, 2771, 2806, 2777, 2807, 2777, 2789, 2769, 2777, 2789, 2800, 2769, 2804, 2805, 2761, 2783, 2793, 2813, 2776, 2792, 2803, 2762, 2787, 2813, 2764, 2807, 2785, 2805, 2773, 2777, 2798, 2798, 2782, 2766, 2785, 2783, 2809, 2807, 2771, 2799, 2788, 2780, 2775, 2773, 2770, 2786, 2781, 2761, 2765, 2792, 2812, 2811, 2780, 2789, 2792, 2736, 2776, 2744, 2685, 2747, 2761, 2787, 2790, 2785, 2799, 2800, 2783, 2749, 2800, 2790, 2767, 2789, 2782, 2754, 2800, 2790, 2763, 2789, 2800, 2794, 2798, 2758, 2786, 2799, 2791, 2800, 2765, 2780, 2792, 2753, 2800, 2766, 2800, 2787, 2800, 2800, 2768, 2797, 2799, 2787, 2800, 2792, 2800, 2799, 2770, 2800, 2800, 2800, 2792, 2763, 2800, 2765, 2726, 2755, 2742, 2764, 2740, 2752, 2751, 2762, 2781, 2779, 2780, 2730, 2768, 2728, 2702, 2728, 2800, 2750, 2739, 2761, 2763, 2800, 2800, 2763, 2782, 2772, 2761, 2800, 2783, 2791, 2798, 2790, 2800, 2779, 2783, 2726, 2704, 2745, 2744, 2800, 2779, 2800, 2800, 2785, 2760, 2797, 2767, 2787, 2769, 2768]


        y2 = []
        for i in range(0, 1000):
            x_axis_data.append(i)

        plt.plot(x_axis_data, y_axis_data2, label='TMAPPO', color='#DC143C', linewidth=1,
                 linestyle='solid',
                 marker='.', markersize=2, alpha=0.8)

        ## plot中参数的含义分别是横轴值，纵轴值，线的形状（'s'方块,'o'实心圆点，'*'五角星   ...，颜色，透明度,线的宽度和标签 ，
        plt.tick_params(labelsize=18)
        plt.legend(loc='lower right', fontsize=19)  # 显示上面的label
        plt.xlabel('Epi', fontsize=20)  # x_label
        plt.ylabel('Reward', fontsize=20)  # y_label
        plt.grid(True, which="major", linestyle="--", color="gray", linewidth=0.75)
        plt.grid(True, which="minor", linestyle=":", color="lightgray", linewidth=0.75)

        # plt.ylim(-1,1)#仅设置y轴坐标范围
        plt.show()



    def plot_trans(self):
        x_axis_data = []  # x
        plt.figure(figsize=(8.5, 6))

        y_axis_data2 = [0.27375, 0.31625, 0.31925, 0.335, 0.31925, 0.3125, 0.30175, 0.31875, 0.31825, 0.32225, 0.323, 0.3195, 0.32525, 0.30425, 0.32725, 0.33275, 0.30325, 0.3385, 0.32025, 0.32925, 0.32325, 0.337, 0.33325, 0.33025, 0.3205, 0.3355, 0.365, 0.3425, 0.33275, 0.33225, 0.35125, 0.3595, 0.355, 0.354, 0.3525, 0.36875, 0.36225, 0.37275, 0.36025, 0.38475, 0.372, 0.3935, 0.38825, 0.37775, 0.384, 0.406, 0.4045, 0.39325, 0.39875, 0.41075, 0.42475, 0.4165, 0.4365, 0.4295, 0.432, 0.4355, 0.42875, 0.45225, 0.44, 0.45275, 0.467, 0.4575, 0.4805, 0.4715, 0.4495, 0.44575, 0.46275, 0.486, 0.49375, 0.49575, 0.494, 0.49175, 0.499, 0.517, 0.51825, 0.522, 0.515, 0.5065, 0.5105, 0.52575, 0.5425, 0.54375, 0.537, 0.554, 0.555, 0.53925, 0.56925, 0.56725, 0.5625, 0.5815, 0.58, 0.57975, 0.56925, 0.56975, 0.58025, 0.57575, 0.58675, 0.584, 0.586, 0.58525, 0.5795, 0.59575, 0.59425, 0.58875, 0.5995, 0.589, 0.60075, 0.606, 0.6095, 0.61475, 0.615, 0.60525, 0.61525, 0.61075, 0.6225, 0.622, 0.61825, 0.64, 0.6275, 0.61875, 0.624, 0.63575, 0.6325, 0.60875, 0.65275, 0.63075, 0.643, 0.643, 0.64825, 0.6385, 0.65775, 0.64575, 0.6425, 0.65225, 0.65525, 0.649, 0.65525, 0.64475, 0.64975, 0.64675, 0.6505, 0.63325, 0.6345, 0.63325, 0.63325, 0.63875, 0.6375, 0.63675, 0.6275, 0.61625, 0.6295, 0.6635, 0.65775, 0.64975, 0.66275, 0.6175, 0.64925, 0.62375, 0.661, 0.646, 0.65925, 0.653, 0.6425, 0.66275, 0.6345, 0.66275, 0.6205, 0.6335, 0.641, 0.6425, 0.65775, 0.65375, 0.65925, 0.614, 0.667, 0.63975, 0.6395, 0.672, 0.658, 0.6725, 0.6615, 0.661, 0.65275, 0.65375, 0.64625, 0.66625, 0.65825, 0.619, 0.654, 0.673, 0.67775, 0.6495, 0.6565, 0.6495, 0.63575, 0.65125, 0.6825, 0.63925, 0.63975, 0.6615, 0.62775, 0.62225, 0.5975, 0.615, 0.6, 0.6305, 0.63175, 0.61825, 0.586, 0.58925, 0.63525, 0.65475, 0.632, 0.66025, 0.64375, 0.645, 0.58825, 0.597, 0.599, 0.5555, 0.65525, 0.62975, 0.627, 0.60925, 0.608, 0.61675, 0.6535, 0.60275, 0.6225, 0.6635, 0.66225, 0.608, 0.628, 0.68025, 0.631, 0.65075, 0.608, 0.58225, 0.60325, 0.6495, 0.689, 0.68, 0.64925, 0.61675, 0.6225, 0.638, 0.61125, 0.6485, 0.596, 0.68075, 0.65, 0.66325, 0.6485, 0.62275, 0.638, 0.61575, 0.69225, 0.677, 0.67175, 0.61975, 0.669, 0.6755, 0.62375, 0.6695, 0.6665, 0.6615, 0.6585, 0.6365, 0.6625, 0.66275, 0.69075, 0.635, 0.65725, 0.61675, 0.63825, 0.68625, 0.65375, 0.64775, 0.6595, 0.653, 0.64025, 0.62425, 0.67125, 0.64, 0.6785, 0.672, 0.634, 0.6235, 0.654, 0.667, 0.66725, 0.69575, 0.67525, 0.65025, 0.597, 0.6255, 0.67175, 0.651, 0.636, 0.661, 0.619, 0.6335, 0.6625, 0.651, 0.63125, 0.64475, 0.61325, 0.6565, 0.64825, 0.62625, 0.6525, 0.65625, 0.66375, 0.65325, 0.67125, 0.66725, 0.64475, 0.61375, 0.625, 0.6285, 0.648, 0.62375, 0.64325, 0.64475, 0.63875, 0.66625, 0.64875, 0.63925, 0.627, 0.6525, 0.6335, 0.65125, 0.62375, 0.663, 0.64425, 0.6405, 0.66825, 0.64825, 0.6525, 0.6425, 0.64175, 0.64925, 0.6455, 0.648, 0.632, 0.6295, 0.64425, 0.631, 0.658, 0.64575, 0.66725, 0.65025, 0.6585, 0.6385, 0.65575, 0.654, 0.648, 0.63925, 0.63925, 0.6515, 0.66475, 0.6625, 0.66025, 0.651, 0.6645, 0.64425, 0.65975, 0.6625, 0.65625, 0.64775, 0.67875, 0.65075, 0.64775, 0.65325, 0.652, 0.6695, 0.65925, 0.6665, 0.664, 0.6365, 0.64625, 0.66175, 0.668, 0.66525, 0.6655, 0.643, 0.6595, 0.6725, 0.67525, 0.65325, 0.667, 0.677, 0.66875, 0.68525, 0.68775, 0.6725, 0.66825, 0.6705, 0.67075, 0.66775, 0.678, 0.6565, 0.6725, 0.67725, 0.64025, 0.6625, 0.6675, 0.64475, 0.6715, 0.6705, 0.658, 0.66425, 0.6815, 0.6735, 0.67925, 0.67975, 0.69075, 0.676, 0.6765, 0.68425, 0.67125, 0.661, 0.67025, 0.68625, 0.6625, 0.679, 0.68575, 0.685, 0.68475, 0.67575, 0.672, 0.68675, 0.67925, 0.666, 0.6675, 0.68925, 0.66575, 0.681, 0.68175, 0.68425, 0.679, 0.67975, 0.66325, 0.66925, 0.66575, 0.67175, 0.6665, 0.698, 0.677, 0.6755, 0.668, 0.6655, 0.6795, 0.66825, 0.6685, 0.66875, 0.67025, 0.672, 0.65625, 0.66425, 0.67425, 0.66475, 0.68125, 0.67425, 0.6665, 0.67525, 0.67675, 0.646, 0.6585, 0.67975, 0.676, 0.6755, 0.6825, 0.67625, 0.6745, 0.68075, 0.68375, 0.686, 0.695, 0.693, 0.696, 0.699, 0.68525, 0.683, 0.6905, 0.69175, 0.68825, 0.69, 0.69375, 0.691, 0.691, 0.698, 0.699, 0.69775, 0.6975, 0.68675, 0.69725, 0.68575, 0.6865, 0.69625, 0.6725, 0.675, 0.6825, 0.67575, 0.68075, 0.6835, 0.68325, 0.68175, 0.669, 0.678, 0.68025, 0.6735, 0.68275, 0.6925, 0.6925, 0.66875, 0.6725, 0.67725, 0.66975, 0.6685, 0.677, 0.69925, 0.68625, 0.6865, 0.69175, 0.6895, 0.6765, 0.67825, 0.685, 0.67775, 0.69575, 0.675, 0.6905, 0.6915, 0.68125, 0.68875, 0.6855, 0.69375, 0.69275, 0.6875, 0.68675, 0.674, 0.68725, 0.69225, 0.691, 0.67175, 0.69875, 0.6815, 0.66975, 0.68775, 0.678, 0.6795, 0.701, 0.68825, 0.688, 0.68825, 0.68475, 0.68425, 0.68825, 0.67775, 0.67875, 0.69975, 0.68325, 0.6915, 0.6845, 0.685, 0.6705, 0.68375, 0.683, 0.69025, 0.6885, 0.6805, 0.692, 0.67475, 0.6725, 0.67375, 0.6795, 0.67975, 0.67375, 0.67075, 0.67975, 0.68275, 0.675, 0.68175, 0.67675, 0.699, 0.671, 0.6955, 0.678, 0.67125, 0.68625, 0.6735, 0.673, 0.679, 0.677, 0.69425, 0.69075, 0.67875, 0.6805, 0.68325, 0.68575, 0.6915, 0.682, 0.68875, 0.68625, 0.6865, 0.66675, 0.678, 0.68825, 0.6915, 0.67325, 0.6985, 0.6755, 0.68825, 0.692, 0.668, 0.685, 0.679, 0.69325, 0.69125, 0.6915, 0.69725, 0.66675, 0.685, 0.693, 0.6845, 0.6915, 0.6915, 0.69525, 0.673, 0.699, 0.69975, 0.69375, 0.68625, 0.679, 0.688, 0.696, 0.696, 0.692, 0.70025, 0.6855, 0.675, 0.685, 0.69625, 0.69875, 0.68975, 0.69175, 0.70125, 0.701, 0.6915, 0.70075, 0.697, 0.69025, 0.6905, 0.68, 0.7015, 0.68925, 0.6915, 0.69675, 0.6915, 0.698, 0.692, 0.7, 0.6945, 0.68875, 0.69575, 0.6795, 0.68975, 0.6965, 0.701, 0.6805, 0.678, 0.69225, 0.687, 0.69325, 0.6975, 0.67975, 0.7015, 0.6875, 0.681, 0.68, 0.66825, 0.676, 0.68275, 0.6765, 0.67525, 0.6715, 0.6865, 0.68425, 0.69425, 0.67425, 0.6815, 0.6685, 0.698, 0.6975, 0.68975, 0.69125, 0.689, 0.698, 0.69025, 0.685, 0.68375, 0.6875, 0.69525, 0.692, 0.69525, 0.6945, 0.698, 0.69675, 0.68, 0.70075, 0.6995, 0.69225, 0.692, 0.70075, 0.69225, 0.69725, 0.691, 0.7, 0.689, 0.696, 0.6935, 0.69625, 0.6985, 0.69125, 0.69575, 0.68825, 0.6915, 0.698, 0.69675, 0.702, 0.701, 0.69975, 0.70225, 0.693, 0.69075, 0.6985, 0.70225, 0.69575, 0.69, 0.68875, 0.7, 0.69425, 0.69275, 0.7015, 0.69725, 0.69725, 0.68975, 0.6985, 0.702, 0.701, 0.70125, 0.70025, 0.694, 0.69, 0.6955, 0.691, 0.695, 0.69875, 0.70025, 0.69725, 0.68825, 0.7, 0.692, 0.69775, 0.69375, 0.70125, 0.68825, 0.694, 0.6945, 0.70225, 0.70125, 0.7, 0.691, 0.68825, 0.69275, 0.692, 0.696, 0.6925, 0.70025, 0.6885, 0.6955, 0.69025, 0.68825, 0.68975, 0.697, 0.69, 0.6905, 0.70075, 0.70075, 0.6995, 0.68375, 0.69575, 0.697, 0.69125, 0.70225, 0.69925, 0.69825, 0.70225, 0.70075, 0.69675, 0.69975, 0.70175, 0.6935, 0.69075, 0.693, 0.6935, 0.7015, 0.6895, 0.69775, 0.69975, 0.6955, 0.697, 0.691, 0.69325, 0.698, 0.699, 0.70075, 0.68975, 0.69075, 0.6955, 0.68875, 0.68875, 0.7, 0.69575, 0.70025, 0.696, 0.688, 0.69175, 0.70025, 0.6935, 0.696, 0.68825, 0.69175, 0.694, 0.6925, 0.69975, 0.69, 0.69825, 0.6895, 0.699, 0.6995, 0.702, 0.691, 0.68775, 0.70075, 0.70175, 0.69175, 0.693, 0.6915, 0.68725, 0.7005, 0.7015, 0.70125, 0.693, 0.698, 0.6875, 0.68875, 0.68825, 0.6915, 0.6885, 0.70025, 0.687, 0.6955, 0.70025, 0.69875, 0.696, 0.68975, 0.69125, 0.70025, 0.70175, 0.68825, 0.69175, 0.69075, 0.689, 0.6945, 0.6915, 0.69325, 0.7015, 0.701, 0.70225, 0.69375, 0.6905, 0.69975, 0.7025, 0.69875, 0.693, 0.69525, 0.69775, 0.70025, 0.6935, 0.69025, 0.6915, 0.6845, 0.69675, 0.687, 0.6685, 0.685, 0.69525, 0.6955, 0.69375, 0.698, 0.69775, 0.6955, 0.69, 0.68425, 0.7, 0.689, 0.68275, 0.6865, 0.69325, 0.688, 0.69575, 0.6985, 0.68725, 0.69575, 0.68975, 0.69775, 0.68775, 0.6785, 0.6985, 0.694, 0.6955, 0.6955, 0.6885, 0.69225, 0.693, 0.68475, 0.6875, 0.6935, 0.69075, 0.6975, 0.68825, 0.7025, 0.69325, 0.69325, 0.69275, 0.6925, 0.702, 0.69525, 0.7025, 0.6905, 0.68575, 0.6985, 0.69775, 0.69775, 0.68775, 0.6925, 0.69675, 0.68075, 0.67125, 0.68825, 0.6775, 0.679, 0.67825, 0.67725, 0.6835, 0.6805, 0.68625, 0.692, 0.68975, 0.68075, 0.69275, 0.6765, 0.678, 0.68275, 0.70225, 0.68075, 0.6795, 0.68575, 0.67825, 0.697, 0.691, 0.6905, 0.69675, 0.6915, 0.67975, 0.69325, 0.6915, 0.6945, 0.69675, 0.68625, 0.68775, 0.69525, 0.68625, 0.67575, 0.668, 0.68, 0.67425, 0.69025, 0.69625, 0.69975, 0.689, 0.69025, 0.68, 0.70125, 0.69125, 0.69225, 0.6865, 0.6815]



        y2 = []

        for i in range(0, 1000):
            x_axis_data.append(i)


        plt.plot(x_axis_data, y_axis_data2, label='TMAPPO', color='#DC143C', linewidth=1,
                 linestyle='solid',
                 marker='.', markersize=2, alpha=0.8)
        plt.tick_params(labelsize=18)
        plt.legend(loc='lower right',fontsize=19)  # 显示上面的label
        plt.xlabel('Epi', fontsize=20)  # x_label
        plt.ylabel('Content Hit Ratio', fontsize=20)  # y_label
        plt.grid(True, which="major", linestyle="--", color="gray", linewidth=0.75)
        plt.grid(True, which="minor", linestyle=":", color="lightgray", linewidth=0.75)


        # plt.ylim(-1,1)#仅设置y轴坐标范围
        plt.show()


    def plot_time_delay(self):
        plt.rcParams["figure.dpi"] = 200
        plt.figure(figsize=(8, 6))
        x_axis_data = [ ]  # x
        y1 = []
        y2= []
        y_axis_data1 = [2044.8767122369477, 2164.993780608232, 2114.743325655953, 2077.7043481874225, 2009.953705661475, 2012.1940261322363, 2057.695808495238, 2007.0299114004101, 1967.688361572314, 1913.3429175167157, 1855.2673889399236, 1855.7969362557053, 1722.0065538021502, 1655.03387250447, 1656.1825619208682, 1596.33124840842, 1640.3438005650912, 1497.4352846981512, 1419.3824445315813, 1414.1747172394198, 1382.6850891382098, 1305.102735168951, 1240.5396351226766, 1250.3279037464035, 1213.7943629683864, 1142.7552218109545, 1112.9308325775576, 1080.8628257415621, 1064.7797614078906, 1014.1579503787051, 1003.5875446506964, 964.3332205323858, 959.0207350462905, 942.1950632303702, 912.551125668216, 886.1321327815772, 881.8046328684426, 874.359951288951, 869.8491669803866, 860.5722851603387, 877.6316639340234, 839.4259987862323, 862.6157046847321, 871.3936454614823, 858.8102702459136, 849.6158360399803, 855.3780313096446, 866.3661621472246, 859.9585629776492, 853.3690709737783, 856.1214654862742, 876.1751150931854, 870.4350587478771, 871.8739183744536, 871.5221191455479, 888.7131775469804, 907.8342919131594, 869.445225639537, 879.5429231267824, 876.8600772138653, 872.5894844899199, 878.601927186967, 876.8102190155518, 875.9239746978194, 887.5895859256614, 877.815657397592, 858.9712181119023, 885.4465840935192, 873.429257298968, 878.690273585065, 895.9659859037927, 914.7351702335768, 889.2018746791128, 852.7978192957829, 902.876088974002, 876.9262563638822, 895.0302198650563, 891.195078555168, 860.0247112450514, 893.8249310904047, 882.3223744308974, 879.4384854097221, 867.5771938387873, 877.4792064784538, 866.2940831794112, 867.5554808855564, 880.3201433458311, 875.463257922144, 860.585437565614, 886.5091161413199, 859.1088700847026, 906.6817892211777, 885.8956696459303, 868.8457885726929, 855.3492259079253, 897.2558729701357, 858.7684632004637, 888.8914480344949, 873.0063824825004, 886.6716289689784, 865.4095948380959, 871.8575454132032, 905.6171925534978, 884.4593061812678, 914.2777131697094, 892.4597375750441, 903.6799332429706, 850.8278613858489, 885.624025870169, 854.4201060781573, 912.3134163264504, 869.6979486909099, 889.1339273704896, 890.9085334790548, 883.8234018166339, 853.7789994699375, 848.778190105641, 901.5949015294806, 868.6498322959454, 882.1968678283367, 869.7866520912264, 855.0508988359559, 865.7550606235183, 882.2639039553698, 904.6828936490101, 874.4662258250161, 848.5535510282255, 861.8537667092969, 887.4946040152249, 871.8007584407709, 877.6332027555742, 875.0203026090647, 884.5928768627374, 896.3864471807644, 821.980802475767, 864.5473302869324, 895.4355918899345, 899.1889226030042, 878.0848693222612, 849.2067655617453, 885.0956363734207, 863.790935199058, 868.3181559780323, 892.0185673161385, 892.4061551332543, 862.8481353574554, 874.3974493295824, 876.5727126214508, 862.0490932389827, 888.7123099429332, 886.1118338754405, 906.2617676643201, 885.3780581681098, 900.1190341867591, 890.485250610367, 891.0117503303325, 873.8004927936953, 853.4763281105885, 883.2172150576702, 855.8476668451688, 868.7676592290909, 884.9736508073814, 880.2030940199579, 870.1373530367274, 848.2830604514464, 904.5767947972986, 871.4433949013503, 854.8548222229048, 864.8773734361222, 878.7855998344822, 872.0835039681178, 878.7092845402403, 823.640899866737, 868.1677765657086, 912.7127591366874, 847.2440666292283, 820.3980248490226, 877.0029437250168, 858.0163442471294, 869.6810909221462, 877.5020064358835, 857.6798878707533, 856.7018531639403, 880.6696519792515, 838.2445339736239, 852.6478285799791, 843.4015987327537, 864.5722989696743, 895.2978341382463, 872.6846681399661, 863.723636476433, 874.8485770362653, 840.1739978800231, 844.0627337682511, 877.8925529729653, 891.4063227186475, 848.6839233182806, 873.1520284005971, 895.5233530471005, 858.9060538568409, 889.5989775263066, 889.9801708137805, 843.5358375437795, 877.9601071416806, 851.2547307952685, 894.8572995537681, 884.864613753657, 871.1287600239735, 844.660549414251, 842.5377586318432, 872.8775130118581, 845.2775379044017, 844.4280679105148, 906.0925599524502, 872.3095271431272, 893.6362772952212, 889.2707717564049, 916.2174260691116, 861.7658270400746, 860.9332316239462, 884.1405967163296, 856.7890962907379, 893.2325167149479, 845.9081823540607, 862.5807585782469, 873.9195322068283, 849.4819646322004, 905.5737909014963, 874.1830994109182, 863.7576080504875, 869.5518678720691, 859.8183750445907, 861.1378124051218, 874.5726064687643, 871.5887353229816, 870.7200925462109, 873.7587146256697, 882.1561003669599, 884.5604813299285, 849.0661566381481, 857.2232652041132, 888.2609198147762, 866.3418647389436, 885.692553091056, 874.6230472804826, 873.6671259158962, 860.3628682667186, 884.9347670445635, 876.7942061315556, 882.7067290758064, 877.7421781442764, 838.9106999849782, 841.8362136589909, 882.3462130423569, 873.8694223759376, 839.2692547512231, 890.0243015457633, 854.8109496047203, 864.3444283563801, 867.0353163924196, 880.8354512641848, 848.4076211142576, 856.2460901040482, 844.9436699048733, 848.8095610630374, 867.0587154981632, 874.2280512967995, 846.7683578574049, 865.0260041378145, 863.4849092176041, 860.3758275789072, 906.0507278038357, 847.078850415397, 820.0657879841219, 853.5850688440058, 857.9532050414148, 844.9364481166588, 870.6050784883329, 851.1192582453347, 858.8040383395162, 870.6643572344796, 850.3315348858843, 900.5158740353615, 851.6376331535838, 853.688807027727, 867.2107240825662, 844.2148651512252, 852.1080398199064, 851.8399534309841, 847.7461178568824, 811.599343239364, 849.6801767739767, 836.5557933707643, 840.4077342516734, 847.7248084593455, 850.6678328859965, 846.9660977774738, 830.6745583999556, 871.9173865479069, 853.2331611162366, 833.9403202365339, 833.4560975560114, 828.8751327700812, 837.0791939396064, 809.7882541428384, 840.2473130575594, 854.2248177557932, 857.3152887211996, 855.6071319762658, 839.9120493246425, 836.5090219382549, 834.2123505262097, 874.1511408478584, 811.5159735324171, 838.2572353241757, 845.7263366144676, 827.0418479924926, 813.4218002092299, 817.2848658346348, 811.8740306524171, 838.2806125226543, 869.0760399987124, 849.968237872618, 811.9970579990581, 830.9880406585537, 832.9056203956321, 837.7245099591706, 847.6062328612801, 818.0623902648276, 820.1739460627408, 844.3799867223088, 820.3025705737506, 824.1728132498077, 823.8241764335211, 834.0384043546164, 835.6556848993025, 809.9229267360338, 841.9120456422254, 852.0874096978429, 852.4456886474401, 835.7265105436405, 839.7625933333217, 809.1551205852982, 819.8970526711513, 819.766630593903, 808.7969173056417, 822.2540362495002, 826.8527295758657, 820.2701530691038, 830.0962652506396, 830.9957082243014, 817.6683211684103, 843.4026036812593, 803.7200849023315, 838.0088552143073, 807.134341280231, 845.7734705237032, 822.1403719056783, 833.5283755354351, 819.4530135647068, 807.7028919213597, 834.9872370688921, 819.8613559911697, 844.0731973618639, 837.4523524222357, 808.3628752419601, 817.6312092375516, 818.1574722251228, 836.157153547351, 822.739600472689, 815.0637340332909, 823.4962022485853, 814.0473259430738, 839.3723864815457, 807.8272428043133, 819.6170514427912, 807.8381396730216, 821.5125203482006, 815.0455871760283, 810.6548058823245, 813.5271436263727, 827.0077163677648, 827.6300366636352, 809.0204137034226, 812.2829197516407, 806.2952438251101, 824.9487906419396, 797.5594617545925, 820.3373528684575, 814.3177925348024, 824.1774022090884, 835.961216367684, 813.9553258130544, 806.3250534788256, 805.8983029283801, 802.3912636212594, 815.4191436352787, 804.3078300563714, 798.3851248319776, 804.2027953056688, 793.6683379960209, 795.3610876147304, 797.9363990796355, 803.3533467370545, 786.3982067977734, 809.0439689370214, 806.9407035320935, 814.4563374978899, 789.2732671410985, 804.890393247056, 784.0327908736358, 796.7126803434677, 782.4667684468913, 798.0285636460403, 791.7657462488529, 783.0122518255794, 773.5609110645134, 786.3267565102169, 776.102359927673, 780.3048693909009, 783.8355858763884, 779.6148512251795, 796.5896718481852, 775.756508296637, 797.7159191350177, 789.6827937261288, 761.7697031578352, 792.33856779107, 818.5155847790771, 795.1827653455151, 805.3817242281474, 796.8268459426549, 800.7071165579127, 775.7866160333759, 790.557636778635, 817.1577494553226, 773.6917991714594, 755.8113656614513, 758.0933889291978, 807.1356925771081, 780.0031723032226, 802.1105431679206, 779.9794536960916, 790.6847818563091, 773.7175587891614, 778.0569574660283, 808.9537640875891, 811.6463026566802, 771.2735501991415, 787.8195493637851, 786.3276961630042, 788.7375355115408, 797.6109021363177, 767.3807612426467, 763.2100066191607, 790.0317427280686, 789.5005063035198, 805.939626549036, 789.7406681525347, 792.6483519239534, 787.9557623531211, 773.5356684437858, 784.2331470438031, 775.9100833808657, 764.844059870006, 778.4588855499813, 772.2347384017285, 798.5362241656452, 783.4475287660873, 771.3442712604888, 781.1926336854042, 772.0916121979768, 751.5827899557571, 788.4521826649684, 766.1130760719192, 793.9432705909944, 784.9083413692405, 775.9944698961658, 777.0751139945907, 752.2038175564825, 795.5963331313601, 783.8615384142415, 778.8632554163532, 787.9594497522058, 772.0534543497731, 768.2075024692545, 784.4617700421393, 770.0646334123643, 780.7731112015981, 794.4527453861853, 798.4064358906835, 781.4712465408754, 784.9127461657785, 771.512949058173, 783.7293695970051, 785.1077100066891, 765.7385301763082, 792.1243970949372, 774.1895139978791, 766.603879754806, 776.7371187754809, 774.8923114529139, 779.4424957006402, 757.2834970468995, 760.4347978555588, 768.6177693974954, 779.8084005112225, 766.110447780272, 783.1717919671213, 782.4671680790415, 767.624335407525, 763.7071885251125, 756.0325781011936, 779.0984400153711, 781.754655842308, 779.2380887331202, 768.1136963922078, 766.4662991948796, 783.0157634431597, 785.1910085330804, 785.9021470021091, 776.7616540026693, 829.1354421160105, 792.7488458052388, 744.0171852776249, 792.4872691436212, 807.8242524013633, 791.0641497915243, 764.3555230532344, 787.4537744687796, 769.6626067124567, 795.9773284816372, 793.6147448256821, 768.2913940856065, 781.9758260147687, 785.1493961583503, 790.6174384724721, 762.8195708713772, 795.697987411313, 800.8434056069555, 769.9640237614547, 780.2494479611983, 803.4540140567168, 784.7526824310597, 797.4172865949753, 773.3416691774776, 784.7494379696908, 775.199668104989, 777.1419931407514, 791.3792892822876, 785.9093193688105, 760.9918863839547, 774.8076644303285, 774.7154072603681, 798.9175954155068, 776.7929098794879, 801.5647817558736, 797.5434981881795, 805.9157956610661, 805.0144655354965, 808.9100910480852, 790.3899770324846, 800.4803702773645, 792.8324740572116, 786.415909553726, 796.6194961033742, 790.6888558829281, 788.0122707017454, 787.5142460960353, 797.9266639143494, 801.1064912058711, 777.7645142606185, 767.2884820580126, 783.2906328991318, 780.2905496137545, 791.5205987961956, 775.7609656820026, 778.8233189651925, 778.5251763420946, 781.8494438594622, 777.8309174647351, 797.2926779664904, 762.1529713739801, 767.6775094504247, 782.3100692223225, 780.3120141757762, 787.2855879556072, 782.4439960681307, 789.8497035865375, 798.8165865765517, 767.5398275236952, 785.1525613782156, 790.1789605268483, 774.0575139100297, 775.4871295985997, 780.6517043728633, 790.5756251606664, 760.0687082186229, 778.0906162840722,761.1287082186229]
        y_axis_data2 = [2070.166073206097, 2096.4046884268782, 2115.087532955437, 2190.282792910263, 2126.551215945201, 2138.7236834021946, 2129.8336482013656, 2107.895765143819, 2141.275635950889, 1989.056862653288, 1918.4039832361302, 1982.4387372978856, 1900.1303628833437, 1933.7276182816454, 1862.6333797429684, 1896.7566744758742, 1744.4962508579154, 1938.8325630052552, 1730.5156680746366, 1693.4647029742694, 1800.1142281337166, 1715.7636196929413, 1671.7061371180548, 1657.0427933618978, 1611.9391923651406, 1643.6243211136002, 1635.9475101844366, 1533.073553092293, 1536.987632868481, 1468.6268565134544, 1455.6598855973698, 1460.2733079099567, 1442.2105915386412, 1374.544418016086, 1366.0925445673388, 1404.3397700867752, 1368.137827156701, 1311.3159334889865, 1296.4821468317036, 1242.2066913687138, 1193.564644030036, 1222.5896838455965, 1253.165730549672, 1249.3638890534255, 1196.793258363787, 1167.6975960901405, 1139.9043479205623, 1145.4194235334703, 1138.420071806811, 1137.3420281570773, 1139.9612389654349, 1135.816982017602, 1109.7919216290702, 1062.3351032256699, 1034.8417229476117, 1087.060852487298, 1062.6601780878993, 1054.9307228752418, 1024.9656865086679, 1041.7657662609256, 985.1953726814785, 992.7394304317542, 985.8484828470303, 1000.4075956179147, 969.2717750720374, 975.3146959487855, 968.1366707535077, 954.069556394745, 954.1638797144615, 982.8269148218334, 964.1984507346824, 954.3571730963375, 925.5538096968525, 931.4545548630737, 934.3993625553625, 913.7803397307791, 913.8751461940986, 937.9535133073302, 930.10909891321, 908.6641411080492, 870.914675839588, 912.7607113730279, 903.5608335215098, 877.8422395105299, 896.7149801236709, 901.4090539364291, 864.9501915737245, 878.2665628834118, 881.335445827586, 888.425921263689, 867.3152316031451, 882.0151595031149, 888.0872278796918, 877.0878969950298, 867.0975950034648, 864.0847810288458, 859.2479424101588, 867.8576431878549, 894.2856569565953, 869.9524268210466, 865.0933025077995, 890.7298143778556, 863.4127800078503, 882.8684228428585, 861.5577201728919, 865.6150599332061, 874.5241868312085, 866.5108093123424, 870.0557911703667, 848.4904729876564, 840.3551118766136, 861.6147103082739, 855.8417398434833, 865.8659934263374, 876.7851326777015, 859.7188266174215, 862.4885274901283, 839.5853666661158, 855.2468130983038, 865.7083693209833, 850.4017177533915, 871.5182406801075, 856.1508698518975, 846.1598164980794, 851.6706505974751, 877.9828167508658, 857.5105261745525, 860.1034158269046, 878.314533986374, 872.7656882673433, 858.7952102732113, 853.6054483910648, 844.6910936504254, 854.2481182558432, 862.274715300876, 840.713403808854, 835.960163334638, 857.6572109135325, 839.7975608972573, 860.8951749826873, 853.5952012616847, 848.5361894886271, 884.7361052739616, 853.3500523791865, 842.9128599702664, 853.5271263346281, 881.5061722048309, 848.3826199398566, 844.0411154094206, 866.6160893377587, 832.9876252414327, 867.0419315783467, 823.1730484202982, 839.4435261658914, 853.721812269716, 851.4300154629605, 844.2141629736639, 858.726354156481, 848.3481044991257, 847.20950838854, 860.592889899994, 846.0596619931442, 820.7691137335432, 833.9840523722467, 864.5372766322864, 863.7354460168661, 863.5328517995958, 851.4391583376953, 832.4901485704684, 828.3888297575753, 886.5385315925288, 814.5904227026916, 841.1155807482548, 816.8053604467214, 858.9021230320404, 844.2849539240688, 848.6636785029966, 873.0314239861248, 831.2369492135333, 856.0849614837998, 887.3790577962774, 829.5584266630749, 836.7022991947754, 846.3943099635342, 843.3407765530753, 842.9982550098675, 844.0253895164336, 829.3435501743246, 829.0440023836336, 808.0198000522639, 829.1210343075293, 799.6651278416406, 836.274721173856, 877.7338287607046, 840.0973051404345, 840.1326906999876, 849.6463666807481, 860.0003848430067, 827.5140238006492, 826.5115054185911, 873.601489586932, 853.2288988847001, 821.037713178078, 827.3894256422866, 851.2920136921352, 847.0821354007891, 844.4010520559899, 849.396493936706, 838.2512603114108, 836.8690006943871, 848.2587582149614, 819.854723144224, 836.4724004232319, 834.484825833994, 848.7051506014931, 826.6907209346682, 847.3013456508872, 839.0284205991305, 844.6139778154586, 839.3043391070203, 846.8424690386349, 834.1026980545163, 854.6402837151173, 847.628856669144, 868.2785308407838, 842.133046384116, 843.0267377801027, 852.6206460306187, 840.5172530587433, 845.034003797748, 833.0255293788483, 842.4146124106991, 852.4994110816112, 822.5833572357172, 836.1659265312331, 835.6350944266583, 859.3239296432293, 832.6323217576628, 851.6289284547012, 842.0207616883054, 834.3196290821401, 842.8348258041581, 834.9910889418682, 846.218885852498, 848.560268264264, 857.8969367525034, 837.0522921146008, 834.823063232075, 848.308356665223, 830.5411484286986, 829.6023066721502, 843.4914507613418, 826.7684876424902, 829.2332950697121, 820.8179658740736, 840.0956129648146, 844.6956736560146, 844.2404065330439, 844.0006186187176, 821.057201052099, 844.4234146261896, 849.2260196253682, 842.989857137706, 819.9115103556801, 855.1535029840059, 835.4507903881873, 854.8495063409123, 837.2595100842032, 832.1641103908173, 854.0231671688123, 836.9142219311049, 833.5516085480675, 819.9699955868737, 836.3111045868787, 838.8381557413361, 856.0193155901453, 847.939218171615, 864.9413503322446, 848.2594073643412, 832.8200530538167, 842.1855729622356, 832.0540893728174, 836.0557317025763, 845.723238533448, 835.6745240749888, 842.6985035307721, 838.1545713894732, 833.5284213848435, 831.0841291842294, 835.0538014803741, 829.7972830737205, 865.6547809396484, 836.7452428503252, 845.7533932742066, 824.1436841553115, 831.5588230014702, 846.3205103907776, 823.8511535298766, 838.2560773448945, 819.876722556547, 831.7551154320912, 823.9253643105068, 852.631409636804, 842.6821381936745, 814.3231134085793, 843.2248627344555, 831.7897733327558, 826.2565844696949, 832.0569382951446, 820.489245982239, 831.3196385419483, 848.4951668340946, 829.7132744779879, 842.2256053713915, 818.258689054125, 820.1312888638813, 806.3210268062367, 841.4999195675044, 826.6815203165958, 837.74749281482, 826.0621992303401, 827.0563418774323, 824.2706163960518, 825.7277714219665, 805.9585368809861, 818.964617114794, 840.4891604440647, 805.6661881597361, 836.7196608843436, 823.694623017314, 812.8894468991323, 835.3968938778976, 846.8518541450954, 834.7024189808382, 823.1153604503141, 808.8302256485458, 822.0319352908468, 817.7390507737998, 839.3729114451628, 822.2796729667405, 852.0601384297822, 823.2696999210879, 797.8835476734847, 809.0717609484818, 805.1655620073606, 811.8522997808936, 807.6839434733614, 819.3537029494088, 807.5890533692572, 812.9158006761706, 858.6004295350499, 794.1772988363738, 813.5270521201045, 827.6259165067198, 817.1965614969085, 857.1918240645978, 849.6045949237305, 862.4028392936656, 845.5689401669696, 812.6237481309315, 812.6272115176349, 816.7612598655519, 827.2373755176844, 807.539087352551, 819.1401293130751, 860.6377077779954, 827.1394394510818, 867.7505797151215, 841.7275589987191, 823.1900132008204, 801.092110996504, 844.2940066356716, 816.7228678034678, 808.0070566622062, 804.7533199006106, 848.388357553149, 847.211907749614, 842.0056697927859, 822.9706475469702, 830.9740237100265, 868.8229075089743, 829.3142770453143, 859.6368148819471, 819.985700914527, 818.7868359335432, 848.6229954995034, 809.4262209696399, 869.508501165786, 848.6961524922382, 830.3284729533553, 857.192187557987, 810.4138316759876, 837.4408107961937, 831.423034549246, 810.3652942480724, 865.9800906384833, 856.2974909131883, 829.7225131196516, 851.2657708286714, 838.7903337374398, 838.456734415113, 849.7099773368002, 826.93243108015, 851.9313882911388, 844.1658400305438, 839.6046684580688, 836.9960717027212, 838.7231782158052, 806.8211630076793, 837.5817388955347, 873.4255869709681, 818.9944352706017, 813.6337058379103, 835.280800502116, 814.9460135775296, 820.2297780693568, 880.7142664848524, 807.8145798361165, 804.635234931502, 812.3376722485077, 859.9231888951775, 839.9411583666786, 816.4367311805694, 831.8045452850675, 850.9843117615187, 877.6986445550046, 811.2996947966215, 858.9191628891323, 855.4888716978246, 825.6258397482528, 828.413015727335, 821.8853382147254, 855.8478944648339, 840.3295211316838, 810.6242415329017, 853.0559568025695, 820.9123224193379, 805.5308397002757, 829.3576731036841, 808.694616043919, 812.6796500014301, 804.8534641305711, 864.569729323485, 830.7119651116785, 812.2404321897325, 828.1642315847048, 835.6581077141976, 804.1833244996138, 834.1697086791445, 815.9161242544527, 853.4346985535038, 869.1836561616341, 800.3749446910128, 830.6578636277279, 821.3914615568345, 794.2281110683839, 842.1385068852965, 830.5200708778372, 835.7670984550263, 807.847684705863, 847.3692268444037, 863.2917819355406, 794.8904131022641, 797.1958481460655, 818.5431094799001, 883.7031071328788, 829.2225052156473, 816.9446522623869, 807.5746864078682, 827.1564183061383, 807.9980171546699, 792.8440464637144, 818.9324112551966, 849.0899050787395, 821.0133318083581, 794.8402452604792, 809.400388746457, 811.0921092373067, 822.0504075845299, 830.4232108885354, 831.270133346358, 830.1578049447138, 857.1526458793337, 842.454912273171, 838.988517083635, 810.1453809516104, 802.4496395098947, 813.6117967028164, 841.1046256813373, 815.4416903803345, 817.2854785513704, 832.7439719518947, 819.1963852329807, 830.4387639819687, 828.7991498620802, 812.2525893712854, 820.6305932077435, 851.1397455882458, 799.3213273730613, 894.8560860700128, 797.0464719091871, 802.3274042808001, 846.6371539910863, 809.3838516188189, 811.122929321334, 849.6205513965324, 809.6971721768991, 802.2674211038928, 850.1334300664312, 798.9903013198522, 803.6231184803032, 807.6467449110918, 861.099341535854, 851.8236796370508, 808.3011506841857, 837.5500120856465, 863.1809114112058, 817.4438385894967, 838.8113187186962, 854.9155201185429, 806.8104267919268, 823.173708605107, 829.1516957146151, 814.3692840389232, 807.1493453494445, 841.1440235910881, 799.6284975717552, 800.3909511289633, 793.8949849758092, 802.992277233014, 833.7120930628857, 807.2910412336249, 801.9694300544678, 812.8742309603543, 817.781878260396, 839.1976840629875, 841.7005046734429, 795.6165436909063, 834.912299673633, 808.122581199223, 812.3189149848599, 841.3846658928567, 830.9885563495907, 823.256158832823, 798.271171066605, 856.2964784162225, 807.0898474835429, 798.1232553184617, 811.8340734032741, 823.5240195081227, 804.7789477321078, 813.1748913436934, 827.9052494961137, 838.0415646337725, 805.309478406191, 816.1296252191161, 823.1296475704959, 818.3252385986829, 789.0086688457748, 797.3682476772381, 850.709160440319, 827.3595429797356, 826.742342803067, 828.1964811366845, 833.5229513257167, 831.2342398580173, 825.9772830611996, 802.6893708552708, 797.7400726366594, 818.908590751673, 814.7063594132923, 899.7236421278568, 808.4089185777526, 818.2584521795815, 820.4008988174594, 828.797016039022, 811.0264594367618, 814.499762951922, 848.2011689775468, 802.662250188829, 804.141449904485, 825.031055876038, 843.2086134219717, 840.0333060182401, 820.8823100880098, 825.1937574559885, 802.1430925422178, 865.2279458202777, 846.9684118376864, 842.5220726858016, 809.6958965285595, 805.9890323815064, 812.9769953812219, 823.6124906216573, 842.2025426139523, 817.7659278626003, 809.7220735268907, 818.7337692318779, 815.750215603938,811.6237692318779]

        for i in range(0, 600):
            x_axis_data.append(i)
            y1.append(y_axis_data1[i]-250)
            y2.append(y_axis_data2[i])

        plt.plot(x_axis_data, y1, color='blue', linestyle='solid',alpha=1, linewidth=1,
                 label='Coded Caching')  # 'bo-'表示蓝色实线，数据点实心原点标注
        plt.plot(x_axis_data, y2, color='#DC143C', linestyle='solid',alpha=0.8, linewidth=1, label='Without Coded Caching')
     #   plt.plot(x_axis_data, y4, 'y--', alpha=0.5, linewidth=1, label='TMAPPO-t4')

        ## plot中参数的含义分别是横轴值，纵轴值，线的形状（'s'方块,'o'实心圆点，'*'五角星   ...，颜色，透明度,线的宽度和标签 ，

        plt.tick_params(labelsize=15)
        plt.legend(fontsize=19)  # 显示上面的label
        plt.xlabel('Epi', fontsize=17)  # x_label
        plt.ylabel('Total Time Delay', fontsize=17)  # y_label

        # plt.ylim(-1,1)#仅设置y轴坐标范围
        plt.show()
