//先导入axios
import axios from 'axios'
//创建一个axios对象，将基础配置配好
var request = axios.create({
  baseURL: '/api', // 请求根路径
  timeout: 2000000000, // 请求超时时间
  headers: {} // 请求头
})
//请求拦截器  前端给后端参数
request.interceptors.request.use(
  (config) => {
    //在请求之前做些什么
    // 添加loading加载
    const token = localStorage.getItem('token')
    if (token) {
      config.headers['token'] = token //请求头添加token
    }
    return config // 拦截成功后最后一定要返回
    //可通过return 向请求中添加数据
    // return {
    //     ...config,
    //     token: token //添加token
    // }
  },
  (err) => {
    //请求错误做些什么
    return Promise.reject(err)
  }
)

// 响应拦截器  后端给前端参数
request.interceptors.response.use(
  (response) => {
    //对响应数据做些什么
    //取消加载
    return response.data
  },
  (err) => {
    //请求失败也要取消加载
    alert(err)
    return Promise.reject(err) //抛出错误,把错误抛给谁? 谁调用它发请求就给谁
  }
)
//导出请求对象
export default request
