import numpy as np
import PSO
import csv
import spiral_deploy
import main_with_kmeans_init
import ga_deploy
import main_rsma

ROW = 100
COL = 100

class UE:
    def __init__(self):
        self.loc = [-1, -1]
        self.list_loc = []   # 所有部署UAV可覆盖该UE的位置


class UAV:
    def __init__(self):
        self.loc = [-1, -1]
        self.client_list = []
        self.los_sum = 0


class SOLUTIN:
    def __init__(self):
        self.mat = np.empty((ROW, COL))
        self.list = []
        self.fit = -1
        self.add = 0
        self.los_total = 0

def main_rsma_va():

    usernum = 50
    csv_name = 'va_solution_result_rsma_csi_1.csv'
    csv_file = open(csv_name, 'w', newline='')
    writer = csv.writer(csv_file)
    index = 1
    in_data = [['usernum','index','uavnum','rates','time1',]]
    for i in range(1):
        for j in range(1):
            addr = 'data\list_ue'+str(usernum)+'_'+str(j + 1) + ".csv"
            uavnum,rates,time = main_rsma.main(addr)#main.main(addr)
            print(uavnum, rates, time)
            # 无人机数量 算法用时 路损方差
            c_l = [usernum,index,uavnum, rates,time]
            in_data.append(c_l)
            index += 1
            print(usernum, j + 1)
            #print('用户数量为%d的第%d次，无人机数量%，用时%f'%(usernum,i+1,len(uav_posi[0]),time))
        usernum += 10
    writer.writerows(in_data)
    csv_file.close()

def main_rsma_va_icsi():
    K_list = [1,2,3,4,5]
    SIGMAE_list = [0,0.05,0.1,0.15,0.2]
    csv_name = 'va_result_rsma_icsi_K1.csv'
    csv_file = open(csv_name, 'w', newline='')
    addr = 'data\list_ue100_6.csv'
    writer = csv.writer(csv_file)
    index = 1
    in_data = [['index','K','SIGMA_E','rates','time1',]]
    for K in K_list:
        for SIGMA_E in SIGMAE_list:
            for i in range(1):
                uavnum,rates,time = main_rsma.main(addr,K,SIGMA_E)#main.main(addr)
                print(index,K,SIGMA_E, rates, time)
                # 无人机数量 算法用时 路损方差
                c_l = [index,K,SIGMA_E, rates,time]
                in_data.append(c_l)
                index += 1
                #print('用户数量为%d的第%d次，无人机数量%，用时%f'%(usernum,i+1,len(uav_posi[0]),time))
    writer.writerows(in_data)
    csv_file.close()

def main_va():

    usernum = 50
    csv_name = 'va_solution_result_sdma0415.csv'
    csv_file = open(csv_name, 'w', newline='')
    writer = csv.writer(csv_file)
    index = 1
    in_data = [['usernum','index','uavnum','rates','rates2','rates3','time1','time2','time3']]
    for i in range(5):
        for j in range(5):
            addr = 'data\list_ue'+str(usernum)+'_'+str(j + 1) + ".csv"
            uavnum,rates,rates2,rates3,time1,time2,time3 = main_with_kmeans_init.main(addr)#main.main(addr)
            print(uavnum,  rates,rates2,rates3,time1,time2,time3)
            # 无人机数量 算法用时 路损方差
            c_l = [usernum,index,uavnum, rates,rates2,rates3,time1,time2,time3]
            in_data.append(c_l)
            index += 1
            print(usernum, j + 1)
            #print('用户数量为%d的第%d次，无人机数量%，用时%f'%(usernum,i+1,len(uav_posi[0]),time))
        usernum += 10
    writer.writerows(in_data)
    csv_file.close()

def main_spiral():
    ue_addr = "va_solution_withBS_channel2.csv"
    list1 = []
    with open(ue_addr, 'r') as f:
        f = csv.reader(f, delimiter=',')
        next(f)
        for row in f:
            list1.append(row[2])
    for i in range(len(list1)):
        list1[i] = int(list1[i])
    usernum = 50
    csv_name = 'spiral_solution_withBSR.csv'
    csv_file = open(csv_name, 'w', newline='')
    writer = csv.writer(csv_file)
    in_data = [['usernum','index','numuav','time','rate']]
    index = 1
    #start = time.time()
    for i in range(10):
        for j in range(10):

            addr = 'data\list_ue'+str(usernum)+'_'+str(j + 1) + ".csv"

            uavnum,time,throughput = spiral_deploy.main(addr,list1[i*10+j])
            # 无人机数量 算法用时 路损方差
            c_l = [usernum,index,uavnum, time,throughput]
            in_data.append(c_l)
            index += 1
            #print('用户数量为%d的第%d次，无人机数量%，用时%f'%(usernum,i+1,len(uav_posi[0]),time))
            print(usernum,j+1)
        usernum += 10
    writer.writerows(in_data)
    csv_file.close()

def main_GA():
    # csv to pickle
    ue_addr = "va_solution_withBS_channel2.csv"
    list1 = []
    with open(ue_addr, 'r') as f:
        f = csv.reader(f, delimiter=',')
        next(f)
        for row in f:
            list1.append(row[2])
    for i in range(len(list1)):
        list1[i] = int(list1[i])
    usernum = 50
    csv_name = "ga_solution_March.csv"
    csv_file = open(csv_name, 'w', newline='')
    writer = csv.writer(csv_file)
    in_data = [['usernum','index','numuav', 'time', 'throughput','uavspace']]
    index = 1
    for i in range(10):
        for j in range(10):
            file_name = 'data\list_ue'+str(usernum)+'_'+str(j + 1)
            uavnum,dtime,throughput = ga_deploy.main(file_name,list1[i*10+j])
            c_l = [usernum, index, uavnum, dtime, throughput]
            in_data.append(c_l)
            index += 1
            print(usernum, j + 1)
            print("用户数量为%d的第%d次，无人机数量%d，用时%f"% (usernum,j+1,uavnum,dtime))
        usernum += 10

    writer.writerows(in_data)
    csv_file.close()

def main_PSO():
    usernum = 50
    csv_name = 'PSO_solution_March0422.csv'
    csv_file = open(csv_name, 'w', newline='')
    writer = csv.writer(csv_file)
    index = 1
    in_data = [['usernum', 'index', 'uavnum', 'rates', 'time1']]
    for i in range(10):
        for j in range(10):
            addr = 'data\list_ue' + str(usernum) + '_' + str(j + 1) + ".csv"

            uavnum, rates, time1 = PSO.main(addr)
            print(uavnum, rates, time1,)
            # 无人机数量 算法用时 路损方差
            c_l = [usernum, index, uavnum, rates, time1]
            in_data.append(c_l)
            index += 1
            print(usernum, j + 1)
            # print('用户数量为%d的第%d次，无人机数量%，用时%f'%(usernum,i+1,len(uav_posi[0]),time))
        usernum += 10
    writer.writerows(in_data)
    csv_file.close()

if __name__ == '__main__':
    main_rsma_va_icsi()