import matplotlib.pyplot as plt

from virtual_force import *
ue_addr = r"D:\pycharm\deploy_algorithms\data\list_ue50_6.csv"
uav_addr = r"D:\pycharm\va_position_power\draw\locationprocess_6.csv"
link_addr = r"D:\pycharm\va_position_power\draw\linkprocess_6.csv"
class UE:
    def __init__(self):
        self.loc = [0, 0, 0]
        self.snrth = 0
        self.uav = -1

class BS:
    def __init__(self):
        self.loc = [0, 0, 0]
        self.sort = 'UAV'
        self.power_upper = 0
        self.power_allocation = []  # 长度为用户数
        self.power_a2a = 0
        self.power = 0
        self.rate = 0
        self.rate_upper = 0

def read_file(addr,nextLine = False,floats=True):
    read_list = []
    with open(addr, 'r') as f:
        f = csv.reader(f, delimiter=',')
        if nextLine:next(f)
        for row in f:
            read_list.append(row)
    for i in range(len(read_list)):
        if floats:
            read_list[i] = list(map(float, read_list[i]))
        else:
            read_list[i] = [int(val) for val in read_list[i] if val.strip()]
    return read_list

ue_list = read_file(ue_addr,nextLine=True)
uav_list = read_file(uav_addr)
linked = read_file(link_addr,floats=False)
UE_list = []
UAV_list = []
for i in range(len(ue_list)):
    ue = UE()
    ue.loc = ue_list[i]
    UE_list.append(ue)

for i in range(len(uav_list)):
    uav = BS()
    uav.loc = uav_list[i]
    UAV_list.append(uav)
draw_uavus_link_circle2(UE_list,UAV_list,linked,basecolor='red',size=40,name='testprocess_')
print(linked)
print(uav_list)
plt.figure()
for i in range(len(ue_list)):
    plt.scatter(UE_list[i].loc[0], UE_list[i].loc[1], color='blue', marker='x', s=40)
    plt.text(UE_list[i].loc[0], UE_list[i].loc[1], i, ha='center', va='bottom', fontsize=9,color='red')
for i in range(len(uav_list)):
    plt.scatter(UAV_list[i].loc[0], UAV_list[i].loc[1], color='blue', marker='x', s=40)
    plt.text(UAV_list[i].loc[0], UAV_list[i].loc[1], i, ha='center', va='bottom', fontsize=9,color='k')
plt.show()