import numpy as np
import copy
import time
import matplotlib
import matplotlib.pyplot as  plt
import csv
import init
from virtual_force import *
import vforce2

# from vatest import *
numfbs = 0
nummbs = 0
sumgbs = nummbs + numfbs
R_mbs = 5
R_uav = 18
snrth = 2  # 1211更新
itermax = 200
init_upper = 20
num1 = 1.01
num2 = 0
num3 = 5
num4 = 0
font_set = matplotlib.font_manager.FontProperties(fname=r"HYQiHei-60S.ttf")


class UE:
    def __init__(self):
        self.loc = [0, 0, 0]
        self.snrth = 0


class BS:
    def __init__(self):
        self.loc = [0, 0, 0]
        self.sort = 'UAV'
        self.power_upper = 0
        self.power_allocation = []  # 长度为用户数
        self.power_a2a = 0
        self.power = 0
        self.rate = 0
        self.rate_upper = 0


def read_UElist(ue_addr):
    ue_list = []
    with open(ue_addr, 'r') as f:
        f = csv.reader(f, delimiter=',')
        next(f)
        for row in f:
            ue_list.append(row)
    for i in range(len(ue_list)):
        ue_list[i] = list(map(float, ue_list[i]))
    UE_list = []
    for i in range(len(ue_list)):
        new_ue = UE()
        new_ue.loc = [ue_list[i][0], ue_list[i][1], 0]
        new_ue.sort = 'ue'
        new_ue.snrth = dB2powerratio(snrth)
        UE_list.append(new_ue)
    return UE_list


def UE_list_real(UE_listmp):
    # 用户数据坐标从0~100变为0~3000，30倍
    UE_list = []
    for i in range(len(UE_listmp)):
        new_ue = UE()
        new_ue.loc = [UE_listmp[i].loc[0] * 30, UE_listmp[i].loc[1] * 30, 0]
        new_ue.snrth = dB2powerratio(snrth)
        new_ue.sort = 'ue'
        UE_list.append(new_ue)

    return UE_list


def main(addr):
    # 记录无人机的位置
    csv_name = 'uav_place.csv'
    csv_file = open(csv_name, 'w', newline='')
    writer = csv.writer(csv_file)

    # 导入用户位置
    UE_listmp = read_UElist(addr)
    UE_list = UE_list_real(UE_listmp.copy())
    # print(len(UE_list), UE_list[0].loc)
    # 确定用户通信需求 各用户所需的信噪比
    numuav = 3
    BS_list = init.main3(UE_listmp.copy(), sumgbs, R_mbs=R_mbs, sumuav=numuav, R_uav=R_uav)
    snr, dist = cal_snr(UE_list, BS_list)
    link, linked = comm_connection(UE_list, BS_list, snr)  # 未建立连接的确保发射功率为0

    power_equal_allocation(BS_list, UE_list, linked, link)

    coverate = cal_coverate(link)
    # 计算覆盖率 以及连接情况
    # print(coverate)
    # 对于未被覆盖的边缘用户来说，目前调整位置并不能为他们提供服务
    # 那么如何继续对位置进行调整 或者能不能对功率进行调整从而实现服务呢
    # 约束：覆盖，功率
    # 计算引力，计算斥力
    times = 0
    init_times = 0
    total_rate = []
    total_rate1 = []
    # total_rate.append(cal_network_rate(BS_list, UE_list,linked))
    # total_rate1.append(cal_network_rate(BS_list, UE_list,linked))
    start = time.time()
    # 求最小数量
    while (coverate != 1):
        # 位置调整

        Fa, Fa_list = virtual_fa(UE_list, BS_list)
        Fr, Fr_list = virtual_fr(BS_list)

        F = total_force(Fa, Fr)
        v = force2v(F, Max_Speed=5)
        move_length = update_state_position(BS_list, v)
        snr, dist = cal_snr(UE_list, BS_list)
        link, linked = comm_connection(UE_list, BS_list, snr)  # 确立连接关系 未建立连接的确保功率为0

        power_equal_allocation(BS_list, UE_list, linked, link)

        coverate = cal_coverate(link)

        if (coverate == 1):
            # print(times, '实现全覆盖，退出迭代')
            break
        # 重新初始化
        if (coverate != 1) and init_times <= init_upper:

            # print('此次无法全覆盖，重新初始化', numuav, coverate)
            BS_list = init.main3(UE_listmp.copy(), sumgbs, R_mbs=R_mbs, sumuav=numuav, R_uav=R_uav)

        elif (coverate != 1):
            # print('无法全覆盖，增加无人机数量并重新初始化', numuav, coverate)
            init_times = 0
            numuav += 1

            BS_list = init.main3(UE_listmp.copy(), sumgbs, R_mbs=R_mbs, sumuav=numuav, R_uav=R_uav)
            snr, dist = cal_snr(UE_list, BS_list)
            link, linked = comm_connection(UE_list, BS_list, snr)  # 确立连接关系 未建立连接的确保功率为0

            # fig = plt.figure('fig')
            # fig.clf()
            """plt.figure()
            for i in range(len(UE_list)):
                plt.scatter(UE_list[i].loc[0], UE_list[i].loc[1], color='blue', marker='x', s=40)
            plt.scatter(UE_list[i].loc[0], UE_list[i].loc[1], color='blue', marker='x', s=40, label='UE')
            plt.xlim(-10, 3100)
            plt.ylim(-10, 3100)
            draw_uavus_link(UE_list, BS_list, linked, basecolor='red', size=40, )
            print(len(BS_list),coverate)
            #pic_name = 'deployprocess'
            #title = pic_name + str(numuav) + '.jpg'
            plt.legend(loc='upper right', borderaxespad=num4, prop=font_set)"""
            # fig.savefig(title)
        init_times += 1  # """
        # times += 1

    # print(len(BS_list))
    """plt.figure()
    for i in range(len(UE_list)):
        plt.scatter(UE_list[i].loc[0], UE_list[i].loc[1], color='blue', marker='x', s=40)
    plt.scatter(UE_list[i].loc[0], UE_list[i].loc[1], color='blue', marker='x', s=40, label='UE')
    plt.xlim(-10, 3100)
    plt.ylim(-10, 3100)
    draw_uavus_link(UE_list, BS_list, linked, basecolor='red', size=40, )
    print(len(BS_list), coverate)

    #pic_name = 'deployprocess'
    #title = pic_name + str(numuav) + '.jpg'
    plt.legend(loc='upper right', borderaxespad=num4, prop=font_set)
    plt.show()"""

    power_equal_allocation(BS_list, UE_list, linked, link)
    BS_list1 = copy.deepcopy(BS_list)
    total_rate.append(cal_network_rate(BS_list, UE_list, linked))
    total_rate1.append(cal_network_rate(BS_list, UE_list, linked))
    while (times < itermax):
        power_ = []
        # 位置调整
        Fa, Fa_list = virtual_fa(UE_list, BS_list)
        Fr, Fr_list = virtual_fr(BS_list)

        F = total_force(Fa, Fr)
        v = force2v(F, 0.2)
        move_length = update_state_position(BS_list, v)
        snr, dist = cal_snr(UE_list, BS_list)
        link, linked = comm_connection(UE_list, BS_list, snr)  # 确立连接关系 未建立连接的确保功率为0
        update_bs_power(BS_list)

        # 功率调整
        Fa, Fa_list = virtual_fa(UE_list, BS_list)
        Fr, Fr_list = virtual_fr(BS_list)

        va = force2v(Fa, Max_Speed=power_step)
        va_list = forcelist2vlist(Fa_list, 1)
        vr_list = power2v(total_fr_power(Fr_list), 1)
        update_state_power(BS_list, va_list, vr_list, link)
        # update_state_power2(BS_list, va, vr_list, link)
        update_bs_power(BS_list)
        for i in range(len(BS_list)):
            power_.append(BS_list[i].power)
        snr, dist = cal_snr(UE_list, BS_list)
        link, linked = comm_connection(UE_list, BS_list, snr)  # 确立连接关系 未建立连接的确保功率为0

        total_rate.append(cal_network_rate(BS_list, UE_list, linked))

        times += 1
    time1 = time.time() - start
    # """
    # 只进行位置调整
    times = 0
    # 只进行位置调整
    vforce2.power_equal_allocation(BS_list1, UE_list, linked, link)
    while (times < itermax):
        # 位置调整
        Fa, Fa_list = vforce2.virtual_fa(UE_list, BS_list1)
        Fr, Fr_list = vforce2.virtual_fr(BS_list1)

        F = total_force(Fa, Fr)
        v = force2v(F, 0.2)
        move_length = update_state_position(BS_list1, v)
        snr, dist = cal_snr(UE_list, BS_list1)
        link, linked = comm_connection(UE_list, BS_list1, snr)  # 确立连接关系 未建立连接的确保功率为0
        update_bs_power(BS_list1)
        total_rate1.append(cal_network_rate(BS_list1, UE_list, linked))
        # print(times,total_rate1[-1])
        times += 1
    time2 = time.time() - start - time1

    print(total_rate[-1], total_rate1[-1])
    return len(BS_list), total_rate[-1], total_rate1[-1], time1, time2


if __name__ == '__main__':
    addr = r"D:\pycharm\deploy_algorithms\data\list_ue100_1.csv"
    result = main(addr)
    print(result)
