import numpy as np
import matplotlib.pyplot as plt

def gene_obs():
    obstacles_param = []
    obstacles_param.append([5,55,65,68])
    obstacles_param.append([72,74,10,55])

    return obstacles_param
ob_params = gene_obs()
def getObstacleCor(ob_param):
    return [[ob_param[0],ob_param[2]],[ob_param[1],ob_param[2]],[ob_param[0],ob_param[3]],[ob_param[1],ob_param[3]]]

def isNLoS(begin,end,ob_params):
    # 都没穿过
    result = False
    for ob_param in ob_params:
        if not passThroughOb(begin,end,ob_param):   # 没穿过
            result = False
        else:
            result = True
            return result
    return result
def passThroughOb(begin,end,ob_param):
    ob_cor = getObstacleCor(ob_param)
    if begin[0] == end[0]:
        if begin[1] == end[1]:
            return False
        elif ob_param[0]<=begin[0]<=ob_param[1]:
            return True
        else:
            return False
        # 线段在方形左侧/右侧/上侧/下侧
    if ((begin[0]-ob_cor[0][0])<0 and (end[0]-ob_cor[0][0])<0) or ((begin[0]-ob_cor[1][0])>0 and (end[0]-ob_cor[1][0])>0) or ((begin[1]-ob_cor[0][1])<0 and (end[1]-ob_cor[0][1])<0) or((begin[1]-ob_cor[2][1])>0 and (end[1]-ob_cor[2][1])>0):
        return False
        # 确定直线方程
    k = (begin[1]-end[1])/(begin[0]-end[0])
    b = begin[1] - begin[0]*k
    cnt = 0
    for i in range(len(ob_cor)):
        if(ob_cor[i][1]-k*ob_cor[i][0]-b)>0:
            cnt+=1
        else:cnt-=1
    if abs(cnt)==4: # 方形区域四个点在直线同侧
        return False
    else:
        return True #穿过


def get_obstacle(obstacles_param):
    obstacles = []
    for k in range(len(obstacles_param)):
        obstacle = np.zeros([100, 100])
        ob_l, ob_r, ob_b, ob_t = obstacles_param[k]
        for i in range(ob_b,ob_t):
            for j in range(ob_l,ob_r):
                obstacle[j][i] = 1
        obstacles.append(obstacle)
    return obstacles
def draw_obstacle(obstacles,scale=1):
    for obstacle in obstacles:
        for i in range(len(obstacle)):
            for j in range(len(obstacle[0])):
                if obstacle[i][j]:
                    plt.scatter(i*scale,j*scale,color='darkgoldenrod',s=9,)
    plt.scatter(i, j, color='darkgoldenrod', s=9, )