import matplotlib.pyplot as plt
import numpy as np
import math
from virtual_force import *
pi = math.pi
f = 1.4e9  # MHz
d0 = 1
c = 3e8

# CSI 误差
mean = 0  # 均值
variance = 0.2  # 方差
size = 1  # 生成样本的数量

def complex_gaussian(mean, variance, size):
    real = np.random.normal(mean, np.sqrt(variance/2), size)
    imag = np.random.normal(mean, np.sqrt(variance/2), size)
    return real + 1j * imag

def LoS_racian(dist,alpha=2):
    return 20 * np.log10(4 * pi * f * d0 / c) + 10 * alpha * math.log10(dist / d0)
def racian(theta,K_para):
    K = get_K(theta,K_para)
    los = 100#LoS_racian(dist)
    print((K*los+1)/(K+1))
    return (K*los+1)/(K+1)

def get_K(theta,K_para):
    k_0,k_pi_2= K_para
    a = k_0
    b = 2*np.log(k_pi_2/a)/pi #if a!= 0 else 0
    # theta = math.atan2(h, dist)
    # print(theta)
    print(theta,b,a*np.exp(b*theta))
    return a*np.exp(b*theta)
if __name__ == '__main__':
    # K_list = [-1,0,1,1.41,1.99]
    csv_name = 'csi_atten.csv'
    csv_file = open(csv_name, 'w', newline='')
    writer = csv.writer(csv_file)

    k_para_list = [[5,15],[3,30],[3,50],]
    theta_list = np.linspace(pi/4,1*pi/3,100)
    # in_data = [['idx','-1','0',  '1', '1.41', '1.99', ]]
    in_data = []
    d_list = [1000,1500,2000,3000] #[500,600,700,800,900,1000,1100,1200,1300,1400,1500]
    res = np.zeros([len(theta_list), len(k_para_list)  ])

    result  = []
    # for d_idx in range(len(d_list)):
    for t_idx in range(len(theta_list)):
        # d = d_list[d_idx]
        t = theta_list[t_idx]
        for i in range(len(k_para_list)):

            K_para = k_para_list[i]
            attenuation_list = []
            l_dB = pathlossA2G(2/np.tan(t),200) #
            h = racian(t, K_para)
            h_dB = 20 * np.log10(h)
            res[t_idx][i] = h_dB#+l_dB
        c_l = [t]
        c_l = np.concatenate((c_l,res[t_idx]))
        in_data.append(c_l)
        # print(d,c_l,res[d-1000])
        # break
    # print(in_data)
    # plt.figure()
    # plt.plot(theta_list, res[:,0])
    # plt.plot(theta_list, res[:, 1])
    # plt.plot(theta_list, res[:, 2])
    # plt.show()

    writer.writerows(in_data)
    csv_file.close()