import numpy as np
import copy
import time
import matplotlib
import matplotlib.pyplot as  plt
import csv
import init
from virtual_force import *
from scipy.interpolate import griddata
import vforce2

# from vatest import *
numfbs = 0
nummbs = 0
sumgbs = nummbs + numfbs
R_mbs = 5
R_uav = 25
snrth = -5
itermax = 200
init_upper = 20
num1 = 1.01
num2 = 0
num3 = 5
num4 = 0
font_set = matplotlib.font_manager.FontProperties(fname=r"HYQiHei-60S.ttf")


class UE:
    def __init__(self):
        self.loc = [0, 0, 0]
        self.snrth = 0


class BS:
    def __init__(self):
        self.loc = [0, 0, 0]
        self.sort = 'UAV'
        self.power_upper = 0
        self.power_allocation = []  # 长度为用户数
        self.power_a2a = 0
        self.power = 0
        self.rate = 0
        self.rate_upper = 0


def read_UElist(ue_addr):
    ue_list = []
    with open(ue_addr, 'r') as f:
        f = csv.reader(f, delimiter=',')
        next(f)
        for row in f:
            ue_list.append(row)
    for i in range(len(ue_list)):
        ue_list[i] = list(map(float, ue_list[i]))
    UE_list = []
    for i in range(len(ue_list)):
        new_ue = UE()
        new_ue.loc = [ue_list[i][0], ue_list[i][1], 0]
        new_ue.sort = 'ue'
        new_ue.snrth = dB2powerratio(snrth)
        UE_list.append(new_ue)
    return UE_list

def pathlossA2G_hotmap(dist2,h):
    '''
    :param dist2: 基站在水平面的投影与用户的距离
    :param h:高度
    :return:空地倾斜路径损耗
    '''
    f = 1.4e9  # MHz
    d0 = 1
    c = 3e8
    alpha = 3.5
    pi = math.pi
    A = 0.25
    C = 0.39
    E = 0.25
    G = 0
    H = 0.05
    dep_tree = 2  # 植被深度
    dist3d = math.sqrt((dist2)**2 + h**2)
    fspl = 20 * np.log10(4 * pi * f * d0 / c) + 10 * alpha * math.log10(dist3d / d0)
    theta = math.atan2(h, dist2)
    slant =  A * np.power(f / math.pow(10, 6), C) * np.power(dep_tree, E) * np.power(theta + G, H)
    return fspl + slant

def BS_list_save(title_,BS_list):
    title = title_ + str(len(BS_list)) + '.csv'
    csv_file = open(title, 'w', newline='')
    writer = csv.writer(csv_file)
    BS_posi = []
    for i in range(len(BS_list)):
        BS_posi.append(BS_list[i].loc)
    writer.writerows(BS_posi)
    csv_file.close()
def expend_data(x, y, z, smooth_degree=10):
    num_x = len(x)
    max_x = np.max(x)
    min_x = np.min(x)

    num_y = len(y)
    max_y = np.max(y)
    min_y = np.min(y)

    X, Y = np.meshgrid(x, y)
    coordinates = np.hstack((X.flatten()[:, None], Y.flatten()[:, None]))
    print(z.shape)

    m = np.linspace(min_x, max_x, (num_x - 1) * smooth_degree + 1)
    n = np.linspace(min_y, max_y, (num_y - 1) * smooth_degree + 1)
    M, N = np.meshgrid(m, n)

    U = griddata(coordinates, z, (M, N), method='cubic')

    return M, N, U

def main(addr):

    hotmap = np.zeros([100 , 100])

    title_ = 'hotmap'
    #csv_name = 'va_joint_solution.csv'
    #csv_file = open(csv_name, 'w', newline='')
    #writer = csv.writer(csv_file)


    # 导入用户位置
    UE_list = read_UElist(addr)
    # print(len(UE_list), UE_list[0].loc)
    # 确定用户通信需求 各用户所需的信噪比
    numuav = 4
    BS_list = init.main3(UE_list.copy(), sumgbs, R_mbs=R_mbs, sumuav=numuav, R_uav=R_uav)
    snr, dist = cal_snr(UE_list, BS_list)

    link, linked = comm_connection(UE_list, BS_list, snr)  # 未建立连接的确保发射功率为0
    power_equal_allocation(BS_list, UE_list, linked, link)

    coverate = cal_coverate(link)
    plt.figure()
    draw_uavus_link_circle(UE_list, BS_list, linked, basecolor='red', size=40, )
    print(len(BS_list), coverate)

    plt.show()



    return len(BS_list)


if __name__ == '__main__':
    addr = r"D:\pycharm\deploy_algorithms\data\list_ue100_2.csv"
    result = main(addr)
    print(result)
